/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.LogWriteException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.FileCacheWarmer;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.JEFileFilter;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.log.entry.FileHeaderEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.HexFormatter;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.StatGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class FileManager {
    private static final boolean DEBUG = false;
    public static long WRITE_COUNT = 0L;
    public static long STOP_ON_WRITE_COUNT = Long.MAX_VALUE;
    public static long N_BAD_WRITES = Long.MAX_VALUE;
    public static boolean THROW_ON_WRITE = false;
    public static final String JE_SUFFIX = ".jdb";
    public static final String DEL_SUFFIX = ".del";
    public static final String BAD_SUFFIX = ".bad";
    private static final String LOCK_FILE = "je.lck";
    static final String[] DEL_SUFFIXES = new String[]{".del"};
    static final String[] JE_SUFFIXES = new String[]{".jdb"};
    private static final String[] JE_AND_DEL_SUFFIXES = new String[]{".jdb", ".del"};
    public static final String TMP_SUFFIX = ".tmp";
    public static final String BUP_SUFFIX = ".bup";
    private boolean syncAtFileEnd = true;
    private final EnvironmentImpl envImpl;
    private final long maxFileSize;
    private final File dbEnvHome;
    private final File[] dbEnvDataDirs;
    private boolean includeDeletedFiles = false;
    private final FileCache fileCache;
    private FileCacheWarmer fileCacheWarmer;
    private RandomAccessFile lockFile;
    private FileChannel channel;
    private FileLock envLock;
    private FileLock exclLock;
    private final boolean readOnly;
    private long currentFileNum;
    private long nextAvailableLsn;
    private long lastUsedLsn;
    private long prevOffset;
    private boolean forceNewFile;
    private final LogEndFileDescriptor endOfLog;
    private final Map<Long, Long> perFileLastUsedLsn;
    private final boolean useWriteQueue;
    private final int writeQueueSize;
    private final boolean useODSYNC;
    public boolean VERIFY_CHECKSUMS = false;
    private final int nDataDirs;
    long lastFileNumberTouched = -1L;
    long lastFileTouchedOffset = 0L;
    private static final long ADJACENT_TRACK_SEEK_DELTA = 0x100000L;
    final StatGroup stats;
    final LongStat nRandomReads;
    final LongStat nRandomWrites;
    final LongStat nSequentialReads;
    final LongStat nSequentialWrites;
    final LongStat nRandomReadBytes;
    final LongStat nRandomWriteBytes;
    final LongStat nSequentialReadBytes;
    final LongStat nSequentialWriteBytes;
    final IntStat nFileOpens;
    final IntStat nOpenFiles;
    final LongStat nBytesReadFromWriteQueue;
    final LongStat nBytesWrittenFromWriteQueue;
    final LongStat nReadsFromWriteQueue;
    final LongStat nWritesFromWriteQueue;
    final LongStat nWriteQueueOverflow;
    final LongStat nWriteQueueOverflowFailures;
    final LongStat nLogFSyncs;
    final LongStat nFSyncTime;
    private static Comparator<File> fileComparator = new Comparator<File>(){

        private String getFileNum(File file) {
            String fname = file.toString();
            return fname.substring(fname.indexOf(File.separator) + 1);
        }

        @Override
        public int compare(File o1, File o2) {
            String fnum1 = this.getFileNum(o1);
            String fnum2 = this.getFileNum(o2);
            return o1.compareTo(o2);
        }
    };
    private static Comparator<String> stringComparator = new Comparator<String>(){

        private String getFileNum(String fname) {
            return fname.substring(fname.indexOf(File.separator) + 1);
        }

        @Override
        public int compare(String o1, String o2) {
            String fnum1 = this.getFileNum(o1);
            String fnum2 = this.getFileNum(o2);
            return fnum1.compareTo(fnum2);
        }
    };
    public static final boolean LOGWRITE_EXCEPTION_TESTING;
    private static String RRET_PROPERTY_NAME;
    private static final int LOGWRITE_EXCEPTION_MAX = 100;
    private int logWriteExceptionCounter = 0;
    private boolean logWriteExceptionThrown = false;
    private Random logWriteExceptionRandom = null;
    public static FileFactory fileFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileManager(EnvironmentImpl envImpl, File dbEnvHome, boolean readOnly) throws EnvironmentLockedException {
        this.envImpl = envImpl;
        this.dbEnvHome = dbEnvHome;
        this.readOnly = readOnly;
        boolean success = false;
        this.stats = new StatGroup("FileManager", "FileManager statistics");
        this.nRandomReads = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_READS);
        this.nRandomWrites = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_WRITES);
        this.nSequentialReads = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_READS);
        this.nSequentialWrites = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES);
        this.nRandomReadBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_READ_BYTES);
        this.nRandomWriteBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES);
        this.nSequentialReadBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES);
        this.nSequentialWriteBytes = new LongStat(this.stats, LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES);
        this.nFileOpens = new IntStat(this.stats, LogStatDefinition.FILEMGR_FILE_OPENS);
        this.nOpenFiles = new IntStat(this.stats, LogStatDefinition.FILEMGR_OPEN_FILES);
        this.nBytesReadFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE);
        this.nBytesWrittenFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE);
        this.nReadsFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE);
        this.nWritesFromWriteQueue = new LongStat(this.stats, LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE);
        this.nWriteQueueOverflow = new LongStat(this.stats, LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW);
        this.nWriteQueueOverflowFailures = new LongStat(this.stats, LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES);
        this.nLogFSyncs = new LongStat(this.stats, LogStatDefinition.FILEMGR_LOG_FSYNCS);
        this.nFSyncTime = new LongStat(this.stats, LogStatDefinition.GRPCMGR_FSYNC_TIME);
        try {
            DbConfigManager configManager = envImpl.getConfigManager();
            this.maxFileSize = configManager.getLong(EnvironmentParams.LOG_FILE_MAX);
            this.useWriteQueue = configManager.getBoolean(EnvironmentParams.LOG_USE_WRITE_QUEUE);
            this.writeQueueSize = configManager.getInt(EnvironmentParams.LOG_WRITE_QUEUE_SIZE);
            this.useODSYNC = configManager.getBoolean(EnvironmentParams.LOG_USE_ODSYNC);
            this.VERIFY_CHECKSUMS = configManager.getBoolean(EnvironmentParams.LOG_VERIFY_CHECKSUMS);
            this.nDataDirs = configManager.getInt(EnvironmentParams.LOG_N_DATA_DIRECTORIES);
            if (this.nDataDirs != 0) {
                this.dbEnvDataDirs = this.gatherDataDirs();
            } else {
                this.checkNoDataDirs();
                this.dbEnvDataDirs = null;
            }
            if (!envImpl.isMemOnly()) {
                boolean isReadOnly;
                if (!dbEnvHome.exists()) {
                    throw new IllegalArgumentException("Environment home " + dbEnvHome + " doesn't exist");
                }
                boolean bl = isReadOnly = envImpl.isArbiter() ? false : readOnly;
                if (!this.lockEnvironment(isReadOnly, false)) {
                    throw new EnvironmentLockedException(envImpl, "The environment cannot be locked for " + (isReadOnly ? "shared" : "single writer") + " access.");
                }
            }
            this.fileCache = new FileCache(configManager);
            this.currentFileNum = 0L;
            this.nextAvailableLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
            this.lastUsedLsn = -1L;
            this.perFileLastUsedLsn = Collections.synchronizedMap(new HashMap());
            this.prevOffset = 0L;
            this.endOfLog = new LogEndFileDescriptor();
            this.forceNewFile = false;
            String stopOnWriteCountName = "je.debug.stopOnWriteCount";
            String stopOnWriteCountProp = System.getProperty("je.debug.stopOnWriteCount");
            if (stopOnWriteCountProp != null) {
                try {
                    STOP_ON_WRITE_COUNT = Long.parseLong(stopOnWriteCountProp);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse: je.debug.stopOnWriteCount", e);
                }
            }
            String stopOnWriteActionName = "je.debug.stopOnWriteAction";
            String stopOnWriteActionProp = System.getProperty("je.debug.stopOnWriteAction");
            if (stopOnWriteActionProp != null) {
                if (stopOnWriteActionProp.compareToIgnoreCase("throw") == 0) {
                    THROW_ON_WRITE = true;
                } else if (stopOnWriteActionProp.compareToIgnoreCase("stop") == 0) {
                    THROW_ON_WRITE = false;
                } else {
                    throw new IllegalArgumentException("Unknown value for: je.debug.stopOnWriteAction" + stopOnWriteActionProp);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setLastPosition(long nextAvailableLsn, long lastUsedLsn, long prevOffset) {
        this.lastUsedLsn = lastUsedLsn;
        this.perFileLastUsedLsn.put(DbLsn.getFileNumber(lastUsedLsn), lastUsedLsn);
        this.nextAvailableLsn = nextAvailableLsn;
        this.currentFileNum = DbLsn.getFileNumber(this.nextAvailableLsn);
        this.prevOffset = prevOffset;
    }

    public void setSyncAtFileEnd(boolean sync) {
        this.syncAtFileEnd = sync;
    }

    public Long getFirstFileNum() {
        return this.getFileNum(true);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public Long getLastFileNum() {
        return this.getFileNum(false);
    }

    public long getCurrentFileNum() {
        return this.currentFileNum;
    }

    boolean getUseWriteQueue() {
        return this.useWriteQueue;
    }

    public boolean isFileValid(long fileNum) {
        if (fileNum == this.currentFileNum || this.envImpl.isMemOnly()) {
            return true;
        }
        String fileName = this.getFullFileName(fileNum, JE_SUFFIX);
        File file = new File(fileName);
        return file.exists();
    }

    public void setIncludeDeletedFiles(boolean includeDeletedFiles) {
        this.includeDeletedFiles = includeDeletedFiles;
    }

    public Long[] getAllFileNumbers() {
        String[] names = this.listFileNames(JE_SUFFIXES);
        Long[] nums = new Long[names.length];
        for (int i = 0; i < nums.length; ++i) {
            int dbEnvDataDirsIdx;
            String name = names[i];
            nums[i] = this.getNumFromName(name);
            long num = nums[i];
            if (this.nDataDirs == 0 || (long)(dbEnvDataDirsIdx = this.getDataDirIndexFromName(name) - 1) == num % (long)this.nDataDirs) continue;
            throw EnvironmentFailureException.unexpectedState("Found file " + name + " but it should have been in " + "data directory " + (dbEnvDataDirsIdx + 1) + ". Perhaps it was moved or restored incorrectly?");
        }
        return nums;
    }

    public Long getFollowingFileNum(long currentFileNum1, boolean forward) {
        String[] names = this.listFileNames(JE_SUFFIXES);
        String searchName = FileManager.getFileName(currentFileNum1, JE_SUFFIX);
        int foundIdx = Arrays.binarySearch(names, searchName, stringComparator);
        boolean foundTarget = false;
        if (foundIdx >= 0) {
            foundIdx = forward ? ++foundIdx : --foundIdx;
        } else {
            foundIdx = Math.abs(foundIdx + 1);
            if (!forward) {
                --foundIdx;
            }
        }
        if (forward && foundIdx < names.length) {
            foundTarget = true;
        } else if (!forward && foundIdx > -1) {
            foundTarget = true;
        }
        if (foundTarget) {
            return this.getNumFromName(names[foundIdx]);
        }
        return null;
    }

    public boolean filesExist() {
        String[] names = this.listFileNames(JE_SUFFIXES);
        return names.length != 0;
    }

    private Long getFileNum(boolean first) {
        String[] names = this.listFileNames(JE_SUFFIXES);
        if (names.length == 0) {
            return null;
        }
        int index = 0;
        if (!first) {
            index = names.length - 1;
        }
        return this.getNumFromName(names[index]);
    }

    private int getDataDirIndexFromName(String fileName) {
        if (this.nDataDirs == 0) {
            return -1;
        }
        int dataDirEnd = fileName.lastIndexOf(File.separator);
        String dataDir = fileName.substring(0, dataDirEnd);
        return Integer.parseInt(dataDir.substring("data".length()));
    }

    public Long getNumFromName(String fileName) {
        String name = fileName;
        if (this.nDataDirs != 0) {
            name = name.substring(name.lastIndexOf(File.separator) + 1);
        }
        String fileNumber = name.substring(0, name.indexOf("."));
        return Long.parseLong(fileNumber, 16);
    }

    String[] listFileNames(String[] suffixes) {
        JEFileFilter fileFilter = new JEFileFilter(suffixes);
        return this.listFileNamesInternal(fileFilter);
    }

    public String[] listFileNames(long minFileNumber, long maxFileNumber) {
        JEFileFilter fileFilter = new JEFileFilter(JE_SUFFIXES, minFileNumber, maxFileNumber);
        return this.listFileNamesInternal(fileFilter);
    }

    public static String[] listFiles(File envDirFile, String[] suffixes, boolean envMultiSubDir) {
        String[] names = envDirFile.list(new JEFileFilter(suffixes));
        ArrayList<String> subFileNames = new ArrayList<String>();
        if (envMultiSubDir) {
            for (File file : envDirFile.listFiles()) {
                File[] subFiles;
                if (!file.isDirectory() || !file.getName().startsWith("data")) continue;
                for (File subFile : subFiles = file.listFiles(new JEFileFilter(suffixes))) {
                    subFileNames.add(file.getName() + File.separator + subFile.getName());
                }
            }
            String[] totalFileNames = new String[names.length + subFileNames.size()];
            for (int i = 0; i < totalFileNames.length; ++i) {
                totalFileNames[i] = i < names.length ? names[i] : (String)subFileNames.get(i - names.length);
            }
            names = totalFileNames;
        }
        if (names != null) {
            Arrays.sort(names, stringComparator);
        } else {
            names = new String[]{};
        }
        return names;
    }

    public File[] listJDBFiles() {
        if (this.nDataDirs == 0) {
            return this.listJDBFilesInternalSingleDir(new JEFileFilter(JE_SUFFIXES));
        }
        return this.listJDBFilesInternalMultiDir(new JEFileFilter(JE_SUFFIXES));
    }

    public File[] listJDBFilesInternalSingleDir(JEFileFilter fileFilter) {
        Object[] files = this.dbEnvHome.listFiles(fileFilter);
        if (files != null) {
            Arrays.sort(files);
        } else {
            files = new File[]{};
        }
        return files;
    }

    public File[] listJDBFilesInternalMultiDir(JEFileFilter fileFilter) {
        File[][] files = new File[this.nDataDirs][];
        int nTotalFiles = 0;
        int i = 0;
        for (File envDir : this.dbEnvDataDirs) {
            files[i] = envDir.listFiles(fileFilter);
            nTotalFiles += files[i].length;
            ++i;
        }
        if (nTotalFiles == 0) {
            return new File[0];
        }
        File[] ret = new File[nTotalFiles];
        i = 0;
        File[][] arr$ = files;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File[] envFiles;
            for (File envFile : envFiles = arr$[i$]) {
                ret[i++] = envFile;
            }
        }
        Arrays.sort(ret, fileComparator);
        return ret;
    }

    private String[] listFileNamesInternal(JEFileFilter fileFilter) {
        if (this.nDataDirs == 0) {
            return this.listFileNamesInternalSingleDir(fileFilter);
        }
        return this.listFileNamesInternalMultiDirs(fileFilter);
    }

    private String[] listFileNamesInternalSingleDir(JEFileFilter fileFilter) {
        Object[] fileNames = this.dbEnvHome.list(fileFilter);
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    private String[] listFileNamesInternalMultiDirs(JEFileFilter filter) {
        String[][] files = new String[this.nDataDirs][];
        int nTotalFiles = 0;
        int i = 0;
        for (File envDir : this.dbEnvDataDirs) {
            files[i] = envDir.list(filter);
            String envDirName = envDir.toString();
            String dataDirName = envDirName.substring(envDirName.lastIndexOf(File.separator) + 1);
            for (int j = 0; j < files[i].length; ++j) {
                files[i][j] = dataDirName + File.separator + files[i][j];
            }
            nTotalFiles += files[i].length;
            ++i;
        }
        if (nTotalFiles == 0) {
            return new String[0];
        }
        String[] ret = new String[nTotalFiles];
        i = 0;
        String[][] arr$ = files;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] envFiles;
            for (String envFile : envFiles = arr$[i$]) {
                ret[i++] = envFile;
            }
        }
        Arrays.sort(ret, stringComparator);
        return ret;
    }

    private void checkNoDataDirs() {
        String[] dataDirNames = this.dbEnvHome.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.length() == "dataNNN".length() && name.startsWith("data");
            }
        });
        if (dataDirNames != null && dataDirNames.length != 0) {
            throw EnvironmentFailureException.unexpectedState(EnvironmentParams.LOG_N_DATA_DIRECTORIES.getName() + " was not set and expected to find no" + " data directories, but found " + dataDirNames.length + " data directories instead.");
        }
    }

    public File[] gatherDataDirs() {
        Object[] dataDirNames = this.dbEnvHome.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.length() == "dataNNN".length() && name.startsWith("data");
            }
        });
        if (dataDirNames != null) {
            Arrays.sort(dataDirNames);
        } else {
            dataDirNames = new String[]{};
        }
        if (dataDirNames.length != this.nDataDirs) {
            throw EnvironmentFailureException.unexpectedState(EnvironmentParams.LOG_N_DATA_DIRECTORIES.getName() + " was set and expected to find " + this.nDataDirs + " data directories, but found " + dataDirNames.length + " instead.");
        }
        int ddNum = 1;
        File[] dataDirs = new File[this.nDataDirs];
        for (Object fn : dataDirNames) {
            String subdirNumStr = ((String)fn).substring(4);
            try {
                int subdirNum = Integer.parseInt(subdirNumStr);
                if (subdirNum != ddNum) {
                    throw EnvironmentFailureException.unexpectedState("Expected to find data subdir: data" + this.paddedDirNum(ddNum) + " but found data" + subdirNumStr + " instead.");
                }
                File dataDir = new File(this.dbEnvHome, (String)fn);
                if (!dataDir.exists()) {
                    throw EnvironmentFailureException.unexpectedState("Data dir: " + dataDir + " doesn't exist.");
                }
                if (!dataDir.isDirectory()) {
                    throw EnvironmentFailureException.unexpectedState("Data dir: " + dataDir + " is not a directory.");
                }
                dataDirs[ddNum - 1] = dataDir;
            }
            catch (NumberFormatException E) {
                throw EnvironmentFailureException.unexpectedState("Illegal data subdir: data" + subdirNumStr);
            }
            ++ddNum;
        }
        return dataDirs;
    }

    private String paddedDirNum(int dirNum) {
        String paddedStr = "000" + dirNum;
        int len = paddedStr.length();
        return paddedStr.substring(len - 3);
    }

    String[] getFullFileNames(long fileNum) {
        if (this.includeDeletedFiles) {
            int nSuffixes = JE_AND_DEL_SUFFIXES.length;
            String[] ret = new String[nSuffixes];
            for (int i = 0; i < nSuffixes; ++i) {
                ret[i] = this.getFullFileName(fileNum, JE_AND_DEL_SUFFIXES[i]);
            }
            return ret;
        }
        return new String[]{this.getFullFileName(fileNum, JE_SUFFIX)};
    }

    private File getDataDir(long fileNum) {
        return this.nDataDirs == 0 ? this.dbEnvHome : this.dbEnvDataDirs[(int)(fileNum % (long)this.nDataDirs)];
    }

    public String getFullFileName(long fileNum) {
        return this.getFullFileName(fileNum, JE_SUFFIX);
    }

    public String getFullFileName(long fileNum, String suffix) {
        File dbEnvDataDir = this.getDataDir(fileNum);
        return dbEnvDataDir + File.separator + FileManager.getFileName(fileNum, suffix);
    }

    public String getFullFileName(String fileName) {
        int suffixStartPos = fileName.indexOf(".");
        String suffix = fileName.substring(suffixStartPos, fileName.length());
        assert (suffix != null);
        String fileNum = fileName.substring(0, suffixStartPos);
        return this.getFullFileName(Long.parseLong(fileNum, 16), suffix);
    }

    public static String getFileName(long fileNum, String suffix) {
        return FileManager.getFileNumberString(fileNum) + suffix;
    }

    public static String getFileName(long fileNum) {
        return FileManager.getFileName(fileNum, JE_SUFFIX);
    }

    private static String getFileNumberString(long fileNum) {
        return HexFormatter.formatLong(fileNum).substring(10);
    }

    public boolean renameFile(long fileNum, String newSuffix) throws IOException, DatabaseException {
        return this.renameFile(fileNum, newSuffix, null) != null;
    }

    public File renameFile(long fileNum, String newSuffix, String subDir) throws IOException {
        File newFile;
        File oldDir = this.getDataDir(fileNum);
        String oldName = FileManager.getFileName(fileNum);
        File oldFile = new File(oldDir, oldName);
        File newDir = subDir != null ? new File(oldDir, subDir) : oldDir;
        String newName = FileManager.getFileName(fileNum, newSuffix);
        String generation = "";
        int repeatNum = 0;
        while ((newFile = new File(newDir, newName + generation)).exists()) {
            generation = "." + ++repeatNum;
        }
        this.clearFileCache(fileNum);
        boolean success = oldFile.renameTo(newFile);
        return success ? newFile : null;
    }

    public boolean deleteFile(long fileNum) throws IOException, DatabaseException {
        String fileName = this.getFullFileNames(fileNum)[0];
        this.clearFileCache(fileNum);
        File file = new File(fileName);
        return file.delete();
    }

    public int getFileLogVersion(long fileNum) throws DatabaseException {
        try {
            FileHandle handle = this.getFileHandle(fileNum);
            int logVersion = handle.getLogVersion();
            handle.release();
            return logVersion;
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileHandle getFileHandle(long fileNum) throws FileNotFoundException, ChecksumException, DatabaseException {
        Long fileId = fileNum;
        FileHandle fileHandle = null;
        try {
            while (true) {
                fileHandle = this.fileCache.get(fileId);
                boolean newHandle = false;
                if (fileHandle == null) {
                    FileCache fileCache = this.fileCache;
                    synchronized (fileCache) {
                        fileHandle = this.fileCache.get(fileId);
                        if (fileHandle == null) {
                            newHandle = true;
                            fileHandle = this.addFileHandle(fileId);
                        }
                    }
                }
                if (newHandle) {
                    boolean success = false;
                    try {
                        this.openFileHandle(fileHandle, FileMode.READ_MODE, null);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            fileHandle.release();
                            this.clearFileCache(fileNum);
                        }
                    }
                } else if (!fileHandle.latchNoWait()) {
                    FileHandle existingHandle = fileHandle;
                    fileHandle = new FileHandle(this.envImpl, fileId, FileManager.getFileNumberString(fileId)){

                        @Override
                        public void release() throws DatabaseException {
                            try {
                                this.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                    this.openFileHandle(fileHandle, FileMode.READ_MODE, existingHandle);
                }
                if (fileHandle.getFile() == null) {
                    fileHandle.release();
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
        }
        return fileHandle;
    }

    private FileHandle addFileHandle(Long fileNum) throws IOException, DatabaseException {
        FileHandle fileHandle = new FileHandle(this.envImpl, fileNum, FileManager.getFileNumberString(fileNum));
        this.fileCache.add(fileNum, fileHandle);
        fileHandle.latch();
        return fileHandle;
    }

    private FileMode getAppropriateReadWriteMode() {
        if (this.useODSYNC) {
            return FileMode.READWRITE_ODSYNC_MODE;
        }
        return FileMode.READWRITE_MODE;
    }

    private FileHandle makeFileHandle(long fileNum, FileMode mode) throws FileNotFoundException, ChecksumException {
        FileHandle fileHandle = new FileHandle(this.envImpl, fileNum, FileManager.getFileNumberString(fileNum));
        this.openFileHandle(fileHandle, mode, null);
        return fileHandle;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openFileHandle(FileHandle fileHandle, FileMode mode, FileHandle existingHandle) throws FileNotFoundException, ChecksumException {
        this.nFileOpens.increment();
        long fileNum = fileHandle.getFileNum();
        String[] fileNames = this.getFullFileNames(fileNum);
        RandomAccessFile newFile = null;
        String fileName = null;
        boolean success = false;
        try {
            int logVersion;
            FileNotFoundException FNFE = null;
            String[] arr$ = fileNames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String fileName2;
                fileName = fileName2 = arr$[i$];
                try {
                    newFile = fileFactory.createFile(this.dbEnvHome, fileName, mode.getModeValue());
                    break;
                }
                catch (FileNotFoundException e) {
                    if (FNFE != null) continue;
                    FNFE = e;
                    continue;
                }
            }
            if (newFile == null) {
                assert (FNFE != null);
                throw FNFE;
            }
            if (existingHandle != null && (logVersion = existingHandle.getLogVersion()) > 0) {
                fileHandle.init(newFile, logVersion);
                return;
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, "Couldn't open file " + fileName, e2);
                }
                catch (DatabaseException e3) {
                    this.closeFileInErrorCase(newFile);
                    e3.addErrorMessage("Couldn't open file " + fileName);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.closeFileInErrorCase(newFile);
                }
                throw throwable;
            }
        }
        {
            int logVersion = 11;
            if (newFile.length() == 0L) {
                if (mode.isWritable()) {
                    long lastLsn = DbLsn.longToLsn(this.perFileLastUsedLsn.remove(fileNum - 1L));
                    long headerPrevOffset = 0L;
                    if (lastLsn != -1L) {
                        headerPrevOffset = DbLsn.getFileOffset(lastLsn);
                    }
                    if (headerPrevOffset == 0L && fileNum > 1L && this.syncAtFileEnd) {
                        throw EnvironmentFailureException.unexpectedState(this.envImpl, "Zero prevOffset fileNum=0x" + Long.toHexString(fileNum) + " lastLsn=" + DbLsn.getNoFormatString(lastLsn) + " perFileLastUsedLsn=" + this.perFileLastUsedLsn + " fileLen=" + newFile.length());
                    }
                    FileHeader fileHeader = new FileHeader(fileNum, headerPrevOffset);
                    this.writeFileHeader(newFile, fileName, fileHeader, fileNum);
                }
            } else {
                logVersion = this.readAndValidateFileHeader(newFile, fileName, fileNum);
            }
            fileHandle.init(newFile, logVersion);
            return;
        }
    }

    private void closeFileInErrorCase(RandomAccessFile file) {
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readAndValidateFileHeader(RandomAccessFile file, String fileName, long fileNum) throws ChecksumException, DatabaseException {
        LogManager logManager = this.envImpl.getLogManager();
        LogEntry headerEntry = logManager.getLogEntryAllowChecksumException(DbLsn.makeLsn(fileNum, 0), file, -1);
        FileHeader header = (FileHeader)headerEntry.getMainItem();
        return header.validate(this.envImpl, fileName, fileNum);
    }

    private void writeFileHeader(RandomAccessFile file, String fileName, FileHeader header, long fileNum) throws DatabaseException {
        int bytesWritten;
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        FileHeaderEntry headerLogEntry = new FileHeaderEntry(LogEntryType.LOG_FILE_HEADER, header);
        ByteBuffer headerBuf = this.envImpl.getLogManager().putIntoBuffer(headerLogEntry, 0L);
        try {
            if (LOGWRITE_EXCEPTION_TESTING) {
                this.generateLogWriteException(file, headerBuf, 0L, fileNum);
            }
            bytesWritten = this.writeToFile(file, headerBuf, 0L, fileNum, true);
        }
        catch (ClosedChannelException e) {
            throw new ThreadInterruptedException(this.envImpl, "Channel closed, may be due to thread interrupt", (Throwable)e);
        }
        catch (IOException e) {
            throw new LogWriteException(this.envImpl, (Throwable)e);
        }
        if (bytesWritten != headerLogEntry.getSize() + 14) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "File " + fileName + " was created with an incomplete header. Only " + bytesWritten + " bytes were written.");
        }
    }

    long getFileHeaderPrevOffset(long fileNum) throws ChecksumException, DatabaseException {
        try {
            LogEntry headerEntry = this.envImpl.getLogManager().getLogEntryAllowChecksumException(DbLsn.makeLsn(fileNum, 0));
            FileHeader header = (FileHeader)headerEntry.getMainItem();
            return header.getLastEntryInPrevFileOffset();
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
    }

    long getPrevEntryOffset() {
        return this.prevOffset;
    }

    boolean bumpLsn(long size) {
        boolean flippedFiles = false;
        if (this.forceNewFile || DbLsn.getFileOffset(this.nextAvailableLsn) + size > this.maxFileSize) {
            this.forceNewFile = false;
            ++this.currentFileNum;
            if (this.lastUsedLsn != -1L) {
                this.perFileLastUsedLsn.put(DbLsn.getFileNumber(this.lastUsedLsn), this.lastUsedLsn);
            }
            this.prevOffset = 0L;
            this.lastUsedLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
            flippedFiles = true;
        } else {
            this.prevOffset = this.lastUsedLsn == -1L ? 0L : DbLsn.getFileOffset(this.lastUsedLsn);
            this.lastUsedLsn = this.nextAvailableLsn;
        }
        this.nextAvailableLsn = DbLsn.makeLsn(DbLsn.getFileNumber(this.lastUsedLsn), DbLsn.getFileOffset(this.lastUsedLsn) + size);
        return flippedFiles;
    }

    void writeLogBuffer(LogBuffer fullBuffer, boolean flushRequired) throws DatabaseException {
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        long firstLsn = fullBuffer.getFirstLsn();
        if (firstLsn != -1L) {
            RandomAccessFile file = this.endOfLog.getWritableFile(DbLsn.getFileNumber(firstLsn), true);
            ByteBuffer data = fullBuffer.getDataBuffer();
            try {
                assert (fullBuffer.getRewriteAllowed() || DbLsn.getFileOffset(firstLsn) >= file.length() || file.length() == (long)FileManager.firstLogEntryOffset()) : "FileManager would overwrite non-empty file 0x" + Long.toHexString(DbLsn.getFileNumber(firstLsn)) + " lsnOffset=0x" + Long.toHexString(DbLsn.getFileOffset(firstLsn)) + " fileLength=0x" + Long.toHexString(file.length());
                if (LOGWRITE_EXCEPTION_TESTING) {
                    this.generateLogWriteException(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn));
                }
                this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn), flushRequired);
            }
            catch (ClosedChannelException e) {
                throw new ThreadInterruptedException(this.envImpl, "File closed, may be due to thread interrupt", (Throwable)e);
            }
            catch (IOException e) {
                throw new LogWriteException(this.envImpl, (Throwable)e);
            }
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToFile(RandomAccessFile file, ByteBuffer data, long destOffset, long fileNum, boolean flushRequired) throws IOException, DatabaseException {
        int totalBytesWritten = 0;
        this.bumpWriteCount("write");
        int pos = data.position();
        int size = data.limit() - pos;
        if (this.lastFileNumberTouched == fileNum && Math.abs(destOffset - this.lastFileTouchedOffset) < 0x100000L) {
            this.nSequentialWrites.increment();
            this.nSequentialWriteBytes.add(size);
        } else {
            this.nRandomWrites.increment();
            this.nRandomWriteBytes.add(size);
        }
        if (this.VERIFY_CHECKSUMS) {
            this.verifyChecksums(data, destOffset, "pre-write");
        }
        boolean fsyncLatchAcquired = this.endOfLog.fsyncFileSynchronizer.tryLock();
        boolean enqueueSuccess = false;
        if (!fsyncLatchAcquired && this.useWriteQueue && !flushRequired) {
            enqueueSuccess = this.endOfLog.enqueueWrite(fileNum, data.array(), destOffset, pos + data.arrayOffset(), size);
        }
        if (!enqueueSuccess) {
            if (!fsyncLatchAcquired) {
                this.endOfLog.fsyncFileSynchronizer.lock();
            }
            try {
                if (this.useWriteQueue) {
                    this.endOfLog.dequeuePendingWrites1();
                }
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    file.seek(destOffset);
                    file.write(data.array(), pos + data.arrayOffset(), size);
                    if (this.VERIFY_CHECKSUMS) {
                        file.seek(destOffset);
                        file.read(data.array(), pos + data.arrayOffset(), size);
                        this.verifyChecksums(data, destOffset, "post-write");
                    }
                }
            }
            finally {
                this.endOfLog.fsyncFileSynchronizer.unlock();
            }
        }
        data.position(pos + size);
        totalBytesWritten = size;
        this.lastFileNumberTouched = fileNum;
        this.lastFileTouchedOffset = destOffset + (long)size;
        return totalBytesWritten;
    }

    private void bumpWriteCount(String debugMsg) throws IOException {
        if (++WRITE_COUNT >= STOP_ON_WRITE_COUNT && WRITE_COUNT < STOP_ON_WRITE_COUNT + N_BAD_WRITES) {
            if (THROW_ON_WRITE) {
                throw new IOException("IOException generated for testing: " + WRITE_COUNT + " " + debugMsg);
            }
            Runtime.getRuntime().halt(255);
        }
    }

    void readFromFile(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNo) throws DatabaseException {
        this.readFromFile(file, readBuffer, offset, fileNo, true);
    }

    boolean readFromFile(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNo, boolean dataKnownToBeInFile) throws DatabaseException {
        try {
            if (this.useWriteQueue && this.endOfLog.checkWriteCache(readBuffer, offset, fileNo)) {
                return true;
            }
            boolean readThisFile = true;
            if (!dataKnownToBeInFile) {
                boolean bl = readThisFile = offset < file.length();
            }
            if (readThisFile) {
                this.readFromFileInternal(file, readBuffer, offset, fileNo);
                return true;
            }
            return false;
        }
        catch (ClosedChannelException e) {
            throw new ThreadInterruptedException(this.envImpl, "Channel closed, may be due to thread interrupt", (Throwable)e);
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromFileInternal(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNum) throws IOException {
        RandomAccessFile randomAccessFile = file;
        synchronized (randomAccessFile) {
            int pos = readBuffer.position();
            int size = readBuffer.limit() - pos;
            if (this.lastFileNumberTouched == fileNum && Math.abs(offset - this.lastFileTouchedOffset) < 0x100000L) {
                this.nSequentialReads.increment();
                this.nSequentialReadBytes.add(size);
            } else {
                this.nRandomReads.increment();
                this.nRandomReadBytes.add(size);
            }
            file.seek(offset);
            int bytesRead = file.read(readBuffer.array(), pos + readBuffer.arrayOffset(), size);
            if (bytesRead > 0) {
                readBuffer.position(pos + bytesRead);
            }
            this.lastFileNumberTouched = fileNum;
            this.lastFileTouchedOffset = offset + (long)bytesRead;
        }
    }

    private void printLogBuffer(ByteBuffer entryBuffer, long lsn) {
        int curPos = entryBuffer.position();
        while (entryBuffer.remaining() > 0) {
            int recStartPos = entryBuffer.position();
            LogEntryHeader header = null;
            try {
                header = new LogEntryHeader(entryBuffer, 11);
            }
            catch (ChecksumException e) {
                System.err.println("ChecksumException in printLogBuffer " + e);
                break;
            }
            LogEntryType recType = LogEntryType.findType(header.getType());
            int recSize = header.getSize() + header.getItemSize();
            System.out.println("LOGREC " + recType.toStringNoVersion() + " at LSN " + DbLsn.toString(lsn) + " , file offset " + DbLsn.getFileOffset(lsn) + " , log buffer offset " + recStartPos);
            lsn += (long)recSize;
            entryBuffer.position(recStartPos + recSize);
        }
        entryBuffer.position(curPos);
    }

    private void verifyChecksums(ByteBuffer entryBuffer, long lsn, String comment) {
        int curPos = entryBuffer.position();
        try {
            while (entryBuffer.remaining() > 0) {
                int recStartPos = entryBuffer.position();
                LogEntryHeader header = new LogEntryHeader(entryBuffer, 11);
                this.verifyChecksum(entryBuffer, header, lsn, comment);
                entryBuffer.position(recStartPos + header.getSize() + header.getItemSize());
            }
        }
        catch (ChecksumException e) {
            System.err.println("ChecksumException: (" + comment + ") " + e);
            System.err.println("start stack trace");
            e.printStackTrace(System.err);
            System.err.println("end stack trace");
        }
        entryBuffer.position(curPos);
    }

    private void verifyChecksum(ByteBuffer entryBuffer, LogEntryHeader header, long lsn, String comment) throws ChecksumException {
        ChecksumValidator validator = null;
        validator = new ChecksumValidator();
        int headerSizeMinusChecksum = header.getSizeMinusChecksum();
        int itemStart = entryBuffer.position();
        entryBuffer.position(itemStart - headerSizeMinusChecksum);
        validator.update(entryBuffer, headerSizeMinusChecksum);
        entryBuffer.position(itemStart);
        int itemSize = header.getItemSize();
        if (entryBuffer.remaining() < itemSize) {
            System.err.println("Couldn't verify checksum (" + comment + ")");
            return;
        }
        validator.update(entryBuffer, itemSize);
        validator.validate(header.getChecksum(), lsn);
    }

    void syncLogEnd() throws DatabaseException {
        try {
            this.endOfLog.force();
        }
        catch (IOException e) {
            throw new LogWriteException(this.envImpl, "IOException during fsync", (Throwable)e);
        }
    }

    void syncLogEndAndFinishFile() throws DatabaseException, IOException {
        if (this.syncAtFileEnd) {
            this.syncLogEnd();
        }
        this.endOfLog.close();
    }

    public boolean hasQueuedWrites() {
        return this.endOfLog.hasQueuedWrites();
    }

    public void testWriteQueueLock() {
        this.endOfLog.fsyncFileSynchronizer.lock();
    }

    public void testWriteQueueUnlock() {
        this.endOfLog.fsyncFileSynchronizer.unlock();
    }

    public void startFileCacheWarmer(long recoveryStartLsn) {
        assert (this.fileCacheWarmer == null);
        DbConfigManager cm = this.envImpl.getConfigManager();
        int warmUpSize = cm.getInt(EnvironmentParams.LOG_FILE_WARM_UP_SIZE);
        if (warmUpSize == 0) {
            return;
        }
        int bufSize = cm.getInt(EnvironmentParams.LOG_FILE_WARM_UP_BUF_SIZE);
        this.fileCacheWarmer = new FileCacheWarmer(this.envImpl, recoveryStartLsn, this.lastUsedLsn, warmUpSize, bufSize);
        this.fileCacheWarmer.start();
    }

    private void stopFileCacheWarmer() {
        FileCacheWarmer fcw = this.fileCacheWarmer;
        if (fcw == null) {
            return;
        }
        fcw.shutdown();
        this.clearFileCacheWarmer();
    }

    void clearFileCacheWarmer() {
        this.fileCacheWarmer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException, DatabaseException {
        FileCache fileCache = this.fileCache;
        synchronized (fileCache) {
            this.fileCache.clear();
        }
        this.endOfLog.close();
    }

    public void close() throws IOException {
        this.stopFileCacheWarmer();
        if (this.envLock != null) {
            this.envLock.release();
            this.envLock = null;
        }
        if (this.exclLock != null) {
            this.exclLock.release();
            this.exclLock = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.lockFile != null) {
            this.lockFile.close();
            this.lockFile = null;
        }
    }

    public boolean lockEnvironment(boolean rdOnly, boolean exclusive) {
        try {
            if (this.checkEnvHomePermissions(rdOnly)) {
                return true;
            }
            if (this.lockFile == null) {
                this.lockFile = new RandomAccessFile(new File(this.dbEnvHome, LOCK_FILE), FileMode.READWRITE_MODE.getModeValue());
            }
            this.channel = this.lockFile.getChannel();
            try {
                if (exclusive) {
                    this.exclLock = this.channel.tryLock(1L, 1L, false);
                    return this.exclLock != null;
                }
                this.envLock = rdOnly ? this.channel.tryLock(1L, 1L, true) : this.channel.tryLock(0L, 1L, false);
                return this.envLock != null;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
        }
    }

    public void releaseExclusiveLock() throws DatabaseException {
        try {
            if (this.exclLock != null) {
                this.exclLock.release();
            }
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
        }
    }

    public boolean checkEnvHomePermissions(boolean rdOnly) throws DatabaseException {
        if (this.nDataDirs == 0) {
            return this.checkEnvHomePermissionsSingleEnvDir(this.dbEnvHome, rdOnly);
        }
        return this.checkEnvHomePermissionsMultiEnvDir(rdOnly);
    }

    private boolean checkEnvHomePermissionsSingleEnvDir(File dbEnvHome, boolean rdOnly) throws DatabaseException {
        boolean envDirIsReadOnly;
        boolean bl = envDirIsReadOnly = !dbEnvHome.canWrite();
        if (envDirIsReadOnly && !rdOnly) {
            throw new IllegalArgumentException("The Environment directory " + dbEnvHome.getAbsolutePath() + " is not writable, but the " + "Environment was opened for read-write access.");
        }
        return envDirIsReadOnly;
    }

    private boolean checkEnvHomePermissionsMultiEnvDir(boolean rdOnly) throws DatabaseException {
        for (File dbEnvDir : this.dbEnvDataDirs) {
            if (this.checkEnvHomePermissionsSingleEnvDir(dbEnvDir, rdOnly)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateSingleFile(long fileNum, long offset) throws IOException, DatabaseException {
        try {
            FileHandle handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
            try (RandomAccessFile file = handle.getFile();){
                file.getChannel().truncate(offset);
            }
            if (handle.isOldHeaderVersion()) {
                this.forceNewFile = true;
            }
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
    }

    public void truncateLog(long fileNum, long offset) throws IOException, DatabaseException {
        for (long i = this.getLastFileNum().longValue(); i >= fileNum; --i) {
            if (!this.isFileValid(i)) continue;
            if (i == fileNum) {
                this.truncateSingleFile(fileNum, offset);
                if (offset != 0L) continue;
            }
            boolean deleted = this.deleteFile(i);
            assert (deleted) : "File " + this.getFullFileName(i, ".jdb") + " not deleted during truncateLog";
        }
    }

    public void makeInvisible(long fileNum, List<Long> lsns) {
        if (lsns.size() == 0) {
            return;
        }
        FileHandle handle = null;
        try {
            handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Opening file " + fileNum + " for invisible marking ", e);
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, "Opening file " + fileNum + " for invisible marking ", e);
        }
        RandomAccessFile file = handle.getFile();
        try {
            for (Long lsn : lsns) {
                if (DbLsn.getFileNumber(lsn) != fileNum) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.UNEXPECTED_STATE, "LSN of " + DbLsn.getNoFormatString(lsn) + " did not match file number" + fileNum);
                }
                int entryFlagsOffset = (int)(DbLsn.getFileOffset(lsn) + 5L);
                file.seek(entryFlagsOffset);
                byte flags = file.readByte();
                byte newFlags = LogEntryHeader.makeInvisible(flags);
                file.seek(entryFlagsOffset);
                file.writeByte(newFlags);
            }
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Flipping invisibility in file " + fileNum, e);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Closing after invisibility cloaking: file " + fileNum, e);
            }
        }
    }

    public void force(Set<Long> fileNums) {
        for (long fileNum : fileNums) {
            RandomAccessFile file = null;
            try {
                FileHandle handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
                file = handle.getFile();
                file.getChannel().force(false);
                this.nLogFSyncs.increment();
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, "Invisible fsyncing file " + fileNum, e);
            }
            catch (ChecksumException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Invisible fsyncing file " + fileNum, e);
            }
            catch (IOException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Invisible fsyncing file " + fileNum, e);
            }
            finally {
                if (file == null) continue;
                try {
                    file.close();
                }
                catch (IOException e) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Invisible fsyncing file " + fileNum, e);
                }
            }
        }
    }

    public void forceNewLogFile() {
        this.forceNewFile = true;
    }

    public static int firstLogEntryOffset() {
        return FileHeader.entrySize() + 14;
    }

    public long getNextLsn() {
        return this.nextAvailableLsn;
    }

    public long getLastUsedLsn() {
        return this.lastUsedLsn;
    }

    StatGroup loadStats(StatsConfig config) {
        this.nOpenFiles.set(this.fileCache.size());
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        return copyStats;
    }

    Set<Long> getCacheKeys() {
        return this.fileCache.getCacheKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileCache(long fileNum) throws IOException, DatabaseException {
        FileCache fileCache = this.fileCache;
        synchronized (fileCache) {
            this.fileCache.remove(fileNum);
        }
    }

    private void generateLogWriteException(RandomAccessFile file, ByteBuffer data, long destOffset, long fileNum) throws DatabaseException, IOException {
        if (this.logWriteExceptionThrown) {
            new Exception("Write after LogWriteException").printStackTrace();
        }
        ++this.logWriteExceptionCounter;
        if (this.logWriteExceptionCounter >= 100) {
            this.logWriteExceptionCounter = 0;
        }
        if (this.logWriteExceptionRandom == null) {
            this.logWriteExceptionRandom = new Random(System.currentTimeMillis());
        }
        if (this.logWriteExceptionCounter == this.logWriteExceptionRandom.nextInt(100)) {
            int len = this.logWriteExceptionRandom.nextInt(data.remaining());
            if (len > 0) {
                byte[] a = new byte[len];
                data.get(a, 0, len);
                ByteBuffer buf = ByteBuffer.wrap(a);
                this.writeToFile(file, buf, destOffset, fileNum, false);
            }
            this.logWriteExceptionThrown = true;
            throw new IOException("Randomly generated for testing");
        }
    }

    static {
        RRET_PROPERTY_NAME = "je.logwrite.exception.testing";
        LOGWRITE_EXCEPTION_TESTING = System.getProperty(RRET_PROPERTY_NAME) != null;
        fileFactory = new FileFactory(){

            @Override
            public RandomAccessFile createFile(File envHome, String fullName, String mode) throws FileNotFoundException {
                return new DefaultRandomAccessFile(fullName, mode);
            }
        };
    }

    public static class DefaultRandomAccessFile
    extends RandomAccessFile {
        public DefaultRandomAccessFile(String fullName, String mode) throws FileNotFoundException {
            super(fullName, mode);
        }

        @Override
        public synchronized long length() throws IOException {
            return super.length();
        }
    }

    public static interface FileFactory {
        public RandomAccessFile createFile(File var1, String var2, String var3) throws FileNotFoundException;
    }

    class LogEndFileDescriptor {
        private RandomAccessFile endOfLogRWFile = null;
        private RandomAccessFile endOfLogSyncFile = null;
        private final ReentrantLock fsyncFileSynchronizer = new ReentrantLock();
        private final byte[] queuedWrites = FileManager.access$1000(FileManager.this) ? new byte[FileManager.access$1100(FileManager.this)] : null;
        private int queuedWritesPosition = 0;
        private long qwStartingOffset;
        private long qwFileNum = -1L;

        LogEndFileDescriptor() {
        }

        void setQueueFileNum(long qwFileNum) {
            this.qwFileNum = qwFileNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkWriteCache(ByteBuffer readBuffer, long requestedOffset, long fileNum) {
            int pos = readBuffer.position();
            int targetBufSize = readBuffer.limit() - pos;
            byte[] byArray = this.queuedWrites;
            synchronized (this.queuedWrites) {
                if (this.qwFileNum != fileNum) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return false;
                }
                if (this.queuedWritesPosition == 0) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return false;
                }
                if (requestedOffset < this.qwStartingOffset || this.qwStartingOffset + (long)this.queuedWritesPosition <= requestedOffset) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return false;
                }
                int nBytesToCopy = (int)((long)this.queuedWritesPosition - (requestedOffset - this.qwStartingOffset));
                nBytesToCopy = Math.min(nBytesToCopy, targetBufSize);
                readBuffer.put(this.queuedWrites, (int)(requestedOffset - this.qwStartingOffset), nBytesToCopy);
                FileManager.this.nBytesReadFromWriteQueue.add(nBytesToCopy);
                FileManager.this.nReadsFromWriteQueue.increment();
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return true;
            }
        }

        boolean enqueueWrite(long fileNum, byte[] data, long destOffset, int arrayOffset, int size) throws DatabaseException {
            assert (!this.fsyncFileSynchronizer.isHeldByCurrentThread());
            for (int i = 0; i < 2; ++i) {
                try {
                    this.enqueueWrite1(fileNum, data, destOffset, arrayOffset, size);
                    return true;
                }
                catch (RelatchRequiredException RE) {
                    this.dequeuePendingWrites();
                    continue;
                }
            }
            FileManager.this.nWriteQueueOverflowFailures.increment();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueWrite1(long fileNum, byte[] data, long destOffset, int arrayOffset, int size) throws RelatchRequiredException, DatabaseException {
            if (this.qwFileNum < fileNum) {
                this.dequeuePendingWrites();
                this.qwFileNum = fileNum;
            }
            byte[] byArray = this.queuedWrites;
            synchronized (this.queuedWrites) {
                boolean overflow;
                boolean bl = overflow = FileManager.this.writeQueueSize - this.queuedWritesPosition < size;
                if (overflow) {
                    FileManager.this.nWriteQueueOverflow.increment();
                    throw RelatchRequiredException.relatchRequiredException;
                }
                assert (this.qwFileNum == fileNum);
                int curPos = this.queuedWritesPosition;
                if (curPos == 0) {
                    this.qwStartingOffset = destOffset;
                }
                if ((long)curPos + this.qwStartingOffset != destOffset) {
                    throw new EnvironmentFailureException(FileManager.this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "non-consecutive writes queued. qwPos=" + this.queuedWritesPosition + " write destOffset=" + destOffset);
                }
                System.arraycopy(data, arrayOffset, this.queuedWrites, this.queuedWritesPosition, size);
                this.queuedWritesPosition += size;
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return;
            }
        }

        boolean hasQueuedWrites() {
            return this.queuedWritesPosition > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dequeuePendingWrites() throws DatabaseException {
            assert (!this.fsyncFileSynchronizer.isHeldByCurrentThread());
            this.fsyncFileSynchronizer.lock();
            try {
                this.dequeuePendingWrites1();
            }
            finally {
                this.fsyncFileSynchronizer.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dequeuePendingWrites1() throws DatabaseException {
            assert (this.fsyncFileSynchronizer.isHeldByCurrentThread());
            try {
                byte[] byArray = this.queuedWrites;
                synchronized (this.queuedWrites) {
                    RandomAccessFile file;
                    if (this.queuedWritesPosition == 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    RandomAccessFile randomAccessFile = file = this.getWritableFile(this.qwFileNum, false);
                    synchronized (randomAccessFile) {
                        file.seek(this.qwStartingOffset);
                        file.write(this.queuedWrites, 0, this.queuedWritesPosition);
                        FileManager.this.nBytesWrittenFromWriteQueue.add(this.queuedWritesPosition);
                        FileManager.this.nWritesFromWriteQueue.increment();
                        if (FileManager.this.VERIFY_CHECKSUMS) {
                            file.seek(this.qwStartingOffset);
                            file.read(this.queuedWrites, 0, this.queuedWritesPosition);
                            ByteBuffer bb = ByteBuffer.allocate(this.queuedWritesPosition);
                            bb.put(this.queuedWrites, 0, this.queuedWritesPosition);
                            bb.position(0);
                            FileManager.this.verifyChecksums(bb, this.qwStartingOffset, "post-write");
                        }
                    }
                    this.queuedWritesPosition = 0;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (IOException e) {
                throw new LogWriteException(FileManager.this.envImpl, "IOException during fsync", (Throwable)e);
            }
            {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RandomAccessFile getWritableFile(long fileNumber, boolean doLock) {
            try {
                if (this.endOfLogRWFile == null) {
                    if (doLock) {
                        this.fsyncFileSynchronizer.lock();
                    }
                    try {
                        this.endOfLogRWFile = FileManager.this.makeFileHandle(fileNumber, FileManager.this.getAppropriateReadWriteMode()).getFile();
                        this.endOfLogSyncFile = FileManager.this.makeFileHandle(fileNumber, FileManager.this.getAppropriateReadWriteMode()).getFile();
                    }
                    finally {
                        if (doLock) {
                            this.fsyncFileSynchronizer.unlock();
                        }
                    }
                }
                return this.endOfLogRWFile;
            }
            catch (Exception e) {
                throw new EnvironmentFailureException(FileManager.this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void force() throws DatabaseException, IOException {
            this.fsyncFileSynchronizer.lock();
            try {
                RandomAccessFile file;
                if (FileManager.this.useWriteQueue) {
                    this.dequeuePendingWrites1();
                }
                if ((file = this.endOfLogSyncFile) != null) {
                    FileManager.this.bumpWriteCount("fsync");
                    FileChannel ch = file.getChannel();
                    try {
                        long start = System.currentTimeMillis();
                        ch.force(false);
                        FileManager.this.nLogFSyncs.increment();
                        long fsyncMs = System.currentTimeMillis() - start;
                        FileManager.this.nFSyncTime.add(fsyncMs);
                    }
                    catch (ClosedChannelException e) {
                        throw new ThreadInterruptedException(FileManager.this.envImpl, "Channel closed, may be due to thread interrupt", (Throwable)e);
                    }
                    assert (EnvironmentImpl.maybeForceYield());
                }
                if (FileManager.this.useWriteQueue) {
                    this.dequeuePendingWrites1();
                }
            }
            finally {
                this.fsyncFileSynchronizer.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            this.fsyncFileSynchronizer.lock();
            try {
                RandomAccessFile file;
                IOException firstException = null;
                if (this.endOfLogRWFile != null) {
                    file = this.endOfLogRWFile;
                    this.endOfLogRWFile = null;
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        firstException = e;
                    }
                }
                if (this.endOfLogSyncFile != null) {
                    file = this.endOfLogSyncFile;
                    this.endOfLogSyncFile = null;
                    file.close();
                }
                if (firstException != null) {
                    throw firstException;
                }
            }
            finally {
                this.fsyncFileSynchronizer.unlock();
            }
        }
    }

    private static class FileCache {
        private final Map<Long, FileHandle> fileMap = new Hashtable<Long, FileHandle>();
        private final List<Long> fileList = new LinkedList<Long>();
        private final int fileCacheSize;

        FileCache(DbConfigManager configManager) {
            this.fileCacheSize = configManager.getInt(EnvironmentParams.LOG_FILE_CACHE_SIZE);
        }

        private FileHandle get(Long fileId) {
            return this.fileMap.get(fileId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Long fileId, FileHandle fileHandle) throws IOException, DatabaseException {
            if (this.fileList.size() >= this.fileCacheSize) {
                Iterator<Long> iter = this.fileList.iterator();
                while (iter.hasNext()) {
                    Long evictId = iter.next();
                    FileHandle evictTarget = this.fileMap.get(evictId);
                    if (!evictTarget.latchNoWait()) continue;
                    try {
                        this.fileMap.remove(evictId);
                        iter.remove();
                        evictTarget.close();
                        break;
                    }
                    finally {
                        evictTarget.release();
                    }
                }
            }
            this.fileList.add(fileId);
            this.fileMap.put(fileId, fileHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(long fileNum) throws IOException, DatabaseException {
            Iterator<Long> iter = this.fileList.iterator();
            while (iter.hasNext()) {
                Long evictId = iter.next();
                if (evictId != fileNum) continue;
                FileHandle evictTarget = this.fileMap.get(evictId);
                try {
                    evictTarget.latch();
                    this.fileMap.remove(evictId);
                    iter.remove();
                    evictTarget.close();
                }
                finally {
                    evictTarget.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() throws IOException, DatabaseException {
            Iterator<FileHandle> iter = this.fileMap.values().iterator();
            while (iter.hasNext()) {
                FileHandle fileHandle = iter.next();
                try {
                    fileHandle.latch();
                    fileHandle.close();
                    iter.remove();
                }
                finally {
                    fileHandle.release();
                }
            }
            this.fileMap.clear();
            this.fileList.clear();
        }

        private Set<Long> getCacheKeys() {
            return this.fileMap.keySet();
        }

        private int size() {
            return this.fileMap.size();
        }
    }

    public static enum FileMode {
        READ_MODE("r", false),
        READWRITE_MODE("rw", true),
        READWRITE_ODSYNC_MODE("rwd", true),
        READWRITE_OSYNC_MODE("rws", true);

        private String fileModeValue;
        private boolean isWritable;

        private FileMode(String fileModeValue, boolean isWritable) {
            this.fileModeValue = fileModeValue;
            this.isWritable = isWritable;
        }

        public String getModeValue() {
            return this.fileModeValue;
        }

        public boolean isWritable() {
            return this.isWritable;
        }
    }
}

