/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TxnChain {
    private final EnvironmentImpl envImpl;
    private final Map<DatabaseId, DatabaseImpl> undoDatabases;
    private final Set<Long> remainingLockedNodes;
    private final LinkedList<RevertInfo> revertList;
    private VLSN lastValidVLSN;

    public TxnChain(long lastLoggedLsn, long txnId, long matchpoint, EnvironmentImpl envImpl) {
        this(lastLoggedLsn, txnId, matchpoint, null, envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TxnChain(long lastLoggedLsn, long txnId, long matchpoint, Map<DatabaseId, DatabaseImpl> undoDatabases, EnvironmentImpl envImpl) throws DatabaseException {
        LogManager logManager = envImpl.getLogManager();
        this.envImpl = envImpl;
        this.undoDatabases = undoDatabases;
        this.remainingLockedNodes = new HashSet<Long>();
        TreeMap<CompareSlot, RevertInfo> recordsMap = new TreeMap<CompareSlot, RevertInfo>();
        this.revertList = new LinkedList();
        long currLsn = lastLoggedLsn;
        try {
            this.lastValidVLSN = VLSN.NULL_VLSN;
            while (currLsn != -1L) {
                WholeEntry wholeEntry = logManager.getLogEntryAllowInvisible(currLsn);
                LNLogEntry currLogrec = (LNLogEntry)wholeEntry.getEntry();
                DatabaseImpl dbImpl = this.getDatabaseImpl(currLogrec.getDbId());
                if (dbImpl == null) {
                    if (undoDatabases != null) {
                        throw EnvironmentFailureException.unexpectedState(envImpl, "DB missing during non-recovery rollback, dbId=" + currLogrec.getDbId() + " txnId=" + txnId);
                    }
                    currLsn = currLogrec.getUserTxn().getLastLsn();
                    continue;
                }
                currLogrec.postFetchInit(dbImpl);
                try {
                    CompareSlot recId = new CompareSlot(dbImpl, currLogrec);
                    RevertInfo ri = (RevertInfo)recordsMap.get(recId);
                    if (ri != null) {
                        ri.revertLsn = currLsn;
                        ri.revertKD = false;
                        ri.revertPD = currLogrec.isDeleted();
                        ri.revertKey = dbImpl.allowsKeyUpdates() ? currLogrec.getKey() : null;
                        ri.revertData = currLogrec.isEmbeddedLN() ? currLogrec.getData() : null;
                        long l = ri.revertVLSN = currLogrec.isEmbeddedLN() ? currLogrec.getLN().getVLSNSequence() : VLSN.NULL_VLSN.getSequence();
                    }
                    if (DbLsn.compareTo(currLsn, matchpoint) > 0) {
                        ri = new RevertInfo(currLogrec.getAbortLsn(), currLogrec.getAbortKnownDeleted(), currLogrec.getAbortKey(), currLogrec.getAbortData(), currLogrec.getAbortVLSN());
                        this.revertList.add(ri);
                        recordsMap.put(recId, ri);
                    } else {
                        if (ri != null) {
                            recordsMap.remove(recId);
                        }
                        this.remainingLockedNodes.add(currLsn);
                        if (this.lastValidVLSN != null && this.lastValidVLSN.isNull() && wholeEntry.getHeader().getVLSN() != null && !wholeEntry.getHeader().getVLSN().isNull()) {
                            this.lastValidVLSN = wholeEntry.getHeader().getVLSN();
                        }
                    }
                    currLsn = currLogrec.getUserTxn().getLastLsn();
                }
                finally {
                    this.releaseDatabaseImpl(dbImpl);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw EnvironmentFailureException.promote(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Problem finding intermediates for txn " + txnId + " at lsn " + DbLsn.getNoFormatString(currLsn), e);
        }
    }

    private DatabaseImpl getDatabaseImpl(DatabaseId dbId) {
        if (this.undoDatabases != null) {
            return this.undoDatabases.get(dbId);
        }
        return this.envImpl.getDbTree().getDb(dbId);
    }

    private void releaseDatabaseImpl(DatabaseImpl dbImpl) {
        if (this.undoDatabases == null) {
            this.envImpl.getDbTree().releaseDb(dbImpl);
        }
    }

    public Set<Long> getRemainingLockedNodes() {
        return this.remainingLockedNodes;
    }

    public RevertInfo pop() {
        return this.revertList.remove();
    }

    public VLSN getLastValidVLSN() {
        return this.lastValidVLSN;
    }

    public String toString() {
        return this.revertList.toString();
    }

    public static class CompareSlot
    implements Comparable<CompareSlot> {
        private final DatabaseImpl dbImpl;
        private final byte[] key;

        public CompareSlot(DatabaseImpl dbImpl, LNLogEntry<?> undoEntry) {
            this(dbImpl, undoEntry.getKey());
        }

        private CompareSlot(DatabaseImpl dbImpl, byte[] key) {
            this.dbImpl = dbImpl;
            this.key = key;
        }

        @Override
        public int compareTo(CompareSlot other) {
            int dbCompare = this.dbImpl.getId().compareTo(other.dbImpl.getId());
            if (dbCompare != 0) {
                return dbCompare;
            }
            return Key.compareKeys(this.key, other.key, this.dbImpl.getKeyComparator());
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompareSlot)) {
                return false;
            }
            return this.compareTo((CompareSlot)other) == 0;
        }

        public int hashCode() {
            throw EnvironmentFailureException.unexpectedState("Hashing not supported");
        }
    }

    public static class RevertInfo {
        public long revertLsn;
        public boolean revertKD;
        public boolean revertPD;
        public byte[] revertKey;
        public byte[] revertData;
        public long revertVLSN;

        RevertInfo(long revertLsn, boolean revertKD, byte[] revertKey, byte[] revertData, long revertVLSN) {
            this.revertLsn = revertLsn;
            this.revertKD = revertKD;
            this.revertPD = false;
            this.revertKey = revertKey;
            this.revertData = revertData;
            this.revertVLSN = revertVLSN;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("revertLsn=");
            sb.append(DbLsn.getNoFormatString(this.revertLsn));
            sb.append(" revertKD=").append(this.revertKD);
            sb.append(" revertPD=").append(this.revertPD);
            if (this.revertKey != null) {
                sb.append(" revertKey=");
                sb.append(Key.getNoFormatString(this.revertKey));
            }
            if (this.revertData != null) {
                sb.append(" revertData=");
                sb.append(Key.getNoFormatString(this.revertData));
            }
            return sb.toString();
        }
    }
}

