/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.BaseStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.text.DecimalFormat;

public abstract class Stat<T>
extends BaseStat<T>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###,###");
    protected final StatDefinition definition;

    Stat(StatGroup group, StatDefinition definition) {
        this.definition = definition;
        group.register(this);
    }

    Stat(StatDefinition definition) {
        this.definition = definition;
    }

    public abstract void set(T var1);

    public abstract void add(Stat<T> var1);

    public abstract Stat<T> computeInterval(Stat<T> var1);

    public abstract void negate();

    @Override
    public Stat<T> copy() {
        Stat copy;
        try {
            copy = (Stat)super.clone();
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException(unexpected);
        }
        return copy;
    }

    public Stat<T> copyAndClear() {
        BaseStat newCopy = this.copy();
        this.clear();
        return newCopy;
    }

    public StatDefinition getDefinition() {
        return this.definition;
    }

    public String toString() {
        return this.definition.getName() + "=" + this.getFormattedValue();
    }

    public String toStringVerbose() {
        return this.definition.getName() + "=" + this.getFormattedValue() + "\n\t\t" + this.definition.getDescription();
    }
}

