/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapAllocator;
import com.sleepycat.je.evictor.OffHeapAllocatorFactory;
import com.sleepycat.je.evictor.OffHeapStatDefinition;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Checksum;

public class OffHeapCache
implements EnvConfigObserver {
    private static final int VLSN_SIZE = 8;
    private static final int CHECKSUM_SIZE = 4;
    private static final int MAX_UNUSED_BIN_BYTES = 100;
    private static final int BIN_FLAG_DELTA = 1;
    private static final int BIN_FLAG_CAN_MUTATE = 2;
    private static final int BIN_FLAG_PROHIBIT_NEXT_DELTA = 4;
    private static final int BIN_FLAG_LOGGED_FULL_VERSION = 8;
    private static final boolean DEBUG_DOUBLE_FREE = false;
    private static final boolean DEBUG_TRACE = false;
    private static final boolean DEBUG_TRACE_STACK = false;
    private static final boolean DEBUG_TRACE_AND_LOG = false;
    private static final int CHUNK_SIZE = 102400;
    private static final long CHUNK_MEMORY_SIZE = MemoryBudget.OBJECT_OVERHEAD + 16 + MemoryBudget.longArraySize(102400) + MemoryBudget.objectArraySize(102400) + MemoryBudget.intArraySize(102400) * 2;
    public static final long MIN_MAIN_CACHE_OVERHEAD = 0L;
    private final Logger logger;
    private final OffHeapAllocator allocator;
    private boolean runEvictorThreads;
    private int maxPoolThreads;
    private final AtomicInteger activePoolThreads = new AtomicInteger(0);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final ThreadPoolExecutor evictionPool;
    private int terminateMillis;
    private long maxMemory;
    private long memoryLimit;
    private final long evictBytes;
    private final Map<Long, Exception> freedBlocks;
    private volatile Chunk[] chunks;
    private int firstFreeListEntry = -1;
    private final Object addRemoveEntryMutex = new Object();
    private final int numLRULists;
    private final LRUList[] pri1LRUSet;
    private final LRUList[] pri2LRUSet;
    private int nextPri1LRUList = 0;
    private int nextPri2LRUList = 0;
    private final AtomicLong nAllocFailure = new AtomicLong(0L);
    private final AtomicLong nAllocOverflow = new AtomicLong(0L);
    private final AtomicLong nThreadUnavailable = new AtomicLong(0L);
    private final AtomicLong nCriticalNodesTargeted = new AtomicLong(0L);
    private final AtomicLong nNodesTargeted = new AtomicLong(0L);
    private final AtomicLong nNodesEvicted = new AtomicLong(0L);
    private final AtomicLong nDirtyNodesEvicted = new AtomicLong(0L);
    private final AtomicLong nNodesStripped = new AtomicLong(0L);
    private final AtomicLong nNodesMutated = new AtomicLong(0L);
    private final AtomicLong nNodesSkipped = new AtomicLong(0L);
    private final AtomicLong nLNsEvicted = new AtomicLong(0L);
    private final AtomicLong nLNsLoaded = new AtomicLong(0L);
    private final AtomicLong nLNsStored = new AtomicLong(0L);
    private final AtomicLong nBINsLoaded = new AtomicLong(0L);
    private final AtomicLong nBINsStored = new AtomicLong(0L);
    private final AtomicInteger cachedLNs = new AtomicInteger(0);
    private final AtomicInteger cachedBINs = new AtomicInteger(0);
    private final AtomicInteger cachedBINDeltas = new AtomicInteger(0);
    private final AtomicInteger totalBlocks = new AtomicInteger(0);
    private final AtomicInteger lruSize = new AtomicInteger(0);

    public OffHeapCache(EnvironmentImpl envImpl) {
        this.logger = LoggerUtils.getLogger(this.getClass());
        try {
            OffHeapAllocatorFactory factory = new OffHeapAllocatorFactory();
            this.allocator = factory.getDefaultAllocator();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to create default allocator for off-heap cache", e);
        }
        DbConfigManager configManager = envImpl.getConfigManager();
        this.evictBytes = configManager.getLong(EnvironmentParams.OFFHEAP_EVICT_BYTES);
        this.numLRULists = configManager.getInt(EnvironmentParams.OFFHEAP_N_LRU_LISTS);
        this.maxMemory = configManager.getLong(EnvironmentParams.MAX_OFF_HEAP_MEMORY);
        this.allocator.setMaxBytes(this.maxMemory);
        this.memoryLimit = this.maxMemory;
        this.pri1LRUSet = new LRUList[this.numLRULists];
        this.pri2LRUSet = new LRUList[this.numLRULists];
        for (int i = 0; i < this.numLRULists; ++i) {
            this.pri1LRUSet[i] = new LRUList();
            this.pri2LRUSet[i] = new LRUList();
        }
        this.freedBlocks = null;
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        int corePoolSize = configManager.getInt(EnvironmentParams.OFFHEAP_CORE_THREADS);
        this.maxPoolThreads = configManager.getInt(EnvironmentParams.OFFHEAP_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.OFFHEAP_KEEP_ALIVE);
        boolean isShared = envImpl.getSharedCache();
        this.evictionPool = new ThreadPoolExecutor(corePoolSize, this.maxPoolThreads, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new StoppableThreadFactory(isShared ? envImpl : null, "JEOffHeapEvictor", this.logger), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                OffHeapCache.this.nThreadUnavailable.incrementAndGet();
            }
        });
        this.runEvictorThreads = configManager.getBoolean(EnvironmentParams.ENV_RUN_OFFHEAP_EVICTOR);
        envImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) {
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        int corePoolSize = configManager.getInt(EnvironmentParams.OFFHEAP_CORE_THREADS);
        this.maxPoolThreads = configManager.getInt(EnvironmentParams.OFFHEAP_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.OFFHEAP_KEEP_ALIVE);
        this.evictionPool.setCorePoolSize(corePoolSize);
        this.evictionPool.setMaximumPoolSize(this.maxPoolThreads);
        this.evictionPool.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
        this.runEvictorThreads = configManager.getBoolean(EnvironmentParams.ENV_RUN_OFFHEAP_EVICTOR);
        long newMaxMemory = configManager.getLong(EnvironmentParams.MAX_OFF_HEAP_MEMORY);
        if (newMaxMemory > 0L != this.maxMemory > 0L) {
            throw new IllegalArgumentException("Cannot change off-heap cache size between zero and non-zero");
        }
        this.maxMemory = newMaxMemory;
        this.allocator.setMaxBytes(newMaxMemory);
        this.memoryLimit = newMaxMemory;
    }

    public void requestShutdown() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
        boolean shutdownFinished = false;
        try {
            shutdownFinished = this.evictionPool.awaitTermination(this.terminateMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!shutdownFinished) {
                this.evictionPool.shutdownNow();
            }
            this.clearCache(null);
            this.chunks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clearCache(EnvironmentImpl matchEnv) {
        Chunk[] myChunks = this.chunks;
        if (myChunks == null) {
            return 0L;
        }
        long size = 0L;
        for (Chunk chunk : myChunks) {
            for (int chunkIdx = 0; chunkIdx < 102400; ++chunkIdx) {
                IN owner = chunk.owners[chunkIdx];
                if (owner == null || matchEnv != null && owner.getEnv() != matchEnv) continue;
                owner.latchNoUpdateLRU();
                try {
                    size += this.removeINFromMain(owner);
                    continue;
                }
                finally {
                    owner.releaseLatch();
                }
            }
        }
        return size;
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup stats = new StatGroup("OffHeap", "Off-heap cache usage and eviction activity.");
        new LongStat(stats, OffHeapStatDefinition.ALLOC_FAILURE, this.nAllocFailure.get());
        new LongStat(stats, OffHeapStatDefinition.ALLOC_OVERFLOW, this.nAllocOverflow.get());
        new LongStat(stats, OffHeapStatDefinition.THREAD_UNAVAILABLE, this.nThreadUnavailable.get());
        new LongStat(stats, OffHeapStatDefinition.CRITICAL_NODES_TARGETED, this.nCriticalNodesTargeted.get());
        new LongStat(stats, OffHeapStatDefinition.NODES_TARGETED, this.nNodesTargeted.get());
        new LongStat(stats, OffHeapStatDefinition.NODES_EVICTED, this.nNodesEvicted.get());
        new LongStat(stats, OffHeapStatDefinition.DIRTY_NODES_EVICTED, this.nDirtyNodesEvicted.get());
        new LongStat(stats, OffHeapStatDefinition.NODES_STRIPPED, this.nNodesStripped.get());
        new LongStat(stats, OffHeapStatDefinition.NODES_MUTATED, this.nNodesMutated.get());
        new LongStat(stats, OffHeapStatDefinition.NODES_SKIPPED, this.nNodesSkipped.get());
        new LongStat(stats, OffHeapStatDefinition.LNS_EVICTED, this.nLNsEvicted.get());
        new LongStat(stats, OffHeapStatDefinition.LNS_LOADED, this.nLNsLoaded.get());
        new LongStat(stats, OffHeapStatDefinition.LNS_STORED, this.nLNsStored.get());
        new LongStat(stats, OffHeapStatDefinition.BINS_LOADED, this.nBINsLoaded.get());
        new LongStat(stats, OffHeapStatDefinition.BINS_STORED, this.nBINsStored.get());
        new IntStat(stats, OffHeapStatDefinition.CACHED_LNS, this.cachedLNs.get());
        new IntStat(stats, OffHeapStatDefinition.CACHED_BINS, this.cachedBINs.get());
        new IntStat(stats, OffHeapStatDefinition.CACHED_BIN_DELTAS, this.cachedBINDeltas.get());
        new LongStat(stats, OffHeapStatDefinition.TOTAL_BYTES, this.allocator.getUsedBytes());
        new IntStat(stats, OffHeapStatDefinition.TOTAL_BLOCKS, this.totalBlocks.get());
        new IntStat(stats, OffHeapStatDefinition.LRU_SIZE, this.lruSize.get());
        if (config.getClear()) {
            this.nAllocFailure.set(0L);
            this.nAllocOverflow.set(0L);
            this.nThreadUnavailable.set(0L);
            this.nCriticalNodesTargeted.set(0L);
            this.nNodesTargeted.set(0L);
            this.nNodesEvicted.set(0L);
            this.nDirtyNodesEvicted.set(0L);
            this.nNodesStripped.set(0L);
            this.nNodesMutated.set(0L);
            this.nNodesSkipped.set(0L);
            this.nLNsEvicted.set(0L);
            this.nLNsLoaded.set(0L);
            this.nLNsStored.set(0L);
            this.nBINsLoaded.set(0L);
            this.nBINsStored.set(0L);
        }
        return stats;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getUsedMemory() {
        return this.allocator.getUsedBytes();
    }

    public void preallocateLRUEntries() {
        if (this.chunks == null) {
            this.freeEntry(this.allocateEntry());
        }
    }

    public OffHeapAllocator getAllocator() {
        return this.allocator;
    }

    private void debug(EnvironmentImpl envImpl, String msg) {
        assert (false);
        LoggerUtils.logMsg(this.logger, envImpl, Level.INFO, msg);
    }

    private int addBack(boolean pri2, IN owner, long memId) {
        assert (owner.isLatchExclusiveOwner());
        int entry = this.allocateEntry();
        int lruIdx = entry % this.numLRULists;
        LRUList lru = pri2 ? this.pri2LRUSet[lruIdx] : this.pri1LRUSet[lruIdx];
        lru.addBack(entry, owner, memId);
        return entry;
    }

    public int moveBack(int entry, boolean pri2) {
        int lruIdx = entry % this.numLRULists;
        LRUList lru = pri2 ? this.pri2LRUSet[lruIdx] : this.pri1LRUSet[lruIdx];
        lru.moveBack(entry);
        return entry;
    }

    private int moveFront(int entry, boolean pri2) {
        int lruIdx = entry % this.numLRULists;
        LRUList lru = pri2 ? this.pri2LRUSet[lruIdx] : this.pri1LRUSet[lruIdx];
        lru.moveFront(entry);
        return entry;
    }

    private void remove(int entry, boolean pri2) {
        int lruIdx = entry % this.numLRULists;
        LRUList lru = pri2 ? this.pri2LRUSet[lruIdx] : this.pri1LRUSet[lruIdx];
        lru.remove(entry);
        this.freeEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateEntry() {
        Object object = this.addRemoveEntryMutex;
        synchronized (object) {
            if (this.firstFreeListEntry >= 0) {
                int entry = this.firstFreeListEntry;
                Chunk chunk = this.chunks[entry / 102400];
                int chunkIdx = entry % 102400;
                this.firstFreeListEntry = chunk.next[chunkIdx];
                chunk.next[chunkIdx] = -2;
                this.lruSize.incrementAndGet();
                return entry;
            }
            Chunk newChunk = new Chunk();
            int[] next = newChunk.next;
            int nOldChunks = this.chunks != null ? this.chunks.length : 0;
            int nextFree = nOldChunks * 102400;
            int entry = nextFree++;
            next[0] = -2;
            next[1] = -1;
            for (int i = 2; i < 102400; ++i) {
                next[i] = nextFree++;
            }
            this.firstFreeListEntry = nextFree;
            Chunk[] newChunks = new Chunk[nOldChunks + 1];
            if (nOldChunks > 0) {
                System.arraycopy(this.chunks, 0, newChunks, 0, nOldChunks);
            }
            newChunks[nOldChunks] = newChunk;
            this.chunks = newChunks;
            this.lruSize.incrementAndGet();
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeEntry(int entry) {
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        Object object = this.addRemoveEntryMutex;
        synchronized (object) {
            if (chunk.owners[chunkIdx] == null) {
                return;
            }
            chunk.owners[chunkIdx] = null;
            chunk.next[chunkIdx] = this.firstFreeListEntry;
            this.firstFreeListEntry = entry;
            this.lruSize.decrementAndGet();
        }
    }

    public long getMemId(int entry) {
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        return chunk.memIds[chunkIdx];
    }

    private IN getOwner(int entry) {
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        return chunk.owners[chunkIdx];
    }

    public void setOwner(int entry, IN owner) {
        assert (owner.isLatchExclusiveOwner());
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        assert (chunk.owners[chunkIdx] != null);
        assert (chunk.owners[chunkIdx].isLatchExclusiveOwner());
        chunk.owners[chunkIdx] = owner;
    }

    private void setOwnerAndMemId(int entry, IN owner, long memId) {
        assert (owner.isLatchExclusiveOwner());
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        assert (chunk.owners[chunkIdx] != null);
        assert (chunk.owners[chunkIdx].isLatchExclusiveOwner());
        chunk.owners[chunkIdx] = owner;
        chunk.memIds[chunkIdx] = memId;
    }

    public boolean storeEvictedLN(BIN bin, int index, LN ln) {
        assert (!ln.isDirty());
        assert (bin.isLatchExclusiveOwner());
        assert (bin.getInListResident());
        DatabaseImpl dbImpl = bin.getDatabase();
        long memId = bin.getOffHeapLNId(index);
        if (memId != 0L) {
            assert (bin.getOffHeapLruId() >= 0);
            if (!bin.getFetchedCold()) {
                this.moveBack(bin.getOffHeapLruId(), false);
            }
            return true;
        }
        if (ln.getFetchedCold() || ln.isDeleted() || bin.isEmbeddedLN(index) || dbImpl.getSortedDuplicates() || dbImpl.isDeferredWriteMode() || dbImpl.getDbType().isInternal()) {
            return false;
        }
        memId = this.serializeLN(dbImpl.getEnv(), ln);
        if (memId == 0L) {
            return false;
        }
        bin.setOffHeapLNId(index, memId);
        int entry = bin.getOffHeapLruId();
        if (entry < 0) {
            entry = this.addBack(false, bin, 0L);
            bin.setOffHeapLruId(entry);
        } else {
            this.moveBack(entry, false);
        }
        return true;
    }

    public boolean storePreloadedLN(BIN bin, int index, LN ln) {
        DatabaseImpl dbImpl = bin.getDatabase();
        assert (!ln.isDirty());
        assert (!ln.isDeleted());
        assert (bin.isLatchExclusiveOwner());
        assert (!bin.isEmbeddedLN(index));
        assert (bin.getTarget(index) == null);
        assert (!dbImpl.getSortedDuplicates());
        assert (!dbImpl.isDeferredWriteMode());
        assert (!dbImpl.getDbType().isInternal());
        if (bin.getOffHeapLNId(index) != 0L) {
            assert (bin.getInListResident());
            return true;
        }
        long memId = this.serializeLN(dbImpl.getEnv(), ln);
        if (memId == 0L) {
            return false;
        }
        if (!bin.getInListResident()) {
            return true;
        }
        bin.setOffHeapLNId(index, memId);
        int entry = bin.getOffHeapLruId();
        if (entry < 0) {
            entry = this.addBack(false, bin, 0L);
            bin.setOffHeapLruId(entry);
        } else {
            this.moveBack(entry, false);
        }
        return true;
    }

    public boolean ensureOffHeapLNsInLRU(BIN bin) {
        assert (bin.isLatchExclusiveOwner());
        if (bin.getOffHeapLruId() >= 0) {
            return true;
        }
        if (!bin.hasOffHeapLNs()) {
            return false;
        }
        int entry = this.addBack(false, bin, 0L);
        bin.setOffHeapLruId(entry);
        return true;
    }

    public LN loadLN(BIN bin, int index, CacheMode cacheMode) {
        assert (bin.isLatchExclusiveOwner());
        long memId = bin.getOffHeapLNId(index);
        if (memId == 0L) {
            return null;
        }
        LN ln = this.materializeLN(bin.getEnv(), memId);
        switch (cacheMode) {
            case UNCHANGED: 
            case MAKE_COLD: {
                break;
            }
            case EVICT_LN: 
            case EVICT_BIN: {
                assert (bin.getOffHeapLruId() >= 0);
                this.moveBack(bin.getOffHeapLruId(), false);
                break;
            }
            case DEFAULT: 
            case KEEP_HOT: {
                bin.setOffHeapLNId(index, 0L);
                this.freeLN(memId);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return ln;
    }

    public void freeRedundantLN(BIN bin, int index, LN ln, CacheMode cacheMode) {
        assert (bin.isLatchExclusiveOwner());
        long memId = bin.getOffHeapLNId(index);
        if (memId == 0L) {
            return;
        }
        switch (cacheMode) {
            case UNCHANGED: 
            case MAKE_COLD: {
                if (!ln.getFetchedCold()) break;
                return;
            }
            case EVICT_LN: 
            case EVICT_BIN: {
                return;
            }
            case DEFAULT: 
            case KEEP_HOT: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        bin.setOffHeapLNId(index, 0L);
        this.freeLN(memId);
    }

    public long loadVLSN(BIN bin, int index) {
        if (!bin.getEnv().getCacheVLSN()) {
            return -1L;
        }
        long memId = bin.getOffHeapLNId(index);
        if (memId == 0L) {
            return -1L;
        }
        return this.getLong(memId, 0, new byte[8]);
    }

    public int freeLN(BIN bin, int index) {
        assert (bin.isLatchExclusiveOwner());
        long memId = bin.getOffHeapLNId(index);
        if (memId == 0L) {
            return 0;
        }
        LN ln = (LN)bin.getTarget(index);
        if (ln != null) {
            ln.setFetchedCold(false);
        }
        bin.setOffHeapLNId(index, 0L);
        return this.freeLN(memId);
    }

    private int freeLN(long memId) {
        this.cachedLNs.decrementAndGet();
        return this.freeMemory(memId);
    }

    private long serializeLN(EnvironmentImpl envImpl, LN ln) {
        byte[] tempBuf;
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int checksumSize = useChecksums ? 4 : 0;
        int vlsnSize = envImpl.getCacheVLSN() ? 8 : 0;
        int lnDataOffset = vlsnSize + checksumSize;
        byte[] data = ln.getData();
        assert (data != null);
        long memId = this.allocateMemory(envImpl, lnDataOffset + data.length);
        if (memId == 0L) {
            return 0L;
        }
        Object object = tempBuf = (Object)(vlsnSize > 0 || useChecksums ? new byte[8] : null);
        if (vlsnSize > 0) {
            this.putLong(ln.getVLSNSequence(), memId, 0, tempBuf);
        }
        if (useChecksums) {
            Checksum checksum = Adler32.makeChecksum();
            checksum.update(data, 0, data.length);
            int checksumValue = (int)checksum.getValue();
            this.putInt(checksumValue, memId, vlsnSize, tempBuf);
        }
        this.allocator.copy(data, 0, memId, lnDataOffset, data.length);
        this.nLNsStored.incrementAndGet();
        this.cachedLNs.incrementAndGet();
        return memId;
    }

    private LN materializeLN(EnvironmentImpl envImpl, long memId) {
        int storedChecksum;
        byte[] tempBuf;
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int checksumSize = useChecksums ? 4 : 0;
        int vlsnSize = envImpl.getCacheVLSN() ? 8 : 0;
        int lnDataOffset = vlsnSize + checksumSize;
        byte[] data = new byte[this.allocator.size(memId) - lnDataOffset];
        this.allocator.copy(memId, lnDataOffset, data, 0, data.length);
        Object object = tempBuf = (Object)(vlsnSize > 0 || useChecksums ? new byte[8] : null);
        if (useChecksums && (storedChecksum = this.getInt(memId, vlsnSize, tempBuf)) != 0) {
            Checksum checksum = Adler32.makeChecksum();
            checksum.update(data, 0, data.length);
            int checksumValue = (int)checksum.getValue();
            if (storedChecksum != checksumValue) {
                throw EnvironmentFailureException.unexpectedState(envImpl, "Off-heap cache checksum error. Expected " + storedChecksum + " but got " + checksumValue);
            }
        }
        this.nLNsLoaded.incrementAndGet();
        LN ln = LN.makeLN(envImpl, data);
        ln.clearDirty();
        if (vlsnSize > 0) {
            ln.setVLSNSequence(this.getLong(memId, 0, tempBuf));
        }
        return ln;
    }

    public boolean storeEvictedBIN(BIN bin, IN parent, int index) {
        int entry;
        assert (bin.isLatchExclusiveOwner());
        assert (bin.getInListResident());
        assert (parent.isLatchExclusiveOwner());
        assert (parent.getInListResident());
        assert (bin == parent.getTarget(index));
        DatabaseImpl dbImpl = bin.getDatabase();
        if (bin.isOffHeapStale()) {
            long freed = this.freeBIN(bin, parent, index);
            assert (freed > 0L);
            entry = -1;
        } else {
            entry = parent.getOffHeapBINId(index);
        }
        if (entry >= 0) {
            assert (parent == this.getOwner(entry));
            assert (bin.isOffHeap());
            assert (bin.getDirty() == parent.isOffHeapBINDirty(index));
            if (!bin.getFetchedCold() && !bin.hasOffHeapLNs()) {
                this.moveBack(entry, parent.isOffHeapBINPri2(index));
            }
            bin.clearOffHeapLNIds();
            return true;
        }
        assert (!bin.isOffHeap());
        if (bin.getFetchedCold() && !bin.getDirty() || dbImpl.isDeferredWriteMode() || dbImpl.getDbType().isInternal()) {
            return false;
        }
        long memId = this.serializeBIN(bin, bin.isBINDelta());
        if (memId == 0L) {
            return false;
        }
        entry = bin.getOffHeapLruId();
        if (entry >= 0) {
            this.setOwnerAndMemId(entry, parent, memId);
            bin.clearOffHeapLNIds();
            bin.setOffHeapLruId(-1);
        } else {
            entry = this.addBack(false, parent, memId);
        }
        bin.setOffHeap(true);
        parent.setOffHeapBINId(index, entry, false, bin.getDirty());
        return true;
    }

    public boolean storePreloadedBIN(BIN bin, IN parent, int index) {
        assert (parent.isLatchExclusiveOwner());
        assert (parent.getInListResident());
        assert (parent.getTarget(index) == null);
        assert (!bin.isOffHeap());
        assert (!bin.isOffHeapStale());
        DatabaseImpl dbImpl = bin.getDatabase();
        assert (!dbImpl.isDeferredWriteMode());
        assert (!dbImpl.getDbType().isInternal());
        if (parent.getOffHeapBINId(index) >= 0) {
            return true;
        }
        long memId = this.serializeBIN(bin, bin.isBINDelta());
        if (memId == 0L) {
            return false;
        }
        int entry = this.addBack(false, parent, memId);
        parent.setOffHeapBINId(index, entry, false, bin.getDirty());
        return true;
    }

    void flushAndDiscardBINChildren(IN in, boolean backgroundIO) {
        assert (in.isLatchExclusiveOwner());
        assert (in.getInListResident());
        assert (in.getNormalizedLevel() == 2);
        if (!in.hasOffHeapBINIds()) {
            return;
        }
        for (int i = 0; i < in.getNEntries(); ++i) {
            int entry = in.getOffHeapBINId(i);
            if (entry < 0) continue;
            this.flushAndDiscardBIN(entry, in.isOffHeapBINPri2(i), in.isOffHeapBINDirty(i), this.getMemId(entry), in, i, backgroundIO, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeINFromMain(IN in) {
        assert (in.isLatchExclusiveOwner());
        int level = in.getNormalizedLevel();
        if (level > 2) {
            return 0L;
        }
        if (level == 2) {
            if (!in.hasOffHeapBINIds()) {
                return 0L;
            }
            long size = 0L;
            for (int i = 0; i < in.getNEntries(); ++i) {
                BIN bin = (BIN)in.getTarget(i);
                if (bin != null) {
                    bin.latchNoUpdateLRU();
                }
                try {
                    size += this.freeBIN(bin, in, i);
                    continue;
                }
                finally {
                    if (bin != null) {
                        bin.releaseLatch();
                    }
                }
            }
            return size;
        }
        assert (level == 1 && in.isBIN());
        BIN bin = (BIN)in;
        int entry = bin.getOffHeapLruId();
        if (entry < 0) {
            assert (!bin.hasOffHeapLNs());
            return 0L;
        }
        long size = 0L;
        if (bin.hasOffHeapLNs()) {
            for (int i = 0; i < bin.getNEntries(); ++i) {
                size += (long)this.freeLN(bin, i);
            }
        }
        bin.setOffHeapLruId(-1);
        this.remove(entry, false);
        return size;
    }

    public BIN loadBIN(EnvironmentImpl envImpl, int entry) {
        assert (entry >= 0);
        return this.materializeBIN(envImpl, this.getMemBytes(this.getMemId(entry)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIN loadBINIfLsnMatches(EnvironmentImpl envImpl, int entry, long lsn) {
        Pair<IN, Integer> result = this.findBINIfLsnMatches(envImpl, entry, lsn);
        if (result == null) {
            return null;
        }
        IN in = result.first();
        int index = result.second();
        try {
            BIN bin = (BIN)in.getTarget(index);
            if (bin != null) {
                bin.latchNoUpdateLRU();
                BIN bIN = bin;
                return bIN;
            }
            long memId = this.getMemId(entry);
            bin = this.materializeBIN(envImpl, this.getMemBytes(memId));
            bin.latchNoUpdateLRU(in.getDatabase());
            BIN bIN = bin;
            return bIN;
        }
        finally {
            in.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictBINIfLsnMatch(EnvironmentImpl envImpl, int entry, long lsn) {
        Pair<IN, Integer> result = this.findBINIfLsnMatches(envImpl, entry, lsn);
        if (result == null) {
            return;
        }
        IN in = result.first();
        int index = result.second();
        try {
            this.freeBIN((BIN)in.getTarget(index), in, index);
        }
        finally {
            in.releaseLatch();
        }
    }

    private Pair<IN, Integer> findBINIfLsnMatches(EnvironmentImpl envImpl, int entry, long lsn) {
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        IN in = chunk.owners[chunkIdx];
        if (in == null) {
            return null;
        }
        in.latchNoUpdateLRU();
        if (in != chunk.owners[chunkIdx] || !in.getInListResident() || in.getEnv() != envImpl || in.isBIN()) {
            in.releaseLatch();
            return null;
        }
        int index = -1;
        for (int i = 0; i < in.getNEntries(); ++i) {
            if (in.getOffHeapBINId(i) != entry) continue;
            index = i;
            break;
        }
        if (index < 0) {
            in.releaseLatch();
            return null;
        }
        if (in.getLsn(index) != lsn) {
            in.releaseLatch();
            return null;
        }
        return new Pair<IN, Integer>(in, index);
    }

    public byte[] getBINBytes(IN parent, int index) {
        assert (parent.isLatchOwner());
        int entry = parent.getOffHeapBINId(index);
        if (entry < 0) {
            return null;
        }
        assert (parent == this.getOwner(entry));
        return this.getMemBytes(this.getMemId(entry));
    }

    public boolean haveBINBytesChanged(IN parent, int index, byte[] bytes) {
        assert (parent.isLatchOwner());
        return !Arrays.equals(bytes, this.getBINBytes(parent, index));
    }

    public void postBINLoad(IN parent, int index, BIN bin, CacheMode cacheMode) {
        assert (bin.isLatchExclusiveOwner());
        assert (parent.isLatchExclusiveOwner());
        assert (parent.getInListResident());
        assert (parent.getTarget(index) == null);
        bin.setOffHeap(true);
        int entry = parent.getOffHeapBINId(index);
        assert (entry >= 0);
        assert (parent == this.getOwner(entry));
        boolean pri2 = parent.isOffHeapBINPri2(index);
        bin.setDirty(parent.isOffHeapBINDirty(index));
        switch (cacheMode) {
            case UNCHANGED: 
            case MAKE_COLD: {
                break;
            }
            case EVICT_BIN: {
                this.moveBack(entry, pri2);
                break;
            }
            case EVICT_LN: 
            case DEFAULT: 
            case KEEP_HOT: {
                long freed = this.freeBIN(bin, parent, index);
                assert (freed > 0L);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.ensureOffHeapLNsInLRU(bin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeRedundantBIN(BIN bin, CacheMode cacheMode) {
        boolean latchedParent;
        assert (bin.isLatchExclusiveOwner());
        assert (bin.getInListResident());
        if (!bin.isOffHeap()) {
            return;
        }
        if (!bin.isOffHeapStale()) {
            switch (cacheMode) {
                case UNCHANGED: 
                case MAKE_COLD: {
                    if (!bin.getFetchedCold()) break;
                    return;
                }
                case EVICT_BIN: {
                    return;
                }
                case EVICT_LN: 
                case DEFAULT: 
                case KEEP_HOT: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        IN parent = bin.getParent();
        assert (parent != null);
        if (parent.isLatchExclusiveOwner()) {
            latchedParent = false;
        } else {
            if (parent.isLatchOwner()) {
                return;
            }
            parent = bin.latchParent();
            latchedParent = true;
        }
        try {
            this.freeBIN(bin, parent, parent.getKnownChildIndex(bin));
        }
        finally {
            if (latchedParent) {
                parent.releaseLatch();
            }
        }
    }

    public long freeBIN(BIN bin, IN parent, int index) {
        assert (parent.isLatchExclusiveOwner());
        assert (bin == null || bin.isLatchExclusiveOwner());
        int entry = parent.getOffHeapBINId(index);
        if (entry < 0) {
            assert (bin == null || !bin.isOffHeap());
            return 0L;
        }
        assert (parent == this.getOwner(entry));
        if (bin != null) {
            assert (bin.isOffHeap());
            bin.setOffHeap(false);
            bin.setOffHeapStale(false);
            bin.setFetchedCold(false);
        }
        boolean pri2 = parent.isOffHeapBINPri2(index);
        long memId = this.getMemId(entry);
        parent.clearOffHeapBINId(index);
        this.remove(entry, pri2);
        return this.freeBIN(parent.getEnv(), memId, bin == null);
    }

    private long freeBIN(EnvironmentImpl envImpl, long memId, boolean freeLNs) {
        int flags;
        long size = 0L;
        if (freeLNs) {
            ParsedBIN pb = this.parseBINBytes(envImpl, this.getMemBytes(memId), false, true);
            if (pb.lnMemIds != null) {
                for (long lnMemId : pb.lnMemIds) {
                    if (lnMemId == 0L) continue;
                    size += (long)this.freeLN(lnMemId);
                }
            }
            flags = pb.flags;
        } else {
            boolean useChecksums = envImpl.useOffHeapChecksums();
            int checksumSize = useChecksums ? 4 : 0;
            flags = this.getByte(memId, checksumSize, new byte[1]);
        }
        this.cachedBINs.decrementAndGet();
        if ((flags & 1) != 0) {
            this.cachedBINDeltas.decrementAndGet();
        }
        return size + (long)this.freeMemory(memId);
    }

    long serializeBIN(BIN bin, boolean asDelta) {
        short lnIdSize;
        int memSize;
        long memId;
        boolean canMutate;
        assert (!bin.hasCachedChildren());
        assert (!bin.isBINDelta() || asDelta);
        EnvironmentImpl envImpl = bin.getEnv();
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int checksumSize = useChecksums ? 4 : 0;
        boolean bl = canMutate = !asDelta && bin.canMutateToBINDelta();
        if (!asDelta && !canMutate) {
            envImpl.lazyCompress(bin);
        }
        int flags = 0;
        if (asDelta) {
            flags |= 1;
        }
        if (canMutate) {
            flags |= 2;
        }
        if (bin.getProhibitNextDelta()) {
            flags |= 4;
        }
        if ((memId = this.allocateMemory(envImpl, memSize = checksumSize + 1 + 8 + 8 + 2 + (lnIdSize = OffHeapCache.getPackedLnMemIdSize(bin)) + bin.getLogSize(asDelta))) == 0L) {
            return 0L;
        }
        byte[] buf = new byte[memSize];
        int bufOffset = checksumSize;
        buf[bufOffset] = (byte)flags;
        OffHeapCache.putLong(bin.getLastFullLsn(), buf, ++bufOffset);
        OffHeapCache.putLong(bin.getLastDeltaLsn(), buf, bufOffset += 8);
        OffHeapCache.putShort(lnIdSize, buf, bufOffset += 8);
        bufOffset += 2;
        if (lnIdSize > 0) {
            OffHeapCache.packLnMemIds(bin, buf, bufOffset);
            bufOffset += lnIdSize;
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, bufOffset, buf.length - bufOffset);
        bin.serialize(byteBuf, asDelta, false);
        if (useChecksums) {
            Checksum checksum = Adler32.makeChecksum();
            checksum.update(buf, checksumSize, buf.length - checksumSize);
            int checksumValue = (int)checksum.getValue();
            this.putInt(checksumValue, memId, 0, buf);
        }
        this.allocator.copy(buf, 0, memId, 0, buf.length);
        this.nBINsStored.incrementAndGet();
        this.cachedBINs.incrementAndGet();
        if (asDelta) {
            this.cachedBINDeltas.incrementAndGet();
        }
        return memId;
    }

    public BIN materializeBIN(EnvironmentImpl envImpl, byte[] buf) {
        ParsedBIN pb = this.parseBINBytes(envImpl, buf, false, true);
        BIN bin = new BIN();
        bin.materialize(pb.binBytes, 11, (pb.flags & 1) != 0, (pb.flags & 8) != 0);
        bin.setLastFullLsn(pb.lastFullLsn);
        bin.setLastDeltaLsn(pb.lastDeltaLsn);
        bin.setProhibitNextDelta((pb.flags & 4) != 0);
        if (pb.lnMemIds != null) {
            for (int i = 0; i < pb.lnMemIds.length; ++i) {
                long lnMemId = pb.lnMemIds[i];
                if (lnMemId == 0L) continue;
                bin.setOffHeapLNId(i, lnMemId);
            }
        }
        this.nBINsLoaded.incrementAndGet();
        return bin;
    }

    public INLogEntry<BIN> createDirtyBINLogEntry(IN parent, int index) {
        int entry = parent.getOffHeapBINId(index);
        if (entry < 0 || !parent.isOffHeapBINDirty(index)) {
            return null;
        }
        assert (parent == this.getOwner(entry));
        long memId = this.getMemId(entry);
        return this.createBINLogEntry(memId, parent);
    }

    public void postBINLog(IN parent, int index, INLogEntry<BIN> logEntry, long newLsn) {
        assert (parent.isLatchExclusiveOwner());
        assert (parent.getInListResident());
        EnvironmentImpl envImpl = parent.getEnv();
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int checksumSize = useChecksums ? 4 : 0;
        boolean isDelta = logEntry.isBINDelta();
        int entry = parent.getOffHeapBINId(index);
        assert (entry >= 0);
        assert (parent.isOffHeapBINDirty(index));
        long memId = this.getMemId(entry);
        byte[] buf = new byte[checksumSize + 1 + 8 + 8];
        this.allocator.copy(memId, 0, buf, 0, buf.length);
        int bufOffset = 0;
        if (useChecksums) {
            OffHeapCache.putInt(0, buf, 0);
            bufOffset += checksumSize;
        }
        int flags = buf[bufOffset];
        if (!isDelta) {
            flags |= 8;
        }
        buf[bufOffset] = (byte)(flags &= 0xFFFFFFFB);
        ++bufOffset;
        if (!isDelta) {
            OffHeapCache.putLong(newLsn, buf, bufOffset);
        }
        OffHeapCache.putLong(isDelta ? newLsn : -1L, buf, bufOffset += 8);
        bufOffset += 8;
        this.allocator.copy(buf, 0, memId, 0, buf.length);
        if (parent.isOffHeapBINPri2(index)) {
            this.pri2LRUSet[entry % this.numLRULists].remove(entry);
            this.moveBack(entry, false);
        }
        parent.setOffHeapBINId(index, entry, false, false);
        if (!logEntry.isPreSerialized()) {
            ((BIN)logEntry.getMainItem()).releaseLatch();
        }
    }

    private INLogEntry<BIN> createBINLogEntry(long memId, IN parent) {
        byte[] buf = this.getMemBytes(memId);
        ParsedBIN pb = this.parseBINBytes(parent.getEnv(), buf, false, false);
        if ((pb.flags & 2) != 0) {
            BIN bin = new BIN();
            bin.materialize(pb.binBytes, 11, false, (pb.flags & 8) != 0);
            bin.latchNoUpdateLRU(parent.getDatabase());
            bin.setLastFullLsn(pb.lastFullLsn);
            bin.setLastDeltaLsn(pb.lastDeltaLsn);
            return new BINDeltaLogEntry(bin);
        }
        return (pb.flags & 1) != 0 ? new BINDeltaLogEntry(pb.binBytes, pb.lastFullLsn, pb.lastDeltaLsn, LogEntryType.LOG_BIN_DELTA, parent) : new INLogEntry(pb.binBytes, pb.lastFullLsn, pb.lastDeltaLsn, LogEntryType.LOG_BIN, parent);
    }

    public BINInfo getBINInfo(EnvironmentImpl envImpl, int entry) {
        assert (entry >= 0);
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int checksumSize = useChecksums ? 4 : 0;
        long memId = this.getMemId(entry);
        byte[] buf = new byte[checksumSize + 1 + 8 + 8];
        this.allocator.copy(memId, 0, buf, 0, buf.length);
        ParsedBIN pb = this.parseBINBytes(envImpl, buf, true, false);
        return new BINInfo(pb);
    }

    public long getINSize(IN in) {
        if (in.isBIN()) {
            BIN bin = (BIN)in;
            if (!bin.hasOffHeapLNs()) {
                return 0L;
            }
            long size = 0L;
            for (int i = 0; i < in.getNEntries(); ++i) {
                long memId = bin.getOffHeapLNId(i);
                if (memId == 0L) continue;
                size += (long)this.allocator.totalSize(memId);
            }
            return size;
        }
        if (in.getNormalizedLevel() != 2) {
            return 0L;
        }
        if (!in.hasOffHeapBINIds()) {
            return 0L;
        }
        EnvironmentImpl envImpl = in.getEnv();
        long size = 0L;
        for (int i = 0; i < in.getNEntries(); ++i) {
            int entry = in.getOffHeapBINId(i);
            if (entry < 0) continue;
            long memId = this.getMemId(entry);
            size += (long)this.allocator.totalSize(memId);
            if (in.getTarget(i) != null) continue;
            ParsedBIN pb = this.parseBINBytes(envImpl, this.getMemBytes(memId), false, true);
            if (pb.lnMemIds == null) continue;
            for (long lnMemId : pb.lnMemIds) {
                if (lnMemId == 0L) continue;
                size += (long)this.allocator.totalSize(lnMemId);
            }
        }
        return size;
    }

    private ParsedBIN parseBINBytes(EnvironmentImpl envImpl, byte[] buf, boolean partialBuf, boolean parseLNIds) {
        int storedChecksum;
        int checksumSize;
        assert (!partialBuf || !parseLNIds);
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int n = checksumSize = useChecksums ? 4 : 0;
        if (useChecksums && !partialBuf && (storedChecksum = OffHeapCache.getInt(buf, 0)) != 0) {
            Checksum checksum = Adler32.makeChecksum();
            checksum.update(buf, checksumSize, buf.length - checksumSize);
            int checksumValue = (int)checksum.getValue();
            if (storedChecksum != checksumValue) {
                throw EnvironmentFailureException.unexpectedState(envImpl, "Off-heap cache checksum error. Expected " + storedChecksum + " but got " + checksumValue);
            }
        }
        int bufOffset = checksumSize;
        byte flags = buf[bufOffset];
        long lastFullLsn = OffHeapCache.getLong(buf, ++bufOffset);
        long lastDeltaLsn = OffHeapCache.getLong(buf, bufOffset += 8);
        bufOffset += 8;
        if (partialBuf) {
            return new ParsedBIN(flags, null, lastFullLsn, lastDeltaLsn, null);
        }
        short lnIdsSize = OffHeapCache.getShort(buf, bufOffset);
        long[] lnMemIds = lnIdsSize > 0 && parseLNIds ? OffHeapCache.unpackLnMemIds(buf, bufOffset += 2, lnIdsSize) : null;
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, bufOffset += Math.abs(lnIdsSize), buf.length - bufOffset);
        return new ParsedBIN(flags, lnMemIds, lastFullLsn, lastDeltaLsn, byteBuf);
    }

    private static void packLnMemIds(BIN bin, byte[] buf, int off) {
        int nOff = off++;
        byte n = 0;
        for (int i = 0; i < bin.getNEntries(); ++i) {
            long memId = bin.getOffHeapLNId(i);
            if (memId != 0L) {
                if (n < 0 || n == 127) {
                    buf[nOff] = n;
                    nOff = off++;
                    n = 0;
                }
                OffHeapCache.putLong(memId, buf, off);
                off += 8;
                n = (byte)(n + 1);
                continue;
            }
            if (n > 0 || n == -127) {
                buf[nOff] = n;
                nOff = off++;
                n = 0;
            }
            n = (byte)(n - 1);
        }
        buf[nOff] = n;
    }

    private static short getPackedLnMemIdSize(BIN bin) {
        if (!bin.hasOffHeapLNs()) {
            return 0;
        }
        int off = 1;
        int n = 0;
        for (int i = 0; i < bin.getNEntries(); ++i) {
            if (bin.getOffHeapLNId(i) != 0L) {
                if (n < 0 || n == 127) {
                    ++off;
                    n = 0;
                }
                off += 8;
                n = (byte)(n + 1);
                continue;
            }
            if (n > 0 || n == -127) {
                ++off;
                n = 0;
            }
            n = (byte)(n - 1);
        }
        if (off > Short.MAX_VALUE) {
            throw EnvironmentFailureException.unexpectedState();
        }
        return (short)off;
    }

    private static long[] unpackLnMemIds(byte[] buf, int startOff, int len) {
        assert (len > 0);
        int endOff = startOff + len;
        int off = startOff;
        int i = 0;
        while (off < endOff) {
            byte n = buf[off];
            ++off;
            if (n > 0) {
                off += n * 8;
                i += n;
                continue;
            }
            assert (n < 0);
            i -= n;
        }
        long[] ids = new long[i + 1];
        off = startOff;
        i = 0;
        while (off < endOff) {
            int n = buf[off];
            ++off;
            if (n > 0) {
                while (n > 0) {
                    ids[i] = OffHeapCache.getLong(buf, off);
                    off += 8;
                    ++i;
                    --n;
                }
                continue;
            }
            assert (n < 0);
            i -= n;
        }
        return ids;
    }

    private long allocateMemory(EnvironmentImpl envImpl, int size) {
        if (!envImpl.isValid()) {
            return 0L;
        }
        long memId = 0L;
        try {
            memId = this.allocator.allocate(size);
            this.totalBlocks.incrementAndGet();
        }
        catch (OutOfMemoryError e) {
            LoggerUtils.envLogMsg(Level.SEVERE, envImpl, "OutOfMemoryError trying to allocate in the off-heap cache. Continuing, but more problems are likely. Allocator error: " + e.getMessage());
            this.nAllocFailure.incrementAndGet();
            this.memoryLimit = this.allocator.getUsedBytes() - this.evictBytes;
        }
        catch (OffHeapAllocator.OffHeapOverflowException e) {
            this.nAllocOverflow.incrementAndGet();
            this.memoryLimit = this.allocator.getUsedBytes();
        }
        if (this.needEviction()) {
            this.wakeUpEvictionThreads();
        }
        return memId;
    }

    private int freeMemory(long memId) {
        this.totalBlocks.decrementAndGet();
        return this.allocator.free(memId);
    }

    private byte[] getMemBytes(long memId) {
        byte[] bytes = new byte[this.allocator.size(memId)];
        this.allocator.copy(memId, 0, bytes, 0, bytes.length);
        return bytes;
    }

    private byte getByte(long memId, int offset, byte[] tempBuf) {
        this.allocator.copy(memId, offset, tempBuf, 0, 1);
        return tempBuf[0];
    }

    private void putShort(short val, long memId, int offset, byte[] tempBuf) {
        OffHeapCache.putShort(val, tempBuf, 0);
        this.allocator.copy(tempBuf, 0, memId, offset, 2);
    }

    private short getShort(long memId, int offset, byte[] tempBuf) {
        this.allocator.copy(memId, offset, tempBuf, 0, 2);
        return OffHeapCache.getShort(tempBuf, 0);
    }

    private void putInt(int val, long memId, int offset, byte[] tempBuf) {
        OffHeapCache.putInt(val, tempBuf, 0);
        this.allocator.copy(tempBuf, 0, memId, offset, 4);
    }

    private int getInt(long memId, int offset, byte[] tempBuf) {
        this.allocator.copy(memId, offset, tempBuf, 0, 4);
        return OffHeapCache.getInt(tempBuf, 0);
    }

    private void putLong(long val, long memId, int offset, byte[] tempBuf) {
        OffHeapCache.putLong(val, tempBuf, 0);
        this.allocator.copy(tempBuf, 0, memId, offset, 8);
    }

    private long getLong(long memId, int offset, byte[] tempBuf) {
        this.allocator.copy(memId, offset, tempBuf, 0, 8);
        return OffHeapCache.getLong(tempBuf, 0);
    }

    private static void putShort(short val, byte[] buf, int offset) {
        buf[offset] = (byte)(val >> 8);
        buf[offset + 1] = (byte)val;
    }

    private static short getShort(byte[] buf, int offset) {
        return (short)(buf[offset] << 8 | buf[offset + 1] & 0xFF);
    }

    private static void putInt(int val, byte[] buf, int offset) {
        buf[offset] = (byte)(val >> 24);
        buf[offset + 1] = (byte)(val >> 16);
        buf[offset + 2] = (byte)(val >> 8);
        buf[offset + 3] = (byte)val;
    }

    private static int getInt(byte[] buf, int offset) {
        return buf[offset] << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    private static void putLong(long val, byte[] buf, int offset) {
        buf[offset] = (byte)(val >> 56);
        buf[offset + 1] = (byte)(val >> 48);
        buf[offset + 2] = (byte)(val >> 40);
        buf[offset + 3] = (byte)(val >> 32);
        buf[offset + 4] = (byte)(val >> 24);
        buf[offset + 5] = (byte)(val >> 16);
        buf[offset + 6] = (byte)(val >> 8);
        buf[offset + 7] = (byte)val;
    }

    private static long getLong(byte[] buf, int offset) {
        return (long)buf[offset] << 56 | ((long)buf[offset + 1] & 0xFFL) << 48 | ((long)buf[offset + 2] & 0xFFL) << 40 | ((long)buf[offset + 3] & 0xFFL) << 32 | ((long)buf[offset + 4] & 0xFFL) << 24 | ((long)buf[offset + 5] & 0xFFL) << 16 | ((long)buf[offset + 6] & 0xFFL) << 8 | (long)buf[offset + 7] & 0xFFL;
    }

    public void doCriticalEviction(boolean backgroundIO) {
        if (this.needEviction()) {
            this.wakeUpEvictionThreads();
            if (this.needCriticalEviction()) {
                this.evictBatch(Evictor.EvictionSource.CRITICAL, backgroundIO);
            }
        }
    }

    public void doDaemonEviction(boolean backgroundIO) {
        if (this.needEviction()) {
            this.wakeUpEvictionThreads();
            if (this.needCriticalEviction()) {
                this.evictBatch(Evictor.EvictionSource.DAEMON, backgroundIO);
            }
        }
    }

    public void doManualEvict() {
        this.evictBatch(Evictor.EvictionSource.MANUAL, true);
    }

    private void wakeUpEvictionThreads() {
        if (!this.runEvictorThreads) {
            return;
        }
        if (this.activePoolThreads.get() >= this.maxPoolThreads) {
            return;
        }
        this.evictionPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OffHeapCache.this.activePoolThreads.incrementAndGet();
                try {
                    OffHeapCache.this.evictBatch(Evictor.EvictionSource.EVICTORTHREAD, true);
                }
                finally {
                    OffHeapCache.this.activePoolThreads.decrementAndGet();
                }
            }
        });
    }

    private boolean needEviction() {
        if (this.maxMemory == 0L) {
            return this.allocator.getUsedBytes() >= 0L;
        }
        return this.allocator.getUsedBytes() + this.evictBytes >= this.memoryLimit;
    }

    private boolean needCriticalEviction() {
        if (this.maxMemory == 0L) {
            return false;
        }
        return this.allocator.getUsedBytes() >= this.memoryLimit;
    }

    private int getLRUSize(LRUList[] listSet) {
        int size = 0;
        for (LRUList l : listSet) {
            size += l.getSize();
        }
        return size;
    }

    private void evictBatch(Evictor.EvictionSource source, boolean backgroundIO) {
        long maxBytesToEvict = this.evictBytes + (this.allocator.getUsedBytes() - this.memoryLimit);
        long bytesEvicted = 0L;
        boolean pri2 = false;
        int maxLruEntries = this.getLRUSize(this.pri1LRUSet);
        int nLruEntries = 0;
        while (bytesEvicted < maxBytesToEvict && this.needEviction() && !this.shutdownRequested.get()) {
            LRUList lru;
            int lruIdx;
            if (nLruEntries >= maxLruEntries) {
                if (pri2) break;
                pri2 = true;
                maxLruEntries = this.getLRUSize(this.pri2LRUSet);
                nLruEntries = 0;
            }
            if (pri2) {
                lruIdx = Math.abs(this.nextPri2LRUList++) % this.numLRULists;
                lru = this.pri2LRUSet[lruIdx];
            } else {
                lruIdx = Math.abs(this.nextPri1LRUList++) % this.numLRULists;
                lru = this.pri1LRUSet[lruIdx];
            }
            int entry = lru.removeFront();
            ++nLruEntries;
            if (entry < 0) continue;
            bytesEvicted += this.evictOne(source, backgroundIO, entry, lru, pri2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long evictOne(Evictor.EvictionSource source, boolean backgroundIO, int entry, LRUList lru, boolean pri2) {
        this.nNodesTargeted.incrementAndGet();
        if (source == Evictor.EvictionSource.CRITICAL) {
            this.nCriticalNodesTargeted.incrementAndGet();
        }
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        IN in = chunk.owners[chunkIdx];
        if (in == null) {
            this.nNodesSkipped.incrementAndGet();
            return 0L;
        }
        EnvironmentImpl envImpl = in.getEnv();
        in.latchNoUpdateLRU();
        try {
            long l;
            long nBytesEvicted;
            int index;
            if (in != chunk.owners[chunkIdx] || !in.getInListResident()) {
                this.nNodesSkipped.incrementAndGet();
                long l2 = 0L;
                return l2;
            }
            if (!in.isBIN()) {
                index = -1;
            } else {
                BIN bin = (BIN)in;
                if (bin.getOffHeapLruId() != entry) {
                    this.nNodesSkipped.incrementAndGet();
                    long l3 = 0L;
                    return l3;
                }
                if (lru.contains(chunk, chunkIdx)) {
                    this.nNodesSkipped.incrementAndGet();
                    long l4 = 0L;
                    return l4;
                }
                int nEvicted = 0;
                long nBytesEvicted2 = 0L;
                for (int i = 0; i < bin.getNEntries(); ++i) {
                    long memId = bin.getOffHeapLNId(i);
                    if (memId == 0L) continue;
                    nBytesEvicted2 += (long)this.freeLN(memId);
                    ++nEvicted;
                }
                if (nEvicted > 0) {
                    bin.clearOffHeapLNIds();
                    this.nLNsEvicted.addAndGet(nEvicted);
                    this.nNodesStripped.incrementAndGet();
                } else {
                    this.nNodesSkipped.incrementAndGet();
                }
                bin.setOffHeapLruId(-1);
                this.freeEntry(entry);
                long l5 = nBytesEvicted2;
                return l5;
            }
            for (int i = 0; i < in.getNEntries(); ++i) {
                if (in.getOffHeapBINId(i) != entry) continue;
                index = i;
                break;
            }
            if (index < 0) {
                this.nNodesSkipped.incrementAndGet();
                long i = 0L;
                return i;
            }
            if (pri2 != in.isOffHeapBINPri2(index)) {
                this.nNodesSkipped.incrementAndGet();
                long i = 0L;
                return i;
            }
            if (lru.contains(chunk, chunkIdx)) {
                this.nNodesSkipped.incrementAndGet();
                long i = 0L;
                return i;
            }
            boolean useChecksums = envImpl.useOffHeapChecksums();
            int checksumSize = useChecksums ? 4 : 0;
            long memId = chunk.memIds[chunkIdx];
            byte flags = this.getByte(memId, checksumSize, new byte[1]);
            boolean dirty = in.isOffHeapBINDirty(index);
            BIN residentBIN = (BIN)in.getTarget(index);
            if (residentBIN != null) {
                residentBIN.latchNoUpdateLRU();
                try {
                    assert (!residentBIN.isBINDelta() || (flags & 1) != 0);
                    assert (!residentBIN.isOffHeap() || residentBIN.isOffHeapStale() || residentBIN.getDirty() == dirty);
                    this.nNodesEvicted.incrementAndGet();
                    long l6 = this.freeBIN(residentBIN, in, index);
                    return l6;
                }
                finally {
                    residentBIN.releaseLatch();
                }
            }
            long nLNBytesEvicted = this.stripLNs(entry, pri2, dirty, memId, chunk, chunkIdx, in, index, backgroundIO);
            if (nLNBytesEvicted > 0L) {
                long l7 = nLNBytesEvicted;
                return l7;
            }
            if ((flags & 2) != 0 && (nBytesEvicted = this.mutateToBINDelta(envImpl, in.getDatabase(), entry, pri2, chunk, chunkIdx)) > 0L) {
                long l8 = nBytesEvicted;
                return l8;
            }
            if (!pri2 && dirty) {
                this.moveBack(entry, true);
                in.setOffHeapBINId(index, entry, true, true);
                l = 0L;
                return l;
            }
            l = this.flushAndDiscardBIN(entry, pri2, dirty, memId, in, index, backgroundIO, false);
            return l;
        }
        finally {
            in.releaseLatch();
        }
    }

    public long stripLNs(IN parent, int index) {
        assert (parent.isLatchExclusiveOwner());
        assert (parent.getInListResident());
        int entry = parent.getOffHeapBINId(index);
        assert (entry >= 0);
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        boolean pri2 = parent.isOffHeapBINPri2(index);
        boolean dirty = parent.isOffHeapBINDirty(index);
        long memId = chunk.memIds[chunkIdx];
        return this.stripLNs(entry, pri2, dirty, memId, chunk, chunkIdx, parent, index, false);
    }

    private long stripLNs(int entry, boolean pri2, boolean dirty, long memId, Chunk chunk, int chunkIdx, IN parent, int index, boolean backgroundIO) {
        EnvironmentImpl envImpl = parent.getEnv();
        boolean useChecksums = envImpl.useOffHeapChecksums();
        int checksumSize = useChecksums ? 4 : 0;
        byte[] headBuf = new byte[19];
        this.allocator.copy(memId, checksumSize, headBuf, 0, headBuf.length);
        int memHeadLen = checksumSize + headBuf.length;
        byte flags = headBuf[0];
        short lnIdsSize = OffHeapCache.getShort(headBuf, headBuf.length - 2);
        if (lnIdsSize <= 0) {
            return 0L;
        }
        byte[] lnBuf = new byte[lnIdsSize];
        this.allocator.copy(memId, memHeadLen, lnBuf, 0, lnBuf.length);
        long[] lnMemIds = OffHeapCache.unpackLnMemIds(lnBuf, 0, lnIdsSize);
        int nStripped = 0;
        long nBytesEvicted = 0L;
        for (long lnMemId : lnMemIds) {
            if (lnMemId == 0L) continue;
            nBytesEvicted += (long)this.freeLN(lnMemId);
            ++nStripped;
        }
        assert (nStripped > 0);
        if (lnIdsSize <= 100) {
            byte[] tempBuf = new byte[8];
            this.putShort(-lnIdsSize, memId, memHeadLen - 2, tempBuf);
            if (useChecksums) {
                this.putInt(0, memId, 0, tempBuf);
            }
        } else {
            int newSize = this.allocator.size(memId) - lnIdsSize;
            long newMemId = this.allocateMemory(envImpl, newSize);
            if (newMemId == 0L) {
                return nBytesEvicted += this.flushAndDiscardBIN(entry, pri2, dirty, memId, parent, index, backgroundIO, true);
            }
            nBytesEvicted -= (long)this.allocator.totalSize(newMemId);
            this.allocator.copy(headBuf, 0, newMemId, checksumSize, headBuf.length - 2);
            this.allocator.copy(memId, memHeadLen + lnIdsSize, newMemId, memHeadLen, newSize - memHeadLen);
            nBytesEvicted += (long)this.freeMemory(memId);
            chunk.memIds[chunkIdx] = newMemId;
        }
        this.nLNsEvicted.addAndGet(nStripped);
        this.nNodesStripped.incrementAndGet();
        this.moveBack(entry, pri2);
        return nBytesEvicted;
    }

    public long mutateToBINDelta(IN parent, int index) {
        assert (parent.isLatchExclusiveOwner());
        assert (parent.getInListResident());
        int entry = parent.getOffHeapBINId(index);
        if (entry < 0) {
            return 0L;
        }
        Chunk chunk = this.chunks[entry / 102400];
        int chunkIdx = entry % 102400;
        return this.mutateToBINDelta(parent.getEnv(), parent.getDatabase(), entry, parent.isOffHeapBINPri2(index), chunk, chunkIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long mutateToBINDelta(EnvironmentImpl envImpl, DatabaseImpl dbImpl, int entry, boolean pri2, Chunk chunk, int chunkIdx) {
        long newMemId;
        long memId = chunk.memIds[chunkIdx];
        BIN bin = this.materializeBIN(envImpl, this.getMemBytes(memId));
        bin.latchNoUpdateLRU(dbImpl);
        try {
            newMemId = this.serializeBIN(bin, true);
        }
        finally {
            bin.releaseLatch();
        }
        if (newMemId == 0L) {
            return 0L;
        }
        long nBytesEvicted = this.freeBIN(envImpl, memId, false);
        nBytesEvicted -= (long)this.allocator.totalSize(newMemId);
        chunk.memIds[chunkIdx] = newMemId;
        this.nNodesMutated.incrementAndGet();
        this.moveBack(entry, pri2);
        return nBytesEvicted;
    }

    private long flushAndDiscardBIN(int entry, boolean pri2, boolean dirty, long memId, IN parent, int index, boolean backgroundIO, boolean freeLNs) {
        assert (parent.isLatchExclusiveOwner());
        EnvironmentImpl envImpl = parent.getEnv();
        if (dirty) {
            INLogEntry<BIN> logEntry = this.createBINLogEntry(memId, parent);
            Provisional provisional = envImpl.coordinateWithCheckpoint(parent.getDatabase(), 65537, parent);
            long lsn = IN.logEntry(logEntry, provisional, backgroundIO, parent);
            parent.updateEntry(index, lsn, -1L, 0);
            this.nDirtyNodesEvicted.incrementAndGet();
            if (!logEntry.isPreSerialized()) {
                ((BIN)logEntry.getMainItem()).releaseLatch();
            }
        }
        this.nNodesEvicted.incrementAndGet();
        parent.clearOffHeapBINId(index);
        this.remove(entry, pri2);
        return this.freeBIN(envImpl, memId, freeLNs);
    }

    private static class ParsedBIN {
        final int flags;
        final long[] lnMemIds;
        final long lastFullLsn;
        final long lastDeltaLsn;
        final ByteBuffer binBytes;

        ParsedBIN(int flags, long[] lnMemIds, long lastFullLsn, long lastDeltaLsn, ByteBuffer binBytes) {
            this.flags = flags;
            this.lnMemIds = lnMemIds;
            this.lastFullLsn = lastFullLsn;
            this.lastDeltaLsn = lastDeltaLsn;
            this.binBytes = binBytes;
        }
    }

    public static class BINInfo {
        public final boolean isBINDelta;
        public final long fullBINLsn;

        private BINInfo(ParsedBIN pb) {
            this.isBINDelta = (pb.flags & 1) != 0;
            this.fullBINLsn = pb.lastFullLsn;
        }
    }

    private class LRUList {
        private int front = -1;
        private int back = -1;
        private int size = 0;

        private LRUList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addBack(int entry, IN owner, long memId) {
            Chunk chunk = OffHeapCache.this.chunks[entry / 102400];
            int chunkIdx = entry % 102400;
            chunk.owners[chunkIdx] = owner;
            chunk.memIds[chunkIdx] = memId;
            LRUList lRUList = this;
            synchronized (lRUList) {
                this.addBackInternal(entry, chunk, chunkIdx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addFront(int entry) {
            Chunk chunk = OffHeapCache.this.chunks[entry / 102400];
            int chunkIdx = entry % 102400;
            LRUList lRUList = this;
            synchronized (lRUList) {
                this.addFrontInternal(entry, chunk, chunkIdx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void moveBack(int entry) {
            Chunk chunk = OffHeapCache.this.chunks[entry / 102400];
            int chunkIdx = entry % 102400;
            LRUList lRUList = this;
            synchronized (lRUList) {
                if (this.back == entry) {
                    return;
                }
                this.removeInternal(entry, chunk, chunkIdx);
                this.addBackInternal(entry, chunk, chunkIdx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void moveFront(int entry) {
            Chunk chunk = OffHeapCache.this.chunks[entry / 102400];
            int chunkIdx = entry % 102400;
            LRUList lRUList = this;
            synchronized (lRUList) {
                if (this.front == entry) {
                    return;
                }
                this.removeInternal(entry, chunk, chunkIdx);
                this.addFrontInternal(entry, chunk, chunkIdx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int removeFront() {
            LRUList lRUList = this;
            synchronized (lRUList) {
                int entry = this.front;
                if (entry < 0) {
                    return -1;
                }
                Chunk chunk = OffHeapCache.this.chunks[entry / 102400];
                int chunkIdx = entry % 102400;
                this.removeInternal(entry, chunk, chunkIdx);
                return entry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(int entry) {
            Chunk chunk = OffHeapCache.this.chunks[entry / 102400];
            int chunkIdx = entry % 102400;
            LRUList lRUList = this;
            synchronized (lRUList) {
                this.removeInternal(entry, chunk, chunkIdx);
            }
        }

        private void addBackInternal(int entry, Chunk chunk, int chunkIdx) {
            assert (chunk.owners[chunkIdx] != null);
            assert (chunk.next[chunkIdx] == -2);
            if (this.back < 0) {
                assert (this.back == -1);
                assert (this.front == -1);
                chunk.prev[chunkIdx] = -1;
                chunk.next[chunkIdx] = -1;
                this.back = entry;
                this.front = entry;
            } else {
                assert (this.front >= 0);
                Chunk nextChunk = OffHeapCache.this.chunks[this.back / 102400];
                int nextIdx = this.back % 102400;
                assert (nextChunk.prev[nextIdx] < 0);
                nextChunk.prev[nextIdx] = entry;
                chunk.next[chunkIdx] = this.back;
                chunk.prev[chunkIdx] = -1;
                this.back = entry;
            }
            ++this.size;
        }

        private void addFrontInternal(int entry, Chunk chunk, int chunkIdx) {
            assert (chunk.owners[chunkIdx] != null);
            assert (chunk.next[chunkIdx] == -2);
            if (this.front < 0) {
                assert (this.back == -1);
                assert (this.front == -1);
                chunk.prev[chunkIdx] = -1;
                chunk.next[chunkIdx] = -1;
                this.front = entry;
                this.back = entry;
            } else {
                assert (this.back >= 0);
                Chunk prevChunk = OffHeapCache.this.chunks[this.front / 102400];
                int prevIdx = this.front % 102400;
                assert (prevChunk.next[prevIdx] < 0);
                prevChunk.next[prevIdx] = entry;
                chunk.prev[chunkIdx] = this.front;
                chunk.next[chunkIdx] = -1;
                this.front = entry;
            }
            ++this.size;
        }

        private void removeInternal(int entry, Chunk chunk, int chunkIdx) {
            assert (chunk.owners[chunkIdx] != null);
            if (chunk.next[chunkIdx] == -2) {
                return;
            }
            assert (this.front >= 0);
            assert (this.back >= 0);
            int prev = chunk.prev[chunkIdx];
            int next = chunk.next[chunkIdx];
            if (prev < 0) {
                assert (prev == -1);
                assert (this.back == entry);
                this.back = next;
            } else {
                assert (this.back != entry);
                Chunk prevChunk = OffHeapCache.this.chunks[prev / 102400];
                int prevIdx = prev % 102400;
                assert (prevChunk.next[prevIdx] == entry);
                prevChunk.next[prevIdx] = next;
            }
            if (next < 0) {
                assert (next == -1);
                assert (this.front == entry);
                this.front = prev;
            } else {
                assert (this.front != entry);
                Chunk nextChunk = OffHeapCache.this.chunks[next / 102400];
                int nextIdx = next % 102400;
                assert (nextChunk.prev[nextIdx] == entry);
                nextChunk.prev[nextIdx] = prev;
            }
            chunk.next[chunkIdx] = -2;
            --this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean contains(Chunk chunk, int chunkIdx) {
            LRUList lRUList = this;
            synchronized (lRUList) {
                assert (chunk.next[chunkIdx] >= -2);
                return chunk.next[chunkIdx] != -2 && chunk.owners[chunkIdx] != null;
            }
        }

        int getSize() {
            return this.size;
        }
    }

    private static class Chunk {
        final long[] memIds = new long[102400];
        final IN[] owners = new IN[102400];
        final int[] prev = new int[102400];
        final int[] next = new int[102400];

        Chunk() {
        }
    }
}

