/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.LatchTable;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tree
implements Loggable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private DatabaseImpl database;
    private int maxTreeEntriesPerNode;
    private ChildReference root;
    private SharedLatch rootLatch;
    private static SplitRequiredException splitRequiredException = new SplitRequiredException();
    private StatGroup stats;
    private IntStat rootSplits;
    private LongStat relatchesRequired;
    private final ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL = new ThreadLocal();
    private TestHook waitHook;
    private TestHook searchHook;
    private TestHook ckptHook;
    private TestHook getParentINHook;
    private TestHook fetchINHook;

    public Tree(DatabaseImpl database) {
        this.init(database);
        this.setDatabase(database);
    }

    public Tree() {
        this.init(null);
        this.maxTreeEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.root = null;
        this.database = database;
        this.stats = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");
        this.relatchesRequired = new LongStat(this.stats, BTreeStatDefinition.BTREE_RELATCHES_REQUIRED);
        this.rootSplits = new IntStat(this.stats, BTreeStatDefinition.BTREE_ROOT_SPLITS);
    }

    public void setDatabase(DatabaseImpl database) {
        this.database = database;
        final EnvironmentImpl envImpl = database.getEnv();
        LatchContext latchContext = new LatchContext(){

            @Override
            public int getLatchTimeoutMs() {
                return envImpl.getLatchTimeoutMs();
            }

            @Override
            public String getLatchName() {
                return "RootLatch";
            }

            @Override
            public LatchTable getLatchTable() {
                return LatchSupport.btreeLatchTable;
            }

            @Override
            public EnvironmentImpl getEnvImplForFatalException() {
                return envImpl;
            }
        };
        this.rootLatch = LatchFactory.createSharedLatch(latchContext, false);
        this.maxTreeEntriesPerNode = database.getNodeMaxTreeEntries();
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    private static void latchChild(IN parent, IN child, CacheMode cacheMode) {
        child.latch(cacheMode);
        if (child.getParent() != parent) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }

    private static void latchChildShared(IN parent, IN child, CacheMode cacheMode) {
        child.latchShared(cacheMode);
        if (child.getParent() != parent) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }

    public void latchRootLatchExclusive() throws DatabaseException {
        this.rootLatch.acquireExclusive();
    }

    public void releaseRootLatch() throws DatabaseException {
        this.rootLatch.release();
    }

    public void setRoot(ChildReference newRoot, boolean notLatched) {
        assert (notLatched || this.rootLatch.isExclusiveOwner());
        this.root = newRoot;
    }

    public ChildReference makeRootChildReference(Node target, byte[] key, long lsn) {
        return new RootChildReference(target, key, lsn);
    }

    private RootChildReference makeRootChildReference() {
        return new RootChildReference();
    }

    public boolean rootExists() {
        if (this.root == null) {
            return false;
        }
        return this.root.getTarget() != null || this.root.getLsn() != -1L;
    }

    public boolean isRootResident() {
        return this.root != null && this.root.getTarget() != null;
    }

    public IN getRootIN(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, false);
    }

    public IN getRootINLatchedExclusive(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootINInternal(CacheMode cacheMode, boolean exclusive) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN iN = this.getRootINRootAlreadyLatched(cacheMode, exclusive);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public IN getRootINRootAlreadyLatched(CacheMode cacheMode, boolean exclusive) {
        if (!this.rootExists()) {
            return null;
        }
        IN rootIN = (IN)this.root.fetchTarget(this.database, null);
        if (exclusive) {
            rootIN.latch(cacheMode);
        } else {
            rootIN.latchShared(cacheMode);
        }
        return rootIN;
    }

    public IN getResidentRootIN(boolean latched) throws DatabaseException {
        IN rootIN = null;
        if (this.rootExists() && (rootIN = (IN)this.root.getTarget()) != null && latched) {
            rootIN.latchShared(CacheMode.UNCHANGED);
        }
        return rootIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedExclusive(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireExclusive();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedShared(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireShared();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public long getRootLsn() {
        if (this.root == null) {
            return -1L;
        }
        return this.root.getLsn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLNs() {
        int topLevelSlots;
        int levels;
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            levels = rootIN.getLevel() & 0xFFFF;
            topLevelSlots = rootIN.getNEntries();
        }
        finally {
            this.rootLatch.release();
        }
        return (long)((double)topLevelSlots * Math.pow(this.database.getNodeMaxTreeEntries(), levels - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] idKey, LocalUtilizationTracker localTracker) throws NodeNotEmptyException, CursorsExistException {
        EnvironmentImpl envImpl = this.database.getEnv();
        INList inList = envImpl.getInMemoryINs();
        Logger logger = envImpl.getLogger();
        IN branchRoot = null;
        IN branchParent = null;
        ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
        IN rootIN = null;
        this.rootLatch.acquireExclusive();
        try {
            if (!this.rootExists()) {
                return;
            }
            rootIN = (IN)this.root.fetchTarget(this.database, null);
            rootIN.latch(CacheMode.UNCHANGED);
            this.searchDeletableSubTree(rootIN, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
            } else {
                SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                branchParent = detachPoint.parent;
                branchRoot = detachPoint.child;
                if (logger.isLoggable(Level.FINEST)) {
                    LoggerUtils.envLogMsg(Level.FINEST, envImpl, "Tree.delete() " + Thread.currentThread().getId() + "-" + Thread.currentThread().getName() + "-" + envImpl.getName() + " Deleting child node: " + branchRoot.getNodeId() + " from parent node: " + branchParent.getNodeId() + " parent has " + branchParent.getNEntries() + " children");
                }
                boolean deleteOk = branchParent.deleteEntry(detachPoint.index, true);
                assert (deleteOk);
                if (this.database.isDeferredWriteMode()) {
                    branchRoot.accountForDeferredWriteSubtreeRemoval(detachPoint.parent);
                }
                this.cascadeUpdates(nodeLadder);
            }
        }
        finally {
            this.releaseNodeLadderLatches(nodeLadder);
            if (rootIN != null) {
                rootIN.releaseLatch();
            }
            this.rootLatch.release();
        }
        if (branchRoot != null) {
            if (!this.database.isDeferredWriteMode()) {
                branchRoot.accountForSubtreeRemoval(localTracker);
            }
            if (logger.isLoggable(Level.FINE)) {
                LoggerUtils.envLogMsg(Level.FINE, envImpl, "SubtreeRemoval: subtreeRoot = " + branchRoot.getNodeId());
            }
        }
    }

    private void searchDeletableSubTree(IN parent, byte[] key, ArrayList<SplitInfo> nodeLadder) throws NodeNotEmptyException, CursorsExistException {
        assert (parent != null);
        assert (key != null);
        assert (parent.isLatchExclusiveOwner());
        IN child = null;
        IN lowestMultipleEntryIN = null;
        IN pinedIN = null;
        do {
            if (parent.getNEntries() == 0) {
                throw EnvironmentFailureException.unexpectedState("Found upper IN with 0 entries");
            }
            if (parent.getNEntries() > 1) {
                lowestMultipleEntryIN = parent;
                pinedIN = null;
            } else if (parent.isPinned()) {
                pinedIN = parent;
            }
            int index = parent.findEntry(key, false, false);
            assert (index >= 0);
            child = parent.fetchIN(index, CacheMode.UNCHANGED);
            Tree.latchChild(parent, child, CacheMode.UNCHANGED);
            nodeLadder.add(new SplitInfo(parent, child, index));
        } while (!(parent = child).isBIN());
        if (pinedIN != null) {
            throw CursorsExistException.CURSORS_EXIST;
        }
        assert (child.isBIN());
        if (child.getNEntries() != 0) {
            throw NodeNotEmptyException.NODE_NOT_EMPTY;
        }
        if (child.isBINDelta()) {
            throw EnvironmentFailureException.unexpectedState("Found BIN delta with 0 entries");
        }
        if (((BIN)child).nCursors() > 0 || child.isPinned()) {
            throw CursorsExistException.CURSORS_EXIST;
        }
        if (lowestMultipleEntryIN != null) {
            INList inList = this.database.getEnv().getInMemoryINs();
            ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = iter.previous();
                if (info.parent != lowestMultipleEntryIN) {
                    inList.remove(info.child);
                    info.child.releaseLatch();
                    iter.remove();
                    continue;
                }
                break;
            }
        } else {
            this.releaseNodeLadderLatches(nodeLadder);
            nodeLadder.clear();
        }
    }

    private void releaseNodeLadderLatches(ArrayList<SplitInfo> nodeLadder) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        while (iter.hasPrevious()) {
            SplitInfo info = iter.previous();
            info.child.releaseLatch();
        }
    }

    private void cascadeUpdates(ArrayList<SplitInfo> nodeLadder) throws DatabaseException {
        for (int i = nodeLadder.size() - 1; i >= 0; --i) {
            SplitInfo info = nodeLadder.get(i);
            if (info.parent.isRoot()) {
                assert (i == 0);
                long newLsn = info.parent.optionalLog();
                this.root.updateLsnAfterOptionalLog(this.database, newLsn);
                continue;
            }
            assert (i > 0);
            SplitInfo nextInfo = nodeLadder.get(i - 1);
            long newLsn = info.parent.optionalLogProvisional(nextInfo.parent);
            nextInfo.parent.updateEntry(nextInfo.index, newLsn, -1L, 0);
        }
    }

    public BIN getFirstNode(CacheMode cacheMode) throws DatabaseException {
        BIN bin = this.search(null, SearchType.LEFT, null, cacheMode, null);
        if (bin != null) {
            bin.mutateToFullBIN();
        }
        return bin;
    }

    public BIN getLastNode(CacheMode cacheMode) throws DatabaseException {
        BIN bin = this.search(null, SearchType.RIGHT, null, cacheMode, null);
        if (bin != null) {
            bin.mutateToFullBIN();
        }
        return bin;
    }

    public BIN getNextBin(BIN bin, CacheMode cacheMode) throws DatabaseException {
        return (BIN)this.getNextIN(bin, true, false, cacheMode);
    }

    public BIN getPrevBin(BIN bin, CacheMode cacheMode) throws DatabaseException {
        return (BIN)this.getNextIN(bin, false, false, cacheMode);
    }

    public IN getNextIN(IN prevIn, boolean forward, boolean latchShared, CacheMode cacheMode) {
        assert (prevIn.isLatchOwner());
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(1);
        }
        prevIn.mutateToFullBIN();
        byte[] searchKey = prevIn.getNEntries() == 0 ? prevIn.getIdentifierKey() : (forward ? prevIn.getKey(prevIn.getNEntries() - 1) : prevIn.getKey(0));
        int targetLevel = prevIn.getLevel();
        IN curr = prevIn;
        boolean currIsLatched = false;
        IN parent = null;
        IN nextIN = null;
        boolean nextINIsLatched = false;
        boolean normalExit = false;
        try {
            while (true) {
                boolean moreEntriesThisIn;
                currIsLatched = false;
                if (curr.isRoot()) {
                    curr.releaseLatch();
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    normalExit = true;
                    IN iN = null;
                    return iN;
                }
                SearchResult result = this.getParentINForChildIN(curr, false, true, cacheMode);
                if (result.exactParentFound) {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(1);
                    }
                } else {
                    throw EnvironmentFailureException.unexpectedState("Failed to find parent for IN");
                }
                parent = result.parent;
                int index = parent.findEntry(searchKey, false, false);
                if (forward) {
                    moreEntriesThisIn = ++index < parent.getNEntries();
                } else {
                    moreEntriesThisIn = index > 0;
                    --index;
                }
                if (moreEntriesThisIn) {
                    nextIN = parent.fetchIN(index, cacheMode);
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(1);
                    }
                    if (nextIN.getLevel() == targetLevel) {
                        if (latchShared) {
                            Tree.latchChildShared(parent, nextIN, cacheMode);
                        } else {
                            Tree.latchChild(parent, nextIN, cacheMode);
                        }
                        nextINIsLatched = true;
                        nextIN.mutateToFullBIN();
                        parent.releaseLatch();
                        parent = null;
                        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                        if (treeStatsAccumulator != null) {
                            nextIN.accumulateStats(treeStatsAccumulator);
                        }
                        if (LatchSupport.TRACK_LATCHES) {
                            LatchSupport.expectBtreeLatchesHeld(1);
                        }
                        normalExit = true;
                        IN iN = nextIN;
                        return iN;
                    }
                    assert (nextIN.isUpperIN());
                    nextIN.latch(cacheMode);
                    nextINIsLatched = true;
                    parent.releaseLatch();
                    parent = null;
                    nextINIsLatched = false;
                    IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, targetLevel, latchShared, cacheMode, null);
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(1);
                    }
                    if (ret.getLevel() == targetLevel) {
                        normalExit = true;
                        IN iN = ret;
                        return iN;
                    }
                    throw EnvironmentFailureException.unexpectedState("subtree did not have a IN at level " + targetLevel);
                }
                curr = parent;
                currIsLatched = true;
                parent = null;
            }
        }
        finally {
            if (!normalExit) {
                if (curr != null && currIsLatched) {
                    curr.releaseLatch();
                }
                if (parent != null) {
                    parent.releaseLatch();
                }
                if (nextIN != null && nextINIsLatched) {
                    nextIN.releaseLatch();
                }
            }
        }
    }

    public SearchResult getParentINForChildIN(IN child, boolean useTargetLevel, boolean doFetch, CacheMode cacheMode) throws DatabaseException {
        return this.getParentINForChildIN(child, useTargetLevel, doFetch, cacheMode, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean useTargetLevel, boolean doFetch, CacheMode cacheMode, List<TrackingInfo> trackingList) throws DatabaseException {
        if (child == null) {
            throw EnvironmentFailureException.unexpectedState("getParentINForChildIN given null child node");
        }
        assert (child.isLatchOwner());
        long targetId = child.getNodeId();
        byte[] targetKey = child.getIdentifierKey();
        int targetLevel = useTargetLevel ? child.getLevel() : -1;
        int exclusiveLevel = child.getLevel() + 1;
        boolean requireExactMatch = true;
        child.releaseLatch();
        return this.getParentINForChildIN(targetId, targetKey, targetLevel, exclusiveLevel, requireExactMatch, doFetch, cacheMode, trackingList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult getParentINForChildIN(long targetNodeId, byte[] targetKey, int targetLevel, int exclusiveLevel, boolean requireExactMatch, boolean doFetch, CacheMode cacheMode, List<TrackingInfo> trackingList) throws DatabaseException {
        TestHookExecute.doHookIfSet(this.getParentINHook);
        assert (doFetch || (exclusiveLevel & 0xFFFF) >= 2);
        SearchResult result = new SearchResult();
        IN rootIN = this.getRootIN(cacheMode);
        if (rootIN == null) {
            return result;
        }
        assert (rootIN.getNodeId() != targetNodeId);
        assert (rootIN.getLevel() >= exclusiveLevel) : " rootLevel=" + rootIN.getLevel() + " exLevel=" + exclusiveLevel;
        IN parent = rootIN;
        IN child = null;
        boolean success = false;
        try {
            if (rootIN.getLevel() <= exclusiveLevel) {
                rootIN.releaseLatch();
                rootIN = this.getRootINLatchedExclusive(cacheMode);
                assert (rootIN != null);
                parent = rootIN;
            }
            while (true) {
                assert (parent.getNEntries() > 0);
                result.index = parent.findEntry(targetKey, false, false);
                if (trackingList != null) {
                    trackingList.add(new TrackingInfo(parent.getLsn(result.index), parent.getNodeId(), parent.getNEntries(), result.index));
                }
                assert (TestHookExecute.doHookIfSet(this.searchHook));
                if (targetLevel > 0 && parent.getLevel() == targetLevel + 1) {
                    result.exactParentFound = true;
                    result.parent = parent;
                    break;
                }
                if (doFetch) {
                    child = parent.fetchINWithNoLatch(result, targetKey, cacheMode);
                    if (child == null) {
                        if (trackingList != null) {
                            trackingList.clear();
                        }
                        result.reset();
                        TestHookExecute.doHookIfSet(this.fetchINHook, child);
                        rootIN = this.getRootIN(cacheMode);
                        assert (rootIN != null);
                        if (rootIN.getLevel() <= exclusiveLevel) {
                            rootIN.releaseLatch();
                            rootIN = this.getRootINLatchedExclusive(cacheMode);
                            assert (rootIN != null);
                        }
                        parent = rootIN;
                        continue;
                    }
                } else {
                    child = parent.getNormalizedLevel() == 2 ? parent.loadIN(result.index, cacheMode) : (IN)parent.getTarget(result.index);
                }
                assert (child != null || !doFetch);
                if (child == null) {
                    if (requireExactMatch) {
                        parent.releaseLatch();
                    } else {
                        result.parent = parent;
                    }
                    result.childNotResident = true;
                    break;
                }
                if (child.getNodeId() == targetNodeId) {
                    result.exactParentFound = true;
                    result.parent = parent;
                    break;
                }
                if (child.isBIN()) {
                    if (requireExactMatch) {
                        parent.releaseLatch();
                        break;
                    }
                    result.parent = parent;
                    break;
                }
                if (child.getLevel() <= exclusiveLevel) {
                    Tree.latchChild(parent, child, cacheMode);
                } else {
                    Tree.latchChildShared(parent, child, cacheMode);
                }
                parent.releaseLatch();
                parent = child;
                child = null;
            }
            success = true;
        }
        finally {
            if (!success) {
                if (parent.isLatchOwner()) {
                    parent.releaseLatch();
                }
                if (child != null && child.isLatchOwner()) {
                    child.releaseLatch();
                }
            }
        }
        if (result.parent != null) {
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(1);
            }
            assert (!doFetch && !requireExactMatch || result.parent.isLatchOwner());
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, byte[] key, boolean splitsAllowed, boolean blindDeltaOps, CacheMode cacheMode) throws DatabaseException {
        location.reset();
        BIN bin = splitsAllowed ? this.searchSplitsAllowed(key, cacheMode, null) : this.search(key, cacheMode);
        if (bin == null) {
            return false;
        }
        try {
            while (true) {
                location.bin = bin;
                int index = bin.findEntry(key, true, false);
                boolean match = index >= 0 && (index & 0x10000) != 0;
                location.index = index &= 0xFFFEFFFF;
                location.lnKey = key;
                if (match) {
                    location.childLsn = bin.getLsn(index);
                    location.childLoggedSize = bin.getLastLoggedSize(index);
                    location.isKD = bin.isEntryKnownDeleted(index);
                    location.isEmbedded = bin.isEmbeddedLN(index);
                    return true;
                }
                if (!bin.isBINDelta() || blindDeltaOps && bin.getNEntries() < bin.getMaxEntries()) break;
                bin.mutateToFullBIN();
                location.reset();
            }
            return false;
        }
        catch (RuntimeException e) {
            bin.releaseLatch();
            location.bin = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIN findBinForInsert(byte[] key, CacheMode cacheMode) {
        boolean rootLatchIsHeld = false;
        BIN bin = null;
        try {
            while (true) {
                rootLatchIsHeld = true;
                this.rootLatch.acquireShared();
                if (!this.rootExists()) {
                    this.rootLatch.release();
                    this.rootLatch.acquireExclusive();
                    if (this.rootExists()) {
                        this.rootLatch.release();
                        rootLatchIsHeld = false;
                        continue;
                    }
                    EnvironmentImpl env = this.database.getEnv();
                    INList inMemoryINs = env.getInMemoryINs();
                    Evictor evictor = env.getEvictor();
                    IN rootIN = new IN(this.database, key, this.maxTreeEntriesPerNode, 2);
                    rootIN.setIsRoot(true);
                    rootIN.latch(cacheMode);
                    bin = new BIN(this.database, key, this.maxTreeEntriesPerNode, 1);
                    bin.latch(cacheMode);
                    long logLsn = bin.optionalLogProvisional(rootIN);
                    boolean insertOk = rootIN.insertEntry(bin, key, logLsn);
                    assert (insertOk);
                    logLsn = rootIN.optionalLog();
                    rootIN.setDirty(true);
                    this.root = this.makeRootChildReference(rootIN, new byte[0], logLsn);
                    rootIN.releaseLatch();
                    inMemoryINs.add(bin);
                    inMemoryINs.add(rootIN);
                    evictor.addBack(bin);
                    this.rootLatch.release();
                    rootLatchIsHeld = false;
                } else {
                    this.rootLatch.release();
                    rootLatchIsHeld = false;
                    bin = this.searchSplitsAllowed(key, cacheMode);
                    if (bin == null) {
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            if (rootLatchIsHeld) {
                this.rootLatch.release();
            }
        }
        assert (TestHookExecute.doHookIfSet(this.ckptHook));
        return bin;
    }

    public BIN searchSplitsAllowed(byte[] key, CacheMode cacheMode) {
        return this.searchSplitsAllowed(key, cacheMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BIN searchSplitsAllowed(byte[] key, CacheMode cacheMode, Comparator<byte[]> comparator) {
        BIN insertTarget = null;
        while (insertTarget == null) {
            this.rootLatch.acquireShared();
            boolean rootLatched = true;
            boolean rootINLatched = false;
            boolean success = false;
            IN rootIN = null;
            try {
                BIN bIN;
                if (!this.rootExists()) {
                    bIN = null;
                    return bIN;
                }
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                if (rootIN.needsSplitting()) {
                    this.rootLatch.release();
                    this.rootLatch.acquireExclusive();
                    if (!this.rootExists()) {
                        bIN = null;
                        return bIN;
                    }
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    if (rootIN.needsSplitting()) {
                        this.splitRoot(cacheMode);
                        this.rootLatch.release();
                        rootLatched = false;
                        EnvironmentImpl env = this.database.getEnv();
                        env.getDbTree().optionalModifyDbRoot(this.database);
                        continue;
                    }
                }
                rootIN.latchShared(cacheMode);
                rootINLatched = true;
                success = true;
            }
            finally {
                if (!success && rootINLatched) {
                    rootIN.releaseLatch();
                }
                if (!rootLatched) continue;
                this.rootLatch.release();
                continue;
            }
            try {
                assert (rootINLatched);
                insertTarget = this.searchSplitsAllowed(rootIN, key, cacheMode, comparator);
                if (insertTarget != null) continue;
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
                this.relatchesRequired.increment();
                this.database.getEnv().incRelatchesRequired();
            }
            catch (SplitRequiredException e) {}
        }
        return insertTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BIN searchSplitsAllowed(IN rootIN, byte[] key, CacheMode cacheMode, Comparator<byte[]> comparator) throws SplitRequiredException {
        assert (rootIN.isLatchOwner());
        if (!rootIN.isRoot()) {
            throw EnvironmentFailureException.unexpectedState("A null or non-root IN was given as the parent");
        }
        IN parent = rootIN;
        IN child = null;
        boolean success = false;
        try {
            do {
                if (parent.getNEntries() == 0) {
                    throw EnvironmentFailureException.unexpectedState("Found upper IN with 0 entries");
                }
                int index = parent.findEntry(key, false, false, comparator);
                assert (index >= 0);
                child = parent.fetchINWithNoLatch(index, key, cacheMode);
                if (child == null) {
                    BIN bIN = null;
                    return bIN;
                }
                Tree.latchChildShared(parent, child, cacheMode);
                if (child.needsSplitting()) {
                    this.database.getEnv().lazyCompress(child);
                    if (child.needsSplitting()) {
                        child.releaseLatch();
                        parent.releaseLatch();
                        assert (TestHookExecute.doHookIfSet(this.waitHook));
                        parent = rootIN = this.forceSplit(key, cacheMode);
                        assert (rootIN.isLatchOwner());
                        if (rootIN.isRoot()) continue;
                        throw EnvironmentFailureException.unexpectedState("A null or non-root IN was given as the parent");
                    }
                }
                parent.releaseLatch();
                parent = child;
                child = null;
            } while (!parent.isBIN());
            success = true;
            BIN bIN = (BIN)parent;
            return bIN;
        }
        finally {
            if (!success) {
                if (child != null && child.isLatchOwner()) {
                    child.releaseLatch();
                }
                if (parent != child && parent.isLatchOwner()) {
                    parent.releaseLatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN forceSplit(byte[] key, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        IN rootIN;
        block23: {
            ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
            boolean allLeftSideDescent = true;
            boolean allRightSideDescent = true;
            IN child = null;
            rootIN = null;
            this.rootLatch.acquireExclusive();
            boolean success = false;
            try {
                int index;
                IN parent = rootIN = (IN)this.root.fetchTarget(this.database, null);
                parent.latch(cacheMode);
                if (rootIN.needsSplitting()) {
                    throw splitRequiredException;
                }
                do {
                    if (parent.getNEntries() == 0) {
                        throw EnvironmentFailureException.unexpectedState("Found upper IN with 0 entries");
                    }
                    index = parent.findEntry(key, false, false);
                    assert (index >= 0);
                    if (index != 0) {
                        allLeftSideDescent = false;
                    }
                    if (index != parent.getNEntries() - 1) {
                        allRightSideDescent = false;
                    }
                    if ((child = parent.loadIN(index, cacheMode)) == null) break;
                    Tree.latchChild(parent, child, cacheMode);
                    nodeLadder.add(new SplitInfo(parent, child, index));
                } while (!(parent = child).isBIN());
                boolean startedSplits = false;
                long lastParentForSplit = -1L;
                for (int i = nodeLadder.size() - 1; i >= 0; --i) {
                    SplitInfo info = (SplitInfo)nodeLadder.get(i);
                    child = info.child;
                    parent = info.parent;
                    index = info.index;
                    if (child.needsSplitting()) {
                        IN grandParent;
                        child.mutateToFullBIN();
                        IN iN = grandParent = i > 0 ? ((SplitInfo)nodeLadder.get((int)(i - 1))).parent : null;
                        if (allLeftSideDescent || allRightSideDescent) {
                            child.splitSpecial(parent, index, grandParent, this.maxTreeEntriesPerNode, key, allLeftSideDescent, cacheMode);
                        } else {
                            child.split(parent, index, grandParent, this.maxTreeEntriesPerNode, cacheMode);
                        }
                        lastParentForSplit = parent.getNodeId();
                        startedSplits = true;
                        if (parent.isRoot()) {
                            this.root.updateLsnAfterOptionalLog(this.database, parent.getLastLoggedLsn());
                        }
                    } else if (startedSplits) {
                        long newChildLsn = lastParentForSplit == child.getNodeId() ? child.getLastLoggedLsn() : child.optionalLogProvisional(parent);
                        parent.updateEntry(index, newChildLsn, -1L, 0);
                        if (parent.isRoot()) {
                            long newRootLsn = parent.optionalLog();
                            this.root.updateLsnAfterOptionalLog(this.database, newRootLsn);
                        }
                    }
                    child.releaseLatch();
                    child = null;
                }
                success = true;
                if (success) break block23;
                if (child != null) {
                    child.releaseLatchIfOwner();
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    if (child != null) {
                        child.releaseLatchIfOwner();
                    }
                    for (SplitInfo info : nodeLadder) {
                        info.child.releaseLatchIfOwner();
                    }
                    if (rootIN != null) {
                        rootIN.releaseLatchIfOwner();
                    }
                }
                this.rootLatch.release();
                throw throwable;
            }
            for (SplitInfo info : nodeLadder) {
                info.child.releaseLatchIfOwner();
            }
            if (rootIN != null) {
                rootIN.releaseLatchIfOwner();
            }
        }
        this.rootLatch.release();
        return rootIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(CacheMode cacheMode) throws DatabaseException {
        EnvironmentImpl env = this.database.getEnv();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch(cacheMode);
        long curRootLsn = 0L;
        long logLsn = 0L;
        IN newRoot = null;
        try {
            byte[] rootIdKey = curRoot.getKey(0);
            newRoot = new IN(this.database, rootIdKey, this.maxTreeEntriesPerNode, curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            newRoot.setIsRoot(true);
            curRoot.setIsRoot(false);
            boolean logSuccess = false;
            try {
                curRootLsn = curRoot.optionalLogProvisional(newRoot);
                boolean inserted = newRoot.insertEntry(curRoot, rootIdKey, curRootLsn);
                assert (inserted);
                logLsn = newRoot.optionalLog();
                logSuccess = true;
            }
            finally {
                if (!logSuccess) {
                    curRoot.setIsRoot(true);
                }
            }
            inMemoryINs.add(newRoot);
            this.root.setTarget(newRoot);
            this.root.updateLsnAfterOptionalLog(this.database, logLsn);
            curRoot.split(newRoot, 0, null, this.maxTreeEntriesPerNode, cacheMode);
            this.root.setLsn(newRoot.getLastLoggedLsn());
        }
        finally {
            newRoot.releaseLatch();
            curRoot.releaseLatch();
        }
        this.rootSplits.increment();
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public BIN search(byte[] key, CacheMode cacheMode) {
        return this.search(key, SearchType.NORMAL, null, cacheMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIN search(byte[] key, SearchType searchType, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> comparator) {
        IN rootIN = this.getRootIN(cacheMode);
        if (rootIN == null) {
            return null;
        }
        assert (searchType != SearchType.LEFT && searchType != SearchType.RIGHT || key == null);
        if (binBoundary != null) {
            binBoundary.isLastBin = true;
            binBoundary.isFirstBin = true;
        }
        boolean success = false;
        IN parent = rootIN;
        IN child = null;
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        try {
            if (treeStatsAccumulator != null) {
                parent.accumulateStats(treeStatsAccumulator);
            }
            do {
                int index;
                if (parent.getNEntries() == 0) {
                    throw EnvironmentFailureException.unexpectedState("Upper IN with 0 entries");
                }
                if (searchType == SearchType.NORMAL) {
                    index = parent.findEntry(key, false, false, comparator);
                } else if (searchType == SearchType.LEFT) {
                    index = 0;
                } else if (searchType == SearchType.RIGHT) {
                    index = parent.getNEntries() - 1;
                } else {
                    throw EnvironmentFailureException.unexpectedState("Invalid value of searchType: " + searchType);
                }
                assert (index >= 0);
                if (binBoundary != null) {
                    if (index != parent.getNEntries() - 1) {
                        binBoundary.isLastBin = false;
                    }
                    if (index != 0) {
                        binBoundary.isFirstBin = false;
                    }
                }
                if ((child = parent.fetchINWithNoLatch(index, key, cacheMode)) == null) {
                    parent = this.getRootIN(cacheMode);
                    assert (parent != null);
                    if (treeStatsAccumulator == null) continue;
                    parent.accumulateStats(treeStatsAccumulator);
                    continue;
                }
                Tree.latchChildShared(parent, child, cacheMode);
                if (treeStatsAccumulator != null) {
                    child.accumulateStats(treeStatsAccumulator);
                }
                parent.releaseLatch();
                parent = child;
                child = null;
            } while (!parent.isBIN());
            success = true;
            BIN bIN = (BIN)parent;
            return bIN;
        }
        finally {
            if (!success) {
                try {
                    if (child != null && child.isLatchOwner()) {
                        child.releaseLatch();
                    }
                    if (parent != child && parent.isLatchOwner()) {
                        parent.releaseLatch();
                    }
                }
                catch (Exception e) {
                    LoggerUtils.traceAndLogException(this.database.getEnv(), "Tree", "searchSubTreeInternal", "", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN searchSubTree(IN parent, byte[] key, SearchType searchType, int targetLevel, boolean latchShared, CacheMode cacheMode, Comparator<byte[]> comparator) {
        assert (parent != null && (parent.isRoot() || parent.isLatchExclusiveOwner()));
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw EnvironmentFailureException.unexpectedState("searchSubTree passed key and left/right search");
        }
        assert (parent.isUpperIN());
        assert (parent.isLatchOwner());
        boolean success = false;
        IN subtreeRoot = parent;
        IN child = null;
        IN grandParent = null;
        boolean childIsLatched = false;
        boolean grandParentIsLatched = false;
        boolean doGrandparentLatching = !parent.isLatchExclusiveOwner();
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        try {
            do {
                int index;
                if (treeStatsAccumulator != null) {
                    parent.accumulateStats(treeStatsAccumulator);
                }
                assert (parent.getNEntries() > 0);
                if (searchType == SearchType.NORMAL) {
                    index = parent.findEntry(key, false, false, comparator);
                } else if (searchType == SearchType.LEFT) {
                    index = 0;
                } else if (searchType == SearchType.RIGHT) {
                    index = parent.getNEntries() - 1;
                } else {
                    throw EnvironmentFailureException.unexpectedState("Invalid value of searchType: " + searchType);
                }
                assert (index >= 0);
                child = (IN)parent.getTarget(index);
                if (child == null && doGrandparentLatching) {
                    if (parent != subtreeRoot) {
                        assert (!parent.isLatchExclusiveOwner());
                        parent.releaseLatch();
                        parent.latch(cacheMode);
                        grandParent.releaseLatch();
                        grandParentIsLatched = false;
                        grandParent = null;
                        doGrandparentLatching = false;
                    } else if (parent.isRoot() && !parent.isLatchExclusiveOwner()) {
                        parent.releaseLatch();
                        parent = subtreeRoot = this.getRootINLatchedExclusive(cacheMode);
                        assert (parent != null);
                        assert (grandParent == null);
                        doGrandparentLatching = false;
                        continue;
                    }
                    child = parent.fetchIN(index, cacheMode);
                } else if (child == null) {
                    child = parent.fetchIN(index, CacheMode.UNCHANGED);
                }
                if (grandParent != null) {
                    grandParent.releaseLatch();
                    grandParentIsLatched = false;
                }
                if (child.getLevel() == targetLevel) {
                    if (latchShared) {
                        child.latchShared(cacheMode);
                    } else {
                        child.latch(cacheMode);
                    }
                } else if (!doGrandparentLatching) {
                    Tree.latchChild(parent, child, cacheMode);
                }
                childIsLatched = true;
                child.mutateToFullBIN();
                if (treeStatsAccumulator != null) {
                    child.accumulateStats(treeStatsAccumulator);
                }
                if (doGrandparentLatching) {
                    grandParent = parent;
                    grandParentIsLatched = true;
                } else {
                    parent.releaseLatch();
                }
                parent = child;
            } while (!parent.isBIN() && parent.getLevel() != targetLevel);
            success = true;
            IN iN = child;
            return iN;
        }
        finally {
            if (!success) {
                try {
                    if (child != null && childIsLatched) {
                        child.releaseLatch();
                    }
                    if (parent != child) {
                        parent.releaseLatch();
                    }
                }
                catch (Exception e) {
                    LoggerUtils.traceAndLogException(this.database.getEnv(), "Tree", "searchSubTreeInternal", "", e);
                }
            }
            if (grandParent != null && grandParentIsLatched) {
                grandParent.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getEnv().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquireShared();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
            }
            finally {
                this.rootLatch.release();
            }
        }
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getEnv().getInMemoryINs();
            if (!inList.contains(parent)) {
                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTarget(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray node " + node + " at index " + i);
                            }
                            byte[] key = parent.getKey(i);
                            if (key != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public int getLogSize() {
        int size = 1;
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        byte booleans = (byte)(this.root != null ? 1 : 0);
        logBuffer.put(booleans);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean rootExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = rootExists = (booleans & 1) != 0;
        if (rootExists) {
            this.root = this.makeRootChildReference();
            this.root.readFromLog(itemBuffer, entryVersion);
        }
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    int getTreeStats() {
        return this.rootSplits.get();
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    public void loadStats(StatsConfig config, BtreeStats btreeStats) {
        btreeStats.setTreeStats(this.stats.cloneGroup(false));
        if (config.getClear()) {
            this.relatchesRequired.clear();
            this.rootSplits.clear();
        }
    }

    public void dump() {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            rootIN.latch();
            try {
                boolean bl = rootIN.validateSubtreeBeforeDelete(index);
                rootIN.releaseLatch();
                return bl;
            }
            catch (Throwable throwable) {
                rootIN.releaseLatch();
                throw throwable;
            }
        }
        finally {
            this.rootLatch.release();
        }
    }

    public void setWaitHook(TestHook hook) {
        this.waitHook = hook;
    }

    public void setSearchHook(TestHook hook) {
        this.searchHook = hook;
    }

    public void setCkptHook(TestHook hook) {
        this.ckptHook = hook;
    }

    public void setGetParentINHook(TestHook hook) {
        this.getParentINHook = hook;
    }

    public void setFetchINHook(TestHook hook) {
        this.fetchINHook = hook;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getEnv().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            LoggerUtils.logMsg(logger, this.database.getEnv(), level, sb.toString());
        }
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    private class RootChildReference
    extends ChildReference {
        private RootChildReference() {
        }

        private RootChildReference(Node target, byte[] key, long lsn) {
            super(target, key, lsn);
        }

        @Override
        public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
            if (this.getTarget() == null && !Tree.this.rootLatch.isExclusiveOwner()) {
                Tree.this.rootLatch.release();
                Tree.this.rootLatch.acquireExclusive();
                if (this != Tree.this.root) {
                    throw EnvironmentFailureException.unexpectedState(database.getEnv(), "Root changed while unlatched, dbId=" + database.getId());
                }
            }
            return super.fetchTarget(database, in);
        }

        @Override
        public void setTarget(Node target) {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.setTarget(target);
        }

        @Override
        public void clearTarget() {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.clearTarget();
        }

        @Override
        public void setLsn(long lsn) {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.setLsn(lsn);
        }

        @Override
        void updateLsnAfterOptionalLog(DatabaseImpl dbImpl, long lsn) {
            assert (Tree.this.rootLatch.isExclusiveOwner());
            super.updateLsnAfterOptionalLog(dbImpl, lsn);
        }

        @Override
        void setDirty() {
            super.setDirty();
            Tree.this.database.setDirty();
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();

        private SearchType() {
        }
    }
}

