/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.LogVerifier;
import java.io.IOException;
import java.io.InputStream;

public class LogVerificationInputStream
extends InputStream {
    private static final int SKIP_BUF_SIZE = 2048;
    private final InputStream in;
    private final LogVerifier verifier;
    private byte[] skipBuf;

    public LogVerificationInputStream(Environment env, InputStream in, String fileName) {
        this(DbInternal.getEnvironmentImpl(env), in, fileName, -1L);
    }

    LogVerificationInputStream(EnvironmentImpl envImpl, InputStream in, String fileName, long fileNum) {
        this.verifier = new LogVerifier(envImpl, fileName, fileNum);
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int lenRead = this.read(b, 0, 1);
        return lenRead <= 0 ? lenRead : b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int lenRead = this.in.read(b, off, len);
        if (lenRead <= 0) {
            if (lenRead < 0) {
                this.verifier.verifyAtEof();
            }
            return lenRead;
        }
        this.verifier.verify(b, off, lenRead);
        return lenRead;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        long remaining;
        int lenRead;
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        if (this.skipBuf == null) {
            this.skipBuf = new byte[2048];
        }
        for (remaining = bytesToSkip; remaining > 0L && (lenRead = this.read(this.skipBuf, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)lenRead) {
        }
        return bytesToSkip - remaining;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

