/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionTimeoutException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.rep.DatabasePreemptedException;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.LockPreemptedException;
import com.sleepycat.je.rep.LogFileRewriteListener;
import com.sleepycat.je.rep.LogOverwriteException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.RepStatManager;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.SyncupProgress;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepConfigManager;
import com.sleepycat.je.rep.impl.RepEnvConfigObserver;
import com.sleepycat.je.rep.impl.RepImplStatDefinition;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNUpdater;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.NodeState;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.stream.ArbiterFeederSource;
import com.sleepycat.je.rep.stream.FeederReader;
import com.sleepycat.je.rep.stream.FeederTxns;
import com.sleepycat.je.rep.txn.MasterThreadLocker;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.rep.txn.ReplayTxn;
import com.sleepycat.je.rep.txn.ReplicaThreadLocker;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.StatCaptureRepDefinitions;
import com.sleepycat.je.rep.utilint.net.DataChannelFactoryBuilder;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.rep.vlsn.VLSNRecoveryTracker;
import com.sleepycat.je.statcap.StatManager;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.BooleanStat;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Formatter;
import java.util.logging.Level;

public class RepImpl
extends EnvironmentImpl
implements RepEnvConfigObserver {
    private VLSNIndex vlsnIndex;
    private final VLSNIndexAccess vlsnIndexAccess = new VLSNIndexAccess();
    private final FeederTxns feederTxns;
    private volatile RepNode repNode;
    private Replay replay;
    private NameIdPair nameIdPair;
    private final NodeState nodeState;
    private static int clockSkewMs = 0;
    private DatabaseImpl groupDbImpl = null;
    private boolean backupProhibited = false;
    private boolean allowConvert = false;
    private boolean preserveVLSN;
    private boolean cacheVLSN;
    private final Set<DbBackup> backups = new HashSet<DbBackup>();
    private final List<RepEnvConfigObserver> repConfigObservers;
    private final ReentrantLock groupDbLock = new ReentrantLock();
    private int replicaAckTimeout;
    private int insufficientReplicasTimeout;
    private int replayTxnTimeout;
    private ReplicaConsistencyPolicy defaultConsistencyPolicy;
    private boolean allowArbiterAck;
    private boolean isArbiter;
    private final StatGroup nodeStats;
    private final BooleanStat hardRecoveryStat;
    private final StringStat hardRecoveryInfoStat;
    private volatile CountDownLatch blockTxnLatch = new CountDownLatch(0);
    private final ReentrantReadWriteLock blockLatchLock = new ReentrantReadWriteLock(true);
    private final ProgressListener<SyncupProgress> syncupProgressListener;
    private final LogFileRewriteListener logRewriteListener;
    private final ReplicationNetworkConfig repNetConfig;
    private volatile DataChannelFactory channelFactory;

    public RepImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv, RepConfigProxy repConfigProxy) throws EnvironmentNotFoundException, EnvironmentLockedException {
        super(envHome, envConfig, sharedCacheEnv, repConfigProxy);
        this.allowConvert = RepInternal.getAllowConvert((ReplicationConfig)repConfigProxy);
        this.repConfigObservers = new ArrayList<RepEnvConfigObserver>();
        this.addRepConfigObserver(this);
        this.repNetConfig = ((ReplicationConfig)repConfigProxy).getRepNetConfig();
        this.nodeState = new NodeState(this.nameIdPair, this);
        if (this.isArbiter) {
            this.nodeStats = null;
            this.syncupProgressListener = null;
            this.logRewriteListener = null;
            this.hardRecoveryStat = null;
            this.hardRecoveryInfoStat = null;
            this.feederTxns = null;
            return;
        }
        this.feederTxns = new FeederTxns(this);
        this.replay = new Replay(this, this.nameIdPair);
        this.nodeStats = new StatGroup("ReplicatedEnvironment", "General information about a replication node");
        this.hardRecoveryStat = new BooleanStat(this.nodeStats, RepImplStatDefinition.HARD_RECOVERY);
        this.hardRecoveryInfoStat = new StringStat(this.nodeStats, RepImplStatDefinition.HARD_RECOVERY_INFO, "This node did not incur a hard recovery.");
        this.syncupProgressListener = ((ReplicationConfig)repConfigProxy).getSyncupProgressListener();
        this.logRewriteListener = ((ReplicationConfig)repConfigProxy).getLogFileRewriteListener();
    }

    @Override
    protected void initConfigParams(EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        super.initConfigParams(envConfig, repConfigProxy);
        this.replicaAckTimeout = this.configManager.getDuration(RepParams.REPLICA_ACK_TIMEOUT);
        this.insufficientReplicasTimeout = this.configManager.getDuration(RepParams.INSUFFICIENT_REPLICAS_TIMEOUT);
        this.replayTxnTimeout = this.configManager.getDuration(RepParams.REPLAY_TXN_LOCK_TIMEOUT);
        this.defaultConsistencyPolicy = RepUtils.getReplicaConsistencyPolicy(this.configManager.get(RepParams.CONSISTENCY_POLICY));
        this.preserveVLSN = this.configManager.getBoolean(RepParams.PRESERVE_RECORD_VERSION);
        this.cacheVLSN = this.configManager.getBoolean(RepParams.CACHE_RECORD_VERSION);
        this.allowArbiterAck = this.configManager.getBoolean(RepParams.ALLOW_ARBITER_ACK);
        this.isArbiter = this.configManager.getBoolean(RepParams.ARBITER_USE);
    }

    @Override
    protected Formatter initFormatter() {
        this.nameIdPair = new NameIdPair(this.configManager.get(RepParams.NODE_NAME));
        return new ReplicationFormatter(this.nameIdPair);
    }

    @Override
    public String getMonitorClassName() {
        return "com.sleepycat.je.rep.jmx.RepJEMonitor";
    }

    @Override
    public String getDiagnosticsClassName() {
        return "com.sleepycat.je.rep.jmx.RepJEDiagnostics";
    }

    @Override
    protected DbConfigManager initConfigManager(EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        return new RepConfigManager(envConfig, repConfigProxy);
    }

    @Override
    public boolean getAllowRepConvert() {
        return this.allowConvert;
    }

    @Override
    protected DbConfigManager resetConfigManager(EnvironmentConfig newConfig) {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        ReplicationConfig repConfig = repConfigManager.makeReplicationConfig();
        return new RepConfigManager(newConfig, repConfig);
    }

    public ReplicationConfig cloneRepConfig() {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        return repConfigManager.makeReplicationConfig();
    }

    public ReplicatedEnvironment makeEnvironment() {
        return new ReplicatedEnvironment(this.getEnvironmentHome(), this.cloneRepConfig(), this.cloneConfig());
    }

    public ReplicationMutableConfig cloneRepMutableConfig() {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        return repConfigManager.makeReplicationConfig();
    }

    public void setRepMutableConfig(ReplicationMutableConfig config) throws DatabaseException {
        RepConfigManager repConfigManager = (RepConfigManager)this.configManager;
        ReplicationConfig newConfig = repConfigManager.makeReplicationConfig();
        config.copyMutablePropsTo(newConfig);
        repConfigManager = new RepConfigManager(this.configManager.getEnvironmentConfig(), newConfig);
        for (int i = this.repConfigObservers.size() - 1; i >= 0; --i) {
            RepEnvConfigObserver o = this.repConfigObservers.get(i);
            o.repEnvConfigUpdate(repConfigManager, newConfig);
        }
    }

    @Override
    public void repEnvConfigUpdate(RepConfigManager configMgr, ReplicationMutableConfig newConfig) throws DatabaseException {
        this.allowArbiterAck = configMgr.getBoolean(RepParams.ALLOW_ARBITER_ACK);
        if (this.repNode == null) {
            return;
        }
        this.repNode.getArbiter().processConfigChange(newConfig);
        this.repNode.getElectionQuorum().setElectableGroupSizeOverride(newConfig.getElectableGroupSizeOverride());
        this.repNode.configLogFlusher(configMgr);
        this.repNode.getReplica().getDbCache().setConfig(configMgr);
    }

    public synchronized void addRepConfigObserver(RepEnvConfigObserver o) {
        this.repConfigObservers.add(o);
    }

    @Override
    public void preRecoveryCheckpointInit(RecoveryInfo recoveryInfo) {
        int stride = this.configManager.getInt(RepParams.VLSN_STRIDE);
        int maxMappings = this.configManager.getInt(RepParams.VLSN_MAX_MAP);
        int maxDist = this.configManager.getInt(RepParams.VLSN_MAX_DIST);
        NameIdPair useNameIdPair = new NameIdPair(this.configManager.get(RepParams.NODE_NAME));
        this.vlsnIndex = new VLSNIndex(this, DbType.VLSN_MAP.getInternalName(), useNameIdPair, stride, maxMappings, maxDist, recoveryInfo);
        this.replay.preRecoveryCheckpointInit(recoveryInfo);
    }

    public ReplicatedEnvironment.State getState() {
        return this.nodeState.getRepEnvState();
    }

    public StateChangeEvent getStateChangeEvent() {
        return this.nodeState.getStateChangeEvent();
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public synchronized ReplicatedEnvironment.State joinGroup(ReplicaConsistencyPolicy consistency, QuorumPolicy initialElectionPolicy) throws ReplicaConsistencyException, DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.TOTAL_JOIN_GROUP);
        try {
            if (this.repNode == null) {
                this.repNode = new RepNode(this, this.replay, this.nodeState);
            }
            ReplicatedEnvironment.State state = this.repNode.joinGroup(consistency, initialElectionPolicy);
            return state;
        }
        catch (IOException ioe) {
            throw EnvironmentFailureException.unexpectedException(this, "Problem attempting to join on " + this.getSocket(), ioe);
        }
        finally {
            this.startupTracker.stop(StartupTracker.Phase.TOTAL_JOIN_GROUP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeChannelFactory() {
        if (this.channelFactory != null) {
            return;
        }
        RepImpl repImpl = this;
        synchronized (repImpl) {
            if (this.channelFactory == null) {
                this.channelFactory = DataChannelFactoryBuilder.construct(this.repNetConfig, DataChannelFactoryBuilder.makeLoggerFactory(this));
            }
        }
    }

    @Override
    protected Environment createInternalEnvironment() {
        return new InternalReplicatedEnvironment(this.getEnvironmentHome(), this.cloneRepConfig(), this.cloneConfig(), this);
    }

    @Override
    protected synchronized void setupClose(PrintWriter errors) throws DatabaseException {
        if (this.groupDbImpl != null) {
            this.getDbTree().releaseDb(this.groupDbImpl);
            this.groupDbImpl = null;
            LoggerUtils.fine(this.envLogger, this, "Group member database shutdown");
        }
        try {
            if (this.repNode != null) {
                this.repNode.shutdown();
                this.repNode = null;
            }
        }
        catch (InterruptedException e) {
            this.appendException(errors, e, "shutting down node " + this.nameIdPair);
        }
    }

    @Override
    protected synchronized void postCheckpointClose(boolean checkpointed) throws DatabaseException {
        if (this.replay != null) {
            this.replay.close();
            this.replay = null;
        }
        this.vlsnIndexAccess.closeVLSNIndex(checkpointed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postRecoveryConversion() {
        super.postRecoveryConversion();
        if (this.needRepConvert) {
            DatabaseImpl nameDb = null;
            try {
                nameDb = this.dbMapTree.getDb(DbTree.NAME_DB_ID);
                if (!nameDb.isReplicated()) {
                    nameDb.setIsReplicatedBit();
                    nameDb.setDirty();
                }
            }
            finally {
                if (nameDb != null) {
                    this.dbMapTree.releaseDb(nameDb);
                }
            }
            Map<DatabaseId, String> idNameMap = this.dbMapTree.getDbNamesAndIds();
            for (DatabaseId id : idNameMap.keySet()) {
                DatabaseImpl db = null;
                try {
                    db = this.dbMapTree.getDb(id);
                    if (db == null || DbTree.isReservedDbName(idNameMap.get(id))) continue;
                    db.setIsReplicatedBit();
                    db.setDirty();
                }
                finally {
                    if (db == null) continue;
                    this.dbMapTree.releaseDb(db);
                }
            }
            CheckpointConfig ckptConfig = new CheckpointConfig();
            ckptConfig.setForce(true);
            ckptConfig.setMinimizeRecoveryTime(true);
            this.invokeCheckpoint(ckptConfig, "Environment conversion");
        }
    }

    @Override
    public synchronized void doCloseAfterInvalid() {
        try {
            if (this.repNode != null) {
                this.repNode.shutdown();
                this.repNode = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doCloseAfterInvalid();
    }

    @Override
    public void abnormalClose() throws DatabaseException {
        this.shutdownDaemons();
        try {
            if (this.repNode != null) {
                this.repNode.getMonitorEventManager().disableLeaveGroupEvent();
                this.repNode.shutdown();
                this.repNode = null;
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        try {
            this.vlsnIndexAccess.abnormalCloseVLSNIndex();
        }
        catch (DatabaseException ignore) {
            // empty catch block
        }
        try {
            super.abnormalClose();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    @Override
    public void registerVLSN(LogItem logItem) {
        LogEntryHeader header = logItem.header;
        VLSN vlsn = header.getVLSN();
        if (LogEntryType.isSyncPoint(header.getType()) || VLSN.FIRST_VLSN.equals(vlsn)) {
            this.repNode.trackSyncableVLSN(vlsn, logItem.lsn);
        }
        this.vlsnIndex.put(logItem);
    }

    @Override
    public VLSN bumpVLSN() {
        return this.vlsnIndex.bump();
    }

    @Override
    public void preCheckpointEndFlush() throws DatabaseException {
        if (this.vlsnIndex != null) {
            this.vlsnIndex.flushToDatabase(Durability.COMMIT_NO_SYNC);
        }
    }

    @Override
    public boolean isMaster() {
        RepNode useNode = this.repNode;
        if (useNode == null) {
            return false;
        }
        return useNode.isMaster();
    }

    public void setChangeListener(StateChangeListener listener) {
        StateChangeListener prevListener = this.nodeState.getChangeListener();
        this.nodeState.setChangeListener(listener);
        StateChangeEvent stateChangeEvent = this.nodeState.getStateChangeEvent();
        try {
            listener.stateChange(stateChangeEvent);
        }
        catch (Exception e) {
            this.nodeState.setChangeListener(prevListener);
            LoggerUtils.severe(this.envLogger, this, "State Change listener exception: " + e.getMessage());
            throw new EnvironmentFailureException((EnvironmentImpl)this, EnvironmentFailureReason.LISTENER_EXCEPTION, (Throwable)e);
        }
    }

    public StateChangeListener getChangeListener() {
        return this.nodeState.getChangeListener();
    }

    public VLSNIndex getVLSNIndex() {
        return this.vlsnIndex;
    }

    public FeederTxns getFeederTxns() {
        return this.feederTxns;
    }

    public ReplicatedEnvironmentStats getStats(StatsConfig config) {
        return this.getStats(config, this.statKey);
    }

    @Override
    public Collection<StatGroup> getRepStatGroups(StatsConfig config, Integer statKey1) {
        ReplicatedEnvironmentStats res = this.getStats(config, statKey1);
        return res == null ? null : res.getStatGroups();
    }

    @Override
    public SortedSet<String> getStatCaptureProjections() {
        return new StatCaptureRepDefinitions().getStatisticProjections();
    }

    @Override
    public StatManager createStatManager() {
        return new RepStatManager(this);
    }

    public ReplicatedEnvironmentStats getStatsInternal(StatsConfig config) {
        if (this.repNode == null) {
            return null;
        }
        return this.repNode.getStats(config);
    }

    public ReplicatedEnvironmentStats getStats(StatsConfig config, Integer contextKey) {
        return ((RepStatManager)this.statManager).getRepStats(config, contextKey);
    }

    public Replay getReplay() {
        return this.replay;
    }

    public void checkIfMaster(Locker locker) throws UnknownMasterException, ReplicaWriteException {
        StateChangeEvent event = this.nodeState.getStateChangeEvent();
        switch (this.nodeState.getRepEnvState()) {
            case MASTER: {
                break;
            }
            case REPLICA: {
                throw new ReplicaWriteException(locker, event);
            }
            case UNKNOWN: {
                throw new UnknownMasterException(locker, event);
            }
            case DETACHED: {
                throw new UnknownMasterException(locker, event);
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unexpected state: " + (Object)((Object)this.nodeState.getRepEnvState()));
            }
        }
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    @Override
    public ThreadLocker createRepThreadLocker() {
        return this.isMaster() ? new MasterThreadLocker(this) : new ReplicaThreadLocker(this);
    }

    @Override
    public Txn createRepUserTxn(TransactionConfig config) throws DatabaseException {
        return this.isMaster() && !config.getReadOnly() && !config.getLocalWrite() ? MasterTxn.create(this, config, this.nameIdPair) : new ReadonlyTxn(this, config);
    }

    public void txnBeginHook(MasterTxn txn) throws InterruptedException, DatabaseException {
        this.checkIfInvalid();
        this.repNode.getDurabilityQuorum().ensureReplicasForCommit(txn, this.insufficientReplicasTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockTxnCompletion(CountDownLatch blocker) throws InterruptedException {
        ReentrantReadWriteLock.WriteLock lock = this.blockLatchLock.writeLock();
        lock.lockInterruptibly();
        try {
            this.blockTxnLatch = blocker;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCBVLSN(LocalCBVLSNUpdater updater) {
        ReentrantReadWriteLock.ReadLock lock = this.blockLatchLock.readLock();
        lock.lock();
        try {
            if (this.blockTxnLatch.getCount() > 0L) {
                return;
            }
            updater.update();
        }
        finally {
            lock.unlock();
        }
    }

    public void unblockTxnCompletion() {
        LoggerUtils.info(this.envLogger, this, "Releasing commit block latch");
        this.blockTxnLatch.countDown();
    }

    public void preLogCommitHook(MasterTxn txn) throws InsufficientReplicasException, RestartRequiredException, UnknownMasterException, ReplicaWriteException, EnvironmentFailureException {
        this.checkIfInvalid();
        this.checkIfMaster(txn);
        this.checkBlock(txn);
        int activeReplicaCount = this.repNode.feederManager().activeAckReplicaCount();
        Durability.ReplicaAckPolicy ackPolicy = txn.getCommitDurability().getReplicaAck();
        int requiredAckCount = txn.getRequiredAckCount();
        if (this.envLogger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.envLogger, this, "Txn " + txn.getId() + " requires: " + requiredAckCount + " active: " + activeReplicaCount + " replica acks. Commit Policy: " + (Object)((Object)ackPolicy));
        }
        if (requiredAckCount > activeReplicaCount) {
            if (ackPolicy.equals((Object)Durability.ReplicaAckPolicy.SIMPLE_MAJORITY) && this.repNode.getArbiter().activateArbitration()) {
                txn.resetRequiredAckCount();
            } else if (this.repNode.getGroup().getAckGroupSize() == 2 && this.allowArbiterAck && this.repNode.feederManager().activeAckArbiterCount() > 0 && ackPolicy == Durability.ReplicaAckPolicy.SIMPLE_MAJORITY) {
                txn.setArbiterAck(true);
            } else {
                InsufficientReplicasException ire = new InsufficientReplicasException((Locker)txn, ackPolicy, requiredAckCount, this.repNode.feederManager().activeAckReplicas());
                LoggerUtils.info(this.envLogger, this, ire.getMessage());
                throw ire;
            }
        }
        this.feederTxns.setupForAcks(txn);
    }

    private void checkBlock(MasterTxn txn) {
        try {
            long txnTimeout;
            if (txn.lockOnce()) {
                this.blockLatchLock.readLock().lockInterruptibly();
            }
            if (this.blockTxnLatch.getCount() > 0L) {
                LoggerUtils.info(this.envLogger, this, "Block transaction: " + txn.getId() + " pending master transfer. Write locks = " + txn.getWriteLockIds());
            }
            if ((txnTimeout = txn.getTxnTimeout()) <= 0L) {
                this.blockTxnLatch.await();
            } else if (!this.blockTxnLatch.await(txnTimeout, TimeUnit.MILLISECONDS)) {
                String message = "Timed out waiting for master transfer. Configured transaction timeout:" + txnTimeout + "ms";
                throw new TransactionTimeoutException(txn, message);
            }
            this.checkIfInvalid();
            this.checkIfMaster(txn);
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException((EnvironmentImpl)this, (Throwable)e);
        }
    }

    public void postLogCommitHook(MasterTxn txn, LogItem commitItem) throws InsufficientAcksException, InterruptedException, EnvironmentFailureException {
        Feeder arbFeeder;
        if (txn.unlockOnce()) {
            this.blockLatchLock.readLock().unlock();
        }
        this.checkIfInvalid();
        if (txn.getArbiterAck() && (arbFeeder = this.repNode.feederManager().getArbiterFeeder()) != null) {
            ArbiterFeederSource as = arbFeeder.getArbiterFeederSource();
            as.addCommit(commitItem);
        }
        try {
            this.feederTxns.awaitReplicaAcks(txn, this.replicaAckTimeout);
        }
        catch (InsufficientAcksException e) {
            LoggerUtils.info(this.envLogger, this, e.getMessage());
            throw e;
        }
    }

    public void preLogAbortHook(MasterTxn txn) throws EnvironmentFailureException, ReplicaWriteException, UnknownMasterException {
        this.checkIfInvalid();
        this.checkIfMaster(txn);
        this.checkBlock(txn);
    }

    public void postLogAbortHook(MasterTxn txn) {
        if (txn.unlockOnce()) {
            this.blockLatchLock.readLock().unlock();
        }
    }

    public void postLogCommitAbortHook(MasterTxn txn) {
        LoggerUtils.info(this.envLogger, this, "post log abort hook for txn: " + txn.getId());
        if (txn.unlockOnce()) {
            this.blockLatchLock.readLock().unlock();
        }
        this.feederTxns.clearTransactionAcks(txn);
    }

    @Override
    public Txn createReplayTxn(long txnId) throws DatabaseException {
        return new ReplayTxn((EnvironmentImpl)this, TransactionConfig.DEFAULT, txnId, this.envLogger);
    }

    @Override
    public VLSNRecoveryProxy getVLSNProxy() {
        int stride = this.configManager.getInt(RepParams.VLSN_STRIDE);
        int maxMappings = this.configManager.getInt(RepParams.VLSN_MAX_MAP);
        int maxDist = this.configManager.getInt(RepParams.VLSN_MAX_DIST);
        return new VLSNRecoveryTracker(this, stride, maxMappings, maxDist);
    }

    public UUID getUUID() {
        return this.repNode.getUUID();
    }

    public static void setSkewMs(int skewMs) {
        clockSkewMs = skewMs;
    }

    public static int getClockSkewMs() {
        return clockSkewMs;
    }

    @Override
    public void vlsnHeadTruncate(VLSN lastVLSN, long deleteFileNum) {
        this.vlsnIndex.truncateFromHead(lastVLSN, deleteFileNum);
    }

    public int getNodeId() {
        return this.nameIdPair.getId();
    }

    public NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    @Override
    public long getReplayTxnTimeout() {
        return this.replayTxnTimeout;
    }

    @Override
    public ReplicaConsistencyPolicy getDefaultConsistencyPolicy() {
        return this.defaultConsistencyPolicy;
    }

    public void setDefaultConsistencyPolicy(ReplicaConsistencyPolicy policy) {
        this.defaultConsistencyPolicy = policy;
    }

    @Override
    public long getLsnForVLSN(VLSN vlsn, int readBufferSize) {
        long fileNumber = this.vlsnIndex.getLTEFileNumber(vlsn);
        FeederReader feederReader = new FeederReader(this, this.vlsnIndex, DbLsn.makeLsn(fileNumber, 0), readBufferSize, this.nameIdPair);
        try {
            feederReader.initScan(vlsn);
            if (!feederReader.readNextEntry()) {
                throw EnvironmentFailureException.unexpectedState("VLSN not found: " + vlsn);
            }
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        return feederReader.getLastLsn();
    }

    @Override
    public long getEndOfLog() {
        return this.vlsnIndex.getRange().getLast().getSequence();
    }

    @Override
    public VLSN getGroupDurableVLSN() {
        return this.repNode.getGroupCBVLSN();
    }

    @Override
    public void freezeLocalCBVLSN() {
        this.repNode.freezeLocalCBVLSN();
    }

    @Override
    public void unfreezeLocalCBVLSN() {
        this.repNode.unfreezeLocalCBVLSN();
    }

    @Override
    public boolean getPreserveVLSN() {
        return this.preserveVLSN;
    }

    @Override
    public boolean getCacheVLSN() {
        return this.preserveVLSN && this.cacheVLSN;
    }

    @Override
    public String getName() {
        return this.nameIdPair + ":" + super.getName();
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    @Override
    public boolean isArbiter() {
        return this.isArbiter;
    }

    @Override
    public void checkRulesForExistingEnv(boolean dbTreeReplicatedBit, boolean dbTreePreserveVLSN) throws UnsupportedOperationException {
        if (!dbTreeReplicatedBit) {
            throw new UnsupportedOperationException("This environment must be converted for replication. using com.sleepycat.je.rep.util.DbEnableReplication.");
        }
        if (dbTreePreserveVLSN != this.getPreserveVLSN()) {
            throw new IllegalArgumentException(RepParams.PRESERVE_RECORD_VERSION.getName() + " parameter may not be changed." + " Previous value: " + dbTreePreserveVLSN + " New value: " + this.getPreserveVLSN());
        }
    }

    public String getHostName() {
        String hostAndPort = this.configManager.get(RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
    }

    public int getPort() {
        String hostAndPort = this.configManager.get(RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? Integer.parseInt(hostAndPort.substring(colonToken + 1)) : this.configManager.getInt(RepParams.DEFAULT_PORT);
    }

    public InetSocketAddress getSocket() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    public JEVersion getCurrentJEVersion() {
        String testJEVersion = this.configManager.get(RepParams.TEST_JE_VERSION);
        return testJEVersion.isEmpty() ? JEVersion.CURRENT_VERSION : new JEVersion(testJEVersion);
    }

    public Set<InetSocketAddress> getHelperSockets() {
        String helperHosts = this.configManager.get(RepParams.HELPER_HOSTS);
        return HostPortPair.getSockets(helperHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl createGroupDb() throws DatabaseException {
        assert (this.isMaster());
        try {
            this.groupDbLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        try {
            if (this.groupDbImpl != null) {
                throw EnvironmentFailureException.unexpectedState("GroupDb should not exist.");
            }
            DatabaseImpl newDbImpl = null;
            Txn txn = null;
            try {
                TransactionConfig txnConfig = new TransactionConfig();
                txnConfig.setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.NONE));
                txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
                txn = new MasterTxn((EnvironmentImpl)this, txnConfig, this.getNameIdPair());
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setAllowCreate(true);
                dbConfig.setTransactional(true);
                dbConfig.setExclusiveCreate(true);
                dbConfig.setReplicated(true);
                newDbImpl = this.getDbTree().createInternalDb(txn, DbType.REP_GROUP.getInternalName(), dbConfig);
                txn.commit();
                txn = null;
            }
            finally {
                if (txn != null) {
                    txn.abort();
                }
            }
            this.groupDbImpl = newDbImpl;
        }
        finally {
            this.groupDbLock.unlock();
        }
        return this.groupDbImpl;
    }

    @Override
    public NavigableSet<Long> getUnprotectedFileSet(NavigableSet<Long> files) {
        if (this.repNode == null) {
            return null;
        }
        if ((files = super.getUnprotectedFileSet(files)).isEmpty()) {
            return files;
        }
        return this.repNode.getUnprotectedFileSet(files, this.getCleaner());
    }

    public DatabaseImpl getGroupDb() throws DatabaseNotFoundException, DatabaseException {
        return this.openGroupDb(false);
    }

    public DatabaseImpl probeGroupDb() throws DatabaseException {
        try {
            return this.openGroupDb(true);
        }
        catch (DatabaseNotFoundException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl openGroupDb(boolean doLockProbe) throws DatabaseNotFoundException, DatabaseException {
        try {
            if (doLockProbe) {
                if (!this.groupDbLock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                    return null;
                }
            } else {
                this.groupDbLock.lockInterruptibly();
            }
        }
        catch (InterruptedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        Txn txn = null;
        try {
            if (this.groupDbImpl != null) {
                DatabaseImpl databaseImpl = this.groupDbImpl;
                return databaseImpl;
            }
            DatabaseImpl newDbImpl = null;
            TransactionConfig txnConfig = new TransactionConfig();
            txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
            txn = new ReadonlyTxn(this, txnConfig);
            newDbImpl = this.getDbTree().getDb(txn, DbType.REP_GROUP.getInternalName(), null);
            if (newDbImpl == null) {
                throw new DatabaseNotFoundException(DbType.REP_GROUP.getInternalName());
            }
            txn.commit();
            txn = null;
            DatabaseImpl databaseImpl = this.groupDbImpl = newDbImpl;
            return databaseImpl;
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
            this.groupDbLock.unlock();
        }
    }

    public boolean isDesignatedPrimary() {
        return this.getConfigManager().getBoolean(RepParams.DESIGNATED_PRIMARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDbBackup(DbBackup backup) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            if (this.backupProhibited) {
                return false;
            }
            assert (this.backups.add(backup));
        }
        super.addDbBackup(backup);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDbBackup(DbBackup backup) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            assert (this.backups.remove(backup));
        }
        super.removeDbBackup(backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateBackups(long fileNumber) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            for (DbBackup backup : this.backups) {
                backup.invalidate(fileNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupProhibited(boolean backupProhibited) {
        Set<DbBackup> set = this.backups;
        synchronized (set) {
            this.backupProhibited = backupProhibited;
        }
    }

    @Override
    public LockPreemptedException createLockPreemptedException(Locker locker, Throwable cause) {
        return new LockPreemptedException(locker, cause);
    }

    @Override
    public DatabasePreemptedException createDatabasePreemptedException(String msg, String dbName, Database db) {
        return new DatabasePreemptedException(msg, dbName, db);
    }

    @Override
    public LogOverwriteException createLogOverwriteException(String msg) {
        return new LogOverwriteException(msg);
    }

    public void shutdownGroupSetup(long timeoutMs) {
        int openCount = this.getAppOpenCount();
        if (openCount > 1) {
            throw new IllegalStateException("Environment has " + (openCount - 1) + " additional open handles.");
        }
        int backupCount = this.getBackupCount();
        if (backupCount > 0) {
            throw new IllegalStateException("Environment has " + backupCount + " DbBackups in progress.");
        }
        this.repNode.shutdownGroupOnClose(timeoutMs);
    }

    public String transferMaster(Set<String> replicas, long timeout, boolean force) {
        return this.repNode.transferMaster(replicas, timeout, force);
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNameIdPair());
        sb.append("[").append((Object)this.getState()).append("] ");
        if (this.repNode != null) {
            sb.append(this.repNode.dumpState());
        }
        if (this.vlsnIndex != null) {
            sb.append("vlsnRange=");
            sb.append(this.vlsnIndex.getRange()).append("\n");
        }
        if (this.replay != null) {
            sb.append(this.replay.dumpState());
        }
        return sb.toString();
    }

    public String dumpAckFeederState() {
        return this.getNameIdPair() + "[" + (Object)((Object)this.getState()) + "]" + this.repNode.dumpAckFeederState();
    }

    public void setHardRecoveryInfo(RollbackException e) {
        this.hardRecoveryStat.set(true);
        this.hardRecoveryInfoStat.set(e.getMessage());
    }

    public StatGroup getNodeStats() {
        return this.nodeStats;
    }

    @Override
    public void awaitVLSNConsistency() {
        this.vlsnIndex.awaitConsistency();
    }

    public void setSyncupProgress(SyncupProgress progress) {
        this.setSyncupProgress(progress, 0L, -1L);
    }

    public void setSyncupProgress(SyncupProgress progress, long n, long total) {
        if (this.syncupProgressListener == null) {
            return;
        }
        if (!this.syncupProgressListener.progress(progress, n, total)) {
            throw new EnvironmentFailureException((EnvironmentImpl)this, EnvironmentFailureReason.PROGRESS_LISTENER_HALT, "ReplicatedEnvironmentConfig.syncupProgressListener: ");
        }
    }

    public LogFileRewriteListener getLogRewriteListener() {
        return this.logRewriteListener;
    }

    public ReplicationNetworkConfig getRepNetConfig() {
        return this.repNetConfig;
    }

    public DataChannelFactory getChannelFactory() {
        this.initializeChannelFactory();
        return this.channelFactory;
    }

    @Override
    public void invalidate(EnvironmentFailureException e) {
        super.invalidate(e);
        this.unblockTxnCompletion();
    }

    public VLSN getLastTxnEnd() {
        return this.vlsnIndexAccess.getLastTxnEnd();
    }

    public Set<MasterTxn> getExistingMasterTxns() {
        Set<Txn> txns = this.getTxnManager().getMasterTxns();
        HashSet<MasterTxn> masterTxns = new HashSet<MasterTxn>();
        for (Txn t : txns) {
            masterTxns.add((MasterTxn)t);
        }
        return masterTxns;
    }

    private class VLSNIndexAccess {
        private VLSNRange savedRange;

        private VLSNIndexAccess() {
        }

        synchronized VLSN getLastTxnEnd() {
            if (RepImpl.this.vlsnIndex != null) {
                return RepImpl.this.vlsnIndex.getRange().getLastTxnEnd();
            }
            return this.savedRange.getLastTxnEnd();
        }

        synchronized void closeVLSNIndex(boolean checkpointed) {
            if (RepImpl.this.vlsnIndex != null) {
                RepImpl.this.vlsnIndex.close(checkpointed);
                this.savedRange = RepImpl.this.vlsnIndex.getRange();
                RepImpl.this.vlsnIndex = null;
            }
        }

        synchronized void abnormalCloseVLSNIndex() {
            if (RepImpl.this.vlsnIndex != null) {
                RepImpl.this.vlsnIndex.abnormalClose();
                this.savedRange = RepImpl.this.vlsnIndex.getRange();
                RepImpl.this.vlsnIndex = null;
            }
        }
    }

    private static class InternalReplicatedEnvironment
    extends ReplicatedEnvironment {
        public InternalReplicatedEnvironment(File environmentHome, ReplicationConfig cloneRepConfig, EnvironmentConfig cloneConfig, RepImpl envImpl) {
            super(environmentHome, cloneRepConfig, cloneConfig, null, null, false, envImpl);
        }

        @Override
        protected boolean isInternalHandle() {
            return true;
        }

        @Override
        public synchronized void close() {
            throw EnvironmentFailureException.unexpectedState("close() not permitted on an internal environment handle");
        }
    }
}

