/*-
 *
 *  This file is part of Oracle Berkeley DB Java Edition
 *  Copyright (C) 2002, 2016 Oracle and/or its affiliates.  All rights reserved.
 *
 *  Oracle Berkeley DB Java Edition is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU Affero General Public License
 *  as published by the Free Software Foundation, version 3.
 *
 *  Oracle Berkeley DB Java Edition is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License in
 *  the LICENSE file along with Oracle Berkeley DB Java Edition.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 *  An active Oracle commercial licensing agreement for this product
 *  supercedes this license.
 *
 *  For more information please contact:
 *
 *  Vice President Legal, Development
 *  Oracle America, Inc.
 *  5OP-10
 *  500 Oracle Parkway
 *  Redwood Shores, CA 94065
 *
 *  or
 *
 *  berkeleydb-info_us@oracle.com
 *
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  [This line intentionally left blank.]
 *  EOF
 *
 */

package com.sleepycat.je.rep.stream;

import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatDefinition.StatType;

/**
 * Per-stat Metadata for HA Feeder Transaction statistics.
 */
public class FeederTxnStatDefinition {

    public static final String GROUP_NAME = "FeederTxns";
    public static final String GROUP_DESC = "FeederTxns statistics";

    public static StatDefinition TXNS_ACKED =
        new StatDefinition("txnsAcked", "Number of Transaction ack'd.");

    public static StatDefinition TXNS_NOT_ACKED =
        new StatDefinition("txnsNotAcked",
                           "Number of Transactions not Ack'd.");

    public static StatDefinition TOTAL_TXN_MS =
            new StatDefinition("totalTxnMS",
                               "The total elapsed MS across all txns from " +
                               "transaction start to end.");

    public static StatDefinition ACK_WAIT_MS =
        new StatDefinition("ackWaitMS", "Total MS waited for acks.");

    public static StatDefinition LAST_COMMIT_VLSN =
        new StatDefinition("lastCommitVLSN",
                           "The VLSN of the last committed transaction on" +
                           " the master, or 0 if not known or this node is" +
                           " not the master.",
                           StatType.CUMULATIVE);

    public static StatDefinition LAST_COMMIT_TIMESTAMP =
        new StatDefinition("lastCommitTimestamp",
                           "The commit timestamp of the last committed" +
                           " transaction on the master, or 0 if not known" +
                           " or this node is not the master.",
                           StatType.CUMULATIVE);

    public static StatDefinition VLSN_RATE =
        new StatDefinition("vlsnRate",
                           "A moving average of the rate replication data is" +
                           " being generated by the master, in VLSNs per" +
                           " minute, or 0 if not known or this node is not" +
                           " the master.");
}
