/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.Get;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryIntegrityException;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.SearchMode;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.txn.HandleLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Database
implements Closeable {
    static final CursorConfig DEFAULT_CURSOR_CONFIG = CursorConfig.DEFAULT.clone().setNonSticky(true);
    static final CursorConfig READ_COMMITTED_CURSOR_CONFIG = CursorConfig.READ_COMMITTED.clone().setNonSticky(true);
    private volatile DbState state;
    private OperationFailureException preemptedCause;
    Environment envHandle;
    private DatabaseImpl databaseImpl;
    DatabaseConfig configuration;
    private boolean isWritable;
    private final AtomicInteger openCursors = new AtomicInteger();
    private HandleLocker handleLocker;
    SecondaryAssociation secAssoc;
    Collection<SecondaryDatabase> simpleAssocSecondaries;
    Collection<SecondaryDatabase> foreignKeySecondaries;
    private AtomicLongStat deleteStat;
    private AtomicLongStat getStat;
    private AtomicLongStat getSearchBothStat;
    private AtomicLongStat putStat;
    private AtomicLongStat putNoDupDataStat;
    private AtomicLongStat putNoOverwriteStat;
    private AtomicLongStat removeSequenceStat;
    final Logger logger;

    Database(Environment env) {
        this.envHandle = env;
        this.handleLocker = null;
        this.logger = this.getEnv().getLogger();
    }

    DatabaseImpl initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) {
        dbConfig.validateForNewDb();
        this.init(env, dbConfig);
        this.databaseImpl = this.getEnv().getDbTree().createDb(locker, databaseName, dbConfig, this.handleLocker);
        this.databaseImpl.addReferringHandle(this);
        return this.databaseImpl;
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl dbImpl, String databaseName, DatabaseConfig dbConfig) {
        this.validateConfigAgainstExistingDb(locker, databaseName, dbConfig, dbImpl);
        this.init(env, dbConfig);
        this.databaseImpl = dbImpl;
        dbImpl.addReferringHandle(this);
    }

    private void init(Environment env, DatabaseConfig config) {
        assert (this.handleLocker != null);
        this.envHandle = env;
        this.configuration = config.clone();
        this.isWritable = !this.configuration.getReadOnly();
        this.setupThroughputStats(this.getEnv());
        this.secAssoc = this.makeSecondaryAssociation();
        this.state = DbState.OPEN;
    }

    private void setupThroughputStats(EnvironmentImpl envImpl) {
        this.deleteStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_DELETE);
        this.getStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_GET);
        this.getSearchBothStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_GETSEARCHBOTH);
        this.putStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_PUT);
        this.putNoDupDataStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_PUTNODUPDATA);
        this.putNoOverwriteStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_PUTNOOVERWRITE);
        this.removeSequenceStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_DB_REMOVESEQUENCE);
    }

    SecondaryAssociation makeSecondaryAssociation() {
        this.foreignKeySecondaries = new CopyOnWriteArraySet<SecondaryDatabase>();
        if (this.configuration.getSecondaryAssociation() != null) {
            if (this.configuration.getSortedDuplicates()) {
                throw new IllegalArgumentException("Duplicates not allowed for a primary database");
            }
            this.simpleAssocSecondaries = Collections.emptySet();
            return this.configuration.getSecondaryAssociation();
        }
        this.simpleAssocSecondaries = new CopyOnWriteArraySet<SecondaryDatabase>();
        return new SecondaryAssociation(){

            @Override
            public boolean isEmpty() {
                return Database.this.simpleAssocSecondaries.isEmpty();
            }

            @Override
            public Database getPrimary(DatabaseEntry primaryKey) {
                return Database.this;
            }

            @Override
            public Collection<SecondaryDatabase> getSecondaries(DatabaseEntry primaryKey) {
                return Database.this.simpleAssocSecondaries;
            }
        };
    }

    void removeReferringAssociations() {
        this.envHandle.removeReferringHandle(this);
    }

    private void validateConfigAgainstExistingDb(Locker locker, String databaseName, DatabaseConfig config, DatabaseImpl dbImpl) {
        int newNodeMaxEntries;
        if (!config.getUseExistingConfig()) {
            this.validatePropertyMatches("sortedDuplicates", dbImpl.getSortedDuplicates(), config.getSortedDuplicates());
            this.validatePropertyMatches("temporary", dbImpl.isTemporary(), config.getTemporary());
            if (this.getEnv().isReplicated()) {
                this.validatePropertyMatches("replicated", dbImpl.isReplicated(), config.getReplicated());
            }
        }
        if (dbImpl.hasOpenHandles()) {
            if (!config.getUseExistingConfig()) {
                this.validatePropertyMatches("transactional", dbImpl.isTransactional(), config.getTransactional());
                this.validatePropertyMatches("deferredWrite", dbImpl.isDurableDeferredWrite(), config.getDeferredWrite());
            }
        } else {
            dbImpl.setTransactional(config.getTransactional());
            dbImpl.setDeferredWrite(config.getDeferredWrite());
        }
        if (config.getUseExistingConfig()) {
            return;
        }
        boolean dbImplModified = false;
        if (config.getOverrideBtreeComparator()) {
            dbImplModified |= dbImpl.setBtreeComparator(config.getBtreeComparator(), config.getBtreeComparatorByClassName());
        }
        if (config.getOverrideDuplicateComparator()) {
            dbImplModified |= dbImpl.setDuplicateComparator(config.getDuplicateComparator(), config.getDuplicateComparatorByClassName());
        }
        dbImplModified |= dbImpl.setTriggers(locker, databaseName, config.getTriggers(), config.getOverrideTriggers());
        boolean newKeyPrefixing = config.getKeyPrefixing();
        if (newKeyPrefixing != dbImpl.getKeyPrefixing()) {
            dbImplModified = true;
            if (newKeyPrefixing) {
                dbImpl.setKeyPrefixing();
            } else {
                dbImpl.clearKeyPrefixing();
            }
        }
        if ((newNodeMaxEntries = config.getNodeMaxEntries()) != 0 && newNodeMaxEntries != dbImpl.getNodeMaxTreeEntries()) {
            dbImplModified = true;
            dbImpl.setNodeMaxTreeEntries(newNodeMaxEntries);
        }
        EnvironmentImpl envImpl = this.getEnv();
        if (dbImplModified && !envImpl.isReadOnly()) {
            try {
                envImpl.getDbTree().updateNameLN(locker, dbImpl.getName(), null);
            }
            catch (LockConflictException e) {
                throw new IllegalStateException("DatabaseConfig properties may not be updated when the database is already open; first close other open handles for this database.", e);
            }
            envImpl.getDbTree().modifyDbRoot(dbImpl);
        }
        dbImpl.setCacheMode(config.getCacheMode());
    }

    private void validatePropertyMatches(String propName, boolean existingValue, boolean newValue) {
        if (newValue != existingValue) {
            throw new IllegalArgumentException("You can't open a Database with a " + propName + " configuration of " + newValue + " if the underlying database was created with a " + propName + " setting of " + existingValue + '.');
        }
    }

    @Override
    public void close() {
        try {
            this.closeInternal(true, true, DbState.CLOSED, null);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    private void closeNoSync() {
        try {
            this.closeInternal(false, true, DbState.CLOSED, null);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    synchronized void setPreempted(String dbName, String msg) {
        OperationFailureException preemptedException = null;
        if (this.databaseImpl != null) {
            preemptedException = this.databaseImpl.getEnv().createDatabasePreemptedException(msg, dbName, this);
        }
        this.closeInternal(false, false, DbState.PREEMPTED, preemptedException);
    }

    synchronized void invalidate() {
        this.closeInternal(false, false, DbState.INVALID, null);
    }

    EnvironmentImpl getEnv() {
        return this.envHandle.getEnvironmentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean doSyncDw, boolean deleteTempDb, DbState newState, OperationFailureException preemptedException) {
        EnvironmentImpl envImpl = this.getEnv();
        if (envImpl != null) {
            try {
                envImpl.getSecondaryAssociationLock().writeLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(envImpl, (Throwable)e);
            }
        }
        try {
            this.closeInternalWork(doSyncDw, deleteTempDb, newState, preemptedException);
        }
        finally {
            if (envImpl != null) {
                envImpl.getSecondaryAssociationLock().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternalWork(boolean doSyncDw, boolean deleteTempDb, DbState newState, OperationFailureException preemptedException) {
        StringBuilder handleRefErrors = new StringBuilder();
        RuntimeException triggerException = null;
        DatabaseImpl dbClosed = null;
        Database database = this;
        synchronized (database) {
            if (this.state != DbState.OPEN) {
                return;
            }
            this.checkEnv();
            this.state = newState;
            this.preemptedCause = preemptedException;
            if (newState == DbState.CLOSED) {
                if (this.openCursors.get() != 0) {
                    handleRefErrors.append(" ").append(this.openCursors.get()).append(" open cursors.");
                }
                if (this.simpleAssocSecondaries != null && this.simpleAssocSecondaries.size() > 0) {
                    handleRefErrors.append(" ").append(this.simpleAssocSecondaries.size()).append(" associated SecondaryDatabases.");
                }
                if (this.foreignKeySecondaries != null && this.foreignKeySecondaries.size() > 0) {
                    handleRefErrors.append(" ").append(this.foreignKeySecondaries.size()).append(" associated foreign key SecondaryDatabases.");
                }
            }
            this.trace(Level.FINEST, "Database.close: ", null, null);
            this.removeReferringAssociations();
            if (this.databaseImpl != null) {
                dbClosed = this.databaseImpl;
                this.databaseImpl.removeReferringHandle(this);
                this.getEnv().getDbTree().releaseDb(this.databaseImpl);
                this.databaseImpl = null;
                if (this.handleLocker != null) {
                    if (newState == DbState.PREEMPTED) {
                        this.handleLocker.setOnlyAbortable(preemptedException);
                    }
                    if (newState == DbState.CLOSED) {
                        if (this.isWritable() && dbClosed.noteWriteHandleClose() == 0) {
                            try {
                                TriggerManager.runCloseTriggers(this.handleLocker, dbClosed);
                            }
                            catch (RuntimeException e) {
                                triggerException = e;
                            }
                        }
                        this.handleLocker.operationEnd(true);
                    } else {
                        this.handleLocker.operationEnd(false);
                    }
                    this.handleLocker = null;
                }
            }
        }
        if (dbClosed != null) {
            dbClosed.handleClosed(doSyncDw, deleteTempDb);
        }
        if (handleRefErrors.length() > 0) {
            throw new IllegalStateException("Database closed while still referenced by other handles." + handleRefErrors.toString());
        }
        if (triggerException != null) {
            throw triggerException;
        }
    }

    public void sync() {
        this.checkEnv();
        this.checkOpen();
        this.trace(Level.FINEST, "Database.sync", null, null, null, null);
        this.databaseImpl.sync(true);
    }

    public Sequence openSequence(Transaction txn, DatabaseEntry key, SequenceConfig config) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkOpen();
            this.trace(Level.FINEST, "Database.openSequence", txn, key, null, null);
            return new Sequence(this, txn, key, config);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public void removeSequence(Transaction txn, DatabaseEntry key) {
        this.removeSequenceStat.increment();
        try {
            this.delete(txn, key);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public Cursor openCursor(Transaction txn, CursorConfig cursorConfig) {
        try {
            CursorConfig useConfig;
            this.checkEnv();
            this.checkOpen();
            CursorConfig cursorConfig2 = useConfig = cursorConfig == null ? CursorConfig.DEFAULT : cursorConfig;
            if (useConfig.getReadUncommitted() && useConfig.getReadCommitted()) {
                throw new IllegalArgumentException("Only one may be specified: ReadCommitted or ReadUncommitted");
            }
            this.trace(Level.FINEST, "Database.openCursor", txn, cursorConfig);
            return this.newDbcInstance(txn, useConfig);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public DiskOrderedCursor openCursor(DiskOrderedCursorConfig cursorConfig) {
        try {
            this.checkEnv();
            this.checkOpen();
            DiskOrderedCursorConfig useConfig = cursorConfig == null ? DiskOrderedCursorConfig.DEFAULT : cursorConfig;
            this.trace(Level.FINEST, "Database.openForwardCursor", null, cursorConfig);
            Database[] dbs = new Database[]{this};
            return new DiskOrderedCursor(dbs, useConfig);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) {
        return new Cursor(this, txn, cursorConfig);
    }

    public void populateSecondaries(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        this.populateSecondaries(txn, key, data, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateSecondaries(Transaction txn, DatabaseEntry key, DatabaseEntry data, long expirationTime, CacheMode cacheMode) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "true", true);
            this.checkOpen();
            this.trace(Level.FINEST, "populateSecondaries", null, key, data, null);
            Collection<SecondaryDatabase> secondaries = this.secAssoc.getSecondaries(key);
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
            boolean success = false;
            if (cacheMode == null) {
                cacheMode = this.databaseImpl.getDefaultCacheMode();
            }
            try {
                for (SecondaryDatabase secDb : secondaries) {
                    if (!secDb.isIncrementalPopulationEnabled()) continue;
                    secDb.updateSecondary(locker, null, key, null, data, cacheMode, expirationTime, false, expirationTime);
                }
                success = true;
            }
            finally {
                locker.operationEnd(success);
            }
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult delete(Transaction txn, DatabaseEntry key, WriteOptions options) {
        try {
            this.checkEnv();
            this.checkOpen();
            this.trace(Level.FINEST, "Database.delete", txn, key, null, null);
            CacheMode cacheMode = options != null ? options.getCacheMode() : null;
            OperationResult result = null;
            this.deleteStat.increment();
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
            try {
                result = this.deleteInternal(locker, key, cacheMode);
                if (locker != null) {
                    locker.operationEnd(result != null);
                }
            }
            catch (Throwable throwable) {
                if (locker != null) {
                    locker.operationEnd(result != null);
                }
                throw throwable;
            }
            return result;
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    OperationResult deleteInternal(Locker locker, DatabaseEntry key, CacheMode cacheMode) {
        DatabaseEntry noData = new DatabaseEntry();
        noData.setPartial(0, 0, true);
        try (Cursor cursor = new Cursor(this, locker, null);){
            cursor.setNonSticky(true);
            LockMode lockMode = cursor.isSerializableIsolation(LockMode.RMW) ? LockMode.RMW : LockMode.READ_UNCOMMITTED_ALL;
            OperationResult searchResult = cursor.search(key, noData, lockMode, cacheMode, SearchMode.SET);
            OperationResult anyResult = null;
            while (searchResult != null) {
                OperationResult deleteResult = cursor.deleteInternal(this.databaseImpl.getRepContext(), cacheMode);
                if (deleteResult != null) {
                    anyResult = deleteResult;
                }
                if (!this.databaseImpl.getSortedDuplicates()) break;
                searchResult = cursor.retrieveNext(key, noData, lockMode, cacheMode, GetMode.NEXT_DUP);
            }
            OperationResult operationResult = anyResult;
            return operationResult;
        }
    }

    public OperationStatus delete(Transaction txn, DatabaseEntry key) {
        OperationResult result = this.delete(txn, key, null);
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult get(Transaction txn, DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options) {
        try {
            CursorConfig cursorConfig;
            this.checkEnv();
            this.checkOpen();
            if (options == null) {
                options = Cursor.DEFAULT_READ_OPTIONS;
            }
            LockMode lockMode = options.getLockMode();
            this.trace(Level.FINEST, "Database.get", String.valueOf((Object)getType), txn, key, null, lockMode);
            this.checkLockModeWithoutTxn(txn, lockMode);
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = READ_COMMITTED_CURSOR_CONFIG;
                lockMode = null;
            } else {
                cursorConfig = DEFAULT_CURSOR_CONFIG;
            }
            OperationResult result = null;
            Locker locker = LockerFactory.getReadableLocker(this, txn, cursorConfig.getReadCommitted());
            try {
                try (Cursor cursor = new Cursor(this, locker, cursorConfig);){
                    result = cursor.getInternal(key, data, getType, options, lockMode, getType.getDbStat());
                }
                locker.operationEnd(result != null);
            }
            catch (Throwable throwable) {
                locker.operationEnd(result != null);
                throw throwable;
            }
            return result;
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(txn, key, data, Get.SEARCH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(txn, key, data, Get.SEARCH_BOTH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult put(Transaction txn, DatabaseEntry key, DatabaseEntry data, Put putType, WriteOptions options) {
        try {
            this.checkEnv();
            this.checkOpen();
            if (putType == Put.CURRENT) {
                throw new IllegalArgumentException("putType may not be Put.CURRENT");
            }
            OperationResult result = null;
            this.trace(Level.FINEST, "Database.put", String.valueOf((Object)putType), txn, key, data, null);
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.databaseImpl.isInternalDb(), this.isTransactional(), this.databaseImpl.isReplicated());
            try {
                try (Cursor cursor = new Cursor(this, locker, DEFAULT_CURSOR_CONFIG);){
                    result = cursor.putInternal(key, data, putType, options, putType.getDbStat());
                }
                locker.operationEnd(result != null);
            }
            catch (Throwable throwable) {
                locker.operationEnd(result != null);
                throw throwable;
            }
            return result;
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        OperationResult result = this.put(txn, key, data, Put.OVERWRITE, null);
        EnvironmentFailureException.assertState(result != null);
        return OperationStatus.SUCCESS;
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        OperationResult result = this.put(txn, key, data, Put.NO_OVERWRITE, null);
        return result == null ? OperationStatus.KEYEXIST : OperationStatus.SUCCESS;
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) {
        OperationResult result = this.put(txn, key, data, Put.NO_DUP_DATA, null);
        return result == null ? OperationStatus.KEYEXIST : OperationStatus.SUCCESS;
    }

    public JoinCursor join(Cursor[] cursors, JoinConfig config) {
        try {
            this.checkEnv();
            this.checkOpen();
            DatabaseUtil.checkForNullParam(cursors, "cursors");
            if (cursors.length == 0) {
                throw new IllegalArgumentException("At least one cursor is required.");
            }
            Locker locker = cursors[0].getCursorImpl().getLocker();
            if (!locker.isTransactional()) {
                EnvironmentImpl env = this.getEnv();
                for (int i = 1; i < cursors.length; ++i) {
                    Locker locker2 = cursors[i].getCursorImpl().getLocker();
                    if (locker2.isTransactional()) {
                        throw new IllegalArgumentException("All cursors must use the same transaction.");
                    }
                    EnvironmentImpl env2 = cursors[i].getDatabaseImpl().getEnv();
                    if (env == env2) continue;
                    throw new IllegalArgumentException("All cursors must use the same environment.");
                }
            } else {
                for (int i = 1; i < cursors.length; ++i) {
                    Locker locker2 = cursors[i].getCursorImpl().getLocker();
                    if (locker.getTxnLocker() == locker2.getTxnLocker()) continue;
                    throw new IllegalArgumentException("All cursors must use the same transaction.");
                }
            }
            return new JoinCursor(this, cursors, config);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public void preload(long maxBytes) {
        this.checkEnv();
        this.checkOpen();
        PreloadConfig config = new PreloadConfig();
        config.setMaxBytes(maxBytes);
        this.databaseImpl.preload(config);
    }

    public void preload(long maxBytes, long maxMillisecs) {
        this.checkEnv();
        this.checkOpen();
        PreloadConfig config = new PreloadConfig();
        config.setMaxBytes(maxBytes);
        config.setMaxMillisecs(maxMillisecs);
        this.databaseImpl.preload(config);
    }

    public PreloadStats preload(PreloadConfig config) {
        this.checkEnv();
        this.checkOpen();
        PreloadConfig useConfig = config == null ? new PreloadConfig() : config;
        return this.databaseImpl.preload(useConfig);
    }

    public long count() {
        this.checkEnv();
        this.checkOpen();
        return this.databaseImpl.count(0L);
    }

    public long count(long memoryLimit) {
        this.checkEnv();
        this.checkOpen();
        return this.databaseImpl.count(memoryLimit);
    }

    public DatabaseStats getStats(StatsConfig config) {
        StatsConfig useConfig;
        this.checkEnv();
        this.checkOpen();
        StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
        if (this.databaseImpl != null) {
            return this.databaseImpl.stat(useConfig);
        }
        return null;
    }

    public DatabaseStats verify(VerifyConfig config) {
        try {
            this.checkEnv();
            this.checkOpen();
            VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
            DatabaseStats stats = this.databaseImpl.getEmptyStats();
            this.databaseImpl.verify(useConfig, stats);
            return stats;
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    public String getDatabaseName() {
        try {
            this.checkEnv();
            if (this.databaseImpl != null) {
                return this.databaseImpl.getName();
            }
            return null;
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    String getDebugName() {
        if (this.databaseImpl != null) {
            return this.databaseImpl.getDebugName();
        }
        return null;
    }

    public DatabaseConfig getConfig() {
        try {
            return DatabaseConfig.combineConfig(this.databaseImpl, this.configuration);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    boolean isTransactional() {
        return this.databaseImpl.isTransactional();
    }

    public Environment getEnvironment() {
        return this.envHandle;
    }

    public List<SecondaryDatabase> getSecondaryDatabases() {
        return new ArrayList<SecondaryDatabase>(this.simpleAssocSecondaries);
    }

    public int compareKeys(DatabaseEntry entry1, DatabaseEntry entry2) {
        return this.doCompareKeys(entry1, entry2, false);
    }

    public int compareDuplicates(DatabaseEntry entry1, DatabaseEntry entry2) {
        return this.doCompareKeys(entry1, entry2, true);
    }

    private int doCompareKeys(DatabaseEntry entry1, DatabaseEntry entry2, boolean duplicates) {
        try {
            this.checkEnv();
            this.checkOpen();
            DatabaseUtil.checkForNullDbt(entry1, "entry1", true);
            DatabaseUtil.checkForNullDbt(entry2, "entry2", true);
            DatabaseUtil.checkForPartial(entry1, "entry1");
            DatabaseUtil.checkForPartial(entry2, "entry2");
            return this.databaseImpl.compareEntries(entry1, entry2, duplicates);
        }
        catch (Error E) {
            this.getEnv().invalidate(E);
            throw E;
        }
    }

    boolean isWritable() {
        return this.isWritable;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.databaseImpl;
    }

    HandleLocker initHandleLocker(EnvironmentImpl envImpl, Locker openDbLocker) {
        this.handleLocker = HandleLocker.createHandleLocker(envImpl, openDbLocker);
        return this.handleLocker;
    }

    void removeCursor(ForwardCursor ignore) throws DatabaseException {
        if (this.state != DbState.PREEMPTED) {
            this.checkOpen();
        }
        this.openCursors.getAndDecrement();
    }

    void addCursor(ForwardCursor ignore) {
        this.checkOpen();
        this.openCursors.getAndIncrement();
    }

    void checkOpen() {
        switch (this.state) {
            case OPEN: {
                break;
            }
            case CLOSED: {
                throw new IllegalStateException("Database was closed.");
            }
            case INVALID: {
                throw new IllegalStateException("The Transaction used to open the Database was aborted.");
            }
            case PREEMPTED: {
                throw this.preemptedCause.wrapSelf(this.preemptedCause.getMessage());
            }
            default: {
                assert (false) : this.state;
                break;
            }
        }
    }

    void checkEnv() throws EnvironmentFailureException {
        this.envHandle.checkHandleIsValid();
        this.envHandle.checkEnv();
    }

    void checkLockModeWithoutTxn(Transaction userTxn, LockMode lockMode) {
        if (userTxn == null && LockMode.RMW.equals((Object)lockMode)) {
            throw new IllegalArgumentException((Object)((Object)lockMode) + " is meaningless and can not be specified " + "when a null (autocommit) transaction is used. There " + "will never be a follow on operation which will promote " + "the lock to WRITE.");
        }
    }

    void trace(Level level, String methodName, String getOrPutType, Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName).append(" ");
            sb.append(getOrPutType);
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            sb.append(" key=").append(key.dumpData());
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.getEnv(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            sb.append(" key=").append(key.dumpData());
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.getEnv(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, Transaction txn, Object config) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            sb.append(" name=").append(this.getDebugName());
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            if (config != null) {
                sb.append(" config=").append(config);
            }
            LoggerUtils.logMsg(this.logger, this.getEnv(), level, sb.toString());
        }
    }

    boolean hasSecondaryOrForeignKeyAssociations() {
        return !this.secAssoc.isEmpty() || !this.foreignKeySecondaries.isEmpty();
    }

    SecondaryIntegrityException secondaryRefersToMissingPrimaryKey(Locker locker, DatabaseEntry secKey, DatabaseEntry priKey, long expirationTime) {
        return new SecondaryIntegrityException(locker, "Secondary refers to a missing key in the primary database", this.getDebugName(), secKey, priKey, expirationTime);
    }

    static enum DbState {
        OPEN,
        CLOSED,
        INVALID,
        PREEMPTED;

    }
}

