/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.SequenceExistsException;
import com.sleepycat.je.SequenceIntegrityException;
import com.sleepycat.je.SequenceNotFoundException;
import com.sleepycat.je.SequenceOverflowException;
import com.sleepycat.je.SequenceStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.SequenceStatDefinition;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Closeable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Sequence
implements Closeable {
    private static final byte FLAG_INCR = 1;
    private static final byte FLAG_WRAP = 2;
    private static final byte FLAG_OVER = 4;
    private static final int MAX_DATA_SIZE = 50;
    private static final byte CURRENT_VERSION = 1;
    private final Database db;
    private final DatabaseEntry key;
    private boolean wrapAllowed;
    private boolean increment;
    private boolean overflow;
    private long rangeMin;
    private long rangeMax;
    private long storedValue;
    private final int cacheSize;
    private long cacheValue;
    private long cacheLast;
    private int nGets;
    private int nCachedGets;
    private TransactionConfig autoCommitConfig;
    private final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Sequence(Database db, Transaction txn, DatabaseEntry key, SequenceConfig config) throws SequenceNotFoundException, SequenceExistsException {
        SequenceConfig useConfig;
        block17: {
            if (db.getDatabaseImpl().getSortedDuplicates()) {
                throw new UnsupportedOperationException("Sequences not supported in databases configured for duplicates");
            }
            SequenceConfig sequenceConfig = useConfig = config != null ? config : SequenceConfig.DEFAULT;
            if (useConfig.getRangeMin() >= useConfig.getRangeMax()) {
                throw new IllegalArgumentException("Minimum sequence value must be less than the maximum");
            }
            if (useConfig.getInitialValue() > useConfig.getRangeMax() || useConfig.getInitialValue() < useConfig.getRangeMin()) {
                throw new IllegalArgumentException("Initial sequence value is out of range");
            }
            if (useConfig.getRangeMin() > useConfig.getRangeMax() - (long)useConfig.getCacheSize()) {
                throw new IllegalArgumentException("The cache size is larger than the sequence range");
            }
            if (useConfig.getAutoCommitNoSync()) {
                this.autoCommitConfig = DbInternal.getDefaultTxnConfig(db.getEnvironment()).clone();
                this.autoCommitConfig.overrideDurability(Durability.COMMIT_NO_SYNC);
            } else {
                this.autoCommitConfig = null;
            }
            this.db = db;
            this.key = this.copyEntry(key);
            this.logger = db.getEnvironment().getEnvironmentImpl().getLogger();
            Locker locker = null;
            Cursor cursor = null;
            OperationStatus status = OperationStatus.NOTFOUND;
            try {
                boolean isWritableLocker;
                locker = LockerFactory.getReadableLocker(db, txn, false);
                cursor = new Cursor(db, locker, null);
                boolean sequenceExists = this.readData(cursor, null);
                boolean bl = isWritableLocker = !db.getConfig().getTransactional() || locker.isTransactional() && !DbInternal.getEnvironmentImpl(db.getEnvironment()).isReplicated();
                if (sequenceExists) {
                    if (useConfig.getAllowCreate() && useConfig.getExclusiveCreate()) {
                        throw new SequenceExistsException("ExclusiveCreate=true and the sequence record already exists.");
                    }
                    break block17;
                }
                if (useConfig.getAllowCreate()) {
                    if (!isWritableLocker) {
                        if (cursor != null) {
                            cursor.close();
                        }
                        locker.operationEnd(OperationStatus.SUCCESS);
                        locker = LockerFactory.getWritableLocker(db.getEnvironment(), txn, db.getDatabaseImpl().isInternalDb(), db.isTransactional(), db.getDatabaseImpl().isReplicated(), this.autoCommitConfig);
                        cursor = new Cursor(db, locker, null);
                    }
                    this.rangeMin = useConfig.getRangeMin();
                    this.rangeMax = useConfig.getRangeMax();
                    this.increment = !useConfig.getDecrement();
                    this.wrapAllowed = useConfig.getWrap();
                    this.storedValue = useConfig.getInitialValue();
                    status = cursor.putNoOverwrite(key, this.makeData());
                    if (!this.readData(cursor, null)) {
                        throw new IllegalStateException("Sequence record removed during openSequence.");
                    }
                    status = OperationStatus.SUCCESS;
                    break block17;
                }
                throw new SequenceNotFoundException("AllowCreate=false and the sequence record does not exist.");
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd(status);
                }
            }
        }
        this.cacheSize = useConfig.getCacheSize();
        this.cacheValue = this.storedValue;
        this.cacheLast = this.increment ? this.storedValue - 1L : this.storedValue + 1L;
    }

    @Override
    public void close() throws DatabaseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long get(Transaction txn, int delta) throws DatabaseException {
        if (delta <= 0) {
            throw new IllegalArgumentException("Sequence delta must be greater than zero");
        }
        if (this.rangeMin > this.rangeMax - (long)delta) {
            throw new IllegalArgumentException("Sequence delta is larger than the range");
        }
        boolean cached = true;
        boolean wrapped = false;
        if (this.increment && (long)delta > this.cacheLast - this.cacheValue + 1L || !this.increment && (long)delta > this.cacheValue - this.cacheLast + 1L) {
            cached = false;
            int adjust = delta > this.cacheSize ? delta : this.cacheSize;
            Locker locker = null;
            Cursor cursor = null;
            OperationStatus status = OperationStatus.NOTFOUND;
            try {
                locker = LockerFactory.getWritableLocker(this.db.getEnvironment(), txn, this.db.getDatabaseImpl().isInternalDb(), this.db.isTransactional(), this.db.getDatabaseImpl().isReplicated(), this.autoCommitConfig);
                cursor = new Cursor(this.db, locker, null);
                this.readDataRequired(cursor, LockMode.RMW);
                if (this.overflow) {
                    throw new SequenceOverflowException("Sequence overflow " + this.storedValue);
                }
                BigInteger availBig = this.increment ? BigInteger.valueOf(this.rangeMax).subtract(BigInteger.valueOf(this.storedValue)) : BigInteger.valueOf(this.storedValue).subtract(BigInteger.valueOf(this.rangeMin));
                if (availBig.compareTo(BigInteger.valueOf(adjust)) < 0) {
                    int availInt = (int)availBig.longValue();
                    if (availInt < delta) {
                        if (this.wrapAllowed) {
                            this.storedValue = this.increment ? this.rangeMin : this.rangeMax;
                            wrapped = true;
                        } else {
                            this.overflow = true;
                            adjust = 0;
                        }
                    } else {
                        adjust = availInt;
                    }
                }
                if (!this.increment) {
                    adjust = -adjust;
                }
                this.storedValue += (long)adjust;
                cursor.put(this.key, this.makeData());
                status = OperationStatus.SUCCESS;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd(status);
                }
            }
            this.cacheValue = this.storedValue - (long)adjust;
            this.cacheLast = this.storedValue + (long)(this.increment ? -1 : 1);
        }
        long retVal = this.cacheValue;
        this.cacheValue = this.increment ? (this.cacheValue += (long)delta) : (this.cacheValue -= (long)delta);
        ++this.nGets;
        if (cached) {
            ++this.nCachedGets;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.db.getEnvironment().getEnvironmentImpl(), "Sequence.get value=" + retVal + " cached=" + cached + " wrapped=" + wrapped);
        }
        return retVal;
    }

    public Database getDatabase() {
        return this.db;
    }

    public DatabaseEntry getKey() {
        return this.copyEntry(this.key);
    }

    public SequenceStats getStats(StatsConfig config) throws DatabaseException {
        if (config == null) {
            config = StatsConfig.DEFAULT;
        }
        if (!config.getFast()) {
            try (Cursor cursor = this.db.openCursor(null, null);){
                this.readDataRequired(cursor, LockMode.READ_UNCOMMITTED);
            }
        }
        StatGroup stats = new StatGroup("Sequence", "Sequence statistics");
        new IntStat(stats, SequenceStatDefinition.SEQUENCE_GETS, this.nGets);
        new IntStat(stats, SequenceStatDefinition.SEQUENCE_CACHED_GETS, this.nCachedGets);
        new IntStat(stats, SequenceStatDefinition.SEQUENCE_CACHE_SIZE, this.cacheSize);
        new LongStat(stats, SequenceStatDefinition.SEQUENCE_STORED_VALUE, this.storedValue);
        new LongStat(stats, SequenceStatDefinition.SEQUENCE_CACHE_VALUE, this.cacheValue);
        new LongStat(stats, SequenceStatDefinition.SEQUENCE_CACHE_LAST, this.cacheLast);
        new LongStat(stats, SequenceStatDefinition.SEQUENCE_RANGE_MIN, this.rangeMin);
        new LongStat(stats, SequenceStatDefinition.SEQUENCE_RANGE_MAX, this.rangeMax);
        SequenceStats seqStats = new SequenceStats(stats);
        if (config.getClear()) {
            this.nGets = 0;
            this.nCachedGets = 0;
        }
        return seqStats;
    }

    private void readDataRequired(Cursor cursor, LockMode lockMode) throws DatabaseException {
        if (!this.readData(cursor, lockMode)) {
            throw new SequenceIntegrityException("The sequence record has been deleted while it is open.");
        }
    }

    private boolean readData(Cursor cursor, LockMode lockMode) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = cursor.getSearchKey(this.key, data, lockMode);
        if (status != OperationStatus.SUCCESS) {
            return false;
        }
        ByteBuffer buf = ByteBuffer.wrap(data.getData());
        byte version = buf.get();
        byte flags = buf.get();
        boolean unpacked = version < 1;
        this.rangeMin = LogUtils.readLong(buf, unpacked);
        this.rangeMax = LogUtils.readLong(buf, unpacked);
        this.storedValue = LogUtils.readLong(buf, unpacked);
        this.increment = (flags & 1) != 0;
        this.wrapAllowed = (flags & 2) != 0;
        this.overflow = (flags & 4) != 0;
        return true;
    }

    private DatabaseEntry makeData() {
        byte[] data = new byte[50];
        ByteBuffer buf = ByteBuffer.wrap(data);
        byte flags = 0;
        if (this.increment) {
            flags = (byte)(flags | 1);
        }
        if (this.wrapAllowed) {
            flags = (byte)(flags | 2);
        }
        if (this.overflow) {
            flags = (byte)(flags | 4);
        }
        buf.put((byte)1);
        buf.put(flags);
        LogUtils.writePackedLong(buf, this.rangeMin);
        LogUtils.writePackedLong(buf, this.rangeMax);
        LogUtils.writePackedLong(buf, this.storedValue);
        return new DatabaseEntry(data, 0, buf.position());
    }

    private DatabaseEntry copyEntry(DatabaseEntry entry) {
        byte[] data;
        int len = entry.getSize();
        if (len == 0) {
            data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        } else {
            data = new byte[len];
            System.arraycopy(entry.getData(), entry.getOffset(), data, 0, data.length);
        }
        return new DatabaseEntry(data);
    }
}

