/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.Durability;
import com.sleepycat.je.config.BooleanConfigParam;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.DurationConfigParam;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.config.LongConfigParam;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class EnvironmentParams {
    public static final String REP_PARAM_PREFIX = "je.rep.";
    public static final Map<String, ConfigParam> SUPPORTED_PARAMS = new HashMap<String, ConfigParam>();
    public static final LongConfigParam MAX_MEMORY = new LongConfigParam("je.maxMemory", null, null, 0L, true, false);
    public static final IntConfigParam MAX_MEMORY_PERCENT = new IntConfigParam("je.maxMemoryPercent", 1, 90, 60, true, false);
    public static final BooleanConfigParam ENV_SHARED_CACHE = new BooleanConfigParam("je.sharedCache", false, false, false);
    public static final BooleanConfigParam ENV_COMPARATORS_REQUIRED = new BooleanConfigParam("je.env.comparatorsRequired", false, false, false);
    public static final BooleanConfigParam ENV_RECOVERY = new BooleanConfigParam("je.env.recovery", true, false, false);
    public static final BooleanConfigParam ENV_RECOVERY_FORCE_CHECKPOINT = new BooleanConfigParam("je.env.recoveryForceCheckpoint", false, false, false);
    public static final BooleanConfigParam ENV_RECOVERY_FORCE_NEW_FILE = new BooleanConfigParam("je.env.recoveryForceNewFile", false, false, false);
    public static final BooleanConfigParam HALT_ON_COMMIT_AFTER_CHECKSUMEXCEPTION = new BooleanConfigParam("je.haltOnCommitAfterChecksumException", false, false, false);
    public static final BooleanConfigParam ENV_RUN_INCOMPRESSOR = new BooleanConfigParam("je.env.runINCompressor", true, true, false);
    public static final BooleanConfigParam ENV_RUN_EVICTOR = new BooleanConfigParam("je.env.runEvictor", true, true, false);
    public static final BooleanConfigParam ENV_DUP_CONVERT_PRELOAD_ALL = new BooleanConfigParam("je.env.dupConvertPreloadAll", true, false, false);
    private static final DurationConfigParam EVICTOR_WAKEUP_INTERVAL = new DurationConfigParam("je.evictor.wakeupInterval", "1 s", "75 min", "5 s", false, false);
    public static final IntConfigParam EVICTOR_CORE_THREADS = new IntConfigParam("je.evictor.coreThreads", 0, Integer.MAX_VALUE, 1, true, false);
    public static final IntConfigParam EVICTOR_MAX_THREADS = new IntConfigParam("je.evictor.maxThreads", 1, Integer.MAX_VALUE, 10, true, false);
    public static final DurationConfigParam EVICTOR_KEEP_ALIVE = new DurationConfigParam("je.evictor.keepAlive", "1 s", "24 h", "10 min", true, false);
    public static final DurationConfigParam EVICTOR_TERMINATE_TIMEOUT = new DurationConfigParam("je.env.terminateTimeout", "1 ms", "60 s", "10 s", true, false);
    public static final BooleanConfigParam EVICTOR_ALLOW_BIN_DELTAS = new BooleanConfigParam("je.evictor.allowBinDeltas", true, false, false);
    public static final BooleanConfigParam EVICTOR_MUTATE_BINS = new BooleanConfigParam("je.evictor.mutateBins", true, false, false);
    public static final BooleanConfigParam ENV_RUN_CHECKPOINTER = new BooleanConfigParam("je.env.runCheckpointer", true, true, false);
    public static final BooleanConfigParam ENV_RUN_CLEANER = new BooleanConfigParam("je.env.runCleaner", true, true, false);
    public static final IntConfigParam ENV_BACKGROUND_READ_LIMIT = new IntConfigParam("je.env.backgroundReadLimit", 0, Integer.MAX_VALUE, 0, true, false);
    public static final IntConfigParam ENV_BACKGROUND_WRITE_LIMIT = new IntConfigParam("je.env.backgroundWriteLimit", 0, Integer.MAX_VALUE, 0, true, false);
    public static final DurationConfigParam ENV_BACKGROUND_SLEEP_INTERVAL = new DurationConfigParam("je.env.backgroundSleepInterval", "1 ms", null, "1 ms", true, false);
    public static final BooleanConfigParam ENV_CHECK_LEAKS = new BooleanConfigParam("je.env.checkLeaks", true, false, false);
    public static final BooleanConfigParam ENV_FORCED_YIELD = new BooleanConfigParam("je.env.forcedYield", false, false, false);
    public static final BooleanConfigParam ENV_INIT_TXN = new BooleanConfigParam("je.env.isTransactional", false, false, false);
    public static final BooleanConfigParam ENV_INIT_LOCKING = new BooleanConfigParam("je.env.isLocking", true, false, false);
    public static final BooleanConfigParam ENV_RDONLY = new BooleanConfigParam("je.env.isReadOnly", false, false, false);
    public static final BooleanConfigParam ENV_FAIR_LATCHES = new BooleanConfigParam("je.env.fairLatches", false, false, false);
    private static final BooleanConfigParam ENV_SHARED_LATCHES = new BooleanConfigParam("je.env.sharedLatches", true, false, false);
    public static final BooleanConfigParam ENV_SETUP_LOGGER = new BooleanConfigParam("je.env.setupLogger", false, false, false);
    public static final DurationConfigParam ENV_LATCH_TIMEOUT = new DurationConfigParam("je.env.latchTimeout", "1 ms", null, "5 min", false, false);
    public static final DurationConfigParam ENV_TTL_CLOCK_TOLERANCE = new DurationConfigParam("je.env.ttlClockTolerance", "1 ms", null, "2 h", false, false);
    public static final DurationConfigParam ENV_TTL_MAX_TXN_TIME = new DurationConfigParam("je.env.ttlMaxTxnTime", null, null, "24 h", false, false);
    public static final DurationConfigParam ENV_TTL_LN_PURGE_DELAY = new DurationConfigParam("je.env.ttlLnPurgeDelay", null, null, "5 s", false, false);
    public static final BooleanConfigParam ENV_EXPOSE_USER_DATA = new BooleanConfigParam("je.env.exposeUserData", false, true, false);
    public static final BooleanConfigParam ENV_DB_EVICTION = new BooleanConfigParam("je.env.dbEviction", true, false, false);
    public static final IntConfigParam ADLER32_CHUNK_SIZE = new IntConfigParam("je.adler32.chunkSize", 0, 0x100000, 0, true, false);
    public static final int MIN_LOG_BUFFER_SIZE = 2048;
    public static final int NUM_LOG_BUFFERS_DEFAULT = 3;
    public static final long LOG_MEM_SIZE_MIN = 6144L;
    public static final String LOG_MEM_SIZE_MIN_STRING = Long.toString(6144L);
    public static final LongConfigParam LOG_MEM_SIZE = new LongConfigParam("je.log.totalBufferBytes", 6144L, null, 0L, false, false);
    public static final IntConfigParam NUM_LOG_BUFFERS = new IntConfigParam("je.log.numBuffers", 2, null, 3, false, false);
    public static final IntConfigParam LOG_BUFFER_MAX_SIZE = new IntConfigParam("je.log.bufferSize", 1024, null, 0x100000, false, false);
    public static final IntConfigParam LOG_FAULT_READ_SIZE = new IntConfigParam("je.log.faultReadSize", 32, null, 2048, false, false);
    public static final IntConfigParam LOG_ITERATOR_READ_SIZE = new IntConfigParam("je.log.iteratorReadSize", 128, null, 8192, false, false);
    public static final IntConfigParam LOG_ITERATOR_MAX_SIZE = new IntConfigParam("je.log.iteratorMaxSize", 128, null, 0x1000000, false, false);
    public static final LongConfigParam LOG_FILE_MAX = new LongConfigParam("je.log.fileMax", 1000000L, 0x40000000L, 10000000L, false, false);
    public static final IntConfigParam LOG_N_DATA_DIRECTORIES = new IntConfigParam("je.log.nDataDirectories", 0, 256, 0, false, false);
    public static final BooleanConfigParam LOG_CHECKSUM_READ = new BooleanConfigParam("je.log.checksumRead", true, false, false);
    public static final BooleanConfigParam LOG_VERIFY_CHECKSUMS = new BooleanConfigParam("je.log.verifyChecksums", false, false, false);
    public static final BooleanConfigParam LOG_MEMORY_ONLY = new BooleanConfigParam("je.log.memOnly", false, false, false);
    public static final IntConfigParam LOG_FILE_CACHE_SIZE = new IntConfigParam("je.log.fileCacheSize", 3, null, 100, false, false);
    public static final IntConfigParam LOG_FILE_WARM_UP_SIZE = new IntConfigParam("je.log.fileWarmUpSize", 0, null, 0, false, false);
    public static final IntConfigParam LOG_FILE_WARM_UP_BUF_SIZE = new IntConfigParam("je.log.fileWarmUpReadSize", 128, null, 0xA00000, false, false);
    public static final DurationConfigParam LOG_FSYNC_TIMEOUT = new DurationConfigParam("je.log.fsyncTimeout", "10 ms", null, "500 ms", false, false);
    public static final DurationConfigParam LOG_FSYNC_TIME_LIMIT = new DurationConfigParam("je.log.fsyncTimeLimit", "0", "30 s", "5 s", false, false);
    public static final DurationConfigParam LOG_GROUP_COMMIT_INTERVAL = new DurationConfigParam("je.log.groupCommitInterval", "0 ns", null, "0 ns", false, false);
    public static final IntConfigParam LOG_GROUP_COMMIT_THRESHOLD = new IntConfigParam("je.log.groupCommitThreshold", 0, null, 0, false, false);
    public static final BooleanConfigParam LOG_USE_ODSYNC = new BooleanConfigParam("je.log.useODSYNC", false, false, false);
    public static final BooleanConfigParam LOG_USE_NIO = new BooleanConfigParam("je.log.useNIO", false, false, false);
    public static final BooleanConfigParam LOG_USE_WRITE_QUEUE = new BooleanConfigParam("je.log.useWriteQueue", true, false, false);
    public static final IntConfigParam LOG_WRITE_QUEUE_SIZE = new IntConfigParam("je.log.writeQueueSize", 4096, 0x10000000, 0x100000, false, false);
    private static final BooleanConfigParam LOG_DIRECT_NIO = new BooleanConfigParam("je.log.directNIO", false, false, false);
    private static final LongConfigParam LOG_CHUNKED_NIO = new LongConfigParam("je.log.chunkedNIO", 0L, 0x4000000L, 0L, false, false);
    public static final BooleanConfigParam LOG_DEFERREDWRITE_TEMP = new BooleanConfigParam("je.deferredWrite.temp", false, false, false);
    public static final IntConfigParam NODE_MAX = new IntConfigParam("je.nodeMaxEntries", 4, (Integer)Short.MAX_VALUE, 128, false, false);
    public static final IntConfigParam NODE_MAX_DUPTREE = new IntConfigParam("je.nodeDupTreeMaxEntries", 4, (Integer)Short.MAX_VALUE, 128, false, false);
    public static final IntConfigParam TREE_MAX_EMBEDDED_LN = new IntConfigParam("je.tree.maxEmbeddedLN", 0, null, 16, false, false);
    private static final IntConfigParam BIN_MAX_DELTAS = new IntConfigParam("je.tree.maxDelta", 0, 100, 10, false, false);
    public static final IntConfigParam BIN_DELTA_PERCENT = new IntConfigParam("je.tree.binDelta", 0, 75, 25, false, false);
    public static final BooleanConfigParam BIN_DELTA_BLIND_OPS = new BooleanConfigParam("je.tree.binDeltaBlindOps", true, false, false);
    public static final BooleanConfigParam BIN_DELTA_BLIND_PUTS = new BooleanConfigParam("je.tree.binDeltaBlindPuts", true, false, false);
    public static final LongConfigParam MIN_TREE_MEMORY = new LongConfigParam("je.tree.minMemory", 51200L, null, 512000L, true, false);
    public static final IntConfigParam TREE_COMPACT_MAX_KEY_LENGTH = new IntConfigParam("je.tree.compactMaxKeyLength", 0, 255, 16, false, false);
    public static final DurationConfigParam COMPRESSOR_WAKEUP_INTERVAL = new DurationConfigParam("je.compressor.wakeupInterval", "1 s", "75 min", "5 s", false, false);
    public static final IntConfigParam COMPRESSOR_RETRY = new IntConfigParam("je.compressor.deadlockRetry", 0, Integer.MAX_VALUE, 3, false, false);
    public static final DurationConfigParam COMPRESSOR_LOCK_TIMEOUT = new DurationConfigParam("je.compressor.lockTimeout", null, "75 min", "500 ms", false, false);
    public static final LongConfigParam EVICTOR_EVICT_BYTES = new LongConfigParam("je.evictor.evictBytes", 1024L, null, 524288L, false, false);
    private static final IntConfigParam EVICTOR_USEMEM_FLOOR = new IntConfigParam("je.evictor.useMemoryFloor", 50, 100, 95, false, false);
    private static final IntConfigParam EVICTOR_NODE_SCAN_PERCENTAGE = new IntConfigParam("je.evictor.nodeScanPercentage", 1, 100, 10, false, false);
    private static final IntConfigParam EVICTOR_EVICTION_BATCH_PERCENTAGE = new IntConfigParam("je.evictor.evictionBatchPercentage", 1, 100, 10, false, false);
    private static final IntConfigParam EVICTOR_NODES_PER_SCAN = new IntConfigParam("je.evictor.nodesPerScan", 1, 1000, 10, false, false);
    public static final IntConfigParam EVICTOR_CRITICAL_PERCENTAGE = new IntConfigParam("je.evictor.criticalPercentage", 0, 1000, 0, false, false);
    private static final IntConfigParam EVICTOR_RETRY = new IntConfigParam("je.evictor.deadlockRetry", 0, Integer.MAX_VALUE, 3, false, false);
    private static final BooleanConfigParam EVICTOR_LRU_ONLY = new BooleanConfigParam("je.evictor.lruOnly", true, false, false);
    public static final BooleanConfigParam EVICTOR_USE_DIRTY_LRU = new BooleanConfigParam("je.evictor.useDirtyLRU", true, false, false);
    public static final IntConfigParam EVICTOR_N_LRU_LISTS = new IntConfigParam("je.evictor.nLRULists", 1, 32, 4, false, false);
    public static final BooleanConfigParam EVICTOR_FORCED_YIELD = new BooleanConfigParam("je.evictor.forcedYield", false, false, false);
    public static final LongConfigParam MAX_OFF_HEAP_MEMORY = new LongConfigParam("je.maxOffHeapMemory", 0L, null, 0L, true, false);
    public static final LongConfigParam OFFHEAP_EVICT_BYTES = new LongConfigParam("je.offHeap.evictBytes", 1024L, null, 0x3200000L, false, false);
    public static final BooleanConfigParam OFFHEAP_CHECKSUM = new BooleanConfigParam("je.offHeap.checksum", false, false, false);
    public static final BooleanConfigParam ENV_RUN_OFFHEAP_EVICTOR = new BooleanConfigParam("je.env.runOffHeapEvictor", true, true, false);
    public static final BooleanConfigParam ENV_EXPIRATION_ENABLED = new BooleanConfigParam("je.env.expirationEnabled", true, true, false);
    public static final IntConfigParam OFFHEAP_CORE_THREADS = new IntConfigParam("je.offHeap.coreThreads", 0, Integer.MAX_VALUE, 1, true, false);
    public static final IntConfigParam OFFHEAP_MAX_THREADS = new IntConfigParam("je.offHeap.maxThreads", 1, Integer.MAX_VALUE, 3, true, false);
    public static final DurationConfigParam OFFHEAP_KEEP_ALIVE = new DurationConfigParam("je.offHeap.keepAlive", "1 s", "24 h", "10 min", true, false);
    public static final IntConfigParam OFFHEAP_N_LRU_LISTS = new IntConfigParam("je.evictor.nLRULists", 1, 32, 4, false, false);
    public static final LongConfigParam CHECKPOINTER_BYTES_INTERVAL = new LongConfigParam("je.checkpointer.bytesInterval", 0L, Long.MAX_VALUE, 20000000L, false, false);
    public static final DurationConfigParam CHECKPOINTER_WAKEUP_INTERVAL = new DurationConfigParam("je.checkpointer.wakeupInterval", "1 s", "75 min", "0", false, false);
    public static final IntConfigParam CHECKPOINTER_RETRY = new IntConfigParam("je.checkpointer.deadlockRetry", 0, Integer.MAX_VALUE, 3, false, false);
    public static final BooleanConfigParam CHECKPOINTER_HIGH_PRIORITY = new BooleanConfigParam("je.checkpointer.highPriority", false, true, false);
    public static final IntConfigParam CLEANER_MIN_UTILIZATION = new IntConfigParam("je.cleaner.minUtilization", 0, 90, 50, true, false);
    public static final IntConfigParam CLEANER_MIN_FILE_UTILIZATION = new IntConfigParam("je.cleaner.minFileUtilization", 0, 50, 5, true, false);
    public static final LongConfigParam CLEANER_BYTES_INTERVAL = new LongConfigParam("je.cleaner.bytesInterval", 0L, Long.MAX_VALUE, 0L, true, false);
    public static final BooleanConfigParam CLEANER_FETCH_OBSOLETE_SIZE = new BooleanConfigParam("je.cleaner.fetchObsoleteSize", false, true, false);
    private static final BooleanConfigParam CLEANER_ADJUST_UTILIZATION = new BooleanConfigParam("je.cleaner.adjustUtilization", false, true, false);
    public static final IntConfigParam CLEANER_DEADLOCK_RETRY = new IntConfigParam("je.cleaner.deadlockRetry", 0, Integer.MAX_VALUE, 3, true, false);
    public static final DurationConfigParam CLEANER_LOCK_TIMEOUT = new DurationConfigParam("je.cleaner.lockTimeout", "0", "75 min", "500 ms", true, false);
    public static final BooleanConfigParam CLEANER_REMOVE = new BooleanConfigParam("je.cleaner.expunge", true, true, false);
    public static final BooleanConfigParam CLEANER_USE_DELETED_DIR = new BooleanConfigParam("je.cleaner.useDeletedDir", false, true, false);
    private static final IntConfigParam CLEANER_MIN_FILES_TO_DELETE = new IntConfigParam("je.cleaner.minFilesToDelete", 1, 1000000, 5, false, false);
    private static final IntConfigParam CLEANER_RETRIES = new IntConfigParam("je.cleaner.retries", 0, 1000, 10, false, false);
    private static final IntConfigParam CLEANER_RESTART_RETRIES = new IntConfigParam("je.cleaner.restartRetries", 0, 1000, 5, false, false);
    public static final IntConfigParam CLEANER_MIN_AGE = new IntConfigParam("je.cleaner.minAge", 1, 1000, 2, true, false);
    private final IntConfigParam CLEANER_CALC_RECENT_LN_SIZES = new IntConfigParam("je.cleaner.calc.recentLNSizes", 1, 100, 10, false, false);
    private static final IntConfigParam CLEANER_CALC_MIN_UNCOUNTED_LNS = new IntConfigParam("je.cleaner.calc.minUncountedLNs", 0, 1000000, 1000, false, false);
    private static final IntConfigParam CLEANER_CALC_INITIAL_ADJUSTMENTS = new IntConfigParam("je.cleaner.calc.initialAdjustments", 1, 100, 5, false, false);
    private static final IntConfigParam CLEANER_CALC_MIN_PROBE_SKIP_FILES = new IntConfigParam("je.cleaner.calc.minProbeSkipFiles", 1, 100, 5, false, false);
    private static final IntConfigParam CLEANER_CALC_MAX_PROBE_SKIP_FILES = new IntConfigParam("je.cleaner.calc.maxProbeSkipFiles", 1, 100, 20, false, false);
    private static final BooleanConfigParam CLEANER_CLUSTER = new BooleanConfigParam("je.cleaner.cluster", false, true, false);
    private static final BooleanConfigParam CLEANER_CLUSTER_ALL = new BooleanConfigParam("je.cleaner.clusterAll", false, true, false);
    public static final IntConfigParam CLEANER_MAX_BATCH_FILES = new IntConfigParam("je.cleaner.maxBatchFiles", 0, 100000, 0, true, false);
    public static final IntConfigParam CLEANER_READ_SIZE = new IntConfigParam("je.cleaner.readSize", 128, null, 0, true, false);
    public static final DurationConfigParam DOS_PRODUCER_QUEUE_TIMEOUT = new DurationConfigParam("je.env.diskOrderedScanLockTimeout", "0", "75 min", "10 seconds", true, false);
    public static final BooleanConfigParam CLEANER_TRACK_DETAIL = new BooleanConfigParam("je.cleaner.trackDetail", true, false, false);
    public static final BooleanConfigParam CLEANER_GRADUAL_EXPIRATION = new BooleanConfigParam("je.cleaner.gradualExpiration", true, true, false);
    public static final IntConfigParam CLEANER_TWO_PASS_GAP = new IntConfigParam("je.cleaner.twoPassGap", 1, 100, 10, true, false);
    public static final IntConfigParam CLEANER_TWO_PASS_THRESHOLD = new IntConfigParam("je.cleaner.twoPassThreshold", 0, 100, 0, true, false);
    public static final IntConfigParam CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE = new IntConfigParam("je.cleaner.detailMaxMemoryPercentage", 1, 90, 2, true, false);
    public static final BooleanConfigParam CLEANER_RMW_FIX = new BooleanConfigParam("je.cleaner.rmwFix", true, false, false);
    public static final ConfigParam CLEANER_FORCE_CLEAN_FILES = new ConfigParam("je.cleaner.forceCleanFiles", "", false, false);
    public static final IntConfigParam CLEANER_UPGRADE_TO_LOG_VERSION = new IntConfigParam("je.cleaner.upgradeToLogVersion", -1, null, 0, false, false);
    public static final IntConfigParam CLEANER_THREADS = new IntConfigParam("je.cleaner.threads", 1, null, 1, true, false);
    public static final IntConfigParam CLEANER_LOOK_AHEAD_CACHE_SIZE = new IntConfigParam("je.cleaner.lookAheadCacheSize", 0, null, 8192, true, false);
    private static final BooleanConfigParam CLEANER_FOREGROUND_PROACTIVE_MIGRATION = new BooleanConfigParam("je.cleaner.foregroundProactiveMigration", false, true, false);
    public static final BooleanConfigParam CLEANER_BACKGROUND_PROACTIVE_MIGRATION = new BooleanConfigParam("je.cleaner.backgroundProactiveMigration", false, true, false);
    private static final BooleanConfigParam CLEANER_LAZY_MIGRATION = new BooleanConfigParam("je.cleaner.lazyMigration", false, true, false);
    public static final IntConfigParam ENV_DB_CACHE_CLEAR_COUNT = new IntConfigParam("je.env.dbCacheClearCount", 1, null, 100, true, false);
    public static final IntConfigParam N_LOCK_TABLES = new IntConfigParam("je.lock.nLockTables", 1, (Integer)Short.MAX_VALUE, 1, false, false);
    public static final DurationConfigParam LOCK_TIMEOUT = new DurationConfigParam("je.lock.timeout", null, "75 min", "500 ms", false, false);
    public static final BooleanConfigParam LOCK_OLD_LOCK_EXCEPTIONS = new BooleanConfigParam("je.lock.oldLockExceptions", false, false, false);
    public static final DurationConfigParam TXN_TIMEOUT = new DurationConfigParam("je.txn.timeout", null, "75 min", "0", false, false);
    public static final BooleanConfigParam TXN_SERIALIZABLE_ISOLATION = new BooleanConfigParam("je.txn.serializableIsolation", false, false, false);
    public static final BooleanConfigParam TXN_DEADLOCK_STACK_TRACE = new BooleanConfigParam("je.txn.deadlockStackTrace", false, true, false);
    public static final BooleanConfigParam TXN_DUMPLOCKS = new BooleanConfigParam("je.txn.dumpLocks", false, true, false);
    public static final BooleanConfigParam JE_LOGGING_DBLOG = new BooleanConfigParam("je.env.logTrace", true, false, false);
    public static final ConfigParam JE_CONSOLE_LEVEL = new ConfigParam("com.sleepycat.je.util.ConsoleHandler.level", "OFF", true, false){

        @Override
        public void validateValue(String level) throws NullPointerException, IllegalArgumentException {
            Level.parse(level);
        }
    };
    public static final ConfigParam JE_FILE_LEVEL = new ConfigParam("com.sleepycat.je.util.FileHandler.level", "INFO", true, false){

        @Override
        public void validateValue(String level) throws NullPointerException, IllegalArgumentException {
            Level.parse(level);
        }
    };
    public static final ConfigParam JE_DURABILITY = new ConfigParam("je.txn.durability", null, true, false){

        @Override
        public void validateValue(String durabilityString) throws IllegalArgumentException {
            Durability.parse(durabilityString);
        }
    };
    public static final DurationConfigParam STARTUP_DUMP_THRESHOLD = new DurationConfigParam("je.env.startupThreshold", "0", null, "5 min", false, false);
    public static final BooleanConfigParam STATS_COLLECT = new BooleanConfigParam("je.stats.collect", true, true, false);
    public static final IntConfigParam STATS_FILE_ROW_COUNT = new IntConfigParam("je.stats.file.row.count", 2, Integer.MAX_VALUE, 1440, true, false);
    public static final IntConfigParam STATS_MAX_FILES = new IntConfigParam("je.stats.max.files", 1, Integer.MAX_VALUE, 10, true, false);
    public static final DurationConfigParam STATS_COLLECT_INTERVAL = new DurationConfigParam("je.stats.collect.interval", "1 s", null, "1 min", true, false);
    public static final ConfigParam STATS_FILE_DIRECTORY = new ConfigParam("je.stats.file.directory", "", false, false);

    public static void addSupportedParam(ConfigParam param) {
        SUPPORTED_PARAMS.put(param.getName(), param);
    }
}

