/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogSource;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

class FileSource
implements LogSource {
    private final RandomAccessFile file;
    private final int readBufferSize;
    private final FileManager fileManager;
    private final long fileNum;
    private final int logVersion;

    FileSource(RandomAccessFile file, int readBufferSize, FileManager fileManager, long fileNum, int logVersion) {
        this.file = file;
        this.readBufferSize = readBufferSize;
        this.fileManager = fileManager;
        this.fileNum = fileNum;
        this.logVersion = logVersion;
    }

    @Override
    public void release() throws DatabaseException {
    }

    @Override
    public ByteBuffer getBytes(long fileOffset) throws DatabaseException {
        ByteBuffer destBuf = ByteBuffer.allocate(this.readBufferSize);
        this.fileManager.readFromFile(this.file, destBuf, fileOffset, this.fileNum);
        assert (EnvironmentImpl.maybeForceYield());
        destBuf.flip();
        return destBuf;
    }

    @Override
    public ByteBuffer getBytes(long fileOffset, int numBytes) throws ChecksumException, DatabaseException {
        ByteBuffer destBuf = ByteBuffer.allocate(numBytes);
        this.fileManager.readFromFile(this.file, destBuf, fileOffset, this.fileNum);
        assert (EnvironmentImpl.maybeForceYield());
        destBuf.flip();
        if (destBuf.remaining() < numBytes) {
            throw new ChecksumException("Entry is incomplete in file, lsn=0x" + Long.toHexString(this.fileNum) + "/" + Long.toHexString(fileOffset) + " expectedLen=" + numBytes + " remainingInBuffer=" + destBuf.remaining());
        }
        return destBuf;
    }

    @Override
    public int getLogVersion() {
        return this.logVersion;
    }
}

