/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.VLSN;
import java.util.Set;

public class InsufficientLogException
extends RestartRequiredException {
    private static final long serialVersionUID = 1L;
    private final transient RepNode repNode;
    private final VLSN refreshVLSN;
    private final Set<ReplicationNode> logProviders;

    public InsufficientLogException(RepNode repNode, VLSN refreshVLSN, Set<ReplicationNode> logProviders) {
        super(repNode.getRepImpl(), EnvironmentFailureReason.INSUFFICIENT_LOG);
        this.repNode = repNode;
        this.refreshVLSN = refreshVLSN;
        this.logProviders = logProviders;
    }

    public InsufficientLogException(RepImpl repImpl, VLSN refreshVLSN) {
        super(repImpl, EnvironmentFailureReason.INSUFFICIENT_LOG);
        this.repNode = null;
        this.refreshVLSN = refreshVLSN;
        this.logProviders = null;
    }

    public InsufficientLogException(String message) {
        super(null, EnvironmentFailureReason.UNEXPECTED_STATE, message);
        this.repNode = null;
        this.refreshVLSN = null;
        this.logProviders = null;
    }

    private InsufficientLogException(String message, InsufficientLogException cause) {
        super(message, cause);
        this.repNode = cause.getRepNode();
        this.refreshVLSN = cause.getRefreshVLSN();
        this.logProviders = cause.getLogProviders();
    }

    @Override
    public EnvironmentFailureException wrapSelf(String msg) {
        return new InsufficientLogException(msg, this);
    }

    public VLSN getRefreshVLSN() {
        return this.refreshVLSN;
    }

    public Set<ReplicationNode> getLogProviders() {
        return this.logProviders;
    }

    public RepNode getRepNode() {
        return this.repNode;
    }
}

