/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.arbiter.ArbiterMutableConfig;
import com.sleepycat.je.rep.impl.RepParams;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;

public class ArbiterConfig
extends ArbiterMutableConfig
implements Cloneable {
    private String arbiterHome;
    private ReplicationNetworkConfig repNetConfig = ReplicationNetworkConfig.createDefault();
    private Handler loggingHandler;

    public ArbiterConfig() {
    }

    public ArbiterConfig(Properties props) {
        super(props);
    }

    public String getArbiterHome() {
        return this.arbiterHome;
    }

    public void setArbiterHome(String arbiterHome) {
        this.arbiterHome = arbiterHome;
    }

    public ArbiterConfig setNodeName(String nodeName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.NODE_NAME, nodeName, this.validateParams);
        return this;
    }

    public String getNodeName() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_NAME);
    }

    public ArbiterConfig setGroupName(String groupName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.GROUP_NAME, groupName, this.validateParams);
        return this;
    }

    public String getGroupName() {
        return DbConfigManager.getVal(this.props, RepParams.GROUP_NAME);
    }

    public ArbiterConfig setNodeHostPort(String hostPort) {
        DbConfigManager.setVal(this.props, RepParams.NODE_HOST_PORT, hostPort, this.validateParams);
        return this;
    }

    public String getNodeHostPort() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
    }

    public ArbiterConfig setUnknownStateTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.ENV_UNKNOWN_STATE_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public long getUnknownStateTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.ENV_UNKNOWN_STATE_TIMEOUT, unit);
    }

    public ArbiterConfig setHeartbeatInterval(int millis) {
        DbConfigManager.setIntVal(this.props, RepParams.HEARTBEAT_INTERVAL, millis, this.validateParams);
        return this;
    }

    public int getHeartbeatInterval() {
        return DbConfigManager.getIntVal(this.props, RepParams.HEARTBEAT_INTERVAL);
    }

    public ArbiterConfig setEnableGroupAcks(boolean val) {
        DbConfigManager.setBooleanVal(this.props, RepParams.ENABLE_GROUP_ACKS, val, this.validateParams);
        return this;
    }

    public boolean getEnableGroupAcks() {
        return DbConfigManager.getBooleanVal(this.props, RepParams.ENABLE_GROUP_ACKS);
    }

    public ArbiterConfig setMessageQueueSize(int val) {
        DbConfigManager.setIntVal(this.props, RepParams.REPLICA_MESSAGE_QUEUE_SIZE, val, this.validateParams);
        return this;
    }

    public int getMessageQueueSize() {
        return DbConfigManager.getIntVal(this.props, RepParams.REPLICA_MESSAGE_QUEUE_SIZE);
    }

    public ArbiterConfig setChannelTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.REPLICA_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public long getChannelTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.REPLICA_TIMEOUT, unit);
    }

    public ArbiterConfig setPreHeartbeatTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.PRE_HEARTBEAT_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public long getPreHeartbeatTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.PRE_HEARTBEAT_TIMEOUT, unit);
    }

    public ArbiterConfig setFeederTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.FEEDER_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public long getFeederTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.FEEDER_TIMEOUT, unit);
    }

    public ArbiterConfig setReceiveBufferSize(int val) {
        DbConfigManager.setIntVal(this.props, RepParams.REPLICA_RECEIVE_BUFFER_SIZE, val, this.validateParams);
        return this;
    }

    public int getReceiveBufferSize() {
        return DbConfigManager.getIntVal(this.props, RepParams.REPLICA_RECEIVE_BUFFER_SIZE);
    }

    public ArbiterConfig setStreamOpenTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.REPSTREAM_OPEN_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public long getStreamOpenTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, RepParams.REPSTREAM_OPEN_TIMEOUT, unit);
    }

    public ReplicationNetworkConfig getRepNetConfig() {
        return this.repNetConfig;
    }

    public ArbiterConfig setRepNetConfig(ReplicationNetworkConfig netConfig) {
        this.setRepNetConfigVoid(netConfig);
        return this;
    }

    @Override
    public ArbiterConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        boolean forReplication = false;
        ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param != null) {
            forReplication = param.isForReplication();
        }
        DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, forReplication, true);
        return this;
    }

    public void setRepNetConfigVoid(ReplicationNetworkConfig netConfig) {
        if (netConfig == null) {
            throw new IllegalArgumentException("netConfig may not be null");
        }
        this.repNetConfig = netConfig;
    }

    ArbiterMutableConfig getArbiterMutableConfig() {
        return super.copy();
    }

    @Override
    public ArbiterConfig clone() {
        ArbiterConfig retval = (ArbiterConfig)super.clone();
        retval.repNetConfig = this.repNetConfig.clone();
        retval.arbiterHome = this.arbiterHome;
        return retval;
    }

    public ArbiterConfig setLoggingHandler(Handler handler) {
        this.loggingHandler = handler;
        return this;
    }

    public Handler getLoggingHandler() {
        return this.loggingHandler;
    }

    @Override
    public String toString() {
        return "arbiterHome=" + this.arbiterHome + "\n" + "repNetConfig=" + this.repNetConfig + "\n" + super.toString();
    }
}

