/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.subscription;

import com.sleepycat.je.rep.GroupShutdownException;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.subscription.SubscriptionConfig;
import com.sleepycat.je.rep.subscription.SubscriptionStat;
import com.sleepycat.je.rep.subscription.SubscriptionStatus;
import com.sleepycat.je.rep.subscription.SubscriptionThread;
import com.sleepycat.je.utilint.InternalException;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.PollCondition;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class Subscription {
    private final SubscriptionConfig configuration;
    private final Logger logger;
    private final ReplicatedEnvironment dummyRepEnv;
    private final SubscriptionStat statistics;
    private SubscriptionThread subscriptionThread;

    public Subscription(SubscriptionConfig configuration, Logger logger) throws IllegalArgumentException {
        this.configuration = configuration;
        this.logger = logger;
        this.dummyRepEnv = this.createDummyRepEnv(configuration);
        this.subscriptionThread = null;
        this.statistics = new SubscriptionStat();
    }

    public void start() throws IllegalArgumentException, InsufficientLogException, GroupShutdownException, InternalException, TimeoutException {
        this.start(VLSN.FIRST_VLSN);
    }

    public void start(VLSN vlsn) throws IllegalArgumentException, InsufficientLogException, GroupShutdownException, InternalException, TimeoutException {
        if (vlsn.equals(VLSN.NULL_VLSN)) {
            throw new IllegalArgumentException("Start VLSN cannot be null");
        }
        this.subscriptionThread = new SubscriptionThread(this.dummyRepEnv, vlsn, this.configuration, this.statistics, this.logger);
        this.subscriptionThread.start();
        if (!this.waitForSubscriptionInitDone(this.subscriptionThread)) {
            LoggerUtils.warning(this.logger, RepInternal.getRepImpl(this.dummyRepEnv), "Timeout in initialization, shut down subscription.");
            this.shutdown();
            throw new TimeoutException("Subscription initialization timeout after " + this.configuration.getPollTimeoutMs() + " ms");
        }
        Exception exp = this.subscriptionThread.getStoredException();
        switch (this.subscriptionThread.getStatus()) {
            case SUCCESS: {
                break;
            }
            case VLSN_NOT_AVAILABLE: {
                throw (InsufficientLogException)exp;
            }
            case GRP_SHUTDOWN: {
                throw (GroupShutdownException)exp;
            }
            default: {
                throw new InternalException("internal exception from subscription thread", exp);
            }
        }
    }

    public void shutdown() {
        if (this.subscriptionThread != null && this.subscriptionThread.isAlive()) {
            this.subscriptionThread.shutdown();
        }
        this.subscriptionThread = null;
        if (this.dummyRepEnv != null) {
            this.dummyRepEnv.close();
        }
    }

    public SubscriptionStatus getSubscriptionStatus() {
        if (this.subscriptionThread == null) {
            return SubscriptionStatus.INIT;
        }
        return this.subscriptionThread.getStatus();
    }

    public SubscriptionStat getStatistics() {
        return this.statistics;
    }

    ReplicatedEnvironment getDummyRepEnv() {
        return this.dummyRepEnv;
    }

    void setExceptionHandlingTestHook(TestHook<SubscriptionThread> testHook) {
        if (this.subscriptionThread != null) {
            this.subscriptionThread.setExceptionHandlingTestHook(testHook);
        }
    }

    private ReplicatedEnvironment createDummyRepEnv(SubscriptionConfig config) throws IllegalArgumentException {
        File envHome = new File(config.getSubscriberHome());
        if (!envHome.exists()) {
            throw new IllegalArgumentException("Env directory " + envHome.getAbsolutePath() + " does not exist.");
        }
        return RepInternal.createInternalEnvHandle(envHome, this.configuration.createReplicationConfig(), this.configuration.createEnvConfig());
    }

    private boolean waitForSubscriptionInitDone(final SubscriptionThread t) {
        return new PollCondition(this.configuration.getPollIntervalMs(), this.configuration.getPollTimeoutMs()){

            @Override
            protected boolean condition() {
                return t.getStatus() != SubscriptionStatus.INIT;
            }
        }.await();
    }
}

