/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.statcap.StatCaptureDefinitions;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMinStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StatManager {
    protected final Map<Integer, StatContext> statContextMap = new HashMap<Integer, StatContext>();
    private final UpdateMinMax updateMinMaxStat = new UpdateMinMax(StatCaptureDefinitions.minStats, StatCaptureDefinitions.maxStats);
    protected final EnvironmentImpl env;

    public StatManager(EnvironmentImpl env) {
        this.env = env;
    }

    public synchronized Integer registerStatContext() {
        StatContext sctx = new StatContext(null);
        int max = 0;
        for (Integer key : this.statContextMap.keySet()) {
            if (key <= max) continue;
            max = key;
        }
        Integer newkey = new Integer(max + 1);
        this.statContextMap.put(newkey, sctx);
        return newkey;
    }

    public synchronized void unregisterStatContext(Integer key) {
        this.statContextMap.remove(key);
    }

    public synchronized EnvironmentStats loadStats(StatsConfig config, Integer contextKey) {
        StatContext sc = this.statContextMap.get(contextKey);
        if (sc == null) {
            throw EnvironmentFailureException.unexpectedState("Internal error stat context is not registered");
        }
        EnvironmentStats curstats = this.env.loadStatsInternal(config);
        Map<String, StatGroup> cur = curstats.getStatGroupsMap();
        Map<String, StatGroup> base = sc.getBase();
        EnvironmentStats intervalStats = base != null ? this.computeIntervalStats(cur, base) : curstats;
        if (config.getClear()) {
            for (StatContext context : this.statContextMap.values()) {
                if (context.getBase() == null) continue;
                this.updateMinMaxStat.updateBase(context.getBase(), cur);
            }
            for (StatContext context : this.statContextMap.values()) {
                if (context == sc) {
                    context.setBase(null);
                    continue;
                }
                if (context.getBase() == null) {
                    context.setBase(this.cloneAndNegate(cur));
                    continue;
                }
                context.setBase(this.computeIntervalStats(context.getBase(), cur).getStatGroupsMap());
            }
        }
        return intervalStats;
    }

    private EnvironmentStats computeIntervalStats(Map<String, StatGroup> current, Map<String, StatGroup> base) {
        EnvironmentStats envStats = new EnvironmentStats();
        for (StatGroup cg : current.values()) {
            StatGroup bg = base.get(cg.getName());
            envStats.setStatGroup(cg.computeInterval(bg));
        }
        return envStats;
    }

    protected Map<String, StatGroup> cloneAndNegate(Map<String, StatGroup> in) {
        HashMap<String, StatGroup> retval = new HashMap<String, StatGroup>();
        for (Map.Entry<String, StatGroup> e : in.entrySet()) {
            StatGroup negatedGroup = e.getValue().cloneGroup(false);
            negatedGroup.negate();
            retval.put(e.getKey(), negatedGroup);
        }
        return retval;
    }

    public class UpdateMinMax {
        private final ArrayList<SDef> minStats = new ArrayList();
        private final ArrayList<SDef> maxStats = new ArrayList();

        public UpdateMinMax(SDef[] minStatistics, SDef[] maxStatistics) {
            for (SDef min : minStatistics) {
                this.minStats.add(min);
            }
            for (SDef max : maxStatistics) {
                this.maxStats.add(max);
            }
        }

        public void updateBase(Map<String, StatGroup> base, Map<String, StatGroup> other) {
            StatGroup sg;
            LongStat baseStat;
            LongStat otherValue;
            StatGroup group;
            for (SDef sd : this.minStats) {
                group = other.get(sd.groupName);
                if (group == null || (otherValue = group.getLongStat(sd.definition)) == null) continue;
                baseStat = base.get(sd.groupName).getLongMinStat(sd.definition);
                if (baseStat == null) {
                    sg = base.get(sd.groupName);
                    baseStat = (LongMinStat)otherValue.copyAndAdd(sg);
                }
                ((LongMinStat)baseStat).setMin(otherValue.get());
            }
            for (SDef sd : this.maxStats) {
                group = other.get(sd.groupName);
                if (group == null || (otherValue = group.getLongStat(sd.definition)) == null) continue;
                baseStat = base.get(sd.groupName).getLongMaxStat(sd.definition);
                if (baseStat == null) {
                    sg = base.get(sd.groupName);
                    baseStat = (LongMaxStat)otherValue.copyAndAdd(sg);
                }
                ((LongMaxStat)baseStat).setMax(otherValue.get());
            }
        }
    }

    public static class SDef {
        private final String groupName;
        private final StatDefinition definition;

        public SDef(String groupname, StatDefinition sd) {
            this.definition = sd;
            this.groupName = groupname;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public StatDefinition getDefinition() {
            return this.definition;
        }
    }

    protected class StatContext {
        private Map<String, StatGroup> base;
        private Map<String, StatGroup> repbase = null;

        StatContext(Map<String, StatGroup> base) {
            this.base = base;
        }

        void setBase(Map<String, StatGroup> base) {
            this.base = base;
        }

        Map<String, StatGroup> getBase() {
            return this.base;
        }

        public void setRepBase(Map<String, StatGroup> base) {
            this.repbase = base;
        }

        public Map<String, StatGroup> getRepBase() {
            return this.repbase;
        }
    }
}

