/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.StatGroup;
import java.util.List;
import java.util.Set;

public class DummyLockManager
extends LockManager {
    private final LockManager superiorLockManager;

    public DummyLockManager(EnvironmentImpl envImpl, LockManager superiorLockManager) {
        super(envImpl);
        this.superiorLockManager = superiorLockManager;
    }

    @Override
    public Set<LockInfo> getOwners(Long lsn) {
        return this.superiorLockManager.getOwners(lsn);
    }

    @Override
    public List<LockInfo> getWaiters(Long lsn) {
        return this.superiorLockManager.getWaiters(lsn);
    }

    @Override
    public LockType getOwnedLockType(Long lsn, Locker locker) {
        return this.superiorLockManager.getOwnedLockType(lsn, locker);
    }

    @Override
    public boolean isLockUncontended(Long lsn) {
        return this.superiorLockManager.isLockUncontended(lsn);
    }

    @Override
    public boolean ownsOrSharesLock(Locker locker, Long lsn) {
        return this.superiorLockManager.ownsOrSharesLock(locker, lsn);
    }

    @Override
    Lock lookupLock(Long lsn) throws DatabaseException {
        Lock ret = this.superiorLockManager.lookupLock(lsn);
        return ret;
    }

    @Override
    LockAttemptResult attemptLock(Long lsn, Locker locker, LockType type, boolean nonBlockingRequest, boolean jumpAheadOfWaiters) throws DatabaseException {
        if (locker.lockingRequired()) {
            return this.superiorLockManager.attemptLock(lsn, locker, type, nonBlockingRequest, jumpAheadOfWaiters);
        }
        return new LockAttemptResult(null, LockGrantType.NEW, true);
    }

    @Override
    LockManager.TimeoutInfo getTimeoutInfo(boolean isLockNotTxnTimeout, Locker locker, long lsn, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database, Set<LockInfo> owners, List<LockInfo> waiters) throws DatabaseException {
        if (locker.lockingRequired()) {
            return this.superiorLockManager.getTimeoutInfo(isLockNotTxnTimeout, locker, lsn, type, grantType, useLock, timeout, start, now, database, owners, waiters);
        }
        return null;
    }

    @Override
    Set<Locker> releaseAndFindNotifyTargets(long lsn, Locker locker) throws DatabaseException {
        return this.superiorLockManager.releaseAndFindNotifyTargets(lsn, locker);
    }

    @Override
    void demote(long lsn, Locker locker) throws DatabaseException {
        if (!locker.lockingRequired()) {
            return;
        }
        this.superiorLockManager.demote(lsn, locker);
    }

    @Override
    boolean isLocked(Long lsn) throws DatabaseException {
        return this.superiorLockManager.isLocked(lsn);
    }

    @Override
    boolean isOwner(Long lsn, Locker locker, LockType type) throws DatabaseException {
        return this.superiorLockManager.isOwner(lsn, locker, type);
    }

    @Override
    boolean isWaiter(Long lsn, Locker locker) throws DatabaseException {
        return this.superiorLockManager.isWaiter(lsn, locker);
    }

    @Override
    int nWaiters(Long lsn) throws DatabaseException {
        return this.superiorLockManager.nWaiters(lsn);
    }

    @Override
    int nOwners(Long lsn) throws DatabaseException {
        return this.superiorLockManager.nOwners(lsn);
    }

    @Override
    Locker getWriteOwnerLocker(Long lsn) throws DatabaseException {
        return this.superiorLockManager.getWriteOwnerLocker(lsn);
    }

    @Override
    boolean validateOwnership(Long lsn, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb, Set<LockInfo> owners, List<LockInfo> waiters) throws DatabaseException {
        if (locker.lockingRequired()) {
            return this.superiorLockManager.validateOwnership(lsn, locker, type, flushFromWaiters, mb, owners, waiters);
        }
        return true;
    }

    @Override
    public LockAttemptResult stealLock(Long lsn, Locker locker, LockType lockType) throws DatabaseException {
        if (locker.lockingRequired()) {
            return this.superiorLockManager.stealLock(lsn, locker, lockType);
        }
        return null;
    }

    @Override
    void dumpLockTable(StatGroup stats, boolean clear) throws DatabaseException {
        this.superiorLockManager.dumpLockTable(stats, clear);
    }
}

