/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.VLSN;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class FileSelector {
    private SortedMap<Long, FileInfo> fileInfoMap = new TreeMap<Long, FileInfo>();
    private Map<Long, LNInfo> pendingLNs = new HashMap<Long, LNInfo>();
    private Set<DatabaseId> pendingDBs = new HashSet<DatabaseId>();
    private boolean anyPendingDuringCheckpoint;

    FileSelector() {
    }

    synchronized Pair<Long, Integer> selectFileForCleaning(UtilizationCalculator calculator, SortedMap<Long, FileSummary> fileSummaryMap, boolean forceCleaning) {
        Set<Long> toBeCleaned = this.getToBeCleanedFiles();
        if (!toBeCleaned.isEmpty()) {
            Long fileNum = toBeCleaned.iterator().next();
            FileInfo info = this.setStatus(fileNum, FileStatus.BEING_CLEANED);
            return new Pair<Long, Integer>(fileNum, info.requiredUtil);
        }
        Pair<Long, Integer> result = calculator.getBestFile(fileSummaryMap, forceCleaning);
        if (result == null) {
            return null;
        }
        Long fileNum = result.first();
        int requiredUtil = result.second();
        assert (!this.fileInfoMap.containsKey(fileNum));
        FileInfo info = this.setStatus(fileNum, FileStatus.BEING_CLEANED);
        info.requiredUtil = requiredUtil;
        return result;
    }

    private synchronized int getNumberOfFiles(FileStatus status) {
        int count = 0;
        for (FileInfo info : this.fileInfoMap.values()) {
            if (info.status != status) continue;
            ++count;
        }
        return count;
    }

    private synchronized NavigableSet<Long> getFiles(FileStatus status) {
        TreeSet<Long> set = new TreeSet<Long>();
        for (Map.Entry<Long, FileInfo> entry : this.fileInfoMap.entrySet()) {
            if (entry.getValue().status != status) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    private FileInfo setStatus(Long fileNum, FileStatus newStatus) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        if (info == null) {
            info = new FileInfo();
            this.fileInfoMap.put(fileNum, info);
        }
        info.status = newStatus;
        return info;
    }

    private void setStatus(Collection<Long> files, FileStatus newStatus) {
        for (Long fileNum : files) {
            this.setStatus(fileNum, newStatus);
        }
    }

    private void setStatus(FileStatus oldStatus, FileStatus newStatus) {
        for (FileInfo info : this.fileInfoMap.values()) {
            if (info.status != oldStatus) continue;
            info.status = newStatus;
        }
    }

    private boolean checkStatus(Long fileNum, FileStatus expectStatus) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        assert (info != null) : "Expected " + (Object)((Object)expectStatus) + " but was missing";
        assert (info.status == expectStatus) : "Expected " + (Object)((Object)expectStatus) + " but was " + (Object)((Object)FileInfo.access$100(info));
        return true;
    }

    private boolean checkStatus(Collection<Long> files, FileStatus expectStatus) {
        for (Long fileNum : files) {
            this.checkStatus(fileNum, expectStatus);
        }
        return true;
    }

    private synchronized boolean isFileCleaningInProgress(Long fileNum) {
        return this.fileInfoMap.containsKey(fileNum);
    }

    synchronized int getRequiredUtil(Long fileNum) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        return info != null ? info.requiredUtil : -1;
    }

    synchronized FileInfo removeFile(Long fileNum, MemoryBudget budget) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        if (info == null) {
            return null;
        }
        this.adjustMemoryBudget(budget, info.dbIds, null);
        this.fileInfoMap.remove(fileNum);
        return info;
    }

    synchronized void putBackFileForCleaning(Long fileNum) {
        assert (this.checkStatus(fileNum, FileStatus.BEING_CLEANED));
        this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
    }

    public synchronized void injectFileForCleaning(Long fileNum) {
        if (!this.isFileCleaningInProgress(fileNum)) {
            FileInfo info = this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
            info.requiredUtil = -1;
        }
    }

    synchronized void addCleanedFile(Long fileNum, Set<DatabaseId> databases, VLSN firstVlsn, VLSN lastVlsn, MemoryBudget budget) {
        assert (this.checkStatus(fileNum, FileStatus.BEING_CLEANED));
        FileInfo info = this.setStatus(fileNum, FileStatus.CLEANED);
        this.adjustMemoryBudget(budget, info.dbIds, databases);
        info.dbIds = databases;
        info.firstVlsn = firstVlsn;
        info.lastVlsn = lastVlsn;
    }

    synchronized Set<Long> getToBeCleanedFiles() {
        return this.getFiles(FileStatus.TO_BE_CLEANED);
    }

    synchronized CheckpointStartCleanerState getFilesAtCheckpointStart() {
        this.anyPendingDuringCheckpoint = !this.pendingLNs.isEmpty() || !this.pendingDBs.isEmpty();
        return new CheckpointStartCleanerState(this.getFiles(FileStatus.CLEANED), this.getFiles(FileStatus.FULLY_PROCESSED));
    }

    public synchronized boolean isCheckpointNeeded() {
        return this.getNumberOfFiles(FileStatus.CLEANED) > 0 || this.getNumberOfFiles(FileStatus.FULLY_PROCESSED) > 0;
    }

    synchronized Map<Long, FileInfo> updateFilesAtCheckpointEnd(EnvironmentImpl env, CheckpointStartCleanerState info) {
        if (info.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, FileInfo> reservedFiles = new HashMap<Long, FileInfo>();
        Set<Long> previouslyCleanedFiles = info.getCleanedFiles();
        Set<Long> previouslyProcessedFiles = info.getFullyProcessedFiles();
        if (previouslyCleanedFiles != null) {
            assert (this.checkStatus(previouslyCleanedFiles, FileStatus.CLEANED));
            if (this.anyPendingDuringCheckpoint) {
                this.setStatus(previouslyCleanedFiles, FileStatus.CHECKPOINTED);
            } else {
                this.makeReservedFiles(env, previouslyCleanedFiles, reservedFiles);
            }
        }
        if (previouslyProcessedFiles != null) {
            assert (this.checkStatus(previouslyProcessedFiles, FileStatus.FULLY_PROCESSED));
            this.makeReservedFiles(env, previouslyProcessedFiles, reservedFiles);
        }
        this.updateProcessedFiles();
        return reservedFiles;
    }

    private void makeReservedFiles(EnvironmentImpl env, Set<Long> safeToDeleteFiles, Map<Long, FileInfo> reservedFiles) {
        FileProtector fileProtector = env.getFileProtector();
        MemoryBudget memoryBudget = env.getMemoryBudget();
        for (Long file : safeToDeleteFiles) {
            FileInfo info = this.removeFile(file, memoryBudget);
            fileProtector.reserveFile(file, info.lastVlsn);
            reservedFiles.put(file, info);
        }
        env.getUtilizationProfile().removeFileSummaries(safeToDeleteFiles);
    }

    synchronized boolean addPendingLN(long logLsn, LNInfo info) {
        this.anyPendingDuringCheckpoint = true;
        return this.pendingLNs.put(logLsn, info) != null;
    }

    synchronized Map<Long, LNInfo> getPendingLNs() {
        if (this.pendingLNs.size() > 0) {
            return new HashMap<Long, LNInfo>(this.pendingLNs);
        }
        return null;
    }

    synchronized void removePendingLN(long originalLsn) {
        this.pendingLNs.remove(originalLsn);
        this.updateProcessedFiles();
    }

    synchronized int getPendingLNQueueSize() {
        return this.pendingLNs.size();
    }

    synchronized boolean addPendingDB(DatabaseId dbId) {
        boolean added = this.pendingDBs.add(dbId);
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized DatabaseId[] getPendingDBs() {
        if (this.pendingDBs.size() > 0) {
            DatabaseId[] dbs = new DatabaseId[this.pendingDBs.size()];
            this.pendingDBs.toArray(dbs);
            return dbs;
        }
        return null;
    }

    synchronized void removePendingDB(DatabaseId dbId) {
        this.pendingDBs.remove(dbId);
        this.updateProcessedFiles();
    }

    public synchronized NavigableSet<Long> getInProgressFiles() {
        return new TreeSet<Long>(this.fileInfoMap.keySet());
    }

    synchronized void close(MemoryBudget budget) {
        for (FileInfo info : this.fileInfoMap.values()) {
            this.adjustMemoryBudget(budget, info.dbIds, null);
        }
    }

    private void updateProcessedFiles() {
        if (this.pendingLNs.isEmpty() && this.pendingDBs.isEmpty()) {
            this.setStatus(FileStatus.CHECKPOINTED, FileStatus.FULLY_PROCESSED);
        }
    }

    private void adjustMemoryBudget(MemoryBudget budget, Set<DatabaseId> oldDatabases, Set<DatabaseId> newDatabases) {
        long adjustMem = 0L;
        if (oldDatabases != null) {
            adjustMem -= this.getCleanedFilesDatabaseEntrySize(oldDatabases);
        }
        if (newDatabases != null) {
            adjustMem += this.getCleanedFilesDatabaseEntrySize(newDatabases);
        }
        budget.updateAdminMemoryUsage(adjustMem);
    }

    private long getCleanedFilesDatabaseEntrySize(Set<DatabaseId> databases) {
        return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.HASHSET_OVERHEAD + databases.size() * MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    }

    public synchronized String toString() {
        return "files = " + this.fileInfoMap + " pendingLNs = " + this.pendingLNs + " pendingDBs = " + this.pendingDBs + " anyPendingDuringCheckpoint = " + this.anyPendingDuringCheckpoint;
    }

    public static class CheckpointStartCleanerState {
        private Set<Long> cleanedFiles;
        private Set<Long> fullyProcessedFiles;

        private CheckpointStartCleanerState(Set<Long> cleanedFiles, Set<Long> fullyProcessedFiles) {
            this.cleanedFiles = cleanedFiles;
            this.fullyProcessedFiles = fullyProcessedFiles;
        }

        public boolean isEmpty() {
            return this.cleanedFiles.size() == 0 && this.fullyProcessedFiles.size() == 0;
        }

        public Set<Long> getCleanedFiles() {
            return this.cleanedFiles;
        }

        public Set<Long> getFullyProcessedFiles() {
            return this.fullyProcessedFiles;
        }
    }

    static class FileInfo {
        private FileStatus status;
        private int requiredUtil = -1;
        Set<DatabaseId> dbIds;
        VLSN firstVlsn = VLSN.NULL_VLSN;
        VLSN lastVlsn = VLSN.NULL_VLSN;

        FileInfo() {
        }

        public String toString() {
            return "status = " + (Object)((Object)this.status) + " dbIds = " + this.dbIds + " firstVlsn = " + this.firstVlsn + " lastVlsn = " + this.lastVlsn;
        }
    }

    static enum FileStatus {
        TO_BE_CLEANED,
        BEING_CLEANED,
        CLEANED,
        CHECKPOINTED,
        FULLY_PROCESSED;

    }
}

