/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.LN;

public enum DbType {
    ID("_jeIdMap"){

        @Override
        public boolean mayCreateDeletedLN() {
            return false;
        }

        @Override
        public LN createDeletedLN(EnvironmentImpl envImpl) {
            throw EnvironmentFailureException.unexpectedState();
        }

        @Override
        public boolean mayCreateUpdatedLN() {
            return false;
        }

        @Override
        public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }
    ,
    NAME("_jeNameMap"){

        @Override
        public boolean mayCreateDeletedLN() {
            return false;
        }

        @Override
        public LN createDeletedLN(EnvironmentImpl envImpl) {
            throw EnvironmentFailureException.unexpectedState();
        }

        @Override
        public boolean mayCreateUpdatedLN() {
            return false;
        }

        @Override
        public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }
    ,
    UTILIZATION("_jeUtilization"){

        @Override
        public LN createDeletedLN(EnvironmentImpl envImpl) {
            return FileSummaryLN.makeDeletedLN();
        }

        @Override
        public boolean mayCreateUpdatedLN() {
            return false;
        }

        @Override
        public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
            throw EnvironmentFailureException.unexpectedState();
        }
    }
    ,
    EXPIRATION("_jeExpiration"),
    REP_GROUP("_jeRepGroupDB"),
    VLSN_MAP("_jeVlsnMapDb"),
    SYNC("_jeSyncDb"),
    RESERVED_FILES("_jeReservedFilesDb"){

        @Override
        public LogEntryType getLogType() {
            return LogEntryType.LOG_RESERVED_FILE_LN;
        }
    }
    ,
    USER(null);

    private final String internalName;

    private DbType(String internalName) {
        this.internalName = internalName;
    }

    public boolean isInternal() {
        return this.internalName != null;
    }

    public String getInternalName() {
        if (this.internalName == null) {
            throw EnvironmentFailureException.unexpectedState();
        }
        return this.internalName;
    }

    public boolean mayCreateUpdatedLN() {
        return true;
    }

    public LN createUpdatedLN(EnvironmentImpl envImpl, byte[] newData) {
        return LN.makeLN(envImpl, newData);
    }

    public boolean mayCreateDeletedLN() {
        return true;
    }

    public LN createDeletedLN(EnvironmentImpl envImpl) {
        return LN.makeLN(envImpl, (byte[])null);
    }

    public LogEntryType getLogType() {
        return null;
    }
}

