/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogParams;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.VersionedLN;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.SizeofMarker;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class LN
extends Node
implements VersionedWriteLoggable {
    private static final String BEGIN_TAG = "<ln>";
    private static final String END_TAG = "</ln>";
    private static final int LAST_FORMAT_CHANGE = 8;
    private byte[] data;
    private static final int DIRTY_BIT = Integer.MIN_VALUE;
    private static final int CLEAR_DIRTY_BIT = Integer.MAX_VALUE;
    private static final int FETCHED_COLD_BIT = 0x40000000;
    private int flags;

    public LN() {
        this.data = null;
    }

    public static LN makeLN(EnvironmentImpl envImpl, byte[] dataParam) {
        if (envImpl.getPreserveVLSN()) {
            return new VersionedLN(dataParam);
        }
        return new LN(dataParam);
    }

    public static LN makeLN(EnvironmentImpl envImpl, DatabaseEntry dbt) {
        if (envImpl.getPreserveVLSN()) {
            return new VersionedLN(dbt);
        }
        return new LN(dbt);
    }

    LN(byte[] data) {
        this.data = (byte[])(data == null ? null : (data.length == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : data));
        this.setDirty();
    }

    LN(DatabaseEntry dbt) {
        byte[] dat = dbt.getData();
        if (dat == null) {
            this.data = null;
        } else if (dbt.getPartial()) {
            this.init(dat, dbt.getOffset(), dbt.getPartialOffset() + dbt.getSize(), dbt.getPartialOffset(), dbt.getSize());
        } else {
            this.init(dat, dbt.getOffset(), dbt.getSize());
        }
        this.setDirty();
    }

    public LN(SizeofMarker marker, DatabaseEntry dbt) {
        this(dbt);
    }

    private void init(byte[] data, int off, int len, int doff, int dlen) {
        if (len == 0) {
            this.data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        } else {
            this.data = new byte[len];
            System.arraycopy(data, off, this.data, doff, dlen);
        }
    }

    private void init(byte[] data, int off, int len) {
        this.init(data, off, len, 0, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isDeleted() {
        return this.data == null;
    }

    @Override
    public boolean isLN() {
        return true;
    }

    void makeDeleted() {
        this.data = null;
    }

    public boolean isDirty() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public void setDirty() {
        this.flags |= Integer.MIN_VALUE;
    }

    public void clearDirty() {
        this.flags &= Integer.MAX_VALUE;
    }

    public boolean getFetchedCold() {
        return (this.flags & 0x40000000) != 0;
    }

    public void setFetchedCold(boolean val) {
        this.flags = val ? (this.flags |= 0x40000000) : (this.flags &= 0xBFFFFFFF);
    }

    @Override
    public void postFetchInit(DatabaseImpl db, long sourceLsn) {
        super.postFetchInit(db, sourceLsn);
        this.setFetchedCold(true);
    }

    public long getVLSNSequence() {
        return -1L;
    }

    public void setVLSNSequence(long seq) {
    }

    @Override
    boolean isValidForDelete() {
        return false;
    }

    boolean isEvictable(long lsn) throws DatabaseException {
        return true;
    }

    public void delete() {
        this.makeDeleted();
        this.setDirty();
    }

    public void modify(byte[] newData) {
        this.data = newData;
        this.setDirty();
    }

    public byte[] setEmpty() {
        byte[] retVal = this.data;
        this.data = Key.EMPTY_KEY;
        return retVal;
    }

    @Override
    void rebuildINList(INList inList) {
    }

    @Override
    public long getMemorySizeIncludedByParent() {
        int size = MemoryBudget.LN_OVERHEAD;
        if (this.data != null) {
            size += MemoryBudget.byteArraySize(this.data.length);
        }
        return size;
    }

    public void releaseMemoryBudget() {
    }

    public long getTreeAdminMemory() {
        return 0L;
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder self = new StringBuilder();
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.beginTag());
            self.append('\n');
        }
        self.append(super.dumpString(nSpaces + 2, true));
        self.append('\n');
        if (this.data != null) {
            self.append(TreeUtils.indent(nSpaces + 2));
            self.append("<data>");
            self.append(Key.DUMP_TYPE.dumpByteArray(this.data));
            self.append("</data>");
            self.append('\n');
        }
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.endTag());
        }
        return self.toString();
    }

    public LogItem optionalLog(EnvironmentImpl envImpl, DatabaseImpl dbImpl, Locker locker, WriteLockInfo writeLockInfo, boolean newEmbeddedLN, byte[] newKey, int newExpiration, boolean newExpirationInHours, boolean currEmbeddedLN, long currLsn, int currSize, boolean isInsertion, ReplicationContext repContext) throws DatabaseException {
        if (dbImpl.isDeferredWriteMode() && currEmbeddedLN == newEmbeddedLN) {
            LogItem item = new LogItem();
            item.lsn = this.assignTransientLsn(envImpl, dbImpl, currLsn, locker);
            item.size = -1;
            return item;
        }
        return this.logInternal(envImpl, dbImpl, locker, writeLockInfo, newEmbeddedLN, newKey, newExpiration, newExpirationInHours, currEmbeddedLN, currLsn, currSize, isInsertion, false, repContext);
    }

    public LogItem log(EnvironmentImpl envImpl, DatabaseImpl dbImpl, Locker locker, WriteLockInfo writeLockInfo, boolean newEmbeddedLN, byte[] newKey, int newExpiration, boolean newExpirationInHours, boolean currEmbeddedLN, long currLsn, int currSize, boolean isInsertion, boolean backgroundIO, ReplicationContext repContext) throws DatabaseException {
        return this.logInternal(envImpl, dbImpl, locker, writeLockInfo, newEmbeddedLN, newKey, newExpiration, newExpirationInHours, currEmbeddedLN, currLsn, currSize, isInsertion, backgroundIO, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogItem logInternal(EnvironmentImpl envImpl, DatabaseImpl dbImpl, Locker locker, WriteLockInfo writeLockInfo, boolean newEmbeddedLN, byte[] newKey, int newExpiration, boolean newExpirationInHours, boolean currEmbeddedLN, long currLsn, int currSize, boolean isInsertion, boolean backgroundIO, ReplicationContext repContext) throws DatabaseException {
        LogItem item;
        block23: {
            LogEntryType entryType;
            assert (this.getClass() == LN.class || this.getClass() == VersionedLN.class || !newEmbeddedLN);
            if (envImpl.isReadOnly()) {
                throw EnvironmentFailureException.unexpectedState("Cannot log LNs in read-only env.");
            }
            boolean isNamingDB = dbImpl.getId().equals(DbTree.NAME_DB_ID);
            if (!isNamingDB && envImpl.isReplicated() && locker != null && dbImpl.isReplicated() != locker.isReplicated()) {
                throw EnvironmentFailureException.unexpectedState((locker.isReplicated() ? "Rep txn used to write to non-rep DB" : "Non-rep txn used to write to rep DB") + ", class = " + locker.getClass().getName() + ", txnId = " + locker.getId() + ", dbName = " + dbImpl.getDebugName());
            }
            if (!isNamingDB) {
                boolean isRepLocker;
                boolean bl = isRepLocker = locker != null && locker.isReplicated();
                if (repContext.inReplicationStream() != isRepLocker) {
                    throw EnvironmentFailureException.unexpectedState((isRepLocker ? "Rep txn used to write outside of rep stream" : "Non-rep txn used to write in rep stream") + (locker != null ? ", class = " + locker.getClass().getName() + ", txnId = " + locker.getId() : ", null locker") + ", dbName = " + dbImpl.getDebugName());
                }
            }
            Txn txn = null;
            long abortLsn = -1L;
            boolean abortKD = false;
            byte[] abortKey = null;
            byte[] abortData = null;
            long abortVLSN = -1L;
            int abortExpiration = 0;
            boolean abortExpirationInHours = false;
            LogParams params = new LogParams();
            if (locker != null && locker.isTransactional()) {
                entryType = this.getLogType(isInsertion, true, dbImpl);
                txn = locker.getTxnLocker();
                assert (txn != null);
                abortLsn = writeLockInfo.getAbortLsn();
                abortKD = writeLockInfo.getAbortKnownDeleted();
                abortKey = writeLockInfo.getAbortKey();
                abortData = writeLockInfo.getAbortData();
                abortVLSN = writeLockInfo.getAbortVLSN();
                abortExpiration = writeLockInfo.getAbortExpiration();
                abortExpirationInHours = writeLockInfo.isAbortExpirationInHours();
                params.obsoleteDupsAllowed = locker.isRolledBack();
            } else {
                entryType = this.getLogType(isInsertion, false, dbImpl);
            }
            params.entry = this.createLogEntry(entryType, dbImpl, txn, abortLsn, abortKD, abortKey, abortData, abortVLSN, abortExpiration, abortExpirationInHours, newKey, newEmbeddedLN, newExpiration, newExpirationInHours, repContext);
            Provisional provisional = params.provisional = dbImpl.isTemporary() ? Provisional.YES : Provisional.NO;
            if (!(currLsn == abortLsn || dbImpl.isLNImmediatelyObsolete() || isInsertion || currEmbeddedLN)) {
                params.oldLsn = currLsn;
                params.oldSize = currSize;
            }
            params.repContext = repContext;
            params.backgroundIO = backgroundIO;
            params.nodeDb = dbImpl;
            if (txn != null && currLsn == abortLsn) {
                writeLockInfo.setAbortLogSize(currSize);
            }
            try {
                if (txn != null) {
                    Txn txn2 = txn;
                    synchronized (txn2) {
                        item = envImpl.getLogManager().log(params);
                        break block23;
                    }
                }
                item = envImpl.getLogManager().log(params);
            }
            catch (Throwable e) {
                if (envImpl.isValid()) {
                    throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INCOMPLETE, "LN could not be logged", e);
                }
                throw e;
            }
            finally {
                this.clearDirty();
            }
        }
        if (locker != null) {
            long newLsn = item.lsn;
            LockResult lockResult = locker.nonBlockingLock(newLsn, LockType.WRITE, false, dbImpl);
            assert (lockResult.getLockGrant() != LockGrantType.DENIED) : DbLsn.getNoFormatString(newLsn);
            lockResult.copyWriteLockInfo(writeLockInfo);
        }
        if (dbImpl.getSortedDuplicates() && (newEmbeddedLN || this.data != null && this.data.length > 0)) {
            throw EnvironmentFailureException.unexpectedState(envImpl, "[#25288] emb=" + newEmbeddedLN + " key=" + Key.getNoFormatString(newKey) + " data=" + Key.getNoFormatString(this.data) + " vlsn=" + item.header.getVLSN() + " lsn=" + DbLsn.getNoFormatString(currLsn));
        }
        return item;
    }

    LNLogEntry<?> createLogEntry(LogEntryType entryType, DatabaseImpl dbImpl, Txn txn, long abortLsn, boolean abortKD, byte[] abortKey, byte[] abortData, long abortVLSN, int abortExpiration, boolean abortExpirationInHours, byte[] newKey, boolean newEmbeddedLN, int newExpiration, boolean newExpirationInHours, ReplicationContext repContext) {
        return new LNLogEntry<LN>(entryType, dbImpl.getId(), txn, abortLsn, abortKD, abortKey, abortData, abortVLSN, abortExpiration, abortExpirationInHours, newKey, this, newEmbeddedLN, newExpiration, newExpirationInHours);
    }

    @Override
    void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incLNFetchStats(isMiss);
    }

    @Override
    public LogEntryType getGenericLogType() {
        return this.getLogType(true, false, null);
    }

    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional, DatabaseImpl db) {
        LogEntryType type;
        if (db != null && (type = db.getDbType().getLogType()) != null) {
            return type;
        }
        if (this.isDeleted()) {
            assert (!isInsert);
            return isTransactional ? LogEntryType.LOG_DEL_LN_TRANSACTIONAL : LogEntryType.LOG_DEL_LN;
        }
        if (isInsert) {
            return isTransactional ? LogEntryType.LOG_INS_LN_TRANSACTIONAL : LogEntryType.LOG_INS_LN;
        }
        return isTransactional ? LogEntryType.LOG_UPD_LN_TRANSACTIONAL : LogEntryType.LOG_UPD_LN;
    }

    private long assignTransientLsn(EnvironmentImpl envImpl, DatabaseImpl dbImpl, long oldLsn, Locker locker) {
        long newLsn = oldLsn != -1L ? oldLsn : envImpl.getNodeSequence().getNextTransientLsn();
        if (locker != null) {
            LockResult lockResult = locker.nonBlockingLock(newLsn, LockType.WRITE, false, dbImpl);
            assert (lockResult.getLockGrant() != LockGrantType.DENIED) : DbLsn.getNoFormatString(newLsn);
        }
        return newLsn;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.emptyList();
    }

    @Override
    public int getLogSize() {
        return this.getLogSize(15, false);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.writeToLog(logBuffer, 15, false);
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        return this.calcLogSize(this.isDeleted() ? -1 : this.data.length);
    }

    private int calcLogSize(int dataLen) {
        int size = 0;
        if (dataLen < 0) {
            size += LogUtils.getPackedIntLogSize(-1);
        } else {
            size += LogUtils.getPackedIntLogSize(dataLen);
            size += dataLen;
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        if (this.isDeleted()) {
            LogUtils.writePackedInt(logBuffer, -1);
        } else {
            LogUtils.writePackedInt(logBuffer, this.data.length);
            LogUtils.writeBytesNoLength(logBuffer, this.data);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        if (entryVersion < 8) {
            LogUtils.readLong(itemBuffer, entryVersion < 6);
        }
        if (entryVersion < 6) {
            boolean dataExists = LogUtils.readBoolean(itemBuffer);
            if (dataExists) {
                this.data = LogUtils.readByteArray(itemBuffer, true);
            }
        } else {
            int size = LogUtils.readInt(itemBuffer, false);
            if (size >= 0) {
                this.data = LogUtils.readBytesNoLength(itemBuffer, size);
            }
        }
    }

    @Override
    public boolean hasReplicationFormat() {
        return false;
    }

    @Override
    public boolean isReplicationFormatWorthwhile(ByteBuffer logBuffer, int srcVersion, int destVersion) {
        return false;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof LN)) {
            return false;
        }
        LN otherLN = (LN)other;
        return Arrays.equals(this.getData(), otherLN.getData());
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append(this.beginTag());
        if (this.data != null) {
            sb.append("<data>");
            if (verbose) {
                sb.append(Key.DUMP_TYPE.dumpByteArray(this.data));
            } else {
                sb.append("hidden");
            }
            sb.append("</data>");
        }
        this.dumpLogAdditional(sb, verbose);
        sb.append(this.endTag());
    }

    public void dumpKey(StringBuilder sb, byte[] key) {
        sb.append(Key.dumpString(key, 0));
    }

    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
    }

    public void addExtraMarshaledMemorySize(BIN parentBIN) {
    }

    public void setEntry(DatabaseEntry entry) {
        assert (!this.isDeleted());
        int len = this.data.length;
        byte[] bytes = new byte[len];
        System.arraycopy(this.data, 0, bytes, 0, len);
        entry.setData(bytes);
    }

    public static void setEntry(DatabaseEntry dest, byte[] bytes) {
        if (bytes != null) {
            int len;
            boolean partial = dest.getPartial();
            int off = partial ? dest.getPartialOffset() : 0;
            int n = len = partial ? dest.getPartialLength() : bytes.length;
            if (off + len > bytes.length) {
                len = off > bytes.length ? 0 : bytes.length - off;
            }
            byte[] newdata = null;
            if (len == 0) {
                newdata = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            } else {
                newdata = new byte[len];
                System.arraycopy(bytes, off, newdata, 0, len);
            }
            dest.setData(newdata);
            dest.setOffset(0);
            dest.setSize(len);
        } else {
            dest.setData(null);
            dest.setOffset(0);
            dest.setSize(0);
        }
    }

    public static void setEntry(DatabaseEntry dest, DatabaseEntry src) {
        if (src.getData() != null) {
            int len;
            byte[] srcBytes = src.getData();
            boolean partial = dest.getPartial();
            int off = partial ? dest.getPartialOffset() : 0;
            int n = len = partial ? dest.getPartialLength() : srcBytes.length;
            if (off + len > srcBytes.length) {
                len = off > srcBytes.length ? 0 : srcBytes.length - off;
            }
            byte[] newdata = null;
            if (len == 0) {
                newdata = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            } else {
                newdata = new byte[len];
                System.arraycopy(srcBytes, off, newdata, 0, len);
            }
            dest.setData(newdata);
            dest.setOffset(0);
            dest.setSize(len);
        } else {
            dest.setData(null);
            dest.setOffset(0);
            dest.setSize(0);
        }
    }

    public static byte[] copyEntryData(DatabaseEntry entry) {
        assert (!entry.getPartial());
        int len = entry.getSize();
        byte[] newData = len == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : new byte[len];
        System.arraycopy(entry.getData(), entry.getOffset(), newData, 0, len);
        return newData;
    }

    public static byte[] resolvePartialEntry(DatabaseEntry entry, byte[] foundDataBytes) {
        int slicelen;
        int origlen;
        assert (foundDataBytes != null);
        int dlen = entry.getPartialLength();
        int doff = entry.getPartialOffset();
        int oldlen = doff + dlen > (origlen = foundDataBytes.length) ? doff + dlen : origlen;
        int len = oldlen - dlen + entry.getSize();
        byte[] newData = len == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : new byte[len];
        int pos = 0;
        int n = slicelen = doff < origlen ? doff : origlen;
        if (slicelen > 0) {
            System.arraycopy(foundDataBytes, 0, newData, pos, slicelen);
        }
        slicelen = entry.getSize();
        System.arraycopy(entry.getData(), entry.getOffset(), newData, pos += doff, slicelen);
        pos += slicelen;
        slicelen = origlen - (doff + dlen);
        if (slicelen > 0) {
            System.arraycopy(foundDataBytes, doff + dlen, newData, pos, slicelen);
        }
        return newData;
    }
}

