/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.util.DbVerify;
import java.io.File;
import java.io.PrintStream;

public class DbStat
extends DbVerify {
    private int progressInterval = 0;

    public static void main(String[] argv) throws DatabaseException {
        DbStat stat = new DbStat();
        stat.parseArgs(argv);
        int ret = 1;
        try {
            stat.openEnv();
            if (stat.stats(System.err)) {
                ret = 0;
            }
            stat.closeEnv();
        }
        catch (Throwable T) {
            ret = 1;
            T.printStackTrace(System.err);
        }
        System.exit(ret);
    }

    DbStat() {
    }

    public DbStat(Environment env, String dbName) {
        super(env, dbName, false);
    }

    @Override
    void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    this.dbName = argv[argc++];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (!thisArg.equals("-v")) continue;
            if (argc < nArgs) {
                this.progressInterval = Integer.parseInt(argv[argc++]);
                if (this.progressInterval > 0) continue;
                this.printUsage("-v requires a positive argument");
                continue;
            }
            this.printUsage("-v requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (this.dbName == null) {
            this.printUsage("-s is a required argument");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stats(PrintStream out) throws DatabaseNotFoundException {
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setShowProgressStream(out);
        if (this.progressInterval > 0) {
            statsConfig.setShowProgressInterval(this.progressInterval);
        }
        try {
            DatabaseImpl dbImpl;
            EnvironmentImpl envImpl = DbInternal.getNonNullEnvImpl(this.env);
            DbTree dbTree = envImpl.getDbTree();
            BasicLocker locker = BasicLocker.createBasicLocker(envImpl, false);
            try {
                dbImpl = dbTree.getDb(locker, this.dbName, null, false);
            }
            finally {
                locker.operationEnd();
            }
            if (dbImpl == null || dbImpl.isDeleted()) {
                return false;
            }
            try {
                BtreeStats stats = dbImpl.stat(statsConfig);
                out.println(stats);
            }
            finally {
                dbTree.releaseDb(dbImpl);
            }
        }
        catch (DatabaseException DE) {
            return false;
        }
        return true;
    }
}

