/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.JavaccTaskException;
import ca.coglinc.gradle.plugins.javacc.NonJavaccSourceFileVisitor;
import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFile;
import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFilesDirectory;
import ca.coglinc.gradle.plugins.javacc.compilationresults.CompiledJavaccFilesDirectoryFactory;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class AbstractJavaccTask
extends SourceTask {
    protected Map<String, String> programArguments;
    private File inputDirectory;
    private File outputDirectory;
    private CompiledJavaccFilesDirectoryFactory compiledJavaccFilesDirectoryFactory = new CompiledJavaccFilesDirectoryFactory();

    protected AbstractJavaccTask(String inputDirectory, String outputDirectory, String filter) {
        this.setInputDirectory(inputDirectory);
        this.setOutputDirectory(outputDirectory);
        this.include(new String[]{filter});
    }

    protected void compile(File inputDirectory, RelativePath inputRelativePath) {
        this.getLogger().debug("Compiling {} file [{}] from [{}] into [{}]", new Object[]{this.getProgramName(), inputRelativePath, inputDirectory, this.getOutputDirectory()});
        String[] arguments = this.buildProgramArguments(inputDirectory, inputRelativePath);
        this.getLogger().debug("Invoking {} with arguments [{}]", (Object)this.getProgramName(), (Object)arguments);
        try {
            this.invokeCompiler(arguments);
        }
        catch (Exception exception) {
            String errorMessage = String.format("Unable to compile '%s' from '%s' into '%s'", inputRelativePath, inputDirectory, this.getOutputDirectory());
            throw new JavaccTaskException(errorMessage, exception);
        }
    }

    protected abstract void invokeCompiler(String[] var1) throws Exception;

    protected void copyNonJavaccFilesToOutputDirectory() {
        this.getSource().visit(this.getNonJavaccSourceFileVisitor());
    }

    protected File getTempOutputDirectory() {
        return new File(this.getOutputDirectory(), "tmp");
    }

    protected void compileSourceFilesToTempOutputDirectory() {
        this.getSource().visit(this.getJavaccSourceFileVisitor());
    }

    protected void copyCompiledFilesFromTempOutputDirectoryToOutputDirectory() {
        CompiledJavaccFilesDirectory compiledJavaccFilesDirectory = this.compiledJavaccFilesDirectoryFactory.getCompiledJavaccFilesDirectory(this.getTempOutputDirectory(), this.getCompleteSourceTree(), this.getOutputDirectory(), this.getLogger());
        for (CompiledJavaccFile compiledJavaccFile : compiledJavaccFilesDirectory.listFiles()) {
            FileTree javaSourceTree;
            if (compiledJavaccFile.customAstClassExists(javaSourceTree = this.getJavaSourceTree())) {
                compiledJavaccFile.ignoreCompiledFileAndUseCustomAstClassFromJavaSourceTree(javaSourceTree);
                continue;
            }
            if (compiledJavaccFile.customAstClassExists()) {
                compiledJavaccFile.copyCustomAstClassToTargetDirectory(this.getCompleteSourceTree());
                continue;
            }
            compiledJavaccFile.copyCompiledFileToTargetDirectory();
        }
    }

    private FileTree getCompleteSourceTree() {
        FileTree javaccTaskSourceTree = this.getSource();
        FileTree javaTasksSourceTree = this.getJavaSourceTree();
        FileTree completeSourceTree = null;
        completeSourceTree = javaTasksSourceTree == null ? javaccTaskSourceTree : javaccTaskSourceTree.plus(javaTasksSourceTree);
        return this.excludeOutputDirectory(completeSourceTree);
    }

    private FileTree excludeOutputDirectory(FileTree sourceTree) {
        if (sourceTree == null) {
            return null;
        }
        Spec<File> outputDirectoryFilter = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                return file.getAbsolutePath().contains(AbstractJavaccTask.this.getOutputDirectory().getAbsolutePath());
            }
        };
        sourceTree = sourceTree.minus(sourceTree.filter((Spec)outputDirectoryFilter)).getAsFileTree();
        return sourceTree;
    }

    private FileTree getJavaSourceTree() {
        FileTree javaSourceTree = null;
        TaskCollection javaCompileTasks = this.getProject().getTasks().withType(JavaCompile.class);
        for (JavaCompile task : javaCompileTasks) {
            if (javaSourceTree == null) {
                javaSourceTree = task.getSource();
                continue;
            }
            javaSourceTree = javaSourceTree.plus(task.getSource());
        }
        return this.excludeOutputDirectory(javaSourceTree);
    }

    protected abstract FileVisitor getJavaccSourceFileVisitor();

    protected FileVisitor getNonJavaccSourceFileVisitor() {
        return new NonJavaccSourceFileVisitor(this);
    }

    public Map<String, String> getArguments() {
        return this.programArguments;
    }

    public AbstractJavaccTask setArguments(Map<String, String> arguments) {
        this.programArguments = arguments;
        return this;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public AbstractJavaccTask setInputDirectory(String inputDirectory) {
        return this.setInputDirectory(new File(this.getProject().getProjectDir(), inputDirectory));
    }

    public AbstractJavaccTask setInputDirectory(File inputDirectory) {
        this.getLogger().debug("Changing input directory to [{}]", (Object)inputDirectory);
        this.inputDirectory = inputDirectory;
        this.setSource(inputDirectory);
        return this;
    }

    public AbstractJavaccTask setOutputDirectory(String outputDirectory) {
        return this.setOutputDirectory(new File(this.getProject().getBuildDir(), outputDirectory));
    }

    public AbstractJavaccTask setOutputDirectory(File outputDirectory) {
        this.getLogger().debug("Changing output directory to [{}]", (Object)outputDirectory);
        this.outputDirectory = outputDirectory;
        return this;
    }

    String[] buildProgramArguments(File inputDirectory, RelativePath inputRelativePath) {
        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
        if (this.programArguments != null) {
            arguments.putAll(this.programArguments);
        }
        this.augmentArguments(inputDirectory, inputRelativePath, arguments);
        int index = 0;
        String[] commandLineArguments = new String[arguments.size() + 1];
        for (Map.Entry entry : arguments.entrySet()) {
            commandLineArguments[index++] = String.format("-%1$s=%2$s", entry.getKey(), entry.getValue());
        }
        commandLineArguments[commandLineArguments.length - 1] = inputRelativePath.getFile(inputDirectory).getAbsolutePath();
        return commandLineArguments;
    }

    protected abstract void augmentArguments(File var1, RelativePath var2, Map<String, String> var3);

    protected abstract String getProgramName();

    protected abstract String supportedSuffix();
}

