/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.bark;

import com.addthis.bark.StringSerializer;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCmdLine {
    private static final Logger logger = LoggerFactory.getLogger(ZkCmdLine.class);
    private static final int zkSessionTimeout = Integer.parseInt(System.getProperty("zk.sessionTimeout", "10000"));
    private static final int zkConnectionTimeout = Integer.parseInt(System.getProperty("zk.connectionTimeout", "60000"));
    private static final int msSleepBetweenRetry = Integer.parseInt(System.getProperty("zk.sleepBetweenRetry", "5000"));
    private CommandLine cmdline;
    private CuratorFramework zkClient;

    public ZkCmdLine(CommandLine cmdline) {
        this.cmdline = cmdline;
        this.zkClient = CuratorFrameworkFactory.newClient((String)(cmdline.getOptionValue("zk") + "/" + cmdline.getOptionValue("chroot")), (int)zkSessionTimeout, (int)zkConnectionTimeout, (RetryPolicy)new RetryOneTime(msSleepBetweenRetry));
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("h", "help", false, "something helpful.");
        options.addOption("z", "zk", true, "zk servers,port");
        options.addOption("c", "chroot", true, "chroot");
        options.addOption("n", "znode", true, "znode");
        options.addOption("d", "dir", true, "directory root");
        options.addOption("p", "put-data", true, "directory root");
        options.addOption("", "to-zk", true, "zk servers,port");
        options.addOption("", "to-chroot", true, "chroot");
        options.addOption("", "to-znode", true, "znode");
        PosixParser parser = new PosixParser();
        CommandLine cmdline = null;
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            System.exit(0);
        }
        HelpFormatter formatter = new HelpFormatter();
        if (cmdline.hasOption("help") || cmdline.getArgList().size() < 1) {
            System.out.println("commands: get jclean jcleanrecur kids grandkids");
            formatter.printHelp("ZkCmdLine", options);
            System.exit(0);
        }
        ZkCmdLine zkcl = new ZkCmdLine(cmdline);
        zkcl.runCmd((String)cmdline.getArgList().get(0));
    }

    public void runCmd(String cmd) throws Exception {
        if ("get".equals(cmd)) {
            this.cmdGet();
        } else if ("put".equals(cmd)) {
            this.cmdPut();
        } else if ("delete".equals(cmd)) {
            this.cmdDelete();
        } else if ("jclean".equals(cmd)) {
            this.cmdCleanJsonString();
        } else if ("jcleanrecur".equals(cmd)) {
            this.cmdCleanJsonStringRecursive();
        } else if ("kids".equals(cmd)) {
            this.cmdKids();
        } else if ("grandkids".equals(cmd)) {
            this.cmdGrandKids();
        } else if ("export".equals(cmd)) {
            this.cmdExport();
        } else if ("exportkids".equals(cmd)) {
            this.cmdExportChildren();
        } else if ("copy".equals(cmd)) {
            this.cmdCopyZnode();
        } else if ("copyrecur".equals(cmd)) {
            this.cmdCopyZnode();
        }
    }

    public void cmdGet() throws Exception {
        String data = StringSerializer.deserialize((byte[])this.zkClient.getData().forPath(this.cmdline.getOptionValue("znode")));
        System.out.println(data);
    }

    public void cmdPut() throws Exception {
        String znode = this.cmdline.getOptionValue("znode");
        String data = null;
        if (this.cmdline.hasOption("put-data")) {
            data = this.cmdline.getOptionValue("put-data");
        }
        try {
            this.zkClient.create().forPath(znode);
        }
        catch (KeeperException.NodeExistsException e) {
            this.zkClient.setData().forPath(znode, StringSerializer.serialize(data));
        }
    }

    public void cmdDelete() throws Exception {
        this.zkClient.delete().forPath(this.cmdline.getOptionValue("znode"));
    }

    public void cmdKids() throws Exception {
        List kids = (List)this.zkClient.getChildren().forPath(this.cmdline.getOptionValue("znode"));
        System.out.println(kids);
    }

    public void cmdGrandKids() throws Exception {
        System.out.println(this.getFamily(this.cmdline.getOptionValue("znode")));
    }

    public void cmdCleanJsonString() throws Exception {
        this.cleanNodeJsonString(this.cmdline.getOptionValue("znode"));
    }

    public void cmdCleanJsonStringRecursive() throws Exception {
        List<Object> graph = this.getFamily(this.cmdline.getOptionValue("znode"));
        this.cleanNodeJsonStringList(graph);
    }

    public void cmdExport() throws Exception {
        String path = this.cmdline.getOptionValue("znode");
        String dir = this.cmdline.getOptionValue("dir");
        this.exportPath(path, dir);
    }

    public void cmdExportChildren() throws Exception {
        String path = this.cmdline.getOptionValue("znode");
        String dir = this.cmdline.getOptionValue("dir");
        List kids = (List)this.zkClient.getChildren().forPath(path);
        System.out.println(kids);
        for (String kid : kids) {
            this.exportPath(path + "/" + kid, dir);
        }
    }

    public void cmdCopyZnode() throws Exception {
        String fromZnode;
        String toZnode = fromZnode = this.cmdline.getOptionValue("znode");
        if (this.cmdline.hasOption("to-znode")) {
            toZnode = this.cmdline.getOptionValue("to-znode");
        }
        CuratorFramework toZkClient = CuratorFrameworkFactory.newClient((String)((this.cmdline.hasOption("to-zk") ? this.cmdline.getOptionValue("to-zk") : this.cmdline.getOptionValue("zk")) + "/" + (this.cmdline.hasOption("to-chroot") ? this.cmdline.getOptionValue("to-chroot") : this.cmdline.getOptionValue("chroot"))), (int)zkSessionTimeout, (int)zkConnectionTimeout, (RetryPolicy)new RetryOneTime(msSleepBetweenRetry));
        this.copyZnode(fromZnode, toZnode, this.zkClient, toZkClient);
    }

    public void cmdCopyZnodeRecur() throws Exception {
        String fromZnode = this.cmdline.getOptionValue("znode");
        CuratorFramework toZkClient = CuratorFrameworkFactory.newClient((String)((this.cmdline.hasOption("to-zk") ? this.cmdline.getOptionValue("to-zk") : this.cmdline.getOptionValue("zk")) + "/" + (this.cmdline.hasOption("to-chroot") ? this.cmdline.getOptionValue("to-chroot") : this.cmdline.getOptionValue("chroot"))), (int)zkSessionTimeout, (int)zkConnectionTimeout, (RetryPolicy)new RetryOneTime(msSleepBetweenRetry));
        List znodes = this.flatten(this.getFamily(fromZnode));
        for (String znode : znodes) {
            this.copyZnode(znode, znode, this.zkClient, toZkClient);
        }
    }

    private void copyZnode(String fromZnode, String toZnode, CuratorFramework fromZkClient, CuratorFramework toZkClient) throws Exception {
        String fromData = StringSerializer.deserialize((byte[])this.zkClient.getData().forPath(fromZnode));
        System.out.println("tonode: " + toZnode + " from data " + fromData);
        try {
            toZkClient.create().forPath(toZnode, StringSerializer.serialize(fromData));
        }
        catch (KeeperException.NodeExistsException e) {
            toZkClient.setData().forPath(toZnode, StringSerializer.serialize(fromData));
        }
    }

    private void exportPath(String path, String dir) throws Exception {
        String data = StringSerializer.deserialize((byte[])this.zkClient.getData().forPath(path));
        if (data == null) {
            System.out.println("no data to export for " + path);
            return;
        }
        File outFile = new File(dir + path);
        Files.createParentDirs((File)outFile);
        Files.write((CharSequence)data, (File)outFile, (Charset)Charset.forName("UTF-8"));
    }

    private void cleanNodeJsonStringList(List<Object> graph) throws Exception {
        for (Object o : graph) {
            if (o instanceof String) {
                this.cleanNodeJsonString((String)o);
                continue;
            }
            this.cleanNodeJsonStringList((List)o);
        }
    }

    private void cleanNodeJsonString(String path) throws Exception {
        String data = StringSerializer.deserialize((byte[])this.zkClient.getData().forPath(path));
        if (data == null) {
            System.out.println("no data on path : " + path);
        } else {
            int idx = data.indexOf("{");
            if (idx == 0) {
                System.out.println("nothing to do");
                return;
            }
            System.out.println("Old Data on path  " + path + " : " + data);
            String newData = data.substring(idx);
            System.out.println("New Data on path  " + path + " : " + newData);
            this.zkClient.setData().forPath(path, StringSerializer.serialize(newData));
        }
    }

    private List<Object> getFamily(String path) throws Exception {
        List kids = (List)this.zkClient.getChildren().forPath(path);
        ArrayList<Object> graph = new ArrayList<Object>();
        graph.add(path);
        for (String kid : kids) {
            String kidpath = path + "/" + kid;
            int numKids = ((List)this.zkClient.getChildren().forPath(kidpath)).size();
            if (numKids == 0) {
                graph.add(kidpath);
                continue;
            }
            graph.add(this.getFamily(kidpath));
        }
        return graph;
    }

    public <T> List<T> flatten(List<?> list) {
        ArrayList retVal = new ArrayList();
        this.flatten(list, retVal);
        return retVal;
    }

    public <T> void flatten(List<?> fromTreeList, List<T> toFlatList) {
        for (Object item : fromTreeList) {
            if (item instanceof List) {
                this.flatten((List)item, toFlatList);
                continue;
            }
            toFlatList.add(item);
        }
    }
}

