/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.chars;

import com.addthis.basis.chars.BufferIndex;
import com.addthis.basis.chars.CharSequenceComparator;
import com.addthis.basis.chars.ReadableCharBuf;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;

@Beta
public abstract class AbstractReadOnlyUtfBuf
implements ReadableCharBuf {
    protected int packedIndexCache;
    protected static final int MAX_USHORT = 65535;
    protected static final int MAX_USHORT_LESS_ONE = 65534;
    protected static final int MAX_USHORT_LESS_FOUR = 65531;

    protected static int cacheByteOffset(int cacheInstance) {
        return cacheInstance >> 15;
    }

    protected static int cacheCharIndex(int cacheInstance) {
        return Short.MAX_VALUE & cacheInstance;
    }

    protected static int packIndexCache(int byteOffset, int charIndex) {
        byteOffset <<= 15;
        return byteOffset |= charIndex;
    }

    protected static int byteIndex(int byteOffset, int charIndex) {
        return charIndex - byteOffset;
    }

    protected boolean knownAsciiOnly(int cacheInstance) {
        return cacheInstance == this.getByteLength();
    }

    @Override
    public int length() {
        int cacheInstance = this.packedIndexCache;
        if (cacheInstance >= 0 && this.knownAsciiOnly(this.tryAsciiScan(cacheInstance, this.getByteLength()))) {
            return this.getByteLength();
        }
        int charIndex = AbstractReadOnlyUtfBuf.cacheCharIndex(cacheInstance);
        int byteOffset = AbstractReadOnlyUtfBuf.cacheByteOffset(cacheInstance);
        int byteLength = this.getByteLength();
        int byteIndex = AbstractReadOnlyUtfBuf.byteIndex(byteOffset, charIndex);
        if (byteIndex == byteLength) {
            return charIndex;
        }
        while (byteIndex < byteLength) {
            byte b = this.getByte(byteIndex);
            if (b < 0) {
                int continuations = (b & 0x10) >> 4;
                byteOffset += continuations;
                continuations += (b & 0x20) >> 5;
                byteOffset -= ++continuations;
                byteIndex += continuations;
            }
            ++byteIndex;
        }
        charIndex = byteLength + byteOffset;
        if (charIndex <= Short.MAX_VALUE) {
            this.packedIndexCache = AbstractReadOnlyUtfBuf.packIndexCache(byteOffset, charIndex);
        }
        return charIndex;
    }

    private int tryAsciiScan(int start, int end) {
        end = Math.min(end, this.getByteLength());
        for (int i = start; i < end; ++i) {
            byte b = this.getByte(i);
            if (b >= 0) continue;
            this.packedIndexCache = i;
            return i;
        }
        this.packedIndexCache = end;
        return end;
    }

    private void nonAsciiScan(BufferIndex index, int end) {
        if (index.charIndex > end) {
            index.charIndex = 0;
            index.byteOffset = 0;
            index.byteIndex = 0;
        }
        while (index.charIndex < end) {
            byte b = this.getByte(index.byteIndex);
            ++index.byteIndex;
            if (b < 0) {
                int continuations = (b & 0x10) >> 4;
                index.charIndex += continuations;
                index.byteIndex += continuations;
                continuations = (b & 0x20) >> 5;
                index.byteOffset -= ++continuations;
                index.byteIndex += continuations;
            }
            ++index.charIndex;
        }
    }

    @Override
    public ReadableCharBuf subSequence(int start, int end) {
        int cacheInstance = this.packedIndexCache;
        if (end <= cacheInstance) {
            return this.getSubSequenceForByteBounds(start, end);
        }
        if (cacheInstance >= 0 && end <= this.tryAsciiScan(cacheInstance, end)) {
            return this.getSubSequenceForByteBounds(start, end);
        }
        BufferIndex index = new BufferIndex(cacheInstance);
        this.nonAsciiScan(index, start);
        if (index.charIndex > start) {
            throw new IllegalArgumentException("first character of the requested subsequence is a low-surrogate");
        }
        int startByte = index.byteIndex;
        this.nonAsciiScan(index, end);
        if (index.byteIndex > end) {
            throw new IllegalArgumentException("last character of the requested subsequence is a high-surrogate");
        }
        if (index.charIndex <= Short.MAX_VALUE) {
            this.packedIndexCache = AbstractReadOnlyUtfBuf.packIndexCache(index.byteOffset, index.charIndex);
        }
        int endByte = index.byteIndex;
        return this.getSubSequenceForByteBounds(startByte, endByte);
    }

    private char nextCharForBufferIndex(BufferIndex index, boolean highSurrogate) {
        char out;
        byte b;
        ++index.charIndex;
        if ((b = this.getByte(index.byteIndex++)) >= 0) {
            out = (char)b;
        } else if (b < -32) {
            out = (char)((b & 0x1F) << 6);
            b = this.getByte(index.byteIndex++);
            out = (char)(out | (char)(b & 0x3F));
            --index.byteOffset;
        } else if (b < -16) {
            out = (char)((b & 0xF) << 12);
            b = this.getByte(index.byteIndex++);
            out = (char)(out | (char)((b & 0x3F) << 6));
            b = this.getByte(index.byteIndex++);
            out = (char)(out | (char)(b & 0x3F));
            index.byteOffset -= 2;
        } else {
            int codePoint = (b & 7) << 18;
            b = this.getByte(index.byteIndex++);
            codePoint |= (b & 0x3F) << 12;
            b = this.getByte(index.byteIndex++);
            codePoint |= (b & 0x3F) << 6;
            b = this.getByte(index.byteIndex++);
            out = highSurrogate ? Character.highSurrogate(codePoint) : Character.lowSurrogate(codePoint |= b & 0x3F);
            ++index.charIndex;
            index.byteOffset -= 2;
        }
        if (index.charIndex <= Short.MAX_VALUE) {
            this.packedIndexCache = AbstractReadOnlyUtfBuf.packIndexCache(index.byteOffset, index.charIndex);
        }
        return out;
    }

    @Override
    public char charAt(int index) {
        byte b = this.getByte(index);
        int cacheInstance = this.packedIndexCache;
        if (index < cacheInstance) {
            return (char)b;
        }
        if (cacheInstance >= 0 && index < this.tryAsciiScan(cacheInstance, index + 16)) {
            return (char)b;
        }
        BufferIndex bufferIndex = new BufferIndex(this.packedIndexCache);
        this.nonAsciiScan(bufferIndex, index);
        boolean highSurrogate = true;
        if (bufferIndex.charIndex > index) {
            bufferIndex.byteIndex -= 4;
            bufferIndex.byteOffset += 2;
            bufferIndex.charIndex -= 2;
            highSurrogate = false;
        }
        return this.nextCharForBufferIndex(bufferIndex, highSurrogate);
    }

    @Override
    public int hashCode() {
        int length = this.length();
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            char c = this.charAt(i);
            hash = 31 * hash + c;
        }
        return hash;
    }

    @Override
    public int compareTo(ReadableCharBuf o) {
        return CharSequenceComparator.INSTANCE.compare(this, o);
    }

    public String toDebugString() {
        int cacheInstance = this.packedIndexCache;
        return Objects.toStringHelper((Object)this).add("byteLength", this.getByteLength()).add("byteIndex", AbstractReadOnlyUtfBuf.cacheCharIndex(cacheInstance)).add("charDelta", AbstractReadOnlyUtfBuf.cacheByteOffset(cacheInstance)).toString();
    }
}

