/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.chars;

import com.addthis.basis.chars.AbstractReadOnlyUtfBuf;
import com.addthis.basis.chars.ReadableCharBuf;
import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@Beta
public class ByteArrayReadOnlyUtfBuf
extends AbstractReadOnlyUtfBuf {
    protected final byte[] data;

    public ByteArrayReadOnlyUtfBuf(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
    }

    public ByteArrayReadOnlyUtfBuf(String javaString) {
        if (javaString == null) {
            throw new NullPointerException("java string");
        }
        this.data = javaString.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte getByte(int index) {
        return this.data[index];
    }

    @Override
    public int getByteLength() {
        return this.data.length;
    }

    @Override
    public ReadableCharBuf getSubSequenceForByteBounds(int start, int end) {
        int length = end - start;
        byte[] wastefulClone = new byte[length];
        System.arraycopy(this.data, start, wastefulClone, 0, length);
        return new ByteArrayReadOnlyUtfBuf(wastefulClone);
    }

    @Override
    public ByteBuf toByteBuf() {
        return Unpooled.wrappedBuffer((byte[])this.data);
    }

    @Override
    public String toString() {
        if (this.knownAsciiOnly(this.packedIndexCache)) {
            return new String(this.data, 0);
        }
        return new String(this.data, StandardCharsets.UTF_8);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteArrayReadOnlyUtfBuf) {
            return Arrays.equals(this.data, ((ByteArrayReadOnlyUtfBuf)obj).data);
        }
        if (obj instanceof ReadableCharBuf) {
            return ByteBufUtil.equals((ByteBuf)((ReadableCharBuf)obj).toByteBuf(), (ByteBuf)this.toByteBuf());
        }
        return false;
    }
}

