/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.chars;

import com.addthis.basis.chars.CharBuf;
import com.addthis.basis.chars.ReadOnlyUtfBuf;
import com.addthis.basis.chars.ReadableCharBuf;
import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;

@Beta
public class ReadOnlyAsciiBuf
extends ReadOnlyUtfBuf {
    public ReadOnlyAsciiBuf(ByteBuf data) {
        super(data);
    }

    public ReadOnlyAsciiBuf(CharBuf charBuf) {
        super(charBuf.toByteBuf());
    }

    @Override
    protected boolean knownAsciiOnly(int cacheInstance) {
        return true;
    }

    @Override
    public int length() {
        return this.getByteLength();
    }

    @Override
    public char charAt(int index) {
        return (char)this.getByte(index);
    }

    @Override
    public ReadableCharBuf subSequence(int start, int end) {
        return this.getSubSequenceForByteBounds(start, end);
    }

    @Override
    public int hashCode() {
        int hash = this.packedIndexCache;
        if (hash == 0) {
            int length = this.length();
            for (int i = 0; i < length; ++i) {
                char c = this.charAt(i);
                hash = 31 * hash + c;
            }
            this.packedIndexCache = hash;
        }
        return hash;
    }

    @Override
    public String toString() {
        ByteBuf slice = this.content().slice();
        char[] values = new char[slice.capacity()];
        if (slice.readableBytes() > 0) {
            for (int i = 0; i < slice.capacity(); ++i) {
                values[i] = (char)slice.getByte(i);
            }
        } else {
            return "";
        }
        return new String(values);
    }
}

