/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.binary;

import com.addthis.basis.util.LessBytes;
import com.addthis.codec.Codec;
import com.addthis.codec.binary.BufferIn;
import com.addthis.codec.binary.BufferOut;
import com.addthis.codec.codables.Codable;
import com.addthis.codec.codables.ConcurrentCodable;
import com.addthis.codec.codables.SuperCodable;
import com.addthis.codec.reflection.CodableClassInfo;
import com.addthis.codec.reflection.CodableFieldInfo;
import com.addthis.codec.reflection.Fields;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecBin2
implements Codec {
    private static final Logger log = LoggerFactory.getLogger(CodecBin2.class);
    public static final CodecBin2 INSTANCE = new CodecBin2(false);
    public static final int CODEC_VERSION = 2;
    private final boolean charstring;

    private CodecBin2(boolean cs) {
        this.charstring = cs;
    }

    @Override
    public byte[] encode(Object obj) throws Exception {
        return CodecBin2.encodeBytes(obj);
    }

    public Object decode(Class type, byte[] data) throws Exception {
        return this.decode(type.newInstance(), data);
    }

    public Object decode(Object shell, byte[] data) throws Exception {
        return CodecBin2.decodeBytes(shell, data);
    }

    @Override
    public boolean storesNull(byte[] data) {
        return data.length == 5 && data[4] == 0;
    }

    public static byte[] encodeBytes(Object object) throws Exception {
        BufferOut buf = new BufferOut();
        LessBytes.writeInt((int)2, (OutputStream)buf.out());
        INSTANCE.encodeObject(object, buf);
        return buf.out.toByteArray();
    }

    @Nullable
    public static Object decodeBytes(Object object, byte[] data) throws Exception {
        BufferIn buf = new BufferIn(data);
        int ver = LessBytes.readInt((InputStream)buf.in);
        CodecBin2.require(ver == 2, "version mismatch " + ver + " != " + 2);
        return INSTANCE.decodeObject(Fields.getClassFieldMap(object.getClass()), object, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeObject(Object object, BufferOut buf) throws Exception {
        log.trace("encodeObject: {} {}", object, (Object)buf);
        if (object == null) {
            buf.out.write(0);
            return;
        }
        boolean lock = object instanceof ConcurrentCodable;
        if (lock) {
            ((ConcurrentCodable)object).encodeLock();
        }
        try {
            if (object instanceof SuperCodable) {
                ((SuperCodable)object).preEncode();
            }
            Class<?> objectClass = object.getClass();
            CodableClassInfo classInfo = Fields.getClassFieldMap(objectClass);
            if (objectClass.isArray()) {
                this.encodeArray(object, objectClass, buf);
            } else if (classInfo.size() == 0 && !(object instanceof Codable)) {
                this.encodeNative(object, buf);
            } else {
                buf.out.write(1);
                this.writeStringHelper(classInfo.getClassName(object), buf.out());
                for (CodableFieldInfo field : classInfo.values()) {
                    this.encodeField(field.get(object), field, buf);
                }
            }
        }
        finally {
            if (lock) {
                ((ConcurrentCodable)object).encodeUnlock();
            }
        }
    }

    @Nullable
    private Object decodeObject(Class<?> type, BufferIn buf) throws Exception {
        log.trace("decodeObject: {} {}", type, (Object)buf);
        if (Fields.isNative(type)) {
            return this.decodeNative(type, buf);
        }
        CodableClassInfo classInfo = Fields.getClassFieldMap(type);
        return this.decodeObject(classInfo, null, buf);
    }

    @Nullable
    private Object decodeObject(CodableClassInfo classInfo, @Nullable Object object, BufferIn buf) throws Exception {
        Class<?> atype;
        int ck = buf.in.read();
        if (ck == 0) {
            return null;
        }
        Class<?> type = classInfo.getBaseClass();
        log.trace("decodeObject: {} {} {}", new Object[]{classInfo, object, buf});
        String stype = this.readStringHelper(buf.in);
        if (!Strings.isNullOrEmpty((String)stype) && type != (atype = classInfo.getClass(stype))) {
            classInfo = Fields.getClassFieldMap(atype);
            type = atype;
        }
        if (object == null) {
            object = type.newInstance();
        }
        for (CodableFieldInfo field : classInfo.values()) {
            field.set(object, this.decodeField(field, buf));
        }
        if (object instanceof SuperCodable) {
            ((SuperCodable)object).postDecode();
        }
        return object;
    }

    private void encodeArray(Object value, Class<?> type, BufferOut buf) throws Exception {
        int len = Array.getLength(value);
        log.trace("encodeArray: {} {} {} len={}", new Object[]{value, type, buf, len});
        LessBytes.writeLength((long)len, (OutputStream)buf.out());
        if (type == Byte.TYPE || type == Byte.class) {
            buf.out.write((byte[])value);
        } else if (type == Integer.TYPE || type == Integer.class) {
            int[] val = (int[])value;
            for (int i = 0; i < len; ++i) {
                LessBytes.writeInt((int)val[i], (OutputStream)buf.out());
            }
        } else if (type == Long.TYPE || type == Long.class) {
            long[] val = (long[])value;
            for (int i = 0; i < len; ++i) {
                LessBytes.writeLong((long)val[i], (OutputStream)buf.out());
            }
        } else if (type.isEnum()) {
            for (int i = 0; i < len; ++i) {
                this.encodeNative(Array.get(value, i).toString(), buf);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.encodeObject(Array.get(value, i), buf);
            }
        }
    }

    @Nullable
    private Object decodeArray(Class<?> type, BufferIn buf) throws Exception {
        Object value;
        block12: {
            log.trace("decodeArray: {} {}", type, (Object)buf);
            int len = (int)LessBytes.readLength((InputStream)buf.in);
            value = null;
            if (len <= 0) break block12;
            value = Array.newInstance(type, len);
            if (type == Byte.TYPE || type == Byte.class) {
                buf.in.read((byte[])value);
            } else if (type == Integer.TYPE || type == Integer.class) {
                int[] val = (int[])value;
                for (int i = 0; i < len; ++i) {
                    val[i] = LessBytes.readInt((InputStream)buf.in);
                }
                value = val;
            } else if (type == Long.TYPE || type == Long.class) {
                long[] val = (long[])value;
                for (int i = 0; i < len; ++i) {
                    val[i] = LessBytes.readLong((InputStream)buf.in);
                }
                value = val;
            } else if (type.isEnum()) {
                for (int i = 0; i < len; ++i) {
                    Array.set(value, i, this.decodeEnum(type, buf));
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    Array.set(value, i, this.decodeObject(type, buf));
                }
            }
        }
        return value;
    }

    private void encodeField(Object value, CodableFieldInfo field, BufferOut buf) throws Exception {
        log.trace("encodeField: {} {} {}", new Object[]{value, field, buf});
        if (value != null) {
            try {
                buf.out.write(1);
                if (field.isArray()) {
                    this.encodeArray(value, field.getTypeOrComponentType(), buf);
                }
                if (field.isNative()) {
                    this.encodeNative(value, buf);
                }
                if (field.isMap()) {
                    Map map = (Map)value;
                    LessBytes.writeLength((long)map.size(), (OutputStream)buf.out());
                    for (Map.Entry entry : map.entrySet()) {
                        Object key = entry.getKey();
                        this.encodeObject(key, buf);
                        this.encodeObject(entry.getValue(), buf);
                    }
                }
                if (field.isCollection()) {
                    Collection coll = (Collection)value;
                    LessBytes.writeLength((long)coll.size(), (OutputStream)buf.out());
                    for (Object aColl : coll) {
                        this.encodeObject(aColl, buf);
                    }
                }
                if (field.isCodable()) {
                    this.encodeObject(value, buf);
                }
                if (field.isEnum()) {
                    this.encodeNative(value.toString(), buf);
                }
                log.warn("[encodeField] unhandled field : {} {}", value, (Object)field);
            }
            catch (Exception ex) {
                log.warn("failed encoding {} class {} type {}", new Object[]{value, value.getClass(), field, ex});
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                log.warn(sw.toString());
                throw ex;
            }
        } else {
            buf.out.write(0);
        }
    }

    private static boolean isNotConcrete(Class<?> type) {
        int mod = type.getModifiers();
        return Modifier.isAbstract(mod) || Modifier.isInterface(mod);
    }

    private static Map<Object, Object> newMap(Class<?> type) throws InstantiationException, IllegalAccessException {
        return CodecBin2.isNotConcrete(type) ? new HashMap() : (Map)type.newInstance();
    }

    private static Collection<Object> newCollection(Class<?> type, int size) throws InstantiationException, IllegalAccessException {
        return CodecBin2.isNotConcrete(type) ? new ArrayList(size) : (Collection)type.newInstance();
    }

    @Nullable
    private Object decodeField(CodableFieldInfo field, BufferIn buf) throws Exception {
        log.trace("decodeField: {} {}", (Object)field, (Object)buf);
        int ck = buf.in.read();
        if (ck == 0) {
            return null;
        }
        Class<Enum> type = field.getTypeOrComponentType();
        if (field.isArray()) {
            return this.decodeArray(type, buf);
        }
        if (field.isMap()) {
            Map<Object, Object> map = CodecBin2.newMap(type);
            int elements = (int)LessBytes.readLength((InputStream)buf.in);
            if (elements == 0) {
                return map;
            }
            Class<?> kc = field.getMapKeyClass();
            Class<?> vc = field.getMapValueClass();
            boolean ka = field.isMapKeyArray();
            boolean va = field.isMapValueArray();
            for (int i = 0; i < elements; ++i) {
                if (ka) {
                    if (va) {
                        map.put(this.decodeArray(kc, buf), this.decodeArray(vc, buf));
                        continue;
                    }
                    map.put(this.decodeArray(kc, buf), this.decodeObject(vc, buf));
                    continue;
                }
                if (va) {
                    map.put(this.decodeObject(kc, buf), this.decodeArray(vc, buf));
                    continue;
                }
                map.put(this.decodeObject(kc, buf), this.decodeObject(vc, buf));
            }
            return map;
        }
        if (field.isCollection()) {
            int elements = (int)LessBytes.readLength((InputStream)buf.in);
            Collection<Object> coll = CodecBin2.newCollection(type, elements);
            if (elements == 0) {
                return coll;
            }
            Class<?> vc = field.getCollectionClass();
            boolean va = field.isCollectionArray();
            for (int i = 0; i < elements; ++i) {
                coll.add(va ? this.decodeArray(vc, buf) : this.decodeObject(vc, buf));
            }
            return coll;
        }
        if (field.isCodable()) {
            return this.decodeObject(type, buf);
        }
        if (field.isEnum()) {
            return this.decodeEnum(type, buf);
        }
        if (field.isNative()) {
            return this.decodeNative(type, buf);
        }
        log.warn("unhandled decode {}", (Object)field);
        return null;
    }

    private void encodeNative(Object value, BufferOut buf) throws Exception {
        log.trace("encodeNative: {} {}", value, (Object)buf);
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.writeStringHelper(value.toString(), buf.out());
        } else if (type == Integer.class || type == Integer.TYPE) {
            LessBytes.writeInt((int)((Integer)value), (OutputStream)buf.out());
        } else if (type == Long.class || type == Long.TYPE) {
            LessBytes.writeLong((long)((Long)value), (OutputStream)buf.out());
        } else if (type == Short.class || type == Short.TYPE) {
            LessBytes.writeShort((short)((Short)value), (OutputStream)buf.out());
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            buf.out.write((Boolean)value != false ? 1 : 0);
        } else if (type == Float.class || type == Float.TYPE) {
            LessBytes.writeInt((int)Float.floatToIntBits(((Float)value).floatValue()), (OutputStream)buf.out());
        } else if (type == Double.class || type == Double.TYPE) {
            LessBytes.writeLong((long)Double.doubleToLongBits((Double)value), (OutputStream)buf.out());
        } else if (type == AtomicLong.class) {
            LessBytes.writeLong((long)((AtomicLong)value).get(), (OutputStream)buf.out());
        } else if (type == AtomicInteger.class) {
            LessBytes.writeInt((int)((AtomicInteger)value).get(), (OutputStream)buf.out());
        } else if (type == AtomicBoolean.class) {
            buf.out.write(((AtomicBoolean)value).get() ? 1 : 0);
        } else {
            log.warn("skip native encode for {} / {}", value, value.getClass());
        }
    }

    private Object decodeEnum(Class<Enum> type, BufferIn buf) throws Exception {
        String val = this.readStringHelper(buf.in);
        return Enum.valueOf(type, val);
    }

    @Nullable
    private Object decodeNative(Class<?> type, BufferIn buf) throws Exception {
        Object result = null;
        if (type == String.class) {
            result = this.readStringHelper(buf.in);
        } else if (type == Integer.class || type == Integer.TYPE) {
            result = LessBytes.readInt((InputStream)buf.in);
        } else if (type == Long.class || type == Long.TYPE) {
            result = LessBytes.readLong((InputStream)buf.in);
        } else if (type == Short.class || type == Short.TYPE) {
            result = LessBytes.readShort((InputStream)buf.in);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            result = buf.in.read() != 0;
        } else if (type == Double.class || type == Double.TYPE) {
            result = Double.longBitsToDouble(LessBytes.readLong((InputStream)buf.in));
        } else if (type == Float.class || type == Float.TYPE) {
            result = Float.valueOf(Float.intBitsToFloat(LessBytes.readInt((InputStream)buf.in)));
        } else if (type == AtomicLong.class) {
            result = new AtomicLong(LessBytes.readLong((InputStream)buf.in));
        } else if (type == AtomicInteger.class) {
            result = new AtomicInteger(LessBytes.readInt((InputStream)buf.in));
        } else if (type == AtomicBoolean.class) {
            result = buf.in.read() != 0 ? new AtomicBoolean(true) : new AtomicBoolean(false);
        } else {
            log.warn("unhandled native decode {}", type);
        }
        return result;
    }

    private static void require(boolean bool, String msg) throws Exception {
        if (!bool) {
            throw new Exception(msg);
        }
    }

    @Nullable
    private String readStringHelper(InputStream in) throws Exception {
        if (this.charstring) {
            return LessBytes.readCharString((InputStream)in);
        }
        return LessBytes.readString((InputStream)in);
    }

    private void writeStringHelper(String str, OutputStream out) throws Exception {
        if (this.charstring) {
            LessBytes.writeCharString((String)str, (OutputStream)out);
        } else {
            LessBytes.writeString((String)str, (OutputStream)out);
        }
    }
}

