/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;

public class CaseIgnoringEnumDeserializer
extends EnumDeserializer {
    public CaseIgnoringEnumDeserializer(EnumResolver<?> enumResolver) {
        super(enumResolver);
    }

    public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING || curr == JsonToken.FIELD_NAME || curr == JsonToken.VALUE_FALSE || curr == JsonToken.VALUE_TRUE) {
            String name = jp.getText();
            if (this._resolver.findEnum(name) != null) {
                return super.deserialize(jp, ctxt);
            }
            TextNode upperName = ctxt.getNodeFactory().textNode(name.toUpperCase());
            JsonParser treeParser = jp.getCodec().treeAsTokens((TreeNode)upperName);
            treeParser.nextToken();
            return super.deserialize(treeParser, ctxt);
        }
        return super.deserialize(jp, ctxt);
    }
}

