/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.annotations.FieldConfig;
import com.addthis.codec.annotations.Pluggable;
import com.addthis.codec.jackson.CodecTypeResolverBuilder;
import com.addthis.codec.plugins.PluginMap;
import com.addthis.codec.plugins.PluginRegistry;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecIntrospector
extends NopAnnotationIntrospector {
    private static final Logger log = LoggerFactory.getLogger(CodecIntrospector.class);
    private final PluginRegistry pluginRegistry;

    public CodecIntrospector(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        TypeResolverBuilder<?> annotationLookup = this._findTypeResolver(config, (Annotated)ac, baseType);
        if (annotationLookup != null) {
            return annotationLookup;
        }
        if (this.pluginRegistry.byClass().containsKey(ac.getRawType())) {
            PluginMap pluginMap = this.pluginRegistry.byClass().get(ac.getRawType());
            return new CodecTypeResolverBuilder(pluginMap, config.getTypeFactory(), this.pluginRegistry);
        }
        return null;
    }

    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType baseType) {
        if (baseType.isContainerType()) {
            return null;
        }
        return this._findTypeResolver(config, (Annotated)am, baseType);
    }

    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType containerType) {
        if (!containerType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + containerType + ")");
        }
        return this._findTypeResolver(config, (Annotated)am, containerType);
    }

    public TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ac, JavaType baseType) {
        Pluggable pluggable = (Pluggable)ac.getAnnotation(Pluggable.class);
        if (pluggable != null) {
            PluginMap pluginMap = this.pluginRegistry.byCategory().get(pluggable.value());
            if (pluginMap != null) {
                return new CodecTypeResolverBuilder(pluginMap, config.getTypeFactory(), this.pluginRegistry);
            }
            log.warn("missing plugin map for {}, reached from {}", (Object)pluggable.value(), (Object)ac.getRawType());
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        PluginMap pluginMap;
        Pluggable pluggable = (Pluggable)a.getAnnotation(Pluggable.class);
        if (pluggable != null) {
            pluginMap = this.pluginRegistry.byCategory().get(pluggable.value());
        } else if (this.pluginRegistry.byClass().containsKey(a.getRawType())) {
            pluginMap = this.pluginRegistry.byClass().get(a.getRawType());
        } else {
            return null;
        }
        ArrayList<NamedType> result = new ArrayList<NamedType>(pluginMap.asBiMap().size());
        for (Map.Entry type : pluginMap.asBiMap().entrySet()) {
            result.add(new NamedType((Class)type.getValue(), (String)type.getKey()));
        }
        return result;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        FieldConfig fieldConfig = (FieldConfig)m.getAnnotation(FieldConfig.class);
        if (fieldConfig != null) {
            return !fieldConfig.codable();
        }
        return false;
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        FieldConfig fieldConfig = (FieldConfig)m.getAnnotation(FieldConfig.class);
        if (fieldConfig != null) {
            return fieldConfig.required();
        }
        return null;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        FieldConfig fieldConfig = (FieldConfig)a.getAnnotation(FieldConfig.class);
        if (fieldConfig != null && !fieldConfig.writeonly() && fieldConfig.codable()) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        FieldConfig fieldConfig = (FieldConfig)a.getAnnotation(FieldConfig.class);
        if (fieldConfig != null && !fieldConfig.readonly() && fieldConfig.codable()) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }
}

