/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.config.ConfigTraversingParser;
import com.addthis.codec.jackson.DefaultCodecJackson;
import com.addthis.codec.jackson.Jackson;
import com.addthis.codec.plugins.PluginMap;
import com.addthis.codec.plugins.PluginRegistry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import io.dropwizard.validation.ConstraintViolations;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Syntax;
import javax.validation.ValidationException;
import javax.validation.Validator;

@Beta
public class CodecJackson {
    private final ObjectMapper objectMapper;
    private final PluginRegistry pluginRegistry;
    private final Config globalDefaults;
    private final Validator validator;

    public CodecJackson(ObjectMapper objectMapper, PluginRegistry pluginRegistry, Config globalDefaults, Validator validator) {
        this.objectMapper = objectMapper;
        this.pluginRegistry = pluginRegistry;
        this.globalDefaults = globalDefaults;
        this.validator = validator;
    }

    public CodecJackson withConfig(Config newGlobalDefaults) {
        if (newGlobalDefaults == this.globalDefaults) {
            return this;
        }
        PluginRegistry newPluginRegistry = new PluginRegistry(newGlobalDefaults);
        ObjectMapper newObjectMapper = Jackson.newObjectMapper(newPluginRegistry);
        return new CodecJackson(newObjectMapper, newPluginRegistry, newGlobalDefaults, this.validator);
    }

    public CodecJackson withOverrides(Config overrides) {
        if (overrides == this.globalDefaults) {
            return this;
        }
        PluginRegistry newPluginRegistry = this.pluginRegistry.withOverrides(overrides);
        ObjectMapper newObjectMapper = Jackson.newObjectMapper(newPluginRegistry);
        return new CodecJackson(newObjectMapper, newPluginRegistry, overrides, this.validator);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public Config getGlobalDefaults() {
        return this.globalDefaults;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public <T> T newDefault(@Nonnull Class<T> type) throws JsonProcessingException, IOException {
        Object value = this.objectMapper.treeToValue((TreeNode)DefaultCodecJackson.DEFAULT_MAPPER.createObjectNode(), type);
        return (T)this.validate(value);
    }

    public <T> T decodeObject(@Nonnull Class<T> type, ConfigValue configValue) throws JsonProcessingException, IOException {
        ConfigTraversingParser configParser = new ConfigTraversingParser(configValue, (ObjectCodec)this.objectMapper);
        return (T)this.validate(configParser.readValueAs(type));
    }

    public <T> T decodeObject(@Nonnull Class<T> type, JsonNode jsonNode) throws JsonProcessingException {
        return (T)this.validate(this.objectMapper.treeToValue((TreeNode)jsonNode, type));
    }

    public <T> T newDefault(@Nonnull String category) throws JsonProcessingException, IOException {
        Class<?> type = this.pluginRegistry.byCategory().get(category).baseClass();
        return (T)this.newDefault(type);
    }

    public <T> T decodeObject(@Nonnull String category, @Syntax(value="HOCON") String configText) throws JsonProcessingException, IOException {
        PluginMap pluginMap = (PluginMap)Preconditions.checkNotNull((Object)this.pluginRegistry.asMap().get(category), (String)"could not find anything about the category %s", (Object[])new Object[]{category});
        Config config = ConfigFactory.parseString((String)configText).resolve();
        return (T)this.decodeObject(pluginMap.baseClass(), config);
    }

    public <T> T decodeObject(@Nonnull Class<T> type, @Syntax(value="HOCON") String configText) throws JsonProcessingException, IOException {
        Config config = ConfigFactory.parseString((String)configText).resolve();
        return this.decodeObject(type, config);
    }

    public <T> T decodeObject(@Nonnull String category, @Nonnull Config config) throws JsonProcessingException, IOException {
        PluginMap pluginMap = (PluginMap)Preconditions.checkNotNull((Object)this.pluginRegistry.asMap().get(category), (String)"could not find anything about the category %s", (Object[])new Object[]{category});
        return (T)this.decodeObject(pluginMap.baseClass(), config);
    }

    public <T> T decodeObject(@Nonnull Class<T> type, Config config) throws JsonProcessingException, IOException {
        return this.decodeObject(type, (ConfigValue)config.root());
    }

    public <T> T decodeObject(@Syntax(value="HOCON") String configText) throws JsonProcessingException, IOException {
        Config config = ConfigFactory.parseString((String)configText).resolve();
        return this.decodeObject(config);
    }

    public <T> T decodeObject(Config config) throws JsonProcessingException, IOException {
        if (config.root().size() != 1) {
            throw new ConfigException.Parse(config.root().origin(), "config root must have exactly one key");
        }
        String category = (String)config.root().keySet().iterator().next();
        PluginMap pluginMap = this.pluginRegistry.asMap().get(category);
        if (pluginMap == null) {
            throw new ConfigException.BadValue(config.root().get((Object)category).origin(), category, "top level key must be a valid category");
        }
        ConfigValue configValue = config.root().get((Object)category);
        return (T)this.decodeObject(pluginMap.baseClass(), configValue);
    }

    public <T> T validate(T value) {
        Set violations = this.validator.validate(value, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ValidationException(ConstraintViolations.format((Set)violations).toString());
        }
        return value;
    }
}

