/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.jackson.CodecTypeIdResolver;
import com.addthis.codec.jackson.Jackson;
import com.addthis.codec.plugins.PluginMap;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;

public class CodecTypeDeserializer
extends TypeDeserializerBase {
    private final PluginMap pluginMap;
    private final JsonTypeInfo.As inludeAs;
    private final CodecTypeIdResolver idRes;

    protected CodecTypeDeserializer(PluginMap pluginMap, JsonTypeInfo.As inludeAs, JavaType baseType, CodecTypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, Class<?> defaultImpl) {
        super(baseType, (TypeIdResolver)idRes, typePropertyName, typeIdVisible, defaultImpl);
        this.pluginMap = pluginMap;
        this.inludeAs = inludeAs;
        this.idRes = idRes;
    }

    protected CodecTypeDeserializer(CodecTypeDeserializer src, BeanProperty property) {
        super((TypeDeserializerBase)src, property);
        this.pluginMap = src.pluginMap;
        this.inludeAs = src.inludeAs;
        this.idRes = src.idRes;
    }

    public CodecTypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new CodecTypeDeserializer(this, prop);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return this.inludeAs;
    }

    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.deserializeTypedFromAny(jp, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.deserializeTypedFromAny(jp, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.deserializeTypedFromAny(jp, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (jp.canReadTypeId() && (typeId = jp.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jp, ctxt, typeId);
        }
        JsonLocation currentLocation = jp.getTokenLocation();
        Object jsonNode = jp.getCurrentToken() == JsonToken.END_OBJECT ? ctxt.getNodeFactory().objectNode() : (JsonNode)jp.readValueAsTree();
        ObjectCodec objectCodec = jp.getCodec();
        try {
            Object bean = null;
            if (jsonNode.isArray()) {
                bean = this._deserializeTypedFromArray((ArrayNode)jsonNode, objectCodec, ctxt);
            } else if (jsonNode.isObject()) {
                bean = this._deserializeTypedFromObject((ObjectNode)jsonNode, objectCodec, ctxt);
            }
            if (bean != null) {
                return bean;
            }
            JsonDeserializer deser = this._findDeserializer(ctxt, null);
            JsonParser treeParser = jp.getCodec().treeAsTokens((TreeNode)jsonNode);
            treeParser.nextToken();
            return deser.deserialize(treeParser, ctxt);
        }
        catch (JsonMappingException ex) {
            throw Jackson.maybeImproveLocation(currentLocation, ex);
        }
    }

    @Nullable
    public Object _deserializeTypedFromObject(ObjectNode objectNode, ObjectCodec objectCodec, DeserializationContext ctxt) throws IOException {
        Object bean;
        if (objectNode.hasNonNull(this._typePropertyName)) {
            return this._deserializeObjectFromProperty(objectNode, objectCodec, ctxt);
        }
        String singleKeyName = this.getSingleKeyIfPresent(objectNode);
        if (singleKeyName != null && (bean = this._deserializeObjectFromSingleKey(objectNode, singleKeyName, objectCodec, ctxt)) != null) {
            return bean;
        }
        bean = this._deserializeObjectFromInlinedType(objectNode, objectCodec, ctxt);
        if (bean != null) {
            return bean;
        }
        if (this.idRes.isValidTypeId("_default")) {
            ConfigObject aliasDefaults = this.pluginMap.aliasDefaults("_default");
            JsonDeserializer deser = this._findDeserializer(ctxt, "_default");
            boolean unwrapPrimary = this.handleDefaultsAndImplicitPrimary(objectNode, aliasDefaults, deser, ctxt);
            try {
                JsonParser treeParser = objectCodec.treeAsTokens((TreeNode)objectNode);
                treeParser.nextToken();
                bean = deser.deserialize(treeParser, ctxt);
            }
            catch (IOException cause) {
                if (unwrapPrimary) {
                    throw Jackson.maybeUnwrapPath((String)aliasDefaults.get((Object)"_primary").unwrapped(), cause);
                }
                throw cause;
            }
        }
        return bean;
    }

    @Nullable
    private String getSingleKeyIfPresent(ObjectNode objectNode) {
        Iterator fieldNames = objectNode.fieldNames();
        String singleKey = null;
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (singleKey == null || singleKey.charAt(0) == '_') {
                singleKey = fieldName;
                continue;
            }
            if (fieldName.charAt(0) == '_') continue;
            return null;
        }
        return singleKey;
    }

    @Nullable
    private Object _deserializeObjectFromInlinedType(ObjectNode objectNode, ObjectCodec objectCodec, DeserializationContext ctxt) throws IOException {
        String matched = null;
        for (String alias : this.pluginMap.inlinedAliases()) {
            if (objectNode.get(alias) == null) continue;
            if (matched != null) {
                String message = String.format("no type specified, more than one key, and both %s and %s match for inlined types.", matched, alias);
                JsonMappingException exception = ctxt.instantiationException(this._baseType.getRawClass(), message);
                exception.prependPath((Object)this._baseType, matched);
                throw exception;
            }
            matched = alias;
        }
        if (matched != null) {
            ConfigObject aliasDefaults = this.pluginMap.aliasDefaults(matched);
            JsonNode configValue = objectNode.get(matched);
            String primaryField = (String)aliasDefaults.get((Object)"_primary").unwrapped();
            objectNode.remove(matched);
            Jackson.setAt(objectNode, configValue, primaryField);
            Jackson.merge(objectNode, Jackson.configConverter(aliasDefaults));
            if (this._typeIdVisible) {
                objectNode.put(this._typePropertyName, matched);
            }
            try {
                JsonDeserializer deser = this._findDeserializer(ctxt, matched);
                JsonParser treeParser = objectCodec.treeAsTokens((TreeNode)objectNode);
                treeParser.nextToken();
                return deser.deserialize(treeParser, ctxt);
            }
            catch (IOException cause) {
                IOException unwrapped = Jackson.maybeUnwrapPath(primaryField, cause);
                if (unwrapped != cause) {
                    throw JsonMappingException.wrapWithPath((Throwable)unwrapped, (Object)this.idRes.typeFromId(matched), (String)matched);
                }
                throw unwrapped;
            }
        }
        return null;
    }

    @Nullable
    private Object _deserializeObjectFromSingleKey(ObjectNode objectNode, String singleKeyName, ObjectCodec objectCodec, DeserializationContext ctxt) throws IOException {
        if (this.idRes.isValidTypeId(singleKeyName)) {
            ConfigObject aliasDefaults = this.pluginMap.aliasDefaults(singleKeyName);
            String primaryField = aliasDefaults.containsKey((Object)"_primary") ? (String)aliasDefaults.get((Object)"_primary").unwrapped() : null;
            boolean unwrapPrimary = false;
            try {
                ObjectNode singleKeyObject;
                JsonNode singleKeyValue = objectNode.get(singleKeyName);
                JsonDeserializer deser = this._findDeserializer(ctxt, singleKeyName);
                if (!singleKeyValue.isObject()) {
                    if (primaryField != null) {
                        singleKeyObject = (ObjectNode)objectCodec.createObjectNode();
                        Jackson.setAt(singleKeyObject, singleKeyValue, primaryField);
                        Jackson.merge(singleKeyObject, Jackson.configConverter(aliasDefaults));
                        singleKeyValue = singleKeyObject;
                        unwrapPrimary = true;
                    }
                } else {
                    singleKeyObject = (ObjectNode)singleKeyValue;
                    unwrapPrimary = this.handleDefaultsAndImplicitPrimary(singleKeyObject, aliasDefaults, deser, ctxt);
                }
                if (this._typeIdVisible && singleKeyValue.isObject()) {
                    ((ObjectNode)singleKeyValue).put(this._typePropertyName, singleKeyName);
                }
                JsonParser treeParser = objectCodec.treeAsTokens((TreeNode)singleKeyValue);
                treeParser.nextToken();
                return deser.deserialize(treeParser, ctxt);
            }
            catch (IOException cause) {
                if (unwrapPrimary) {
                    cause = Jackson.maybeUnwrapPath(primaryField, cause);
                }
                throw JsonMappingException.wrapWithPath((Throwable)cause, (Object)this.idRes.typeFromId(singleKeyName), (String)singleKeyName);
            }
            catch (Throwable cause) {
                throw JsonMappingException.wrapWithPath((Throwable)cause, (Object)this.idRes.typeFromId(singleKeyName), (String)singleKeyName);
            }
        }
        return null;
    }

    private Object _deserializeObjectFromProperty(ObjectNode objectNode, ObjectCodec objectCodec, DeserializationContext ctxt) throws IOException {
        JsonDeserializer deser;
        String type = objectNode.get(this._typePropertyName).asText();
        if (!this._typeIdVisible) {
            objectNode.remove(this._typePropertyName);
        }
        try {
            deser = this._findDeserializer(ctxt, type);
        }
        catch (Throwable cause) {
            throw JsonMappingException.wrapWithPath((Throwable)cause, Class.class, (String)this._typePropertyName);
        }
        ConfigObject aliasDefaults = this.pluginMap.aliasDefaults(type);
        String primaryField = aliasDefaults.containsKey((Object)"_primary") ? (String)aliasDefaults.get((Object)"_primary").unwrapped() : null;
        boolean unwrapPrimary = this.handleDefaultsAndImplicitPrimary(objectNode, aliasDefaults, deser, ctxt);
        try {
            JsonParser treeParser = objectCodec.treeAsTokens((TreeNode)objectNode);
            treeParser.nextToken();
            return deser.deserialize(treeParser, ctxt);
        }
        catch (IOException cause) {
            if (unwrapPrimary) {
                throw Jackson.maybeUnwrapPath(primaryField, cause);
            }
            throw cause;
        }
    }

    @Nullable
    private Object _deserializeTypedFromArray(ArrayNode arrayNode, ObjectCodec objectCodec, DeserializationContext ctxt) throws IOException {
        if (this.idRes.isValidTypeId("_array")) {
            Config aliasDefaults = this.pluginMap.aliasDefaults("_array").toConfig();
            String arrayField = aliasDefaults.getString("_primary");
            try {
                ObjectNode objectFieldValues = (ObjectNode)objectCodec.createObjectNode();
                Jackson.setAt(objectFieldValues, (JsonNode)arrayNode, arrayField);
                ObjectNode aliasFieldDefaults = Jackson.configConverter(aliasDefaults.root());
                Jackson.merge(objectFieldValues, aliasFieldDefaults);
                JsonDeserializer deser = this._findDeserializer(ctxt, "_array");
                JsonParser treeParser = objectCodec.treeAsTokens((TreeNode)objectFieldValues);
                treeParser.nextToken();
                return deser.deserialize(treeParser, ctxt);
            }
            catch (IOException ex) {
                throw Jackson.maybeUnwrapPath(arrayField, ex);
            }
        }
        return null;
    }

    private boolean handleDefaultsAndImplicitPrimary(ObjectNode fieldValues, ConfigObject aliasDefaults, JsonDeserializer<?> deserializer, DeserializationContext ctxt) throws JsonMappingException {
        if (!aliasDefaults.isEmpty()) {
            if (deserializer instanceof DelegatingDeserializer) {
                deserializer = ((DelegatingDeserializer)deserializer).getDelegatee();
            }
            if (deserializer instanceof BeanDeserializerBase && aliasDefaults.get((Object)"_primary") != null) {
                TypeDeserializer primaryTypeDeserializer;
                SettableBeanProperty primaryProperty;
                BeanDeserializerBase beanDeserializer = (BeanDeserializerBase)deserializer;
                String primaryField = (String)aliasDefaults.get((Object)"_primary").unwrapped();
                if (!fieldValues.has(primaryField) && (primaryProperty = beanDeserializer.findProperty(primaryField)) != null && primaryProperty.hasValueTypeDeserializer() && (primaryTypeDeserializer = primaryProperty.getValueTypeDeserializer()) instanceof CodecTypeDeserializer) {
                    CodecTypeIdResolver primaryPropertyTypeIdResolver = ((CodecTypeDeserializer)primaryTypeDeserializer).idRes;
                    String possibleInlinedPrimary = null;
                    Iterator fieldNames = fieldValues.fieldNames();
                    while (fieldNames.hasNext()) {
                        String fieldName = (String)fieldNames.next();
                        if (fieldName.charAt(0) == '_' || beanDeserializer.hasProperty(fieldName) || !primaryPropertyTypeIdResolver.isValidTypeId(fieldName)) continue;
                        if (possibleInlinedPrimary == null) {
                            possibleInlinedPrimary = fieldName;
                            continue;
                        }
                        String message = String.format("%s and %s are both otherwise unknown properties that could be types for the _primary property %s whose category is %s. This is too ambiguous to resolve.", possibleInlinedPrimary, fieldName, primaryField, ((CodecTypeDeserializer)primaryTypeDeserializer).pluginMap.category());
                        JsonMappingException ex = ctxt.instantiationException(this._baseType.getRawClass(), message);
                        ex.prependPath((Object)beanDeserializer.getValueType(), fieldName);
                        throw ex;
                    }
                    if (possibleInlinedPrimary != null) {
                        JsonNode inlinedPrimaryValue = fieldValues.remove(possibleInlinedPrimary);
                        fieldValues.with(primaryField).set(possibleInlinedPrimary, inlinedPrimaryValue);
                        Jackson.merge(fieldValues, Jackson.configConverter(aliasDefaults));
                        return true;
                    }
                }
            }
            Jackson.merge(fieldValues, Jackson.configConverter(aliasDefaults));
        }
        return false;
    }
}

