/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.json;

import com.addthis.codec.Codec;
import com.addthis.codec.jackson.Jackson;
import com.addthis.maljson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecJSON
implements Codec {
    private static final Logger log = LoggerFactory.getLogger(CodecJSON.class);
    public static final CodecJSON INSTANCE = new CodecJSON();

    private CodecJSON() {
    }

    @Override
    public byte[] encode(Object obj) throws Exception {
        return Jackson.defaultCodec().getObjectMapper().writeValueAsBytes(obj);
    }

    @Override
    public <T> T decode(T shell, byte[] data) throws IOException {
        return (T)Jackson.defaultCodec().getObjectMapper().readerForUpdating(shell).readValue(data);
    }

    @Override
    public <T> T decode(Class<T> type, byte[] data) throws Exception {
        return (T)Jackson.defaultCodec().getObjectMapper().reader(type).readValue(data);
    }

    @Override
    public boolean storesNull(byte[] data) {
        throw new UnsupportedOperationException();
    }

    public static JsonNode encodeJsonNode(Object object) throws Exception {
        return Jackson.defaultCodec().getObjectMapper().valueToTree(object);
    }

    @Deprecated
    public static JSONObject encodeJSON(Object object) throws Exception {
        return new JSONObject(Jackson.defaultCodec().getObjectMapper().writeValueAsString(object));
    }

    public static String encodeString(Object object) throws JsonProcessingException {
        return Jackson.defaultCodec().getObjectMapper().writeValueAsString(object);
    }

    public static String tryEncodeString(Object object, String defaultValue) {
        try {
            return Jackson.defaultCodec().getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            return defaultValue;
        }
    }

    @Deprecated
    public static <T> T decodeString(T object, String json) throws IOException {
        return (T)Jackson.defaultCodec().getObjectMapper().readerForUpdating(object).readValue(json);
    }

    public static <T> T decodeString(Class<T> type, String json) throws IOException {
        return (T)Jackson.defaultCodec().getObjectMapper().reader(type).readValue(json);
    }

    public static <T> T decodeJSON(T object, JsonNode json) throws IOException {
        return (T)Jackson.defaultCodec().getObjectMapper().readerForUpdating(object).readValue(json);
    }
}

