/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.plugins;

import com.addthis.codec.annotations.Pluggable;
import com.addthis.codec.plugins.DefaultRegistry;
import com.addthis.codec.plugins.PluginMap;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class PluginRegistry {
    private static final Logger log = LoggerFactory.getLogger(PluginRegistry.class);
    public static final String PLUGIN_DEFAULTS_PATH = "addthis.codec.plugins.defaults";
    public static final String PLUGINS_PATH_PATH = "addthis.codec.plugins.path";
    @Nonnull
    private final Map<String, PluginMap> pluginMapsByCategory;
    @Nonnull
    private final BiMap<Class<?>, PluginMap> pluginMapsByClass;
    @Nonnull
    private final Config config;

    public static PluginRegistry defaultRegistry() {
        return DefaultRegistry.DEFAULT;
    }

    public PluginRegistry(@Nonnull Config config) {
        this.config = config;
        Config defaultPluginMapSettings = config.getConfig(PLUGIN_DEFAULTS_PATH);
        String pluginPath = config.getString(PLUGINS_PATH_PATH);
        Config pluginConfigs = config.getConfig(pluginPath);
        Set categories = pluginConfigs.root().keySet();
        HashMap<String, PluginMap> mapsFromConfig = new HashMap<String, PluginMap>(categories.size());
        HashBiMap mapsFromConfigByClass = HashBiMap.create((int)categories.size());
        for (String category : categories) {
            Config pluginConfig = pluginConfigs.getConfig(category).withFallback((ConfigMergeable)defaultPluginMapSettings);
            PluginMap pluginMap = new PluginMap(category, pluginConfig);
            mapsFromConfig.put(category, pluginMap);
            Class<?> baseClass = pluginMap.baseClass();
            if (baseClass == null) continue;
            if (mapsFromConfigByClass.containsKey(baseClass)) {
                AnnotatedClass annotatedClass = AnnotatedClass.construct(baseClass, (AnnotationIntrospector)new JacksonAnnotationIntrospector(), null);
                String existingCategory = ((PluginMap)mapsFromConfigByClass.get(baseClass)).category();
                if (annotatedClass.hasAnnotation(Pluggable.class) && ((Pluggable)annotatedClass.getAnnotation(Pluggable.class)).value().equals(existingCategory)) continue;
                mapsFromConfigByClass.put(pluginMap.baseClass(), (Object)pluginMap);
                continue;
            }
            mapsFromConfigByClass.put(pluginMap.baseClass(), (Object)pluginMap);
        }
        this.pluginMapsByCategory = Collections.unmodifiableMap(mapsFromConfig);
        this.pluginMapsByClass = Maps.unmodifiableBiMap((BiMap)mapsFromConfigByClass);
    }

    private PluginRegistry(@Nonnull Config config, @Nonnull Map<String, PluginMap> pluginMapsByCategory, @Nonnull BiMap<Class<?>, PluginMap> pluginMapsByClass) {
        this.config = config;
        this.pluginMapsByCategory = pluginMapsByCategory;
        this.pluginMapsByClass = pluginMapsByClass;
    }

    public PluginRegistry withOverrides(Config overrides) {
        Config newConfig = overrides.withFallback((ConfigMergeable)this.config);
        String pluginPath = this.config.getString(PLUGINS_PATH_PATH);
        if (overrides.hasPath(PLUGIN_DEFAULTS_PATH) || overrides.hasPath(PLUGINS_PATH_PATH) || overrides.hasPath(pluginPath)) {
            return new PluginRegistry(newConfig);
        }
        return new PluginRegistry(newConfig, this.pluginMapsByCategory, this.pluginMapsByClass);
    }

    public Config config() {
        return this.config;
    }

    public Map<String, PluginMap> asMap() {
        return this.pluginMapsByCategory;
    }

    public Map<String, PluginMap> byCategory() {
        return this.pluginMapsByCategory;
    }

    public Map<Class<?>, PluginMap> byClass() {
        return this.pluginMapsByClass;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config.origin", (Object)this.config.origin()).add("pluginMapsByCategory", this.pluginMapsByCategory).add("pluginMapsByClass", this.pluginMapsByClass).toString();
    }
}

