/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.reflection;

import com.addthis.codec.annotations.FieldConfig;
import com.addthis.codec.codables.Codable;
import com.addthis.codec.reflection.Fields;
import com.addthis.codec.reflection.RequiredFieldException;
import com.google.common.annotations.Beta;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class CodableFieldInfo {
    private static final Logger log = LoggerFactory.getLogger(CodableFieldInfo.class);
    public static final int ARRAY = 1;
    public static final int CODABLE = 2;
    public static final int COLLECTION = 4;
    public static final int GENERIC = 8;
    public static final int NATIVE = 16;
    public static final int MAP = 32;
    public static final int NUMBER = 64;
    public static final int REQUIRED = 128;
    public static final int READONLY = 256;
    public static final int WRITEONLY = 512;
    public static final int ENUM = 1024;
    @Nonnull
    private final Field field;
    @Nonnull
    private final Class<?> typeOrComponentType;
    private final int bits;
    @Nullable
    private final FieldConfig fieldConfig;
    @Nullable
    private final Type[] genTypes;
    @Nullable
    private final boolean[] genArray;

    public CodableFieldInfo(@Nonnull Field field) {
        this.field = field;
        field.setAccessible(true);
        this.fieldConfig = field.getAnnotation(FieldConfig.class);
        Class<?> type = field.getType();
        boolean array = type.isArray();
        if (array) {
            this.typeOrComponentType = type.getComponentType();
            this.bits = this.cacheFlags(1);
        } else {
            this.typeOrComponentType = type;
            this.bits = this.cacheFlags(0);
        }
        this.genTypes = !Fields.isNative(this.typeOrComponentType) ? Fields.collectTypes(this.typeOrComponentType, field.getGenericType()) : null;
        if (this.genTypes == null) {
            this.genArray = null;
        } else {
            this.genArray = new boolean[this.genTypes.length];
            this.mutateGenericTypes(this.genTypes, this.genArray);
        }
    }

    private int cacheFlags(int externalBits) {
        int partialBits = externalBits;
        if (Codable.class.isAssignableFrom(this.typeOrComponentType)) {
            partialBits |= 2;
        }
        if (Collection.class.isAssignableFrom(this.typeOrComponentType)) {
            partialBits |= 4;
        }
        if (Map.class.isAssignableFrom(this.typeOrComponentType)) {
            partialBits |= 0x20;
        }
        if (this.typeOrComponentType.isEnum()) {
            partialBits |= 0x400;
        }
        if (Number.class.isAssignableFrom(this.typeOrComponentType)) {
            partialBits |= 0x40;
        }
        if (Fields.isNative(this.typeOrComponentType)) {
            partialBits |= 0x10;
        }
        if (this.fieldConfig != null) {
            if (this.fieldConfig.readonly()) {
                partialBits |= 0x100;
            }
            if (this.fieldConfig.writeonly()) {
                partialBits |= 0x200;
            }
            if (this.fieldConfig.codable()) {
                partialBits |= 2;
            }
            if (this.fieldConfig.required()) {
                partialBits |= 0x80;
            }
        }
        return partialBits;
    }

    @Nonnull
    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    @Nonnull
    public Class<?> getTypeOrComponentType() {
        return this.typeOrComponentType;
    }

    @Nullable
    public Type[] getGenericTypes() {
        return this.genTypes;
    }

    private void mutateGenericTypes(@Nonnull Type[] collectedTypes, @Nonnull boolean[] genericFlags) {
        for (int i = 0; i < collectedTypes.length; ++i) {
            Type currentType = collectedTypes[i];
            if (currentType instanceof GenericArrayType) {
                genericFlags[i] = true;
                collectedTypes[i] = ((GenericArrayType)currentType).getGenericComponentType();
                continue;
            }
            if (currentType instanceof Class && ((Class)currentType).isArray()) {
                genericFlags[i] = true;
                collectedTypes[i] = ((Class)currentType).getComponentType();
                continue;
            }
            genericFlags[i] = false;
        }
    }

    public Object newInstance() throws Exception {
        return this.typeOrComponentType.newInstance();
    }

    @Nullable
    public Class<?> getCollectionClass() {
        return this.genTypes != null && this.genTypes.length == 1 ? (Class)this.genTypes[0] : null;
    }

    @Nullable
    public Class<?> getMapKeyClass() {
        return this.genTypes != null && this.genTypes.length == 2 ? (Class)this.genTypes[0] : null;
    }

    @Nullable
    public Class<?> getMapValueClass() {
        return this.genTypes != null && this.genTypes.length == 2 ? (Class)this.genTypes[1] : null;
    }

    public boolean isCollectionArray() {
        return this.genArray != null && this.genArray.length == 1 ? this.genArray[0] : false;
    }

    public boolean isMapKeyArray() {
        return this.genArray != null && this.genArray.length == 2 ? this.genArray[0] : false;
    }

    public boolean isMapValueArray() {
        return this.genArray != null && this.genArray.length == 2 ? this.genArray[1] : false;
    }

    public Object get(Object src) {
        try {
            return this.field.get(src);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStrict(@Nonnull Object dst, @Nullable Object value) throws IllegalAccessException {
        if (value == null) {
            if (this.isRequired()) {
                throw new RequiredFieldException("missing required field '" + this.getName() + "' for " + dst, this.getName());
            }
            return;
        }
        this.field.set(dst, value);
    }

    public void set(@Nonnull Object dst, @Nullable Object value) {
        if (value == null) {
            if (this.isRequired() && this.get(dst) == null) {
                throw new RequiredFieldException("missing required field '" + this.getName() + "' for " + dst, this.getName());
            }
            return;
        }
        try {
            this.field.set(dst, value);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn("error setting ({})({}) on ({}) in {}", new Object[]{value, value.getClass(), dst, this.toString()});
            throw new RuntimeException(ex);
        }
    }

    public boolean isArray() {
        return (this.bits & 1) == 1;
    }

    public boolean isCodable() {
        return (this.bits & 2) == 2;
    }

    public boolean isCollection() {
        return (this.bits & 4) == 4;
    }

    public boolean isGeneric() {
        return (this.bits & 8) == 8;
    }

    public boolean isMap() {
        return (this.bits & 0x20) == 32;
    }

    public boolean isEnum() {
        return (this.bits & 0x400) == 1024;
    }

    public boolean isNative() {
        return (this.bits & 0x10) == 16;
    }

    public boolean isRequired() {
        return (this.bits & 0x80) == 128;
    }

    public boolean isReadOnly() {
        return (this.bits & 0x100) == 256;
    }

    public boolean isWriteOnly() {
        return (this.bits & 0x200) == 512;
    }

    public String toString() {
        return "[" + this.getName() + "," + this.typeOrComponentType + (this.isArray() ? "[]," : ",") + Integer.toString(this.bits, 2) + "]";
    }
}

