/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.utils;

import com.addthis.codec.annotations.Time;
import com.addthis.codec.utils.SizeGauge;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.MoreExecutors;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@JsonDeserialize(builder=ExecutorServiceBuilder.class)
@Beta
public class ExecutorServiceBuilder {
    private final ThreadFactory threadFactory;
    private final int coreThreads;
    private final int maxThreads;
    private final int keepAlive;
    private final BlockingQueue<Runnable> queue;
    private final boolean shutdownHook;

    @JsonCreator
    public ExecutorServiceBuilder(@JsonProperty(value="thread-factory") ThreadFactory threadFactory, @JsonProperty(value="core-threads") int coreThreads, @JsonProperty(value="max-threads") int maxThreads, @JsonProperty(value="keep-alive") @Time(value=TimeUnit.MILLISECONDS) int keepAlive, @JsonProperty(value="queue-size") int queueSize, @JsonProperty(value="queue-gauge-class") Class<?> gaugeClass, @JsonProperty(value="queue-gauge-name") String gaugeName, @JsonProperty(value="shutdown-hook") boolean shutdownHook) {
        this.threadFactory = threadFactory;
        this.coreThreads = coreThreads;
        this.maxThreads = maxThreads;
        this.keepAlive = keepAlive;
        this.queue = new LinkedBlockingQueue<Runnable>(queueSize);
        if (gaugeClass != null && gaugeName != null) {
            Metrics.newGauge(gaugeClass, (String)gaugeName, (Gauge)new SizeGauge(this.queue));
        }
        this.shutdownHook = shutdownHook;
    }

    public ExecutorService build() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(this.coreThreads, this.maxThreads, (long)this.keepAlive, TimeUnit.MILLISECONDS, this.queue, this.threadFactory);
        if (this.shutdownHook) {
            return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)service);
        }
        return service;
    }
}

