/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.maljson;

import com.addthis.maljson.LineNumberInfo;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class JSONException
extends Exception {
    @Nonnull
    private final LineNumberInfo[] lineNumberInfo;

    private static LineNumberInfo[] filterMissingInfo(LineNumberInfo[] input) {
        ArrayList<LineNumberInfo> info = new ArrayList<LineNumberInfo>();
        for (LineNumberInfo element : input) {
            if (LineNumberInfo.MissingInfo.equals(element)) continue;
            info.add(element);
        }
        return info.toArray(new LineNumberInfo[info.size()]);
    }

    private static String generateLineInfoString(LineNumberInfo ... info) {
        info = JSONException.filterMissingInfo(info);
        StringBuilder builder = new StringBuilder();
        builder.append(" at ");
        for (int i = 0; i < info.length; ++i) {
            LineNumberInfo current = info[i];
            if (i > 0) {
                if (i == info.length - 1) {
                    builder.append(" and ");
                } else {
                    builder.append(", ");
                }
            }
            builder.append("line " + (current.getLine() + 1));
            builder.append(" and column " + (current.getColumn() + 1));
        }
        return builder.toString();
    }

    public JSONException(String s) {
        super(s);
        this.lineNumberInfo = new LineNumberInfo[1];
        this.lineNumberInfo[0] = LineNumberInfo.MissingInfo;
    }

    public JSONException(String s, LineNumberInfo lineInfo) {
        super(lineInfo == LineNumberInfo.MissingInfo ? s : s + JSONException.generateLineInfoString(lineInfo));
        this.lineNumberInfo = new LineNumberInfo[1];
        this.lineNumberInfo[0] = lineInfo;
    }

    public JSONException(String s, LineNumberInfo ... lineInfo) {
        super(s + JSONException.generateLineInfoString(lineInfo));
        this.lineNumberInfo = lineInfo;
    }

    public int getLine() {
        return this.getLine(0);
    }

    public int getColumn() {
        return this.getColumn(0);
    }

    public int getLine(int pos) {
        return this.lineNumberInfo[pos].line;
    }

    public int getColumn(int pos) {
        return this.lineNumberInfo[pos].column;
    }

    public int getLineNumberInfoSize() {
        return this.lineNumberInfo.length;
    }
}

