/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.maljson;

import com.addthis.maljson.JSONArray;
import com.addthis.maljson.JSONException;
import com.addthis.maljson.JSONObject;
import com.addthis.maljson.LineNumberInfo;

public class JSONTokener {
    private final String in;
    private final boolean allowDuplicates;
    private int pos;
    private int line;
    private int col;
    private static final JSONException sentinel = new JSONException("Expected literal value");

    public JSONTokener(String in) {
        this(in, true);
    }

    public JSONTokener(String in, boolean allowDuplicates) {
        if (in != null && in.startsWith("\ufeff")) {
            in = in.substring(1);
        }
        this.in = in;
        this.allowDuplicates = allowDuplicates;
    }

    public Object nextValue() throws JSONException {
        return this.nextValue(false);
    }

    Object nextValue(boolean returnSentinel) throws JSONException {
        int c = this.nextCleanInternal();
        switch (c) {
            case -1: {
                throw this.syntaxError("End of input");
            }
            case 123: {
                return this.readObject();
            }
            case 91: {
                return this.readArray();
            }
            case 34: 
            case 39: {
                return this.nextString((char)c);
            }
        }
        this.back();
        Object literal = this.readLiteral();
        if (!returnSentinel && literal == sentinel) {
            throw this.syntaxError("Expected literal value");
        }
        return literal;
    }

    private int nextCleanInternal() throws JSONException {
        return this.nextCleanConsume(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextCleanConsume(boolean consume) throws JSONException {
        try {
            while (this.pos < this.in.length()) {
                char c = this.in.charAt(this.pos);
                block4 : switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '/': {
                        if (this.pos == this.in.length()) {
                            char c2 = c;
                            return c2;
                        }
                        char peek = this.peek();
                        switch (peek) {
                            case '*': {
                                int commentEnd = this.in.indexOf("*/", this.pos);
                                if (commentEnd == -1) {
                                    throw this.syntaxError("Unterminated comment");
                                }
                                this.skipToPosition(commentEnd + 1);
                                break block4;
                            }
                            case '/': {
                                this.skipToEndOfLine();
                                break block4;
                            }
                        }
                        char c3 = c;
                        return c3;
                    }
                    case '#': {
                        this.skipToEndOfLine();
                        break;
                    }
                    default: {
                        char c4 = c;
                        return c4;
                    }
                }
                this.advance();
            }
        }
        finally {
            if (consume) {
                this.advance();
            }
        }
        return -1;
    }

    private void skipToEndOfLine() {
        char c;
        while (this.pos < this.in.length() && (c = this.peek()) != '\r' && c != '\n') {
            this.advance();
        }
    }

    public String nextString(char quote) throws JSONException {
        StringBuilder builder = null;
        int start = this.pos;
        while (this.pos < this.in.length()) {
            char c = this.advance();
            if (c == quote) {
                if (builder == null) {
                    return new String(this.in.substring(start, this.pos - 1));
                }
                builder.append(this.in, start, this.pos - 1);
                return builder.toString();
            }
            if (c != '\\') continue;
            if (this.pos == this.in.length()) {
                this.back();
                throw this.syntaxError("Unterminated escape sequence");
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.in, start, this.pos - 1);
            builder.append(this.readEscapeCharacter());
            start = this.pos;
        }
        this.back(this.pos - start);
        throw this.syntaxError("Unterminated string");
    }

    private char readEscapeCharacter() throws JSONException {
        char escaped = this.advance();
        switch (escaped) {
            case 'u': {
                if (this.pos + 4 > this.in.length()) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String hex = this.in.substring(this.pos, this.pos + 4);
                this.skipToPosition(this.pos + 4);
                return (char)Integer.parseInt(hex, 16);
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    private Object readLiteral() throws JSONException {
        String literal = this.nextToInternal("{}[]/\\:,=;# \t\f");
        if (literal.length() == 0) {
            this.skipWhitespace();
            if (this.current() == '}') {
                return sentinel;
            }
            throw this.syntaxError("Expected literal value");
        }
        if ("null".equalsIgnoreCase(literal)) {
            return JSONObject.NULL;
        }
        if ("true".equalsIgnoreCase(literal)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(literal)) {
            return Boolean.FALSE;
        }
        if (literal.indexOf(46) == -1) {
            int base = 10;
            String number = literal;
            if (number.startsWith("0x") || number.startsWith("0X")) {
                number = number.substring(2);
                base = 16;
            } else if (number.startsWith("0") && number.length() > 1) {
                number = number.substring(1);
                base = 8;
            }
            try {
                long longValue = Long.parseLong(number, base);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            return Double.valueOf(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return new String(literal);
        }
    }

    private String nextToInternal(String excluded) {
        int start = this.pos;
        while (this.pos < this.in.length()) {
            char c = this.in.charAt(this.pos);
            if (c == '\r' || c == '\n' || excluded.indexOf(c) != -1) {
                return this.in.substring(start, this.pos);
            }
            this.advance();
        }
        return this.in.substring(start);
    }

    private JSONObject readObject() throws JSONException {
        JSONObject result = new JSONObject().setAllowDuplicates(this.allowDuplicates);
        int first = this.nextCleanInternal();
        if (first == 125) {
            return result;
        }
        if (first != -1) {
            this.back();
        }
        block4: while (true) {
            this.skipWhitespace();
            LineNumberInfo keyInfo = this.getLineNumberInfo();
            Object name = this.nextValue(true);
            if (name == sentinel) {
                this.advance();
                return result;
            }
            if (!(name instanceof String)) {
                if (name == null) {
                    throw this.syntaxError("Names cannot be null");
                }
                throw this.syntaxError("Names must be strings, but " + name + " is of type " + name.getClass().getName());
            }
            int separator = this.nextCleanInternal();
            if (separator != 58 && separator != 61) {
                throw this.syntaxError("Expected ':' after " + name);
            }
            if (this.pos < this.in.length() && this.in.charAt(this.pos) == '>') {
                this.advance();
            }
            this.skipWhitespace();
            LineNumberInfo valInfo = this.getLineNumberInfo();
            Object val = this.nextValue();
            result.put((String)name, val, keyInfo, valInfo);
            switch (this.nextCleanInternal()) {
                case 125: {
                    return result;
                }
                case 44: 
                case 59: {
                    continue block4;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated object");
    }

    private JSONArray readArray() throws JSONException {
        JSONArray result = new JSONArray();
        block9: while (true) {
            switch (this.nextCleanInternal()) {
                case -1: {
                    throw this.syntaxError("Unterminated array");
                }
                case 93: {
                    return result;
                }
                case 44: 
                case 59: {
                    continue block9;
                }
            }
            this.back();
            this.skipWhitespace();
            LineNumberInfo lineInfo = this.getLineNumberInfo();
            result.put(this.nextValue());
            result.setLineNumber(result.length() - 1, lineInfo);
            switch (this.nextCleanInternal()) {
                case 93: {
                    return result;
                }
                case 44: 
                case 59: {
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Unterminated array");
    }

    public JSONException syntaxError(String message) {
        return this.syntaxError(message, true);
    }

    public JSONException syntaxError(String message, boolean stepBack) {
        if (stepBack) {
            this.back();
        }
        return new JSONException(message, this.getLineNumberInfo());
    }

    public String toString() {
        return " at character " + this.pos + " of " + this.in;
    }

    public boolean more() {
        return this.pos < this.in.length();
    }

    public char next() {
        return this.advance();
    }

    private char advance() {
        char next;
        char c = next = this.pos < this.in.length() ? this.in.charAt(this.pos++) : (char)'\u0000';
        if (next == '\n') {
            ++this.line;
            this.col = 0;
        } else if (next != '\u0000') {
            ++this.col;
        }
        return next;
    }

    public char peek() {
        return this.pos + 1 < this.in.length() ? this.in.charAt(this.pos + 1) : (char)'\u0000';
    }

    public void back() {
        this.back(1);
    }

    private void back(int length) {
        for (int i = 0; i < length && this.pos > 0; ++i) {
            --this.pos;
            if (this.in.charAt(this.pos) == '\n') {
                if (this.line > 1) {
                    this.col = this.pos - this.in.lastIndexOf(10, this.pos - 1);
                } else if (this.line == 1) {
                    this.col = this.pos;
                } else {
                    String msg = "Illegal state reached for input string \"" + this.in + "\" at position " + this.pos;
                    throw new IllegalStateException(msg);
                }
                --this.line;
                continue;
            }
            --this.col;
        }
    }

    public char current() {
        return this.pos < this.in.length() ? this.in.charAt(this.pos) : (char)'\u0000';
    }

    public char next(char c) throws JSONException {
        char result = this.next();
        if (result != c) {
            JSONException exception = this.syntaxError("Expected " + c + " but was " + result);
            this.advance();
            throw exception;
        }
        return result;
    }

    public char nextClean() throws JSONException {
        int nextCleanInt = this.nextCleanInternal();
        return nextCleanInt == -1 ? (char)'\u0000' : (char)nextCleanInt;
    }

    public String next(int length) throws JSONException {
        if (this.pos + length > this.in.length()) {
            throw this.syntaxError(length + " is out of bounds", false);
        }
        String result = this.in.substring(this.pos, this.pos + length);
        this.skipToPosition(this.pos + length);
        return result;
    }

    public String nextTo(String excluded) {
        if (excluded == null) {
            throw new NullPointerException("excluded == null");
        }
        return this.nextToInternal(excluded).trim();
    }

    public String nextTo(char excluded) {
        return this.nextToInternal(String.valueOf(excluded)).trim();
    }

    private void skipWhitespace() throws JSONException {
        this.nextCleanConsume(false);
    }

    public void skipPast(String thru) {
        int thruStart = this.in.indexOf(thru, this.pos);
        int newPos = thruStart == -1 ? this.in.length() : thruStart + thru.length();
        this.skipToPosition(newPos);
    }

    public char skipTo(char to) {
        int index = this.in.indexOf(to, this.pos);
        if (index != -1) {
            this.skipToPosition(index);
            return to;
        }
        return '\u0000';
    }

    public void skipToPosition(int newPos) {
        assert (this.pos <= newPos);
        assert (newPos <= this.in.length());
        String[] lines = this.in.substring(this.pos, newPos).split("\n", -1);
        if (lines.length > 1) {
            this.line += lines.length - 1;
            this.col = lines[lines.length - 1].length();
        } else {
            this.col += lines[0].length();
        }
        this.pos = newPos;
    }

    public static int dehexchar(char hex) {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        if (hex >= 'a' && hex <= 'f') {
            return hex - 97 + 10;
        }
        return -1;
    }

    public int getColumn() {
        return this.col;
    }

    public int getLine() {
        return this.line;
    }

    public LineNumberInfo getLineNumberInfo() {
        return new LineNumberInfo(this.line, this.col);
    }
}

