/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecordsResult
implements Serializable {
    private ListWithAutoConstructFlag<Record> records;
    private String nextToken;
    private Integer count;
    private Long datasetSyncCount;
    private String lastModifiedBy;
    private ListWithAutoConstructFlag<String> mergedDatasetNames;
    private Boolean datasetExists;
    private Boolean datasetDeletedAfterRequestedSyncCount;
    private String syncSessionToken;

    public List<Record> getRecords() {
        if (this.records == null) {
            this.records = new ListWithAutoConstructFlag();
            this.records.setAutoConstruct(true);
        }
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
        recordsCopy.addAll(records);
        this.records = recordsCopy;
    }

    public ListRecordsResult withRecords(Record ... records) {
        if (this.getRecords() == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record value : records) {
            this.getRecords().add(value);
        }
        return this;
    }

    public ListRecordsResult withRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
        } else {
            ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
            recordsCopy.addAll(records);
            this.records = recordsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListRecordsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public ListRecordsResult withCount(Integer count) {
        this.count = count;
        return this;
    }

    public Long getDatasetSyncCount() {
        return this.datasetSyncCount;
    }

    public void setDatasetSyncCount(Long datasetSyncCount) {
        this.datasetSyncCount = datasetSyncCount;
    }

    public ListRecordsResult withDatasetSyncCount(Long datasetSyncCount) {
        this.datasetSyncCount = datasetSyncCount;
        return this;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public ListRecordsResult withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public List<String> getMergedDatasetNames() {
        if (this.mergedDatasetNames == null) {
            this.mergedDatasetNames = new ListWithAutoConstructFlag();
            this.mergedDatasetNames.setAutoConstruct(true);
        }
        return this.mergedDatasetNames;
    }

    public void setMergedDatasetNames(Collection<String> mergedDatasetNames) {
        if (mergedDatasetNames == null) {
            this.mergedDatasetNames = null;
            return;
        }
        ListWithAutoConstructFlag mergedDatasetNamesCopy = new ListWithAutoConstructFlag(mergedDatasetNames.size());
        mergedDatasetNamesCopy.addAll(mergedDatasetNames);
        this.mergedDatasetNames = mergedDatasetNamesCopy;
    }

    public ListRecordsResult withMergedDatasetNames(String ... mergedDatasetNames) {
        if (this.getMergedDatasetNames() == null) {
            this.setMergedDatasetNames(new ArrayList<String>(mergedDatasetNames.length));
        }
        for (String value : mergedDatasetNames) {
            this.getMergedDatasetNames().add(value);
        }
        return this;
    }

    public ListRecordsResult withMergedDatasetNames(Collection<String> mergedDatasetNames) {
        if (mergedDatasetNames == null) {
            this.mergedDatasetNames = null;
        } else {
            ListWithAutoConstructFlag mergedDatasetNamesCopy = new ListWithAutoConstructFlag(mergedDatasetNames.size());
            mergedDatasetNamesCopy.addAll(mergedDatasetNames);
            this.mergedDatasetNames = mergedDatasetNamesCopy;
        }
        return this;
    }

    public Boolean isDatasetExists() {
        return this.datasetExists;
    }

    public void setDatasetExists(Boolean datasetExists) {
        this.datasetExists = datasetExists;
    }

    public ListRecordsResult withDatasetExists(Boolean datasetExists) {
        this.datasetExists = datasetExists;
        return this;
    }

    public Boolean getDatasetExists() {
        return this.datasetExists;
    }

    public Boolean isDatasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public void setDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
        this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
    }

    public ListRecordsResult withDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
        this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
        return this;
    }

    public Boolean getDatasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public String getSyncSessionToken() {
        return this.syncSessionToken;
    }

    public void setSyncSessionToken(String syncSessionToken) {
        this.syncSessionToken = syncSessionToken;
    }

    public ListRecordsResult withSyncSessionToken(String syncSessionToken) {
        this.syncSessionToken = syncSessionToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: " + this.getRecords() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getCount() != null) {
            sb.append("Count: " + this.getCount() + ",");
        }
        if (this.getDatasetSyncCount() != null) {
            sb.append("DatasetSyncCount: " + this.getDatasetSyncCount() + ",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: " + this.getLastModifiedBy() + ",");
        }
        if (this.getMergedDatasetNames() != null) {
            sb.append("MergedDatasetNames: " + this.getMergedDatasetNames() + ",");
        }
        if (this.isDatasetExists() != null) {
            sb.append("DatasetExists: " + this.isDatasetExists() + ",");
        }
        if (this.isDatasetDeletedAfterRequestedSyncCount() != null) {
            sb.append("DatasetDeletedAfterRequestedSyncCount: " + this.isDatasetDeletedAfterRequestedSyncCount() + ",");
        }
        if (this.getSyncSessionToken() != null) {
            sb.append("SyncSessionToken: " + this.getSyncSessionToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetSyncCount() == null ? 0 : this.getDatasetSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getMergedDatasetNames() == null ? 0 : this.getMergedDatasetNames().hashCode());
        hashCode = 31 * hashCode + (this.isDatasetExists() == null ? 0 : this.isDatasetExists().hashCode());
        hashCode = 31 * hashCode + (this.isDatasetDeletedAfterRequestedSyncCount() == null ? 0 : this.isDatasetDeletedAfterRequestedSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.getSyncSessionToken() == null ? 0 : this.getSyncSessionToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsResult)) {
            return false;
        }
        ListRecordsResult other = (ListRecordsResult)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getDatasetSyncCount() == null ^ this.getDatasetSyncCount() == null) {
            return false;
        }
        if (other.getDatasetSyncCount() != null && !other.getDatasetSyncCount().equals(this.getDatasetSyncCount())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getMergedDatasetNames() == null ^ this.getMergedDatasetNames() == null) {
            return false;
        }
        if (other.getMergedDatasetNames() != null && !other.getMergedDatasetNames().equals(this.getMergedDatasetNames())) {
            return false;
        }
        if (other.isDatasetExists() == null ^ this.isDatasetExists() == null) {
            return false;
        }
        if (other.isDatasetExists() != null && !other.isDatasetExists().equals(this.isDatasetExists())) {
            return false;
        }
        if (other.isDatasetDeletedAfterRequestedSyncCount() == null ^ this.isDatasetDeletedAfterRequestedSyncCount() == null) {
            return false;
        }
        if (other.isDatasetDeletedAfterRequestedSyncCount() != null && !other.isDatasetDeletedAfterRequestedSyncCount().equals(this.isDatasetDeletedAfterRequestedSyncCount())) {
            return false;
        }
        if (other.getSyncSessionToken() == null ^ this.getSyncSessionToken() == null) {
            return false;
        }
        return other.getSyncSessionToken() == null || other.getSyncSessionToken().equals(this.getSyncSessionToken());
    }
}

