/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.VaultAccessPolicy;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SetVaultAccessPolicyRequestMarshaller
implements Marshaller<Request<SetVaultAccessPolicyRequest>, SetVaultAccessPolicyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public SetVaultAccessPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SetVaultAccessPolicyRequest> marshall(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) {
        if (setVaultAccessPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setVaultAccessPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/access-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", setVaultAccessPolicyRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)setVaultAccessPolicyRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", setVaultAccessPolicyRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)setVaultAccessPolicyRequest.getVaultName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            VaultAccessPolicy policy = setVaultAccessPolicyRequest.getPolicy();
            if (policy != null) {
                jsonGenerator.writeStartObject();
                if (policy.getPolicy() != null) {
                    jsonGenerator.writeFieldName("Policy").writeValue(policy.getPolicy());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

