/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.transform.GrantConstraintsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateGrantRequestMarshaller
implements Marshaller<Request<CreateGrantRequest>, CreateGrantRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateGrantRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateGrantRequest> marshall(CreateGrantRequest createGrantRequest) {
        if (createGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGrantRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.CreateGrant");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalList operationsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createGrantRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(createGrantRequest.getKeyId());
            }
            if (createGrantRequest.getGranteePrincipal() != null) {
                jsonGenerator.writeFieldName("GranteePrincipal").writeValue(createGrantRequest.getGranteePrincipal());
            }
            if (createGrantRequest.getRetiringPrincipal() != null) {
                jsonGenerator.writeFieldName("RetiringPrincipal").writeValue(createGrantRequest.getRetiringPrincipal());
            }
            if (!(operationsList = (SdkInternalList)createGrantRequest.getOperations()).isEmpty() || !operationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Operations");
                jsonGenerator.writeStartArray();
                for (Object operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    jsonGenerator.writeValue((String)operationsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createGrantRequest.getConstraints() != null) {
                jsonGenerator.writeFieldName("Constraints");
                GrantConstraintsJsonMarshaller.getInstance().marshall(createGrantRequest.getConstraints(), jsonGenerator);
            }
            if (!(grantTokensList = (SdkInternalList)createGrantRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GrantTokens");
                jsonGenerator.writeStartArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonGenerator.writeValue(grantTokensListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createGrantRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createGrantRequest.getName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

