/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceAsync;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsResult;
import com.amazonaws.services.elasticmapreduce.model.AddTagsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddTagsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsResult;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.services.elasticmapreduce.model.ListClustersResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesResult;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListStepsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest;
import com.amazonaws.services.elasticmapreduce.model.RemoveTagsResult;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonElasticMapReduceAsyncClient
extends AmazonElasticMapReduceClient
implements AmazonElasticMapReduceAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonElasticMapReduceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticMapReduceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticMapReduceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ListBootstrapActionsResult> listBootstrapActionsAsync(final ListBootstrapActionsRequest listBootstrapActionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListBootstrapActionsResult>(){

            @Override
            public ListBootstrapActionsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.listBootstrapActions(listBootstrapActionsRequest);
            }
        });
    }

    @Override
    public Future<ListBootstrapActionsResult> listBootstrapActionsAsync(final ListBootstrapActionsRequest listBootstrapActionsRequest, final AsyncHandler<ListBootstrapActionsRequest, ListBootstrapActionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListBootstrapActionsResult>(){

            @Override
            public ListBootstrapActionsResult call() throws Exception {
                ListBootstrapActionsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listBootstrapActions(listBootstrapActionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listBootstrapActionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest addTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.addTags(addTagsRequest);
            }
        });
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest addTagsRequest, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.addTags(addTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setVisibleToAllUsersAsync(final SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.setVisibleToAllUsers(setVisibleToAllUsersRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setVisibleToAllUsersAsync(final SetVisibleToAllUsersRequest setVisibleToAllUsersRequest, final AsyncHandler<SetVisibleToAllUsersRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticMapReduceAsyncClient.this.setVisibleToAllUsers(setVisibleToAllUsersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setVisibleToAllUsersRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListStepsResult> listStepsAsync(final ListStepsRequest listStepsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStepsResult>(){

            @Override
            public ListStepsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.listSteps(listStepsRequest);
            }
        });
    }

    @Override
    public Future<ListStepsResult> listStepsAsync(final ListStepsRequest listStepsRequest, final AsyncHandler<ListStepsRequest, ListStepsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStepsResult>(){

            @Override
            public ListStepsResult call() throws Exception {
                ListStepsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listSteps(listStepsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listStepsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AddJobFlowStepsResult> addJobFlowStepsAsync(final AddJobFlowStepsRequest addJobFlowStepsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddJobFlowStepsResult>(){

            @Override
            public AddJobFlowStepsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.addJobFlowSteps(addJobFlowStepsRequest);
            }
        });
    }

    @Override
    public Future<AddJobFlowStepsResult> addJobFlowStepsAsync(final AddJobFlowStepsRequest addJobFlowStepsRequest, final AsyncHandler<AddJobFlowStepsRequest, AddJobFlowStepsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddJobFlowStepsResult>(){

            @Override
            public AddJobFlowStepsResult call() throws Exception {
                AddJobFlowStepsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.addJobFlowSteps(addJobFlowStepsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addJobFlowStepsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStepResult> describeStepAsync(final DescribeStepRequest describeStepRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStepResult>(){

            @Override
            public DescribeStepResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.describeStep(describeStepRequest);
            }
        });
    }

    @Override
    public Future<DescribeStepResult> describeStepAsync(final DescribeStepRequest describeStepRequest, final AsyncHandler<DescribeStepRequest, DescribeStepResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStepResult>(){

            @Override
            public DescribeStepResult call() throws Exception {
                DescribeStepResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.describeStep(describeStepRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeStepRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(final ListClustersRequest listClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.listClusters(listClustersRequest);
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(final ListClustersRequest listClustersRequest, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listClusters(listClustersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listClustersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(final RemoveTagsRequest removeTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.removeTags(removeTagsRequest);
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(final RemoveTagsRequest removeTagsRequest, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.removeTags(removeTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(removeTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListInstanceGroupsResult> listInstanceGroupsAsync(final ListInstanceGroupsRequest listInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListInstanceGroupsResult>(){

            @Override
            public ListInstanceGroupsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.listInstanceGroups(listInstanceGroupsRequest);
            }
        });
    }

    @Override
    public Future<ListInstanceGroupsResult> listInstanceGroupsAsync(final ListInstanceGroupsRequest listInstanceGroupsRequest, final AsyncHandler<ListInstanceGroupsRequest, ListInstanceGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListInstanceGroupsResult>(){

            @Override
            public ListInstanceGroupsResult call() throws Exception {
                ListInstanceGroupsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listInstanceGroups(listInstanceGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listInstanceGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync(final ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.modifyInstanceGroups(modifyInstanceGroupsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceGroupsAsync(final ModifyInstanceGroupsRequest modifyInstanceGroupsRequest, final AsyncHandler<ModifyInstanceGroupsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticMapReduceAsyncClient.this.modifyInstanceGroups(modifyInstanceGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(modifyInstanceGroupsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListInstancesResult> listInstancesAsync(final ListInstancesRequest listInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListInstancesResult>(){

            @Override
            public ListInstancesResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.listInstances(listInstancesRequest);
            }
        });
    }

    @Override
    public Future<ListInstancesResult> listInstancesAsync(final ListInstancesRequest listInstancesRequest, final AsyncHandler<ListInstancesRequest, ListInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListInstancesResult>(){

            @Override
            public ListInstancesResult call() throws Exception {
                ListInstancesResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.listInstances(listInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AddInstanceGroupsResult> addInstanceGroupsAsync(final AddInstanceGroupsRequest addInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddInstanceGroupsResult>(){

            @Override
            public AddInstanceGroupsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.addInstanceGroups(addInstanceGroupsRequest);
            }
        });
    }

    @Override
    public Future<AddInstanceGroupsResult> addInstanceGroupsAsync(final AddInstanceGroupsRequest addInstanceGroupsRequest, final AsyncHandler<AddInstanceGroupsRequest, AddInstanceGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AddInstanceGroupsResult>(){

            @Override
            public AddInstanceGroupsResult call() throws Exception {
                AddInstanceGroupsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.addInstanceGroups(addInstanceGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addInstanceGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> terminateJobFlowsAsync(final TerminateJobFlowsRequest terminateJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.terminateJobFlows(terminateJobFlowsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> terminateJobFlowsAsync(final TerminateJobFlowsRequest terminateJobFlowsRequest, final AsyncHandler<TerminateJobFlowsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticMapReduceAsyncClient.this.terminateJobFlows(terminateJobFlowsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(terminateJobFlowsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setTerminationProtectionAsync(final SetTerminationProtectionRequest setTerminationProtectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElasticMapReduceAsyncClient.this.setTerminationProtection(setTerminationProtectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setTerminationProtectionAsync(final SetTerminationProtectionRequest setTerminationProtectionRequest, final AsyncHandler<SetTerminationProtectionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonElasticMapReduceAsyncClient.this.setTerminationProtection(setTerminationProtectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setTerminationProtectionRequest, null);
                return null;
            }
        });
    }

    @Override
    @Deprecated
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync(final DescribeJobFlowsRequest describeJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeJobFlowsResult>(){

            @Override
            public DescribeJobFlowsResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.describeJobFlows(describeJobFlowsRequest);
            }
        });
    }

    @Override
    public Future<DescribeJobFlowsResult> describeJobFlowsAsync(final DescribeJobFlowsRequest describeJobFlowsRequest, final AsyncHandler<DescribeJobFlowsRequest, DescribeJobFlowsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeJobFlowsResult>(){

            @Override
            public DescribeJobFlowsResult call() throws Exception {
                DescribeJobFlowsResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.describeJobFlows(describeJobFlowsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeJobFlowsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RunJobFlowResult> runJobFlowAsync(final RunJobFlowRequest runJobFlowRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunJobFlowResult>(){

            @Override
            public RunJobFlowResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.runJobFlow(runJobFlowRequest);
            }
        });
    }

    @Override
    public Future<RunJobFlowResult> runJobFlowAsync(final RunJobFlowRequest runJobFlowRequest, final AsyncHandler<RunJobFlowRequest, RunJobFlowResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunJobFlowResult>(){

            @Override
            public RunJobFlowResult call() throws Exception {
                RunJobFlowResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.runJobFlow(runJobFlowRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(runJobFlowRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(final DescribeClusterRequest describeClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                return AmazonElasticMapReduceAsyncClient.this.describeCluster(describeClusterRequest);
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(final DescribeClusterRequest describeClusterRequest, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result;
                try {
                    result = AmazonElasticMapReduceAsyncClient.this.describeCluster(describeClusterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeClusterRequest, result);
                return result;
            }
        });
    }
}

