/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MultipleFileTransfer<T extends Transfer>
extends AbstractTransfer {
    protected final Collection<? extends T> subTransfers;
    private AtomicBoolean subTransferStarted = new AtomicBoolean(false);

    MultipleFileTransfer(String description, TransferProgress transferProgress, com.amazonaws.event.ProgressListenerChain progressListenerChain, Collection<? extends T> subTransfers) {
        super(description, transferProgress, progressListenerChain);
        this.subTransfers = subTransfers;
    }

    @Deprecated
    MultipleFileTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, Collection<? extends T> subTransfers) {
        this(description, transferProgress, progressListenerChain.transformToGeneralProgressListenerChain(), subTransfers);
    }

    public void collateFinalState() {
        boolean seenCanceled = false;
        for (Transfer download : this.subTransfers) {
            if (download.getState() == Transfer.TransferState.Failed) {
                this.setState(Transfer.TransferState.Failed);
                return;
            }
            if (download.getState() != Transfer.TransferState.Canceled) continue;
            seenCanceled = true;
        }
        if (seenCanceled) {
            this.setState(Transfer.TransferState.Canceled);
        } else {
            this.setState(Transfer.TransferState.Completed);
        }
    }

    @Override
    public void setState(Transfer.TransferState state) {
        super.setState(state);
        switch (state) {
            case Waiting: {
                this.fireProgressEvent(1);
                break;
            }
            case InProgress: {
                if (!this.subTransferStarted.compareAndSet(false, true)) break;
                this.fireProgressEvent(2);
                break;
            }
            case Completed: {
                this.fireProgressEvent(4);
                break;
            }
            case Canceled: {
                this.fireProgressEvent(16);
                break;
            }
            case Failed: {
                this.fireProgressEvent(8);
                break;
            }
        }
    }
}

