
/**
 * Synchronous and asynchronous client classes for accessing AmazonDirectConnect.
 *
 * <p>
 * AWS Direct Connect makes it easy to establish a dedicated network
 * connection from your premises to Amazon Web Services (AWS). Using AWS
 * Direct Connect, you can establish private connectivity between AWS and
 * your data center, office, or colocation environment, which in many
 * cases can reduce your network costs, increase bandwidth throughput,
 * and provide a more consistent network experience than Internet-based
 * connections.
 * </p>
 * <p>
 * The AWS Direct Connect API Reference provides descriptions, syntax,
 * and usage examples for each of the actions and data types for AWS
 * Direct Connect. Use the following links to get started using the
 * <i>AWS Direct Connect API Reference</i> :
 * </p>
 * 
 * <ul>
 * <li>
 * <a href="http://docs.aws.amazon.com/directconnect/latest/APIReference/API_Operations.html"> Actions </a>
 * : An alphabetical list of all AWS Direct Connect actions.</li>
 * <li>
 * <a href="http://docs.aws.amazon.com/directconnect/latest/APIReference/API_Types.html"> Data Types </a>
 * : An alphabetical list of all AWS Direct Connect data types.</li>
 * <li>
 * <a href="http://docs.aws.amazon.com/directconnect/latest/APIReference/CommonParameters.html"> Common Query Parameters </a>
 * : Parameters that all Query actions can use.</li>
 * <li>
 * <a href="http://docs.aws.amazon.com/directconnect/latest/APIReference/CommonErrors.html"> Common Errors </a>
 * : Client and server errors that all actions can return.</li>
 * 
 * </ul>
 */
 package com.amazonaws.services.directconnect;
        