// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The MetadataPermissionsWorkspacesItem model. */
@Fluent
public final class MetadataPermissionsWorkspacesItem {
    /*
     * The resource ID on the permission indication.
     */
    @JsonProperty(value = "resourceId", required = true)
    private String resourceId;

    /*
     * The list of tables that were denied access for the resource ID.
     */
    @JsonProperty(value = "denyTables")
    private List<String> denyTables;

    /**
     * Creates an instance of MetadataPermissionsWorkspacesItem class.
     *
     * @param resourceId the resourceId value to set.
     */
    @JsonCreator
    public MetadataPermissionsWorkspacesItem(@JsonProperty(value = "resourceId", required = true) String resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * Get the resourceId property: The resource ID on the permission indication.
     *
     * @return the resourceId value.
     */
    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * Get the denyTables property: The list of tables that were denied access for the resource ID.
     *
     * @return the denyTables value.
     */
    public List<String> getDenyTables() {
        return this.denyTables;
    }

    /**
     * Set the denyTables property: The list of tables that were denied access for the resource ID.
     *
     * @param denyTables the denyTables value to set.
     * @return the MetadataPermissionsWorkspacesItem object itself.
     */
    public MetadataPermissionsWorkspacesItem setDenyTables(List<String> denyTables) {
        this.denyTables = denyTables;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getResourceId() == null) {
            throw new IllegalArgumentException(
                    "Missing required property resourceId in model MetadataPermissionsWorkspacesItem");
        }
    }
}
