// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.IndexActionType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an index action that operates on a document.
 */
@Fluent
public final class IndexAction implements JsonSerializable<IndexAction> {

    /*
     * The operation to perform on a document in an indexing batch.
     */
    @Generated
    private IndexActionType actionType;

    /*
     * Represents an index action that operates on a document.
     */
    @Generated
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of IndexAction class.
     */
    @Generated
    public IndexAction() {
    }

    /**
     * Get the actionType property: The operation to perform on a document in an indexing batch.
     *
     * @return the actionType value.
     */
    @Generated
    public IndexActionType getActionType() {
        return this.actionType;
    }

    /**
     * Set the actionType property: The operation to perform on a document in an indexing batch.
     *
     * @param actionType the actionType value to set.
     * @return the IndexAction object itself.
     */
    @Generated
    public IndexAction setActionType(IndexActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an index action that operates on a document.
     *
     * @return the additionalProperties value.
     */
    @Generated
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an index action that operates on a document.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the IndexAction object itself.
     */
    @Generated
    public IndexAction setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@search.action", this.actionType == null ? null : this.actionType.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexAction from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexAction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IndexAction.
     */
    @Generated
    public static IndexAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IndexAction deserializedIndexAction = new IndexAction();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@search.action".equals(fieldName)) {
                    deserializedIndexAction.actionType = IndexActionType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }
                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedIndexAction.additionalProperties = additionalProperties;
            return deserializedIndexAction;
        });
    }

    private String rawDocument;

    /**
     * Gets the raw JSON document.
     *
     * @return The raw JSON document.
     */
    public String getRawDocument() {
        return this.rawDocument;
    }

    /**
     * Sets the raw JSON document.
     *
     * @param rawDocument The raw JSON document.
     * @return the IndexAction object itself.
     */
    public IndexAction setRawDocument(String rawDocument) {
        this.rawDocument = rawDocument;
        return this;
    }
}
