// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.indexes.implementation.models.DocumentKeysOrIds;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.IndexerResyncBody;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Indexers.
 */
public final class IndexersImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final IndexersService service;

    /**
     * The service client containing this operation class.
     */
    private final SearchServiceClientImpl client;

    /**
     * Initializes an instance of IndexersImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    IndexersImpl(SearchServiceClientImpl client) {
        this.service = RestProxy.create(IndexersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchServiceClientIndexers to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SearchServiceClientIndexers")
    public interface IndexersService {
        @Post("/indexers('{indexerName}')/search.reset")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> reset(@HostParam("endpoint") String endpoint, @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/indexers('{indexerName}')/search.reset")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> resetSync(@HostParam("endpoint") String endpoint, @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/indexers('{indexerName}')/search.resetdocs")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> resetDocs(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName, @QueryParam("overwrite") Boolean overwrite,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") DocumentKeysOrIds keysOrIds, Context context);

        @Post("/indexers('{indexerName}')/search.resetdocs")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> resetDocsSync(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName, @QueryParam("overwrite") Boolean overwrite,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") DocumentKeysOrIds keysOrIds, Context context);

        @Post("/indexers('{indexerName}')/search.resync")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> resync(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") IndexerResyncBody indexerResync, Context context);

        @Post("/indexers('{indexerName}')/search.resync")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> resyncSync(@HostParam("endpoint") String endpoint, @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") IndexerResyncBody indexerResync, Context context);

        @Post("/indexers('{indexerName}')/search.run")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> run(@HostParam("endpoint") String endpoint, @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/indexers('{indexerName}')/search.run")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> runSync(@HostParam("endpoint") String endpoint, @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Put("/indexers('{indexerName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchIndexer>> createOrUpdate(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @HeaderParam("Prefer") String prefer,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("ignoreResetRequirements") Boolean skipIndexerResetRequirementForCache,
            @QueryParam("disableCacheReprocessingChangeDetection") Boolean disableCacheReprocessingChangeDetection,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") SearchIndexer indexer,
            Context context);

        @Put("/indexers('{indexerName}')")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchIndexer> createOrUpdateSync(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @HeaderParam("Prefer") String prefer,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("ignoreResetRequirements") Boolean skipIndexerResetRequirementForCache,
            @QueryParam("disableCacheReprocessingChangeDetection") Boolean disableCacheReprocessingChangeDetection,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") SearchIndexer indexer,
            Context context);

        @Delete("/indexers('{indexerName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> delete(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/indexers('{indexerName}')")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteSync(@HostParam("endpoint") String endpoint, @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId, @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("If-None-Match") String ifNoneMatch, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/indexers('{indexerName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchIndexer>> get(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/indexers('{indexerName}')")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchIndexer> getSync(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/indexers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<ListIndexersResult>> list(@HostParam("endpoint") String endpoint,
            @QueryParam("$select") String select, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/indexers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<ListIndexersResult> listSync(@HostParam("endpoint") String endpoint,
            @QueryParam("$select") String select, @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/indexers")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchIndexer>> create(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") SearchIndexer indexer, Context context);

        @Post("/indexers")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchIndexer> createSync(@HostParam("endpoint") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") SearchIndexer indexer, Context context);

        @Get("/indexers('{indexerName}')/search.status")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<SearchIndexerStatus>> getStatus(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/indexers('{indexerName}')/search.status")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<SearchIndexerStatus> getStatusSync(@HostParam("endpoint") String endpoint,
            @PathParam("indexerName") String indexerName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Resets the change tracking state associated with an indexer.
     * 
     * @param indexerName The name of the indexer to reset.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> resetWithResponseAsync(indexerName, requestOptions, context));
    }

    /**
     * Resets the change tracking state associated with an indexer.
     * 
     * @param indexerName The name of the indexer to reset.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetWithResponseAsync(String indexerName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.reset(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Resets the change tracking state associated with an indexer.
     * 
     * @param indexerName The name of the indexer to reset.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetAsync(String indexerName, RequestOptions requestOptions) {
        return resetWithResponseAsync(indexerName, requestOptions).flatMap(ignored -> Mono.empty());
    }

    /**
     * Resets the change tracking state associated with an indexer.
     * 
     * @param indexerName The name of the indexer to reset.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return resetWithResponseAsync(indexerName, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Resets the change tracking state associated with an indexer.
     * 
     * @param indexerName The name of the indexer to reset.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.resetSync(this.client.getEndpoint(), indexerName, xMsClientRequestId,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Resets the change tracking state associated with an indexer.
     * 
     * @param indexerName The name of the indexer to reset.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void reset(String indexerName, RequestOptions requestOptions) {
        resetWithResponse(indexerName, requestOptions, Context.NONE);
    }

    /**
     * Resets specific documents in the datasource to be selectively re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to reset documents for.
     * @param overwrite If false, keys or ids will be appended to existing ones. If true, only the keys or ids in this
     * payload will be queued to be re-ingested.
     * @param keysOrIds The keysOrIds parameter.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetDocsWithResponseAsync(String indexerName, Boolean overwrite,
        DocumentKeysOrIds keysOrIds, RequestOptions requestOptions) {
        return FluxUtil.withContext(
            context -> resetDocsWithResponseAsync(indexerName, overwrite, keysOrIds, requestOptions, context));
    }

    /**
     * Resets specific documents in the datasource to be selectively re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to reset documents for.
     * @param overwrite If false, keys or ids will be appended to existing ones. If true, only the keys or ids in this
     * payload will be queued to be re-ingested.
     * @param keysOrIds The keysOrIds parameter.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetDocsWithResponseAsync(String indexerName, Boolean overwrite,
        DocumentKeysOrIds keysOrIds, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.resetDocs(this.client.getEndpoint(), indexerName, overwrite, xMsClientRequestId,
            this.client.getApiVersion(), accept, keysOrIds, context);
    }

    /**
     * Resets specific documents in the datasource to be selectively re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to reset documents for.
     * @param overwrite If false, keys or ids will be appended to existing ones. If true, only the keys or ids in this
     * payload will be queued to be re-ingested.
     * @param keysOrIds The keysOrIds parameter.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetDocsAsync(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds,
        RequestOptions requestOptions) {
        return resetDocsWithResponseAsync(indexerName, overwrite, keysOrIds, requestOptions)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Resets specific documents in the datasource to be selectively re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to reset documents for.
     * @param overwrite If false, keys or ids will be appended to existing ones. If true, only the keys or ids in this
     * payload will be queued to be re-ingested.
     * @param keysOrIds The keysOrIds parameter.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetDocsAsync(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds,
        RequestOptions requestOptions, Context context) {
        return resetDocsWithResponseAsync(indexerName, overwrite, keysOrIds, requestOptions, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Resets specific documents in the datasource to be selectively re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to reset documents for.
     * @param overwrite If false, keys or ids will be appended to existing ones. If true, only the keys or ids in this
     * payload will be queued to be re-ingested.
     * @param keysOrIds The keysOrIds parameter.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetDocsWithResponse(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.resetDocsSync(this.client.getEndpoint(), indexerName, overwrite, xMsClientRequestId,
            this.client.getApiVersion(), accept, keysOrIds, context);
    }

    /**
     * Resets specific documents in the datasource to be selectively re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to reset documents for.
     * @param overwrite If false, keys or ids will be appended to existing ones. If true, only the keys or ids in this
     * payload will be queued to be re-ingested.
     * @param keysOrIds The keysOrIds parameter.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetDocs(String indexerName, Boolean overwrite, DocumentKeysOrIds keysOrIds,
        RequestOptions requestOptions) {
        resetDocsWithResponse(indexerName, overwrite, keysOrIds, requestOptions, Context.NONE);
    }

    /**
     * Resync selective options from the datasource to be re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to resync for.
     * @param indexerResync The indexerResync parameter.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resyncWithResponseAsync(String indexerName, IndexerResyncBody indexerResync,
        RequestOptions requestOptions) {
        return FluxUtil
            .withContext(context -> resyncWithResponseAsync(indexerName, indexerResync, requestOptions, context));
    }

    /**
     * Resync selective options from the datasource to be re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to resync for.
     * @param indexerResync The indexerResync parameter.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resyncWithResponseAsync(String indexerName, IndexerResyncBody indexerResync,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.resync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(),
            accept, indexerResync, context);
    }

    /**
     * Resync selective options from the datasource to be re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to resync for.
     * @param indexerResync The indexerResync parameter.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resyncAsync(String indexerName, IndexerResyncBody indexerResync, RequestOptions requestOptions) {
        return resyncWithResponseAsync(indexerName, indexerResync, requestOptions).flatMap(ignored -> Mono.empty());
    }

    /**
     * Resync selective options from the datasource to be re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to resync for.
     * @param indexerResync The indexerResync parameter.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resyncAsync(String indexerName, IndexerResyncBody indexerResync, RequestOptions requestOptions,
        Context context) {
        return resyncWithResponseAsync(indexerName, indexerResync, requestOptions, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Resync selective options from the datasource to be re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to resync for.
     * @param indexerResync The indexerResync parameter.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resyncWithResponse(String indexerName, IndexerResyncBody indexerResync,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.resyncSync(this.client.getEndpoint(), indexerName, xMsClientRequestId,
            this.client.getApiVersion(), accept, indexerResync, context);
    }

    /**
     * Resync selective options from the datasource to be re-ingested by the indexer.
     * 
     * @param indexerName The name of the indexer to resync for.
     * @param indexerResync The indexerResync parameter.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resync(String indexerName, IndexerResyncBody indexerResync, RequestOptions requestOptions) {
        resyncWithResponse(indexerName, indexerResync, requestOptions, Context.NONE);
    }

    /**
     * Runs an indexer on-demand.
     * 
     * @param indexerName The name of the indexer to run.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> runWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> runWithResponseAsync(indexerName, requestOptions, context));
    }

    /**
     * Runs an indexer on-demand.
     * 
     * @param indexerName The name of the indexer to run.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> runWithResponseAsync(String indexerName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.run(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Runs an indexer on-demand.
     * 
     * @param indexerName The name of the indexer to run.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> runAsync(String indexerName, RequestOptions requestOptions) {
        return runWithResponseAsync(indexerName, requestOptions).flatMap(ignored -> Mono.empty());
    }

    /**
     * Runs an indexer on-demand.
     * 
     * @param indexerName The name of the indexer to run.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> runAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return runWithResponseAsync(indexerName, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Runs an indexer on-demand.
     * 
     * @param indexerName The name of the indexer to run.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> runWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.runSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Runs an indexer on-demand.
     * 
     * @param indexerName The name of the indexer to run.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void run(String indexerName, RequestOptions requestOptions) {
        runWithResponse(indexerName, requestOptions, Context.NONE);
    }

    /**
     * Creates a new indexer or updates an indexer if it already exists.
     * 
     * @param indexerName The name of the indexer to create or update.
     * @param indexer The definition of the indexer to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param skipIndexerResetRequirementForCache Ignores cache reset requirements.
     * @param disableCacheReprocessingChangeDetection Disables cache reprocessing change detection.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createOrUpdateWithResponseAsync(String indexerName, SearchIndexer indexer,
        String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache,
        Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions) {
        return FluxUtil
            .withContext(context -> createOrUpdateWithResponseAsync(indexerName, indexer, ifMatch, ifNoneMatch,
                skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions, context));
    }

    /**
     * Creates a new indexer or updates an indexer if it already exists.
     * 
     * @param indexerName The name of the indexer to create or update.
     * @param indexer The definition of the indexer to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param skipIndexerResetRequirementForCache Ignores cache reset requirements.
     * @param disableCacheReprocessingChangeDetection Disables cache reprocessing change detection.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createOrUpdateWithResponseAsync(String indexerName, SearchIndexer indexer,
        String ifMatch, String ifNoneMatch, Boolean skipIndexerResetRequirementForCache,
        Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions, Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdate(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch,
            prefer, this.client.getApiVersion(), skipIndexerResetRequirementForCache,
            disableCacheReprocessingChangeDetection, accept, indexer, context);
    }

    /**
     * Creates a new indexer or updates an indexer if it already exists.
     * 
     * @param indexerName The name of the indexer to create or update.
     * @param indexer The definition of the indexer to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param skipIndexerResetRequirementForCache Ignores cache reset requirements.
     * @param disableCacheReprocessingChangeDetection Disables cache reprocessing change detection.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexer> createOrUpdateAsync(String indexerName, SearchIndexer indexer, String ifMatch,
        String ifNoneMatch, Boolean skipIndexerResetRequirementForCache,
        Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions) {
        return createOrUpdateWithResponseAsync(indexerName, indexer, ifMatch, ifNoneMatch,
            skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new indexer or updates an indexer if it already exists.
     * 
     * @param indexerName The name of the indexer to create or update.
     * @param indexer The definition of the indexer to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param skipIndexerResetRequirementForCache Ignores cache reset requirements.
     * @param disableCacheReprocessingChangeDetection Disables cache reprocessing change detection.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexer> createOrUpdateAsync(String indexerName, SearchIndexer indexer, String ifMatch,
        String ifNoneMatch, Boolean skipIndexerResetRequirementForCache,
        Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions, Context context) {
        return createOrUpdateWithResponseAsync(indexerName, indexer, ifMatch, ifNoneMatch,
            skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new indexer or updates an indexer if it already exists.
     * 
     * @param indexerName The name of the indexer to create or update.
     * @param indexer The definition of the indexer to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param skipIndexerResetRequirementForCache Ignores cache reset requirements.
     * @param disableCacheReprocessingChangeDetection Disables cache reprocessing change detection.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndexer> createOrUpdateWithResponse(String indexerName, SearchIndexer indexer, String ifMatch,
        String ifNoneMatch, Boolean skipIndexerResetRequirementForCache,
        Boolean disableCacheReprocessingChangeDetection, RequestOptions requestOptions, Context context) {
        final String prefer = "return=representation";
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createOrUpdateSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch,
            ifNoneMatch, prefer, this.client.getApiVersion(), skipIndexerResetRequirementForCache,
            disableCacheReprocessingChangeDetection, accept, indexer, context);
    }

    /**
     * Creates a new indexer or updates an indexer if it already exists.
     * 
     * @param indexerName The name of the indexer to create or update.
     * @param indexer The definition of the indexer to create or update.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param skipIndexerResetRequirementForCache Ignores cache reset requirements.
     * @param disableCacheReprocessingChangeDetection Disables cache reprocessing change detection.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndexer createOrUpdate(String indexerName, SearchIndexer indexer, String ifMatch, String ifNoneMatch,
        Boolean skipIndexerResetRequirementForCache, Boolean disableCacheReprocessingChangeDetection,
        RequestOptions requestOptions) {
        return createOrUpdateWithResponse(indexerName, indexer, ifMatch, ifNoneMatch,
            skipIndexerResetRequirementForCache, disableCacheReprocessingChangeDetection, requestOptions, Context.NONE)
                .getValue();
    }

    /**
     * Deletes an indexer.
     * 
     * @param indexerName The name of the indexer to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String indexerName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return FluxUtil.withContext(
            context -> deleteWithResponseAsync(indexerName, ifMatch, ifNoneMatch, requestOptions, context));
    }

    /**
     * Deletes an indexer.
     * 
     * @param indexerName The name of the indexer to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String indexerName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.delete(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an indexer.
     * 
     * @param indexerName The name of the indexer to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String indexerName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions) {
        return deleteWithResponseAsync(indexerName, ifMatch, ifNoneMatch, requestOptions)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an indexer.
     * 
     * @param indexerName The name of the indexer to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions,
        Context context) {
        return deleteWithResponseAsync(indexerName, ifMatch, ifNoneMatch, requestOptions, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an indexer.
     * 
     * @param indexerName The name of the indexer to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String indexerName, String ifMatch, String ifNoneMatch,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.deleteSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, ifMatch, ifNoneMatch,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an indexer.
     * 
     * @param indexerName The name of the indexer to delete.
     * @param ifMatch Defines the If-Match condition. The operation will be performed only if the ETag on the server
     * matches this value.
     * @param ifNoneMatch Defines the If-None-Match condition. The operation will be performed only if the ETag on the
     * server does not match this value.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String indexerName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        deleteWithResponse(indexerName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    /**
     * Retrieves an indexer definition.
     * 
     * @param indexerName The name of the indexer to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> getWithResponseAsync(String indexerName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> getWithResponseAsync(indexerName, requestOptions, context));
    }

    /**
     * Retrieves an indexer definition.
     * 
     * @param indexerName The name of the indexer to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> getWithResponseAsync(String indexerName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.get(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves an indexer definition.
     * 
     * @param indexerName The name of the indexer to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexer> getAsync(String indexerName, RequestOptions requestOptions) {
        return getWithResponseAsync(indexerName, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an indexer definition.
     * 
     * @param indexerName The name of the indexer to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexer> getAsync(String indexerName, RequestOptions requestOptions, Context context) {
        return getWithResponseAsync(indexerName, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves an indexer definition.
     * 
     * @param indexerName The name of the indexer to retrieve.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndexer> getWithResponse(String indexerName, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getSync(this.client.getEndpoint(), indexerName, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Retrieves an indexer definition.
     * 
     * @param indexerName The name of the indexer to retrieve.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndexer get(String indexerName, RequestOptions requestOptions) {
        return getWithResponse(indexerName, requestOptions, Context.NONE).getValue();
    }

    /**
     * Lists all indexers available for a search service.
     * 
     * @param select Selects which top-level properties of the indexers to retrieve. Specified as a comma-separated list
     * of JSON property names, or '*' for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexers request along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ListIndexersResult>> listWithResponseAsync(String select, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> listWithResponseAsync(select, requestOptions, context));
    }

    /**
     * Lists all indexers available for a search service.
     * 
     * @param select Selects which top-level properties of the indexers to retrieve. Specified as a comma-separated list
     * of JSON property names, or '*' for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexers request along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ListIndexersResult>> listWithResponseAsync(String select, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Lists all indexers available for a search service.
     * 
     * @param select Selects which top-level properties of the indexers to retrieve. Specified as a comma-separated list
     * of JSON property names, or '*' for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexers request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ListIndexersResult> listAsync(String select, RequestOptions requestOptions) {
        return listWithResponseAsync(select, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists all indexers available for a search service.
     * 
     * @param select Selects which top-level properties of the indexers to retrieve. Specified as a comma-separated list
     * of JSON property names, or '*' for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexers request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ListIndexersResult> listAsync(String select, RequestOptions requestOptions, Context context) {
        return listWithResponseAsync(select, requestOptions, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists all indexers available for a search service.
     * 
     * @param select Selects which top-level properties of the indexers to retrieve. Specified as a comma-separated list
     * of JSON property names, or '*' for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexers request along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ListIndexersResult> listWithResponse(String select, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.listSync(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Lists all indexers available for a search service.
     * 
     * @param select Selects which top-level properties of the indexers to retrieve. Specified as a comma-separated list
     * of JSON property names, or '*' for all properties. The default is all properties.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response from a List Indexers request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ListIndexersResult list(String select, RequestOptions requestOptions) {
        return listWithResponse(select, requestOptions, Context.NONE).getValue();
    }

    /**
     * Creates a new indexer.
     * 
     * @param indexer The definition of the indexer to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createWithResponseAsync(SearchIndexer indexer, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> createWithResponseAsync(indexer, requestOptions, context));
    }

    /**
     * Creates a new indexer.
     * 
     * @param indexer The definition of the indexer to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexer>> createWithResponseAsync(SearchIndexer indexer, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            indexer, context);
    }

    /**
     * Creates a new indexer.
     * 
     * @param indexer The definition of the indexer to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexer> createAsync(SearchIndexer indexer, RequestOptions requestOptions) {
        return createWithResponseAsync(indexer, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new indexer.
     * 
     * @param indexer The definition of the indexer to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexer> createAsync(SearchIndexer indexer, RequestOptions requestOptions, Context context) {
        return createWithResponseAsync(indexer, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new indexer.
     * 
     * @param indexer The definition of the indexer to create.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndexer> createWithResponse(SearchIndexer indexer, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), accept,
            indexer, context);
    }

    /**
     * Creates a new indexer.
     * 
     * @param indexer The definition of the indexer to create.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an indexer.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndexer create(SearchIndexer indexer, RequestOptions requestOptions) {
        return createWithResponse(indexer, requestOptions, Context.NONE).getValue();
    }

    /**
     * Returns the current status and execution history of an indexer.
     * 
     * @param indexerName The name of the indexer for which to retrieve status.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents the current status and execution history of an indexer along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexerStatus>> getStatusWithResponseAsync(String indexerName,
        RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> getStatusWithResponseAsync(indexerName, requestOptions, context));
    }

    /**
     * Returns the current status and execution history of an indexer.
     * 
     * @param indexerName The name of the indexer for which to retrieve status.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents the current status and execution history of an indexer along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchIndexerStatus>> getStatusWithResponseAsync(String indexerName,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getStatus(this.client.getEndpoint(), indexerName, xMsClientRequestId,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns the current status and execution history of an indexer.
     * 
     * @param indexerName The name of the indexer for which to retrieve status.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents the current status and execution history of an indexer on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexerStatus> getStatusAsync(String indexerName, RequestOptions requestOptions) {
        return getStatusWithResponseAsync(indexerName, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the current status and execution history of an indexer.
     * 
     * @param indexerName The name of the indexer for which to retrieve status.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents the current status and execution history of an indexer on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchIndexerStatus> getStatusAsync(String indexerName, RequestOptions requestOptions,
        Context context) {
        return getStatusWithResponseAsync(indexerName, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the current status and execution history of an indexer.
     * 
     * @param indexerName The name of the indexer for which to retrieve status.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents the current status and execution history of an indexer along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchIndexerStatus> getStatusWithResponse(String indexerName, RequestOptions requestOptions,
        Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.getStatusSync(this.client.getEndpoint(), indexerName, xMsClientRequestId,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Returns the current status and execution history of an indexer.
     * 
     * @param indexerName The name of the indexer for which to retrieve status.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents the current status and execution history of an indexer.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchIndexerStatus getStatus(String indexerName, RequestOptions requestOptions) {
        return getStatusWithResponse(indexerName, requestOptions, Context.NONE).getValue();
    }
}
