// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.EdgeNGramTokenFilterSide;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

/**
 * Generates n-grams of the given size(s) starting from the front or the back of an input token. This token filter is
 * implemented using Apache Lucene.
 */
@Fluent
public final class EdgeNGramTokenFilterV1 extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.EdgeNGramTokenFilter";

    /*
     * The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
     */
    @Generated
    private Integer minGram;

    /*
     * The maximum n-gram length. Default is 2.
     */
    @Generated
    private Integer maxGram;

    /*
     * Specifies which side of the input the n-gram should be generated from. Default is "front".
     */
    @Generated
    private EdgeNGramTokenFilterSide side;

    /**
     * Creates an instance of EdgeNGramTokenFilterV1 class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public EdgeNGramTokenFilterV1(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the minGram property: The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
     * 
     * @return the minGram value.
     */
    @Generated
    public Integer getMinGram() {
        return this.minGram;
    }

    /**
     * Set the minGram property: The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
     * 
     * @param minGram the minGram value to set.
     * @return the EdgeNGramTokenFilterV1 object itself.
     */
    @Generated
    public EdgeNGramTokenFilterV1 setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    /**
     * Get the maxGram property: The maximum n-gram length. Default is 2.
     * 
     * @return the maxGram value.
     */
    @Generated
    public Integer getMaxGram() {
        return this.maxGram;
    }

    /**
     * Set the maxGram property: The maximum n-gram length. Default is 2.
     * 
     * @param maxGram the maxGram value to set.
     * @return the EdgeNGramTokenFilterV1 object itself.
     */
    @Generated
    public EdgeNGramTokenFilterV1 setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    /**
     * Get the side property: Specifies which side of the input the n-gram should be generated from. Default is "front".
     * 
     * @return the side value.
     */
    @Generated
    public EdgeNGramTokenFilterSide getSide() {
        return this.side;
    }

    /**
     * Set the side property: Specifies which side of the input the n-gram should be generated from. Default is "front".
     * 
     * @param side the side value to set.
     * @return the EdgeNGramTokenFilterV1 object itself.
     */
    @Generated
    public EdgeNGramTokenFilterV1 setSide(EdgeNGramTokenFilterSide side) {
        this.side = side;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minGram", this.minGram);
        jsonWriter.writeNumberField("maxGram", this.maxGram);
        jsonWriter.writeStringField("side", this.side == null ? null : this.side.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EdgeNGramTokenFilterV1 from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EdgeNGramTokenFilterV1 if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EdgeNGramTokenFilterV1.
     */
    @Generated
    public static EdgeNGramTokenFilterV1 fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.EdgeNGramTokenFilter";
            Integer minGram = null;
            Integer maxGram = null;
            EdgeNGramTokenFilterSide side = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("minGram".equals(fieldName)) {
                    minGram = reader.getNullable(JsonReader::getInt);
                } else if ("maxGram".equals(fieldName)) {
                    maxGram = reader.getNullable(JsonReader::getInt);
                } else if ("side".equals(fieldName)) {
                    side = EdgeNGramTokenFilterSide.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                EdgeNGramTokenFilterV1 deserializedEdgeNGramTokenFilterV1 = new EdgeNGramTokenFilterV1(name);
                deserializedEdgeNGramTokenFilterV1.odataType = odataType;
                deserializedEdgeNGramTokenFilterV1.minGram = minGram;
                deserializedEdgeNGramTokenFilterV1.maxGram = maxGram;
                deserializedEdgeNGramTokenFilterV1.side = side;

                return deserializedEdgeNGramTokenFilterV1;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
