// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeBase;
import java.io.IOException;
import java.util.List;

/**
 * The ListKnowledgeBasesResult model.
 */
@Immutable
public final class ListKnowledgeBasesResult implements JsonSerializable<ListKnowledgeBasesResult> {
    /*
     * The value property.
     */
    @Generated
    private final List<KnowledgeBase> knowledgeBases;

    /**
     * Creates an instance of ListKnowledgeBasesResult class.
     * 
     * @param knowledgeBases the knowledgeBases value to set.
     */
    @Generated
    public ListKnowledgeBasesResult(List<KnowledgeBase> knowledgeBases) {
        this.knowledgeBases = knowledgeBases;
    }

    /**
     * Get the knowledgeBases property: The value property.
     * 
     * @return the knowledgeBases value.
     */
    @Generated
    public List<KnowledgeBase> getKnowledgeBases() {
        return this.knowledgeBases;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.knowledgeBases, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListKnowledgeBasesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListKnowledgeBasesResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListKnowledgeBasesResult.
     */
    @Generated
    public static ListKnowledgeBasesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeBasesFound = false;
            List<KnowledgeBase> knowledgeBases = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    knowledgeBases = reader.readArray(reader1 -> KnowledgeBase.fromJson(reader1));
                    knowledgeBasesFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeBasesFound) {
                return new ListKnowledgeBasesResult(knowledgeBases);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
