// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import java.io.IOException;
import java.util.List;

/**
 * The ListKnowledgeSourcesResult model.
 */
@Immutable
public final class ListKnowledgeSourcesResult implements JsonSerializable<ListKnowledgeSourcesResult> {
    /*
     * The value property.
     */
    @Generated
    private final List<KnowledgeSource> knowledgeSources;

    /**
     * Creates an instance of ListKnowledgeSourcesResult class.
     * 
     * @param knowledgeSources the knowledgeSources value to set.
     */
    @Generated
    public ListKnowledgeSourcesResult(List<KnowledgeSource> knowledgeSources) {
        this.knowledgeSources = knowledgeSources;
    }

    /**
     * Get the knowledgeSources property: The value property.
     * 
     * @return the knowledgeSources value.
     */
    @Generated
    public List<KnowledgeSource> getKnowledgeSources() {
        return this.knowledgeSources;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.knowledgeSources, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListKnowledgeSourcesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListKnowledgeSourcesResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListKnowledgeSourcesResult.
     */
    @Generated
    public static ListKnowledgeSourcesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeSourcesFound = false;
            List<KnowledgeSource> knowledgeSources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    knowledgeSources = reader.readArray(reader1 -> KnowledgeSource.fromJson(reader1));
                    knowledgeSourcesFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeSourcesFound) {
                return new ListKnowledgeSourcesResult(knowledgeSources);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
