// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for Azure Blob Storage knowledge source.
 */
@Fluent
public final class AIServices implements JsonSerializable<AIServices> {
    /*
     * The URI of the AI Services endpoint.
     */
    @Generated
    private final String uri;

    /*
     * The API key for accessing AI Services.
     */
    @Generated
    private String apiKey;

    /**
     * Creates an instance of AIServices class.
     * 
     * @param uri the uri value to set.
     */
    @Generated
    public AIServices(String uri) {
        this.uri = uri;
    }

    /**
     * Get the uri property: The URI of the AI Services endpoint.
     * 
     * @return the uri value.
     */
    @Generated
    public String getUri() {
        return this.uri;
    }

    /**
     * Get the apiKey property: The API key for accessing AI Services.
     * 
     * @return the apiKey value.
     */
    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    /**
     * Set the apiKey property: The API key for accessing AI Services.
     * 
     * @param apiKey the apiKey value to set.
     * @return the AIServices object itself.
     */
    @Generated
    public AIServices setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AIServices from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AIServices if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AIServices.
     */
    @Generated
    public static AIServices fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean uriFound = false;
            String uri = null;
            String apiKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    uri = reader.getString();
                    uriFound = true;
                } else if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (uriFound) {
                AIServices deserializedAIServices = new AIServices(uri);
                deserializedAIServices.apiKey = apiKey;

                return deserializedAIServices;
            }
            throw new IllegalStateException("Missing required property: uri");
        });
    }
}
